var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _this = this;
import { test, testGroup, nextFrame } from "../lib/helpers";
import { TestEnvironment } from "../lib/environment";
import { AttributeObserverRecorder } from "../lib/delegate_recorders";
import { AttributeObserver } from "@stimulus/mutation-observers";
testGroup("AttributeObserver", function (hooks) {
    hooks.beforeEach(function () { _this.env = TestEnvironment.setup(AttributeObserver, AttributeObserverRecorder); });
    hooks.afterEach(function () { _this.env.teardown(); });
    test("attribute matches", function (assert) { return __awaiter(_this, void 0, void 0, function () {
        var done, _a, element, childElement, attributeName, recorder;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    done = assert.async();
                    _a = this.env, element = _a.element, childElement = _a.childElement, attributeName = _a.attributeName, recorder = _a.recorder;
                    element.setAttribute(attributeName, "a");
                    childElement.setAttribute(attributeName, "a");
                    return [4 /*yield*/, nextFrame()];
                case 1:
                    _b.sent();
                    assert.deepEqual(recorder.entries, [
                        { elementMatchedAttribute: [element, attributeName] },
                        { elementMatchedAttribute: [childElement, attributeName] }
                    ]);
                    done();
                    return [2 /*return*/];
            }
        });
    }); });
    test("attribute value changes", function (assert) { return __awaiter(_this, void 0, void 0, function () {
        var done, _a, element, childElement, attributeName, recorder;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    done = assert.async();
                    _a = this.env, element = _a.element, childElement = _a.childElement, attributeName = _a.attributeName, recorder = _a.recorder;
                    element.setAttribute(attributeName, "a");
                    childElement.setAttribute(attributeName, "a");
                    return [4 /*yield*/, nextFrame()];
                case 1:
                    _b.sent();
                    element.setAttribute(attributeName, "b");
                    childElement.setAttribute(attributeName, "b");
                    return [4 /*yield*/, nextFrame()];
                case 2:
                    _b.sent();
                    assert.deepEqual(recorder.entries.slice(-2), [
                        { elementAttributeValueChanged: [element, attributeName] },
                        { elementAttributeValueChanged: [childElement, attributeName] }
                    ]);
                    done();
                    return [2 /*return*/];
            }
        });
    }); });
    test("attribute unmatches", function (assert) { return __awaiter(_this, void 0, void 0, function () {
        var done, _a, element, childElement, attributeName, recorder;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    done = assert.async();
                    _a = this.env, element = _a.element, childElement = _a.childElement, attributeName = _a.attributeName, recorder = _a.recorder;
                    element.setAttribute(attributeName, "a");
                    childElement.setAttribute(attributeName, "a");
                    return [4 /*yield*/, nextFrame()];
                case 1:
                    _b.sent();
                    element.removeAttribute(attributeName);
                    childElement.removeAttribute(attributeName);
                    return [4 /*yield*/, nextFrame()];
                case 2:
                    _b.sent();
                    assert.deepEqual(recorder.entries.slice(-2), [
                        { elementUnmatchedAttribute: [element, attributeName] },
                        { elementUnmatchedAttribute: [childElement, attributeName] }
                    ]);
                    done();
                    return [2 /*return*/];
            }
        });
    }); });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXR0cmlidXRlX29ic2VydmVyX3Rlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9Ac3RpbXVsdXMvbXV0YXRpb24tb2JzZXJ2ZXJzL3Rlc3QvY2FzZXMvYXR0cmlidXRlX29ic2VydmVyX3Rlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSxpQkFpRUE7QUFqRUEsT0FBTyxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsU0FBUyxFQUFFLE1BQU0sZ0JBQWdCLENBQUE7QUFDM0QsT0FBTyxFQUFFLGVBQWUsRUFBRSxNQUFNLG9CQUFvQixDQUFBO0FBQ3BELE9BQU8sRUFBRSx5QkFBeUIsRUFBRSxNQUFNLDJCQUEyQixDQUFBO0FBQ3JFLE9BQU8sRUFBRSxpQkFBaUIsRUFBRSxNQUFNLDhCQUE4QixDQUFBO0FBRWhFLFNBQVMsQ0FBQyxtQkFBbUIsRUFBRSxVQUFBLEtBQUs7SUFDbEMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxjQUFRLEtBQUksQ0FBQyxHQUFHLEdBQUcsZUFBZSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSx5QkFBeUIsQ0FBQyxDQUFBLENBQUMsQ0FBQyxDQUFDLENBQUE7SUFDMUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxjQUFTLEtBQUksQ0FBQyxHQUFHLENBQUMsUUFBUSxFQUFFLENBQUEsQ0FBQyxDQUFDLENBQUMsQ0FBQTtJQUUvQyxJQUFJLENBQUMsbUJBQW1CLEVBQUUsVUFBTSxNQUFNOzs7OztvQkFDOUIsSUFBSSxHQUFHLE1BQU0sQ0FBQyxLQUFLLEVBQUUsQ0FBQTtvQkFDckIsS0FBcUQsSUFBSSxDQUFDLEdBQUcsRUFBM0QsT0FBTyxhQUFBLEVBQUUsWUFBWSxrQkFBQSxFQUFFLGFBQWEsbUJBQUEsRUFBRSxRQUFRLGNBQUEsQ0FBYTtvQkFFbkUsT0FBTyxDQUFDLFlBQVksQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLENBQUE7b0JBQ3hDLFlBQVksQ0FBQyxZQUFZLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxDQUFBO29CQUM3QyxxQkFBTSxTQUFTLEVBQUUsRUFBQTs7b0JBQWpCLFNBQWlCLENBQUE7b0JBRWpCLE1BQU0sQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLE9BQU8sRUFBRTt3QkFDakMsRUFBRSx1QkFBdUIsRUFBRSxDQUFDLE9BQU8sRUFBRSxhQUFhLENBQUMsRUFBRTt3QkFDckQsRUFBRSx1QkFBdUIsRUFBRSxDQUFDLFlBQVksRUFBRSxhQUFhLENBQUMsRUFBRTtxQkFDM0QsQ0FBQyxDQUFBO29CQUVGLElBQUksRUFBRSxDQUFBOzs7O1NBQ1AsQ0FBQyxDQUFBO0lBRUYsSUFBSSxDQUFDLHlCQUF5QixFQUFFLFVBQU0sTUFBTTs7Ozs7b0JBQ3BDLElBQUksR0FBRyxNQUFNLENBQUMsS0FBSyxFQUFFLENBQUE7b0JBQ3JCLEtBQXFELElBQUksQ0FBQyxHQUFHLEVBQTNELE9BQU8sYUFBQSxFQUFFLFlBQVksa0JBQUEsRUFBRSxhQUFhLG1CQUFBLEVBQUUsUUFBUSxjQUFBLENBQWE7b0JBRW5FLE9BQU8sQ0FBQyxZQUFZLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxDQUFBO29CQUN4QyxZQUFZLENBQUMsWUFBWSxDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsQ0FBQTtvQkFDN0MscUJBQU0sU0FBUyxFQUFFLEVBQUE7O29CQUFqQixTQUFpQixDQUFBO29CQUVqQixPQUFPLENBQUMsWUFBWSxDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsQ0FBQTtvQkFDeEMsWUFBWSxDQUFDLFlBQVksQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLENBQUE7b0JBQzdDLHFCQUFNLFNBQVMsRUFBRSxFQUFBOztvQkFBakIsU0FBaUIsQ0FBQTtvQkFFakIsTUFBTSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO3dCQUMzQyxFQUFFLDRCQUE0QixFQUFFLENBQUMsT0FBTyxFQUFFLGFBQWEsQ0FBQyxFQUFFO3dCQUMxRCxFQUFFLDRCQUE0QixFQUFFLENBQUMsWUFBWSxFQUFFLGFBQWEsQ0FBQyxFQUFFO3FCQUNoRSxDQUFDLENBQUE7b0JBRUYsSUFBSSxFQUFFLENBQUE7Ozs7U0FDUCxDQUFDLENBQUE7SUFFRixJQUFJLENBQUMscUJBQXFCLEVBQUUsVUFBTSxNQUFNOzs7OztvQkFDaEMsSUFBSSxHQUFHLE1BQU0sQ0FBQyxLQUFLLEVBQUUsQ0FBQTtvQkFDckIsS0FBcUQsSUFBSSxDQUFDLEdBQUcsRUFBM0QsT0FBTyxhQUFBLEVBQUUsWUFBWSxrQkFBQSxFQUFFLGFBQWEsbUJBQUEsRUFBRSxRQUFRLGNBQUEsQ0FBYTtvQkFFbkUsT0FBTyxDQUFDLFlBQVksQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLENBQUE7b0JBQ3hDLFlBQVksQ0FBQyxZQUFZLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxDQUFBO29CQUM3QyxxQkFBTSxTQUFTLEVBQUUsRUFBQTs7b0JBQWpCLFNBQWlCLENBQUE7b0JBRWpCLE9BQU8sQ0FBQyxlQUFlLENBQUMsYUFBYSxDQUFDLENBQUE7b0JBQ3RDLFlBQVksQ0FBQyxlQUFlLENBQUMsYUFBYSxDQUFDLENBQUE7b0JBQzNDLHFCQUFNLFNBQVMsRUFBRSxFQUFBOztvQkFBakIsU0FBaUIsQ0FBQTtvQkFFakIsTUFBTSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO3dCQUMzQyxFQUFFLHlCQUF5QixFQUFFLENBQUMsT0FBTyxFQUFFLGFBQWEsQ0FBQyxFQUFFO3dCQUN2RCxFQUFFLHlCQUF5QixFQUFFLENBQUMsWUFBWSxFQUFFLGFBQWEsQ0FBQyxFQUFFO3FCQUM3RCxDQUFDLENBQUE7b0JBRUYsSUFBSSxFQUFFLENBQUE7Ozs7U0FDUCxDQUFDLENBQUE7QUFDSixDQUFDLENBQUMsQ0FBQSJ9