import { setFixture } from "./helpers";
var TestEnvironment = /** @class */ (function () {
    function TestEnvironment(observerConstructor, recorderConstructor) {
        this.element = document.createElement("div");
        this.childElement = document.createElement("span");
        this.attributeName = "data-test";
        this.recorder = new recorderConstructor;
        this.observer = new observerConstructor(this.element, this.attributeName, this.recorder);
    }
    TestEnvironment.setup = function (observerConstructor, recorderConstructor) {
        var environment = new TestEnvironment(observerConstructor, recorderConstructor);
        environment.setup();
        return environment;
    };
    TestEnvironment.prototype.setup = function () {
        this.element.appendChild(this.childElement);
        setFixture(this.element);
        this.observer.start();
    };
    TestEnvironment.prototype.teardown = function () {
        this.observer.stop();
        setFixture("");
    };
    return TestEnvironment;
}());
export { TestEnvironment };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW52aXJvbm1lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9Ac3RpbXVsdXMvbXV0YXRpb24tb2JzZXJ2ZXJzL3Rlc3QvbGliL2Vudmlyb25tZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxXQUFXLENBQUE7QUFRdEM7SUFhRSx5QkFBWSxtQkFBbUIsRUFBRSxtQkFBbUI7UUFDbEQsSUFBSSxDQUFDLE9BQU8sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFBO1FBQzVDLElBQUksQ0FBQyxZQUFZLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsQ0FBQTtRQUNsRCxJQUFJLENBQUMsYUFBYSxHQUFHLFdBQVcsQ0FBQTtRQUNoQyxJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksbUJBQW1CLENBQUE7UUFDdkMsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLG1CQUFtQixDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUE7SUFDMUYsQ0FBQztJQVpNLHFCQUFLLEdBQVosVUFBYSxtQkFBbUIsRUFBRSxtQkFBbUI7UUFDbkQsSUFBTSxXQUFXLEdBQUcsSUFBSSxlQUFlLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLENBQUMsQ0FBQTtRQUNqRixXQUFXLENBQUMsS0FBSyxFQUFFLENBQUE7UUFDbkIsTUFBTSxDQUFDLFdBQVcsQ0FBQTtJQUNwQixDQUFDO0lBVUQsK0JBQUssR0FBTDtRQUNFLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQTtRQUMzQyxVQUFVLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFBO1FBQ3hCLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLENBQUE7SUFDdkIsQ0FBQztJQUVELGtDQUFRLEdBQVI7UUFDRSxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxDQUFBO1FBQ3BCLFVBQVUsQ0FBQyxFQUFFLENBQUMsQ0FBQTtJQUNoQixDQUFDO0lBQ0gsc0JBQUM7QUFBRCxDQUFDLEFBL0JELElBK0JDIn0=