export interface ElementObserverDelegate {
    matchElement(element: Element): boolean;
    matchElementsInTree(tree: Element): Element[];
    elementMatched?(element: Element): any;
    elementUnmatched?(element: Element): any;
    elementAttributeChanged?(element: Element, attributeName: string): any;
}
export declare class ElementObserver {
    element: Element;
    started: boolean;
    private delegate;
    private elements;
    private mutationObserver;
    constructor(element: any, delegate: any);
    start(): void;
    stop(): void;
    refresh(): void;
    private processMutations(mutations);
    private processMutation(mutation);
    private processAttributeChange(node, attributeName);
    private processRemovedNodes(nodes);
    private processAddedNodes(nodes);
    private matchElement(element);
    private matchElementsInTree(tree?);
    private processNode(node, processor);
    private elementFromNode(node);
    private addElement(element);
    private removeElement(element);
}
