import { ElementObserverDelegate } from "./element_observer";
export interface TokenListObserverDelegate {
    elementMatchedTokenForAttribute?(element: Element, token: string, attributeName: string): any;
    elementUnmatchedTokenForAttribute?(element: Element, token: string, attributeName: string): any;
}
export declare class TokenListObserver implements ElementObserverDelegate {
    attributeName: string;
    private delegate;
    private elementObserver;
    private tokensByElement;
    constructor(element: Element, attributeName: string, delegate: TokenListObserverDelegate);
    readonly started: boolean;
    start(): void;
    stop(): void;
    refresh(): void;
    readonly element: Element;
    readonly selector: string;
    getElementsMatchingToken(token: string): Element[];
    matchElement(element: Element): boolean;
    matchElementsInTree(tree: Element): Element[];
    elementMatched(element: Element): void;
    elementUnmatched(element: Element): void;
    elementAttributeChanged(element: Element): void;
    private elementMatchedToken(element, token);
    private elementUnmatchedToken(element, token);
    private getTokensForElement(element);
    private readTokenSetForElement(element);
}
