var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { TestCase } from "@stimulus/test";
import { identifierForContextKey } from "../index";
(/** @class */ (function (_super) {
    __extends(WebpackHelperTests, _super);
    function WebpackHelperTests() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    WebpackHelperTests.prototype["test filenames require an extension"] = function () {
        this.assertContextKeyMapsToIdentifier("./hello_controller", undefined);
        this.assertContextKeyMapsToIdentifier("./hello_controller.js", "hello");
        this.assertContextKeyMapsToIdentifier("./hello_controller.ts", "hello");
    };
    WebpackHelperTests.prototype["test filenames require a controller suffix"] = function () {
        this.assertContextKeyMapsToIdentifier("./hello.js", undefined);
        this.assertContextKeyMapsToIdentifier("./hello_world.js", undefined);
        this.assertContextKeyMapsToIdentifier("./hello_controller.js", "hello");
        this.assertContextKeyMapsToIdentifier("./hello-controller.js", "hello");
    };
    WebpackHelperTests.prototype["test underscores map to one dash"] = function () {
        this.assertContextKeyMapsToIdentifier("./remote_content_controller.js", "remote-content");
        this.assertContextKeyMapsToIdentifier("./date_range_editor_controller.js", "date-range-editor");
    };
    WebpackHelperTests.prototype["test slashes map to two dashes"] = function () {
        this.assertContextKeyMapsToIdentifier("./users/list_item_controller.js", "users--list-item");
        this.assertContextKeyMapsToIdentifier("./my/navigation/menu_controller.js", "my--navigation--menu");
    };
    WebpackHelperTests.prototype.assertContextKeyMapsToIdentifier = function (contextKey, expectedIdentifier) {
        var actualIdentifier = identifierForContextKey(contextKey);
        this.assert.equal(actualIdentifier, expectedIdentifier);
    };
    return WebpackHelperTests;
}(TestCase))).defineModule();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9Ac3RpbXVsdXMvd2VicGFjay1oZWxwZXJzL3Rlc3QvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUFBLE9BQU8sRUFBRSxRQUFRLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQTtBQUN6QyxPQUFPLEVBQUUsdUJBQXVCLEVBQUUsTUFBTSxVQUFVLENBQUE7QUFFbEQ7SUFBa0Msc0NBQVE7SUFBekM7O0lBNEJELENBQUM7SUEzQkMsbUVBQXFDLEdBQXJDO1FBQ0UsSUFBSSxDQUFDLGdDQUFnQyxDQUFDLG9CQUFvQixFQUFFLFNBQVMsQ0FBQyxDQUFBO1FBQ3RFLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyx1QkFBdUIsRUFBRSxPQUFPLENBQUMsQ0FBQTtRQUN2RSxJQUFJLENBQUMsZ0NBQWdDLENBQUMsdUJBQXVCLEVBQUUsT0FBTyxDQUFDLENBQUE7SUFDekUsQ0FBQztJQUVELDBFQUE0QyxHQUE1QztRQUNFLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxZQUFZLEVBQUUsU0FBUyxDQUFDLENBQUE7UUFDOUQsSUFBSSxDQUFDLGdDQUFnQyxDQUFDLGtCQUFrQixFQUFFLFNBQVMsQ0FBQyxDQUFBO1FBQ3BFLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyx1QkFBdUIsRUFBRSxPQUFPLENBQUMsQ0FBQTtRQUN2RSxJQUFJLENBQUMsZ0NBQWdDLENBQUMsdUJBQXVCLEVBQUUsT0FBTyxDQUFDLENBQUE7SUFDekUsQ0FBQztJQUVELGdFQUFrQyxHQUFsQztRQUNFLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxnQ0FBZ0MsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFBO1FBQ3pGLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxtQ0FBbUMsRUFBRSxtQkFBbUIsQ0FBQyxDQUFBO0lBQ2pHLENBQUM7SUFFRCw4REFBZ0MsR0FBaEM7UUFDRSxJQUFJLENBQUMsZ0NBQWdDLENBQUMsaUNBQWlDLEVBQUUsa0JBQWtCLENBQUMsQ0FBQTtRQUM1RixJQUFJLENBQUMsZ0NBQWdDLENBQUMsb0NBQW9DLEVBQUUsc0JBQXNCLENBQUMsQ0FBQTtJQUNyRyxDQUFDO0lBRUQsNkRBQWdDLEdBQWhDLFVBQWlDLFVBQVUsRUFBRSxrQkFBa0I7UUFDN0QsSUFBTSxnQkFBZ0IsR0FBRyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsQ0FBQTtRQUM1RCxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsRUFBRSxrQkFBa0IsQ0FBQyxDQUFBO0lBQ3pELENBQUM7SUFDSCx5QkFBQztBQUFELENBQUMsQUE1QkEsQ0FBaUMsUUFBUSxHQTRCeEMsQ0FBQyxZQUFZLEVBQUUsQ0FBQSJ9