export declare const zoomApiYaml = "\nswagger: '2.0'\nschemes:\n  - https\nhost: api.zoom.us\nbasePath: /v2\ninfo:\n  contact:\n    email: developer@zoom.us\n    name: Zoom Developers\n    url: 'https://developer.zoom.us/'\n    x-twitter: zoom_us\n  description: API Description\n  license:\n    name: MIT\n    url: 'https://opensource.org/licenses/MIT'\n  title: Zoom\n  version: 2.0.0\n  x-apisguru-categories:\n    - telecom\n  x-logo:\n    url: 'https://twitter.com/zoom_us/profile_image?size=original'\n  x-origin:\n    - format: swagger\n      url: 'https://raw.githubusercontent.com/zoom/api/master/openapi.v2.json'\n      version: '2.0'\n  x-providerName: zoom.us\nexternalDocs:\n  description: Zoom API Documentation\n  url: 'https://zoom.github.io/api'\nconsumes:\n  - application/json\n  - multipart/form-data\nproduces:\n  - application/json\n  - application/xml\nsecurityDefinitions:\n  global:\n    in: query\n    name: access_token\n    type: apiKey\nsecurity:\n  - global: []\nparameters:\n  AccountId:\n    description: The account ID\n    in: path\n    name: accountId\n    required: true\n    type: string\n  FromDate:\n    description: Start Date\n    format: date\n    in: query\n    name: from\n    required: true\n    type: string\n  GroupId:\n    description: The group ID\n    in: path\n    name: groupId\n    required: true\n    type: string\n  LoginType:\n    enum:\n      - 0\n      - 1\n      - 99\n      - 100\n      - 101\n    in: query\n    name: login_type\n    type: string\n    x-enum-descriptions:\n      - Facebook\n      - Google\n      - API\n      - Zoom\n      - SSO\n  Mc:\n    default: 'false'\n    description: 'Query mc '\n    in: query\n    name: mc\n    type: string\n  MeetingId:\n    description: The meeting ID\n    in: path\n    name: meetingId\n    required: true\n    type: integer\n    enum: [0, 1, 2, 3]\n\n  MeetingId4Metrics:\n    description: 'The meeting ID or meeting UUID. If given meeting ID, will take the last meeting instance.'\n    in: path\n    name: meetingId\n    required: true\n    type: integer\n  MeetingId4Recording:\n    description: 'The meeting ID or meeting UUID. If given meeting ID, will take the last meeting instance.'\n    in: path\n    name: meetingId\n    required: true\n    type: integer\n  MeetingIdNumber:\n    description: The meeting ID or uuid\n    in: path\n    name: meetingId\n    required: true\n    type: string\n  MeetingType:\n    default: live\n    description: The meeting type\n    enum:\n      - scheduled\n      - live\n    in: query\n    name: type\n    type: string\n    x-enum-descriptions:\n      - all the scheduled meetings\n      - all the live meetings\n  MeetingTypePast:\n    default: live\n    description: The meeting type\n    enum:\n      - past\n      - pastOne\n      - live\n    in: query\n    name: type\n    type: string\n    x-enum-descriptions:\n      - past meetings\n      - past one user meetings\n      - live meetings\n  MeetingTypePast2:\n    default: live\n    description: The meeting type\n    enum:\n      - past\n      - live\n    in: query\n    name: type\n    type: string\n    x-enum-descriptions:\n      - past meeting\n      - live meeting\n  MeetingTypePast3:\n    default: live\n    description: The meeting type\n    enum:\n      - past\n      - pastOne\n      - live\n    in: query\n    name: type\n    type: string\n    x-enum-descriptions:\n      - past meeting\n      - past one user meeting\n      - live meeting\n  MemberId:\n    description: The member ID\n    in: path\n    name: memberId\n    required: true\n    type: string\n  NextPageToken:\n    description: 'Next page token, used to paginate through large result sets. A next page token will be returned whenever the set of available result list exceeds page size. The expiration period is 15 minutes.'\n    in: query\n    name: next_page_token\n    type: string\n  OccurrenceId:\n    description: The meeting occurrence ID\n    in: query\n    name: occurrence_id\n    type: string\n  PageNumber:\n    default: 1\n    description: Current page number of returned records.\n    in: query\n    name: page_number\n    type: integer\n  PageSize:\n    default: 30\n    description: 'The amount of records returns within a single API call. '\n    in: query\n    maximum: 300\n    name: page_size\n    type: integer\n  PageSize4Qos:\n    default: 1\n    description: Number of items returned per page\n    in: query\n    maximum: 10\n    name: page_size\n    type: integer\n  PageToken:\n    description: 'Next page token, used to paginate through large result sets. A next page token will be returned whenever the set of available result list exceeds page size. The expiration period is 15 minutes.'\n    in: query\n    name: next_page_token\n    type: string\n  ParticipantId:\n    description: 'The participant ID, such as 16778240'\n    in: path\n    name: participantId\n    required: true\n    type: string\n  RecordingDeleteAction:\n    default: trash\n    description: The recording delete action\n    enum:\n      - trash\n      - delete\n    in: query\n    name: action\n    type: string\n    x-enum-descriptions:\n      - move recording to trash\n      - delete recording permanently\n  RecordingId:\n    description: The recording ID\n    in: path\n    name: recordingId\n    required: true\n    type: string\n  RegistrantId:\n    description: The registrant ID\n    in: path\n    name: registrantId\n    required: true\n    type: string\n  RegistrantStatus:\n    default: approved\n    description: The registrant status\n    enum:\n      - pending\n      - approved\n      - denied\n    in: query\n    name: status\n    type: string\n    x-enum-descriptions:\n      - registrants status is pending\n      - registrants status is approved\n      - registrants status is denied\n  TSPId:\n    description: TSP account index\n    in: path\n    name: tspId\n    required: true\n    type: string\n  ToDate:\n    description: End Date\n    format: date\n    in: query\n    name: to\n    required: true\n    type: string\n  Trash:\n    default: false\n    description: 'Query trash '\n    in: query\n    name: trash\n    type: boolean\n  UserId:\n    description: The user ID or email address\n    in: path\n    name: userId\n    required: true\n    type: string\n  WebhookId:\n    description: The webhook ID\n    in: path\n    name: webhookId\n    required: true\n    type: string\n  WebinarId:\n    description: The webinar ID\n    in: path\n    name: webinarId\n    required: true\n    type: integer\n  WebinarId4Metrics:\n    description: 'The webinar ID or webinar UUID. If given webinar ID, will take the last webinar instance.'\n    in: path\n    name: webinarId\n    required: true\n    type: integer\n  WebinarTypePast:\n    default: live\n    description: The webinar type\n    enum:\n      - past\n      - live\n    in: query\n    name: type\n    type: string\n    x-enum-descriptions:\n      - past webinars\n      - live webinars\n  WebinarTypePast2:\n    default: live\n    description: The webinar type\n    enum:\n      - past\n      - live\n    in: query\n    name: type\n    type: string\n    x-enum-descriptions:\n      - past webinar\n      - live webinar\n  ZoomRoomId:\n    description: The Zoom Room ID\n    in: path\n    name: zoomroomId\n    required: true\n    type: integer\ntags:\n  - description: Account operations\n    name: Accounts\n  - description: Billing operations\n    name: Billing\n  - description: User operations\n    name: Users\n  - description: Meeting operations\n    name: Meetings\n  - description: Webinar operations\n    name: Webinars\n  - description: Group operations\n    name: Groups\n  - description: IM Group operations\n    name: IM Groups\n  - description: Cloud Recording operations\n    name: Cloud Recording\n  - description: Report operations\n    name: Reports\n  - description: Dashboard operations\n    name: Dashboards\n  - description: Webhook operations\n    name: Webhooks\n  - description: TSP operations\n    name: TSP\npaths:\n  /accounts:\n    get:\n      description: List all the sub accounts under the master account.\n      operationId: accounts\n      parameters:\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: Account list returned\n          schema:\n            $ref: '#/definitions/AccountList'\n      summary: List sub accounts\n      tags:\n        - Accounts\n    post:\n      description: 'Create a sub account under the master account <aside>Your account must be a master account and have this privilege to create sub account. Zoom only assign this privilege to trusted partner. The created user will not receive the confirmation email.</aside>'\n      operationId: accountCreate\n      parameters:\n        - description: Account\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/Account'\n      responses:\n        '201':\n          description: Account Created\n          headers:\n            Content-Location:\n              description: Location of created Account\n              type: string\n          schema:\n            properties:\n              created_at:\n                description: Account created date time\n                type: string\n              id:\n                description: Account ID\n                type: string\n              owner_email:\n                description: Account owner email\n                type: string\n              owner_id:\n                description: Account Owner ID\n                type: string\n        '409':\n          description: Account with that email already exists\n      summary: Create a sub account\n      tags:\n        - Accounts\n  '/accounts/{accountId}':\n    delete:\n      description: Disassociate a sub account from the master account\n      operationId: accountDisassociate\n      parameters:\n        - $ref: '#/parameters/AccountId'\n      responses:\n        '204':\n          description: Account deleted\n        '404':\n          description: Account not found\n      summary: Disassociate an account\n      tags:\n        - Accounts\n    get:\n      description: 'Retrieve a sub account under the master account <aside>Your account must be a master account and have this privilege to get sub account. Zoom only assign this privilege to trusted partner</aside>'\n      operationId: account\n      parameters:\n        - $ref: '#/parameters/AccountId'\n      responses:\n        '200':\n          description: Account object returned\n          schema:\n            properties:\n              created_at:\n                description: Account creation date/time\n                format: date-time\n                type: string\n              id:\n                description: Account ID\n                type: string\n              options:\n                $ref: '#/definitions/AccountOptions'\n              owner_email:\n                description: Account Owner email\n                type: string\n              owner_id:\n                description: Account Owner ID\n                type: string\n        '404':\n          description: User not found\n      summary: Retrieve a sub account\n      tags:\n        - Accounts\n  '/accounts/{accountId}/billing':\n    get:\n      description: Retrieve billing information for a sub account under the master account\n      operationId: accountBilling\n      parameters:\n        - $ref: '#/parameters/AccountId'\n      responses:\n        '200':\n          description: Account billing contact information returned\n          schema:\n            $ref: '#/definitions/BillingContactRequired'\n        '404':\n          description: Account not found\n      summary: Retrieve billing information for a sub account\n      tags:\n        - Billing\n    patch:\n      description: 'Update billing information for a sub account under the master account <aside>Only for the sub account which is a paid account and paid by master account</aside>'\n      operationId: accountBillingUpdate\n      parameters:\n        - $ref: '#/parameters/AccountId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/BillingContact'\n      responses:\n        '204':\n          description: Account billing contact information updated\n        '404':\n          description: Account not found\n      summary: Update billing information for a sub account\n      tags:\n        - Billing\n  '/accounts/{accountId}/options':\n    patch:\n      description: \"Update a sub account's options under the master account\"\n      operationId: accountOptionsUpdate\n      parameters:\n        - $ref: '#/parameters/AccountId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/AccountOptions'\n      responses:\n        '204':\n          description: Account options updated\n        '404':\n          description: Account not found\n      summary: \"Update a sub account's options\"\n      tags:\n        - Accounts\n  '/accounts/{accountId}/plans':\n    get:\n      description: 'Retrieve plan information for a sub account under the master account  <aside>Only for the sub account which is paid by master account</aside>'\n      operationId: accountPlans\n      parameters:\n        - $ref: '#/parameters/AccountId'\n      responses:\n        '200':\n          description: Account plans returned\n          schema:\n            $ref: '#/definitions/AccountPlans'\n        '404':\n          description: Account not fond\n      summary: Retrieve plan information for a sub account\n      tags:\n        - Billing\n    post:\n      description: 'Subscribe plans for a sub account of the master account <aside>Can only subscribe plans for the sub account which is a free account and paid by master account</aside>'\n      operationId: accountPlanCreate\n      parameters:\n        - $ref: '#/parameters/AccountId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            allOf:\n              - properties:\n                  contact:\n                    $ref: '#/definitions/BillingContactRequired'\n                type: object\n              - $ref: '#/definitions/AccountPlans'\n      responses:\n        '201':\n          description: Account plans updated\n          schema:\n            $ref: '#/definitions/AccountPlans'\n      summary: Subscribe plans for a sub account\n      tags:\n        - Billing\n  '/accounts/{accountId}/plans/addons':\n    post:\n      description: 'Add an additional plan for sub account <aside>Can only add an Additional plan for the sub account which is a paid account and paid by master account</aside>'\n      operationId: accountPlanAddonCreate\n      parameters:\n        - $ref: '#/parameters/AccountId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/AccountPlanRequired'\n      responses:\n        '201':\n          description: Account plans updated\n      summary: Add an additional plan for sub account\n      tags:\n        - Billing\n    put:\n      description: 'Update an additional plan for sub account<aside>Can only update an Additional plan for the sub account which is a paid account and paid by master account</aside>'\n      operationId: accountPlanAddonUpdate\n      parameters:\n        - $ref: '#/parameters/AccountId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/AccountPlanRequired'\n      responses:\n        '204':\n          description: Account plans updated\n      summary: Update an additional plan for sub account\n      tags:\n        - Billing\n  '/accounts/{accountId}/plans/base':\n    put:\n      description: 'Update a base plan for a sub account <aside>Can only update a base plan for the sub account which is a paid account and paid by master account</aside>'\n      operationId: accountPlanBaseUpdate\n      parameters:\n        - $ref: '#/parameters/AccountId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/AccountPlanBaseRequired'\n      responses:\n        '204':\n          description: Account plans updated\n      summary: Update a base plan for a sub account\n      tags:\n        - Billing\n  '/accounts/{accountId}/settings':\n    get:\n      description: \"Retrieve a sub account's settings under the master account\"\n      operationId: accountSettings\n      parameters:\n        - $ref: '#/parameters/AccountId'\n      responses:\n        '200':\n          description: Account settings returned\n          schema:\n            $ref: '#/definitions/AccountSettings'\n        '404':\n          description: Account not found\n      summary: \"Retrieve a sub account's settings\"\n      tags:\n        - Accounts\n    patch:\n      description: \"Update a sub account's settings under the master account\"\n      operationId: accountSettingsUpdate\n      parameters:\n        - $ref: '#/parameters/AccountId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/AccountSettings'\n      responses:\n        '204':\n          description: Account settings updated\n        '404':\n          description: Account not found\n      summary: \"Update a sub account's settings\"\n      tags:\n        - Accounts\n  /groups:\n    get:\n      description: List groups under your account\n      operationId: groups\n      parameters: []\n      responses:\n        '200':\n          description: List of groups returned.\n          schema:\n            $ref: '#/definitions/GroupList'\n      summary: List groups\n      tags:\n        - Groups\n    post:\n      description: Create a group under your account\n      operationId: groupCreate\n      parameters:\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              name:\n                description: Group name.\n                type: string\n      responses:\n        '201':\n          description: Group created.\n          headers:\n            Content-Location:\n              description: Location of created group\n              type: string\n          schema:\n            properties:\n              id:\n                description: Group ID\n                type: string\n              name:\n                description: Group name\n                type: string\n              total_members:\n                description: Group member count\n                type: integer\n      summary: Create a group\n      tags:\n        - Groups\n  '/groups/{groupId}':\n    delete:\n      description: Delete a group under your account\n      operationId: groupDelete\n      parameters:\n        - $ref: '#/parameters/GroupId'\n      responses:\n        '204':\n          description: Group deleted.\n        '404':\n          description: Group not found\n      summary: Delete a group\n      tags:\n        - Groups\n    get:\n      description: Retrieve a group under your account\n      operationId: group\n      parameters:\n        - $ref: '#/parameters/GroupId'\n      responses:\n        '200':\n          description: Group object returned\n          schema:\n            allOf:\n              - properties:\n                  id:\n                    description: Group ID\n                    type: string\n              - $ref: '#/definitions/Group'\n        '404':\n          description: Group not found\n      summary: Retrieve a group\n      tags:\n        - Groups\n    patch:\n      description: Update a group under your account\n      operationId: groupUpdate\n      parameters:\n        - $ref: '#/parameters/GroupId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              name:\n                description: Group name. Must be unique in one account. Character length is less than 128.\n                type: string\n      responses:\n        '204':\n          description: Group updated.\n        '404':\n          description: Group not found\n      summary: Update a group\n      tags:\n        - Groups\n  '/groups/{groupId}/members':\n    get:\n      description: \"List a group's members under your account\"\n      operationId: groupMembers\n      parameters:\n        - $ref: '#/parameters/GroupId'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: Group member list returned\n          schema:\n            $ref: '#/definitions/GroupMemberList'\n        '404':\n          description: Group not found\n      summary: \"List a group's members\"\n      tags:\n        - Groups\n    post:\n      description: Add members to a group under your account\n      operationId: groupMembersCreate\n      parameters:\n        - $ref: '#/parameters/GroupId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              members:\n                description: List of Group members\n                items:\n                  properties:\n                    email:\n                      description: 'User email. If ID given, email is ignored.'\n                      type: string\n                    id:\n                      description: User ID.\n                      type: string\n                maximum: 30\n                type: array\n      responses:\n        '201':\n          description: Member added.\n          schema:\n            properties:\n              added_at:\n                format: date-time\n                type: string\n              ids:\n                type: string\n        '404':\n          description: Group not found\n      summary: Add group members\n      tags:\n        - Groups\n  '/groups/{groupId}/members/{memberId}':\n    delete:\n      description: Delete a member from a group under your account\n      operationId: groupMembersDelete\n      parameters:\n        - $ref: '#/parameters/GroupId'\n        - $ref: '#/parameters/MemberId'\n      responses:\n        '204':\n          description: Group member deleted.\n        '404':\n          description: Group or Group member not found\n      summary: Delete a group member\n      tags:\n        - Groups\n  /im/groups:\n    get:\n      description: List IM groups under your account\n      operationId: imGroups\n      parameters: []\n      responses:\n        '200':\n          description: List of IM Groups returned.\n          schema:\n            $ref: '#/definitions/IMGroupList'\n      summary: List IM Groups\n      tags:\n        - IM Groups\n    post:\n      description: Create a IM Group under your account\n      operationId: imGroupCreate\n      parameters:\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              name:\n                description: 'Group name, must be unique in one account'\n                maxLength: 128\n                type: string\n              search_by_account:\n                description: Members can search others under same account\n                type: boolean\n              search_by_domain:\n                description: Members can search others in the same email domain\n                type: boolean\n              search_by_ma_account:\n                description: 'Members can search others under same master account, including all sub accounts'\n                type: boolean\n              type:\n                default: normal\n                description: IM Group type\n                enum:\n                  - normal\n                  - shared\n                  - restricted\n                type: string\n                x-enum-descriptions:\n                  - Only members can see the group automatically. Other people can search members in the group\n                  - All people in the account can see the group and members automatically\n                  - Nobody can see the group or search members except the members in the group\n      responses:\n        '201':\n          description: IM Group created.\n          headers:\n            Content-Location:\n              description: Location of created IM Group\n              type: string\n          schema:\n            properties:\n              id:\n                description: Group ID\n                type: string\n              name:\n                description: Group name\n                type: string\n              search_by_account:\n                description: Members can search others under same account.\n                type: boolean\n              search_by_domain:\n                description: Members can search others in the same email domain.\n                type: boolean\n              search_by_ma_account:\n                description: 'Members can search others under same master account, including all sub accounts.'\n                type: boolean\n              total_members:\n                description: Group member count\n                type: integer\n      summary: Create an IM Group\n      tags:\n        - IM Groups\n  '/im/groups/{groupId}':\n    delete:\n      description: Delete an IM Group under your account\n      operationId: imGroupDelete\n      parameters:\n        - $ref: '#/parameters/GroupId'\n      responses:\n        '204':\n          description: IM Group deleted.\n        '404':\n          description: IM Group not found\n      summary: Delete an IM Group\n      tags:\n        - IM Groups\n    get:\n      description: Retrieve an IM Group under your account\n      operationId: imGroup\n      parameters:\n        - $ref: '#/parameters/GroupId'\n      responses:\n        '200':\n          description: IM Group object returned\n          schema:\n            allOf:\n              - properties:\n                  id:\n                    description: Group ID\n                    type: string\n              - $ref: '#/definitions/IMGroup'\n        '404':\n          description: IM Group not found\n      summary: Retrieve an IM Group\n      tags:\n        - IM Groups\n    patch:\n      description: Update an IM Group under your account\n      operationId: imGroupUpdate\n      parameters:\n        - $ref: '#/parameters/GroupId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              name:\n                description: 'Group name, must be unique in one account'\n                maxLength: 128\n                type: string\n              search_by_account:\n                description: Members can search others under same account\n                type: boolean\n              search_by_domain:\n                description: Members can search others in the same email domain\n                type: boolean\n              search_by_ma_account:\n                description: 'Members can search others under same master account, including all sub accounts'\n                type: boolean\n              type:\n                description: IM Group type\n                enum:\n                  - normal\n                  - shared\n                  - restricted\n                type: string\n                x-enum-descriptions:\n                  - Only members can see the group automatically. Other people can search members in the group\n                  - All people in the account can see the group and members automatically\n                  - Nobody can see the group or search members except the members in the group\n      responses:\n        '204':\n          description: IM Group updated.\n        '404':\n          description: IM Group not found\n      summary: Update an IM Group\n      tags:\n        - IM Groups\n  '/im/groups/{groupId}/members':\n    get:\n      description: \"List an IM Group's members under your account\"\n      operationId: imGroupMembers\n      parameters:\n        - $ref: '#/parameters/GroupId'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: IM Group member list returned\n          schema:\n            $ref: '#/definitions/GroupMemberList'\n        '404':\n          description: IM Group not found\n      summary: \"List an IM Group's members\"\n      tags:\n        - IM Groups\n    post:\n      description: Add members to an IM Group under your account\n      operationId: imGroupMembersCreate\n      parameters:\n        - $ref: '#/parameters/GroupId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              members:\n                description: List of IM Group members\n                items:\n                  properties:\n                    email:\n                      description: 'User email. If ID given, email is ignored.'\n                      type: string\n                    id:\n                      description: User ID.\n                      type: string\n                maximum: 10\n                type: array\n      responses:\n        '201':\n          description: Member added.\n          schema:\n            properties:\n              added_at:\n                format: date-time\n                type: string\n              ids:\n                type: string\n        '404':\n          description: IM Group not found\n      summary: Add IM Group members\n      tags:\n        - IM Groups\n  '/im/groups/{groupId}/members/{memberId}':\n    delete:\n      description: Delete a member from an IM Group under your account\n      operationId: imGroupMembersDelete\n      parameters:\n        - $ref: '#/parameters/GroupId'\n        - $ref: '#/parameters/MemberId'\n      responses:\n        '204':\n          description: IM Group member deleted.\n        '404':\n          description: IM Group or IM Group member not found\n      summary: Delete an IM Group member\n      tags:\n        - IM Groups\n  '/meetings/{meetingId}':\n    delete:\n      description: Delete a meeting\n      operationId: meetingDelete\n      parameters:\n        - $ref: '#/parameters/MeetingId'\n        - $ref: '#/parameters/OccurrenceId'\n      responses:\n        '204':\n          description: Meeting deleted\n        '404':\n          description: Meeting not found\n      summary: Delete a meeting\n      tags:\n        - Meetings\n    get:\n      description: \"Retrieve a meeting's details\"\n      operationId: meeting\n      parameters:\n        - $ref: '#/parameters/MeetingId'\n      responses:\n        '200':\n          description: Meeting object returned\n          schema:\n            allOf:\n              - properties:\n                  host_id:\n                    description: ID of the user set as host of meeting\n                    type: string\n                  id:\n                    description: 'Meeting ID, also know as meeting number'\n                    type: string\n                  uuid:\n                    description: Meeting unique ID\n                    type: string\n                type: object\n              - $ref: '#/definitions/MeetingInfo'\n        '404':\n          description: Meeting not found\n      summary: Retrieve a meeting\n      tags:\n        - Meetings\n    patch:\n      description: \"Update a meeting's details\"\n      operationId: meetingUpdate\n      parameters:\n        - $ref: '#/parameters/MeetingId'\n        - description: Meeting\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/MeetingUpdate'\n      responses:\n        '204':\n          description: Meeting Updated\n        '404':\n          description: Meeting not found\n      summary: Update a meeting\n      tags:\n        - Meetings\n  '/meetings/{meetingId}/recordings':\n    delete:\n      description: \"Delete a meeting's recordings\"\n      operationId: recordingDelete\n      parameters:\n        - $ref: '#/parameters/MeetingId4Recording'\n        - $ref: '#/parameters/RecordingDeleteAction'\n      responses:\n        '204':\n          description: Meeting recording deleted\n        '404':\n          description: Meeting recording not found\n      summary: \"Delete a meeting's recordings\"\n      tags:\n        - Cloud Recording\n    get:\n      description: Retrieve a meeting\u2019s all recordings\n      operationId: recordingGet\n      parameters:\n        - $ref: '#/parameters/MeetingId4Recording'\n      responses:\n        '200':\n          description: Recording object returned\n          schema:\n            allOf:\n              - $ref: '#/definitions/Recording'\n        '404':\n          description: Meeting recording not found\n      summary: Retrieve a meeting\u2019s all recordings\n      tags:\n        - Cloud Recording\n  '/meetings/{meetingId}/recordings/status':\n    put:\n      description: \"Recover a meeting's recordings\"\n      operationId: recordingStatusUpdate\n      parameters:\n        - $ref: '#/parameters/MeetingId4Recording'\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              action:\n                enum:\n                  - recover\n                type: string\n                x-enum-descriptions:\n                  - recover meeting recording\n      responses:\n        '204':\n          description: Meeting recording recover\n        '404':\n          description: Meeting recording not found\n      summary: \"Recover a meeting's recordings\"\n      tags:\n        - Cloud Recording\n  '/meetings/{meetingId}/recordings/{recordingId}':\n    delete:\n      description: Delete one meeting recording file\n      operationId: recordingDeleteOne\n      parameters:\n        - $ref: '#/parameters/MeetingId4Recording'\n        - $ref: '#/parameters/RecordingId'\n        - $ref: '#/parameters/RecordingDeleteAction'\n      responses:\n        '204':\n          description: Meeting recording file deleted\n        '404':\n          description: Meeting recording file not found\n      summary: Delete one meeting recording file\n      tags:\n        - Cloud Recording\n  '/meetings/{meetingId}/recordings/{recordingId}/status':\n    put:\n      description: Recover a meeting one recording\n      operationId: recordingStatusUpdateOne\n      parameters:\n        - $ref: '#/parameters/MeetingId4Recording'\n        - $ref: '#/parameters/RecordingId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              action:\n                enum:\n                  - recover\n                type: string\n                x-enum-descriptions:\n                  - recover meeting recording\n      responses:\n        '204':\n          description: Meeting recording recover\n        '404':\n          description: Meeting recording not found\n      summary: Recover a meeting one recording\n      tags:\n        - Cloud Recording\n  '/meetings/{meetingId}/registrants':\n    get:\n      description: List registrants of a meeting\n      operationId: meetingRegistrants\n      parameters:\n        - $ref: '#/parameters/MeetingId'\n        - $ref: '#/parameters/OccurrenceId'\n        - $ref: '#/parameters/RegistrantStatus'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: Success\n          schema:\n            $ref: '#/definitions/MeetingRegistrantList'\n        '404':\n          description: Meeting not found\n      summary: \"List a meeting's registrants\"\n      tags:\n        - Meetings\n    post:\n      description: Register a participant for a meeting\n      operationId: meetingRegistrantCreate\n      parameters:\n        - $ref: '#/parameters/MeetingId'\n        - description: 'Occurrence IDs, could get this value from Meeting Get API. Multiple value separated by comma.'\n          in: query\n          name: occurrence_ids\n          type: string\n        - in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/MeetingRegistrant'\n      responses:\n        '201':\n          description: Registration created\n          schema:\n            properties:\n              id:\n                description: Registrant ID\n                type: string\n              join_url:\n                description: Join URL for this registrant\n                type: string\n              registrant_id:\n                description: Registrant ID\n                type: string\n              start_time:\n                description: Start time\n                format: date-time\n                type: string\n              topic:\n                description: Topic\n                type: string\n            type: object\n        '404':\n          description: Meeting not found\n      summary: Add a meeting registrant\n      tags:\n        - Meetings\n  '/meetings/{meetingId}/registrants/status':\n    put:\n      description: \"Update a meeting registrant's status\"\n      operationId: meetingRegistrantStatus\n      parameters:\n        - $ref: '#/parameters/MeetingId'\n        - $ref: '#/parameters/OccurrenceId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/RegistrantStatus'\n      responses:\n        '204':\n          description: Registrant status updated\n        '404':\n          description: Meeting or Registrant not found\n      summary: \"Update a meeting registrant's status\"\n      tags:\n        - Meetings\n  '/meetings/{meetingId}/status':\n    put:\n      description: \"Update a meeting's status\"\n      operationId: meetingStatus\n      parameters:\n        - $ref: '#/parameters/MeetingId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              action:\n                enum:\n                  - end\n                type: string\n                x-enum-descriptions:\n                  - end a meeting\n      responses:\n        '204':\n          description: Meeting updated\n        '404':\n          description: Meeting not found\n      summary: \"Update a meeting's status\"\n      tags:\n        - Meetings\n  /metrics/crc:\n    get:\n      description: \"Get CRC Port usage hour by hour for a specified time period <aside class='notice'>We will report a maximum of one month. For example, if \"from\" is set to \"2017-08-05\" and \"to\" is \"2017-10-10\" we will adjust \"from\" to \"2017-09-10\"</aside>\"\n      operationId: dashboardCRC\n      parameters:\n        - $ref: '#/parameters/FromDate'\n        - $ref: '#/parameters/ToDate'\n      responses:\n        '200':\n          description: CRC Usage returned\n          schema:\n            allOf:\n              - properties:\n                  from:\n                    description: Start date for this report\n                    format: date\n                    type: string\n                  to:\n                    description: End date for this report\n                    format: date\n                    type: string\n              - properties:\n                  crc_ports_usage:\n                    items:\n                      properties:\n                        crc_ports_hour_usage:\n                          items:\n                            properties:\n                              hour:\n                                type: string\n                              max_usage:\n                                type: integer\n                              total_usage:\n                                type: integer\n                          type: array\n                        date_time:\n                          description: Date and time\n                          type: string\n                    type: array\n      summary: Retrieve CRC Port Usage\n      tags:\n        - Dashboards\n  /metrics/im:\n    get:\n      description: Retrieve metrics of Zoom IM\n      operationId: dashboardIM\n      parameters:\n        - $ref: '#/parameters/FromDate'\n        - $ref: '#/parameters/ToDate'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/NextPageToken'\n      responses:\n        '200':\n          description: IM setails returned\n          schema:\n            allOf:\n              - properties:\n                  from:\n                    description: Start date for this report\n                    format: date\n                    type: string\n                  to:\n                    description: End date for this report\n                    format: date\n                    type: string\n              - $ref: '#/definitions/PaginationToken'\n              - properties:\n                  users:\n                    items:\n                      properties:\n                        calls_receive:\n                          type: integer\n                        calls_send:\n                          type: integer\n                        email:\n                          description: User email\n                          type: string\n                        emoji_receive:\n                          type: integer\n                        emoji_send:\n                          type: integer\n                        files_receive:\n                          type: integer\n                        files_send:\n                          type: integer\n                        group_receive:\n                          type: integer\n                        group_send:\n                          type: integer\n                        images_receive:\n                          type: integer\n                        images_send:\n                          type: integer\n                        total_receive:\n                          type: integer\n                        total_send:\n                          type: integer\n                        user_id:\n                          description: User ID\n                          type: string\n                        user_name:\n                          description: User display name\n                          type: string\n                        videos_receive:\n                          type: integer\n                        videos_send:\n                          type: integer\n                        voice_receive:\n                          type: integer\n                        voice_send:\n                          type: integer\n                    type: array\n      summary: Retrieve IM\n      tags:\n        - Dashboards\n  /metrics/meetings:\n    get:\n      description: List live meetings or past meetings for a specified period\n      operationId: dashboardMeetings\n      parameters:\n        - $ref: '#/parameters/MeetingTypePast'\n        - $ref: '#/parameters/FromDate'\n        - $ref: '#/parameters/ToDate'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/NextPageToken'\n      responses:\n        '200':\n          description: Meetings Returned\n          schema:\n            allOf:\n              - properties:\n                  from:\n                    description: Start date for this report\n                    format: date\n                    type: string\n                  to:\n                    description: End date for this report\n                    format: date\n                    type: string\n              - $ref: '#/definitions/PaginationToken'\n              - properties:\n                  meetings:\n                    description: Array of meeting objects\n                    items:\n                      $ref: '#/definitions/MeetingMetric'\n                    type: array\n      summary: List meetings\n      tags:\n        - Dashboards\n  '/metrics/meetings/{meetingId}':\n    get:\n      description: Retrieve live or past meetings detail\n      operationId: dashboardMeetingDetail\n      parameters:\n        - $ref: '#/parameters/MeetingId4Metrics'\n        - $ref: '#/parameters/MeetingTypePast3'\n      responses:\n        '200':\n          description: Meeting Returned\n          schema:\n            $ref: '#/definitions/MeetingMetric'\n      summary: Retrieve meeting detail\n      tags:\n        - Dashboards\n  '/metrics/meetings/{meetingId}/participants':\n    get:\n      description: Retrieve live or past meetings participants\n      operationId: dashboardMeetingParticipants\n      parameters:\n        - $ref: '#/parameters/MeetingId4Metrics'\n        - $ref: '#/parameters/MeetingTypePast3'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/NextPageToken'\n      responses:\n        '200':\n          description: Meeting Participants Returned\n          schema:\n            allOf:\n              - $ref: '#/definitions/PaginationToken'\n              - properties:\n                  participants:\n                    description: Array of user objects\n                    items:\n                      properties:\n                        device:\n                          description: Participant device\n                          type: string\n                        domain:\n                          description: Participant domain\n                          type: string\n                        harddisk_id:\n                          description: Participant hard disk id\n                          type: string\n                        id:\n                          description: Participant UUID\n                          format: uuid\n                          type: string\n                        ip_address:\n                          description: Participant IP Address\n                          type: string\n                        join_time:\n                          description: Participant join time\n                          format: date-time\n                          type: string\n                        leave_time:\n                          description: Participant leave time\n                          format: date-time\n                          type: string\n                        location:\n                          description: Participant location\n                          type: string\n                        mac_addr:\n                          description: Participant MAC Address\n                          type: string\n                        network_type:\n                          description: Participant network type\n                          type: string\n                        pc_name:\n                          description: Participant PC name\n                          type: string\n                        recording:\n                          description: Participant record\n                          type: boolean\n                        share_application:\n                          description: Did participant share application\n                          type: boolean\n                        share_desktop:\n                          description: Did participant share desktop\n                          type: boolean\n                        share_whiteboard:\n                          description: Did participant share whiteboard\n                          type: boolean\n                        user_id:\n                          description: Participant ID\n                          format: uuid\n                          type: string\n                        user_name:\n                          description: Participant display name\n                          type: string\n                        version:\n                          description: Participant version\n                          type: string\n                    type: array\n      summary: Retrieve meeting participants\n      tags:\n        - Dashboards\n  '/metrics/meetings/{meetingId}/participants/qos':\n    get:\n      description: Retrieve list of live or past meetings participants quality of service\n      operationId: dashboardMeetingParticipantsQOS\n      parameters:\n        - $ref: '#/parameters/MeetingId4Metrics'\n        - $ref: '#/parameters/MeetingTypePast2'\n        - $ref: '#/parameters/PageSize4Qos'\n        - $ref: '#/parameters/NextPageToken'\n      responses:\n        '200':\n          description: Meeting Participants Returned\n          schema:\n            $ref: '#/definitions/QOSParticipantList'\n      summary: List meeting participants QOS\n      tags:\n        - Dashboards\n  '/metrics/meetings/{meetingId}/participants/sharing':\n    get:\n      description: Retrieve sharing/recording details of live or past meetings participant\n      operationId: dashboardMeetingParticipantShare\n      parameters:\n        - $ref: '#/parameters/MeetingId4Metrics'\n        - $ref: '#/parameters/MeetingTypePast2'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageToken'\n      responses:\n        '200':\n          description: Meeting Participants Returned\n          schema:\n            allOf:\n              - $ref: '#/definitions/PaginationToken'\n              - properties:\n                  participants:\n                    description: Array of participants\n                    items:\n                      properties:\n                        details:\n                          description: Array of sharing and recording details\n                          items:\n                            properties:\n                              content:\n                                description: Type of content shared\n                                type: string\n                              end_time:\n                                description: End time of sharing\n                                type: string\n                              start_time:\n                                description: Start time of sharing\n                                type: string\n                          type: array\n                        id:\n                          description: Participant UUID\n                          type: string\n                        user_id:\n                          description: Participant ID\n                          type: string\n                        user_name:\n                          description: Participant display name\n                          type: string\n                    type: array\n      summary: Retrieve sharing/recording details of meeting participant\n      tags:\n        - Dashboards\n  '/metrics/meetings/{meetingId}/participants/{participantId}/qos':\n    get:\n      description: Retrieve live or past meetings participant quality of service\n      operationId: dashboardMeetingParticipantQOS\n      parameters:\n        - $ref: '#/parameters/MeetingId4Metrics'\n        - $ref: '#/parameters/ParticipantId'\n        - $ref: '#/parameters/MeetingTypePast2'\n      responses:\n        '200':\n          description: Meeting Participant QOS Returned\n          schema:\n            $ref: '#/definitions/QOSParticipant'\n      summary: Retrieve meeting participant QOS\n      tags:\n        - Dashboards\n  /metrics/webinars:\n    get:\n      description: List live webinars or past webinars for a specified period\n      operationId: dashboardWebinars\n      parameters:\n        - $ref: '#/parameters/WebinarTypePast'\n        - $ref: '#/parameters/FromDate'\n        - $ref: '#/parameters/ToDate'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/NextPageToken'\n      responses:\n        '200':\n          description: Meetings Returned\n          schema:\n            allOf:\n              - properties:\n                  from:\n                    description: Start date for this report\n                    format: date\n                    type: string\n                  to:\n                    description: End date for this report\n                    format: date\n                    type: string\n              - $ref: '#/definitions/PaginationToken'\n              - properties:\n                  webinars:\n                    description: Array of webinar objects\n                    items:\n                      $ref: '#/definitions/WebinarMetric'\n                    type: array\n      summary: List webinars\n      tags:\n        - Dashboards\n  '/metrics/webinars/{webinarId}':\n    get:\n      description: Retrieve live  or past webinars detail\n      operationId: dashboardWebinarDetail\n      parameters:\n        - $ref: '#/parameters/WebinarId4Metrics'\n        - $ref: '#/parameters/WebinarTypePast2'\n      responses:\n        '200':\n          description: Webinar Returned\n          schema:\n            $ref: '#/definitions/WebinarMetric'\n      summary: Retrieve webinar detail\n      tags:\n        - Dashboards\n  '/metrics/webinars/{webinarId}/participants':\n    get:\n      description: Retrieve live or past webinar participants\n      operationId: dashboardWebinarParticipants\n      parameters:\n        - $ref: '#/parameters/WebinarId4Metrics'\n        - $ref: '#/parameters/WebinarTypePast2'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/NextPageToken'\n      responses:\n        '200':\n          description: Webinar Participants Returned\n          schema:\n            allOf:\n              - $ref: '#/definitions/PaginationToken'\n              - properties:\n                  participants:\n                    description: Array of user objects\n                    items:\n                      properties:\n                        device:\n                          description: Participant device\n                          type: string\n                        domain:\n                          description: Participant domain\n                          type: string\n                        harddisk_id:\n                          description: Participant hard disk id\n                          type: string\n                        id:\n                          description: Participant UUID\n                          format: uuid\n                          type: string\n                        ip_address:\n                          description: Participant IP Address\n                          type: string\n                        join_time:\n                          description: Participant join time\n                          format: date-time\n                          type: string\n                        leave_time:\n                          description: Participant leave time\n                          format: date-time\n                          type: string\n                        location:\n                          description: Participant location\n                          type: string\n                        mac_addr:\n                          description: Participant MAC Address\n                          type: string\n                        network_type:\n                          description: Participant network type\n                          type: string\n                        pc_name:\n                          description: Participant PC name\n                          type: string\n                        recording:\n                          description: Participant record\n                          type: boolean\n                        share_application:\n                          description: Did participant share application\n                          type: boolean\n                        share_desktop:\n                          description: Did participant share desktop\n                          type: boolean\n                        share_whiteboard:\n                          description: Did participant share whiteboard\n                          type: boolean\n                        user_id:\n                          description: Participant ID\n                          format: uuid\n                          type: string\n                        user_name:\n                          description: Participant display name\n                          type: string\n                        version:\n                          description: Participant version\n                          type: string\n                    type: array\n      summary: Retrieve webinar participants\n      tags:\n        - Dashboards\n  '/metrics/webinars/{webinarId}/participants/qos':\n    get:\n      description: Retrieve list of live or past webinar participants quality of service\n      operationId: dashboardWebinarParticipantsQOS\n      parameters:\n        - $ref: '#/parameters/WebinarId4Metrics'\n        - $ref: '#/parameters/WebinarTypePast2'\n        - $ref: '#/parameters/PageSize4Qos'\n        - $ref: '#/parameters/NextPageToken'\n      responses:\n        '200':\n          description: Webinar Participants Returned\n          schema:\n            $ref: '#/definitions/QOSParticipantList'\n      summary: List webinar participant QOS\n      tags:\n        - Dashboards\n  '/metrics/webinars/{webinarId}/participants/sharing':\n    get:\n      description: Retrieve sharing/recording details of live or past webinar participant\n      operationId: dashboardWebinarParticipantShare\n      parameters:\n        - $ref: '#/parameters/WebinarId4Metrics'\n        - $ref: '#/parameters/WebinarTypePast2'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageToken'\n      responses:\n        '200':\n          description: Webinar Participants Returned\n          schema:\n            allOf:\n              - $ref: '#/definitions/PaginationToken'\n              - properties:\n                  participants:\n                    description: Array of participants\n                    items:\n                      properties:\n                        details:\n                          description: Array of sharing and recording details\n                          items:\n                            properties:\n                              content:\n                                description: Type of content shared\n                                type: string\n                              end_time:\n                                description: End time of sharing\n                                type: string\n                              start_time:\n                                description: Start time of sharing\n                                type: string\n                          type: array\n                        id:\n                          description: Participant UUID\n                          type: string\n                        user_id:\n                          description: Participant ID\n                          type: string\n                        user_name:\n                          description: Participant display name\n                          type: string\n                    type: array\n      summary: Retrieve sharing/recording details of webinar participant\n      tags:\n        - Dashboards\n  '/metrics/webinars/{webinarId}/participants/{participantId}/qos':\n    get:\n      description: Retrieve live or past webinar participant quality of service\n      operationId: dashboardWebinarParticipantQOS\n      parameters:\n        - $ref: '#/parameters/WebinarId4Metrics'\n        - $ref: '#/parameters/ParticipantId'\n        - $ref: '#/parameters/WebinarTypePast2'\n      responses:\n        '200':\n          description: Webinar Participant QOS Returned\n          schema:\n            $ref: '#/definitions/QOSParticipant'\n      summary: Retrieve webinar participant QOS\n      tags:\n        - Dashboards\n  /metrics/zoomrooms:\n    get:\n      description: List all zoom rooms on account\n      operationId: dashboardZoomRooms\n      parameters:\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: List of Zoom Rooms returned\n          schema:\n            $ref: '#/definitions/ZoomRoomList'\n      summary: List Zoom Rooms\n      tags:\n        - Dashboards\n  '/metrics/zoomrooms/{zoomroomId}':\n    get:\n      description: Retrieve zoom room on account\n      operationId: dashboardZoomRoom\n      parameters:\n        - $ref: '#/parameters/ZoomRoomId'\n        - $ref: '#/parameters/FromDate'\n        - $ref: '#/parameters/ToDate'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: Zoom Room returned\n          schema:\n            allOf:\n              - $ref: '#/definitions/ZoomRoom'\n              - properties:\n                  live_meeting:\n                    $ref: '#/definitions/MeetingMetric'\n                  past_meetings:\n                    allOf:\n                      - properties:\n                          from:\n                            description: Start date for this report\n                            format: date\n                            type: string\n                          to:\n                            description: End date for this report\n                            format: date\n                            type: string\n                      - $ref: '#/definitions/PaginationToken'\n                      - properties:\n                          meetings:\n                            description: Array of meeting objects\n                            items:\n                              $ref: '#/definitions/MeetingMetric'\n                            type: array\n                    type: object\n      summary: Retrieve Zoom Room\n      tags:\n        - Dashboards\n  /report/daily:\n    get:\n      description: 'Retrieve daily report for one month, can only get daily report for recent 6 months.'\n      operationId: reportDaily\n      parameters:\n        - description: Year for this report\n          in: query\n          name: year\n          type: integer\n        - description: Month for this report\n          in: query\n          name: month\n          type: integer\n      responses:\n        '200':\n          description: Daily Report Returned\n          schema:\n            properties:\n              dates:\n                description: Array of date objects\n                items:\n                  properties:\n                    date:\n                      description: Date for this object\n                      format: date\n                      type: string\n                    meeting_minutes:\n                      description: Number of meeting minutes on this date\n                      type: integer\n                    meetings:\n                      description: Number of meetings on this date\n                      type: integer\n                    new_users:\n                      description: Number of new users on this date\n                      type: integer\n                    participants:\n                      description: Number of participants on this date\n                      type: integer\n                type: array\n              month:\n                description: Month for this report\n                type: integer\n              year:\n                description: Year for this report\n                type: integer\n      summary: Retrieve daily report\n      tags:\n        - Reports\n  '/report/meetings/{meetingId}':\n    get:\n      description: Retrieve ended meeting details report\n      operationId: reportMeetingDetails\n      parameters:\n        - $ref: '#/parameters/MeetingId4Metrics'\n      responses:\n        '200':\n          description: Meeting detail Returned\n          schema:\n            properties:\n              duration:\n                description: Meeting duration\n                type: integer\n              end_time:\n                description: Meeting end time\n                format: date-time\n                type: string\n              id:\n                description: Meeting ID\n                type: integer\n              participants_count:\n                description: Number of meeting participants\n                type: integer\n              start_time:\n                description: Meeting start time\n                format: date-time\n                type: string\n              topic:\n                description: Meeting topic\n                type: string\n              total_minutes:\n                description: Number of meeting minutes\n                type: integer\n              type:\n                description: Meeting type\n                type: integer\n              user_email:\n                description: User email\n                type: string\n              user_name:\n                description: User display name\n                type: string\n              uuid:\n                description: Meeting UUID\n                format: uuid\n                type: string\n        '404':\n          description: Meeting not found\n      summary: Retrieve meeting details report\n      tags:\n        - Reports\n  '/report/meetings/{meetingId}/participants':\n    get:\n      description: Retrieve ended meeting participants report\n      operationId: reportMeetingParticipants\n      parameters:\n        - $ref: '#/parameters/MeetingId4Metrics'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/NextPageToken'\n      responses:\n        '200':\n          description: Meeting Participants Report Returned\n          schema:\n            allOf:\n              - $ref: '#/definitions/PaginationToken'\n              - properties:\n                  participants:\n                    description: Array of meeting participant objects\n                    items:\n                      properties:\n                        attentiveness_score:\n                          description: Participant attentiveness score\n                          type: integer\n                        duration:\n                          description: Participant duration\n                          type: integer\n                        join_time:\n                          description: Participant join time\n                          format: date-time\n                          type: string\n                        leave_time:\n                          description: Participant leave time\n                          format: date-time\n                          type: string\n                        name:\n                          description: Participant display name\n                          type: string\n                        user_email:\n                          description: Participant email\n                          type: string\n                    type: array\n        '404':\n          description: Meeting not found\n      summary: Retrieve meeting participants report\n      tags:\n        - Reports\n  /report/telephone:\n    get:\n      description: \"Retrieve telephone report for a specified period <aside>Toll Report API is provided for enabled 'Toll Report' option.</aside>\"\n      operationId: reportTelephone\n      parameters:\n        - description: Audio type\n          enum:\n            - 1\n            - 2\n          in: query\n          name: type\n          type: string\n          x-enum-descriptions:\n            - 'Toll-free Call-in & Call-out'\n            - Toll\n        - $ref: '#/parameters/FromDate'\n        - $ref: '#/parameters/ToDate'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: Telephone Report Returned\n          schema:\n            allOf:\n              - properties:\n                  from:\n                    description: Start date for this report\n                    format: date\n                    type: string\n                  to:\n                    description: End date for this report\n                    format: date\n                    type: string\n              - $ref: '#/definitions/Pagination'\n              - properties:\n                  telephony_usage:\n                    description: Array of telephony objects\n                    items:\n                      properties:\n                        dept:\n                          description: User department\n                          type: string\n                        duration:\n                          description: Meeting duration\n                          type: integer\n                        end_time:\n                          description: Meeting end time\n                          format: date-time\n                          type: string\n                        host_email:\n                          description: User email\n                          type: string\n                        host_name:\n                          description: User display name\n                          type: string\n                        meeting_id:\n                          description: Meeting ID\n                          type: integer\n                        phone_number:\n                          description: Telephone Number\n                          type: string\n                        start_time:\n                          description: Meeting start time\n                          format: date-time\n                          type: string\n                        total:\n                          description: Total\n                          type: number\n                    type: array\n      summary: Retrieve telephone report\n      tags:\n        - Reports\n  /report/users:\n    get:\n      description: Retrieve active or inactive hosts report for a specified period\n      operationId: reportUsers\n      parameters:\n        - description: Active hosts or inactive hosts\n          enum:\n            - active\n            - inactive\n          in: query\n          name: type\n          type: string\n          x-enum-descriptions:\n            - Active hosts\n            - Inactive hosts\n        - $ref: '#/parameters/FromDate'\n        - $ref: '#/parameters/ToDate'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: Active/Inactive Hosts Report Returned\n          schema:\n            allOf:\n              - properties:\n                  from:\n                    description: Start date for this report\n                    format: date\n                    type: string\n                  to:\n                    description: End date for this report\n                    format: date\n                    type: string\n              - $ref: '#/definitions/Pagination'\n              - properties:\n                  total_meeting_minutes:\n                    description: Number of meeting minutes for this range\n                    type: integer\n                  total_meetings:\n                    description: Number of meetings for this range\n                    type: integer\n                  total_participants:\n                    description: Number of participants for this range\n                    type: integer\n                  users:\n                    description: Array of user objects\n                    items:\n                      properties:\n                        dept:\n                          description: User department\n                          type: string\n                        email:\n                          description: User email\n                          type: string\n                        id:\n                          description: User ID\n                          format: uuid\n                          type: string\n                        meeting_minutes:\n                          description: Number of meeting minutes for user\n                          type: integer\n                        meetings:\n                          description: Number of meetings for user\n                          type: integer\n                        participants:\n                          description: Number of participants in meetings for user\n                          type: integer\n                        type:\n                          description: User type\n                          type: integer\n                        user_name:\n                          description: User display name\n                          type: string\n                    type: array\n      summary: Retrieve hosts report\n      tags:\n        - Reports\n  '/report/users/{userId}/meetings':\n    get:\n      description: Retrieve ended meetings report for a specified period\n      operationId: reportMeetings\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - $ref: '#/parameters/FromDate'\n        - $ref: '#/parameters/ToDate'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/NextPageToken'\n      responses:\n        '200':\n          description: Active/Inactive Hosts Report Returned\n          schema:\n            allOf:\n              - properties:\n                  from:\n                    description: Start date for this report\n                    format: date\n                    type: string\n                  to:\n                    description: End date for this report\n                    format: date\n                    type: string\n              - $ref: '#/definitions/PaginationToken'\n              - properties:\n                  meetings:\n                    description: Array of meeting objects\n                    items:\n                      properties:\n                        duration:\n                          description: Meeting duration\n                          type: integer\n                        end_time:\n                          description: Meeting end time\n                          format: date-time\n                          type: string\n                        id:\n                          description: Meeting ID\n                          type: integer\n                        participants_count:\n                          description: Number of meeting participants\n                          type: integer\n                        start_time:\n                          description: Meeting start time\n                          format: date-time\n                          type: string\n                        topic:\n                          description: Meeting topic\n                          type: string\n                        total_minutes:\n                          description: Number of meeting minutes\n                          type: integer\n                        type:\n                          description: Meeting type\n                          type: integer\n                        user_email:\n                          description: User email\n                          type: string\n                        user_name:\n                          description: User display name\n                          type: string\n                        uuid:\n                          description: Meeting UUID\n                          format: uuid\n                          type: string\n                    type: array\n        '404':\n          description: User not found\n      summary: Retrieve meetings report\n      tags:\n        - Reports\n  '/report/webinars/{webinarId}':\n    get:\n      description: Retrieve ended webinar details report\n      operationId: reportWebinarDetails\n      parameters:\n        - $ref: '#/parameters/WebinarId4Metrics'\n      responses:\n        '200':\n          description: Webinar detail Returned\n          schema:\n            properties:\n              duration:\n                description: Meeting duration\n                type: integer\n              end_time:\n                description: Meeting end time\n                format: date-time\n                type: string\n              id:\n                description: Meeting ID\n                type: integer\n              participants_count:\n                description: Number of meeting participants\n                type: integer\n              start_time:\n                description: Meeting start time\n                format: date-time\n                type: string\n              topic:\n                description: Meeting topic\n                type: string\n              total_minutes:\n                description: Number of meeting minutes\n                type: integer\n              type:\n                description: Meeting type\n                type: integer\n              user_email:\n                description: User email\n                type: string\n              user_name:\n                description: User display name\n                type: string\n              uuid:\n                description: Meeting UUID\n                format: uuid\n                type: string\n        '404':\n          description: Webinar not found\n      summary: Retrieve webinar details report\n      tags:\n        - Reports\n  '/report/webinars/{webinarId}/participants':\n    get:\n      description: Retrieve ended webinar participants report\n      operationId: reportWebinarParticipants\n      parameters:\n        - $ref: '#/parameters/WebinarId4Metrics'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/NextPageToken'\n      responses:\n        '200':\n          description: Meeting Participants Report Returned\n          schema:\n            allOf:\n              - $ref: '#/definitions/PaginationToken'\n              - properties:\n                  participants:\n                    description: Array of webinar participant objects\n                    items:\n                      properties:\n                        attentiveness_score:\n                          description: Participant attentiveness score\n                          type: string\n                        duration:\n                          description: Participant duration\n                          type: integer\n                        join_time:\n                          description: Participant join time\n                          format: date-time\n                          type: string\n                        leave_time:\n                          description: Participant leave time\n                          format: date-time\n                          type: string\n                        name:\n                          description: Participant display name\n                          type: string\n                        user_email:\n                          description: Participant email\n                          type: string\n                    type: array\n        '404':\n          description: Webinar not found\n      summary: Retrieve webinar participants report\n      tags:\n        - Reports\n  '/report/webinars/{webinarId}/polls':\n    get:\n      description: Retrieve ended webinar polls report\n      operationId: reportWebinarPolls\n      parameters:\n        - $ref: '#/parameters/WebinarId4Metrics'\n      responses:\n        '200':\n          description: Webinar Polls Report Returned\n          schema:\n            properties:\n              id:\n                description: Webinar ID\n                type: integer\n              questions:\n                description: Array of webinar question objects\n                items:\n                  properties:\n                    email:\n                      description: Participant email\n                      type: string\n                    name:\n                      description: Participant display name\n                      type: string\n                    question_details:\n                      description: Array of questions from user\n                      items:\n                        properties:\n                          answer:\n                            description: Given answer\n                            type: string\n                          question:\n                            description: Asked question\n                            type: string\n                      type: array\n                type: array\n              start_time:\n                description: Webinar start time\n                format: date-time\n                type: string\n              uuid:\n                description: Webinar UUID\n                format: uuid\n                type: string\n        '404':\n          description: Webinar not found\n      summary: Retrieve webinar polls report\n      tags:\n        - Reports\n  '/report/webinars/{webinarId}/qa':\n    get:\n      description: 'Retrieve ended webinar Q&A report'\n      operationId: reportWebinarQA\n      parameters:\n        - $ref: '#/parameters/WebinarId4Metrics'\n      responses:\n        '200':\n          description: 'Webinar Q&A Report Returned'\n          schema:\n            properties:\n              id:\n                description: Webinar ID\n                type: integer\n              questions:\n                description: Array of webinar question objects\n                items:\n                  properties:\n                    email:\n                      description: Participant email\n                      type: string\n                    name:\n                      description: Participant display name\n                      type: string\n                    question_details:\n                      description: Array of questions from user\n                      items:\n                        properties:\n                          answer:\n                            description: Given answer\n                            type: string\n                          question:\n                            description: Asked question\n                            type: string\n                      type: array\n                type: array\n              start_time:\n                description: Webinar start time\n                format: date-time\n                type: string\n              uuid:\n                description: Webinar UUID\n                format: uuid\n                type: string\n        '404':\n          description: Webinar not found\n      summary: 'Retrieve webinar Q&A report'\n      tags:\n        - Reports\n  /tsp:\n    get:\n      description: List TSP dial-in numbers under account\n      operationId: tsp\n      parameters: []\n      responses:\n        '200':\n          description: TSP dial-in numbers returned\n          schema:\n            properties:\n              dial_in_numbers:\n                items:\n                  properties:\n                    code:\n                      description: Country Code\n                      type: string\n                    number:\n                      description: 'Dial-in number, length is less than 16.'\n                      type: string\n                    type:\n                      type: string\n                type: array\n              tsp_provider:\n                type: string\n      summary: List TSP dial-in numbers\n      tags:\n        - TSP\n  /users:\n    get:\n      description: List users on your account\n      operationId: users\n      parameters:\n        - default: active\n          description: User status\n          enum:\n            - active\n            - inactive\n            - pending\n          in: query\n          name: status\n          type: string\n          x-enum-descriptions:\n            - users with active status\n            - users with inactive status\n            - users with pending status\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: User list returned\n          schema:\n            $ref: '#/definitions/UserList'\n      summary: List Users\n      tags:\n        - Users\n    post:\n      description: Create a user on your account\n      operationId: userCreate\n      parameters:\n        - description: User\n          in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              action:\n                description: Action to take for user creation\n                enum:\n                  - create\n                  - autoCreate\n                  - custCreate\n                  - ssoCreate\n                type: string\n                x-enum-descriptions:\n                  - 'User will get an email sent from Zoom. There is a confirmation link in this email. User will then need to click this link to activate their account to the Zoom service. The user can set or change their password in Zoom. <br/>'\n                  - 'This action is provided for enterprise customer who has a managed domain. This feature is disabled by default because of the security risk involved in creating a user who does not belong to your domain without notifying the user. <br/>'\n                  - 'This action is provided for API partner only. User created in this way has no password and is not able to log into the Zoom web site or client. <br/>'\n                  - 'This action is provided for enabled \"Pre-provisioning SSO User\" option. User created in this way has no password. If it is not a basic user, will generate a Personal Vanity URL using user name (no domain) of the provisioning email. If user name or pmi is invalid or occupied, will use random number/random personal vanity URL. <br/>'\n              user_info:\n                properties:\n                  email:\n                    description: \"User's email address.\"\n                    type: string\n                  first_name:\n                    description: \"User's first name. Cannot contain more than 5 Chinese words.\"\n                    maxLength: 64\n                    type: string\n                  last_name:\n                    description: \"User's last name. Cannot contain more than 5 Chinese words.\"\n                    maxLength: 64\n                    type: string\n                  password:\n                    description: 'User\u2019s password. Only for \"autoCreate\" action.'\n                    type: string\n                  type:\n                    description: \"User's type\"\n                    enum:\n                      - 1\n                      - 2\n                      - 3\n                    type: integer\n                    x-enum-descriptions:\n                      - basic\n                      - pro\n                      - corp\n                required:\n                  - email\n                  - type\n            required:\n              - action\n            type: object\n      responses:\n        '201':\n          description: User Created\n          headers:\n            Content-Location:\n              description: Location of created User\n              type: string\n          schema:\n            properties:\n              email:\n                description: \"User's email address.\"\n                type: string\n              first_name:\n                description: \"User's first name.\"\n                maxLength: 64\n                type: string\n              id:\n                description: User ID\n                type: string\n              last_name:\n                description: \"User's last name.\"\n                maxLength: 64\n                type: string\n              type:\n                description: \"User's type\"\n                enum:\n                  - 1\n                  - 2\n                  - 3\n                type: integer\n                x-enum-descriptions:\n                  - basic\n                  - pro\n                  - corp\n        '409':\n          description: User with that email already exists\n      summary: Create a user\n      tags:\n        - Users\n  /users/email:\n    get:\n      description: Check if the user email exists.\n      operationId: userEmail\n      parameters:\n        - description: User email\n          in: query\n          name: email\n          required: true\n          type: string\n      responses:\n        '200':\n          description: Success\n          schema:\n            properties:\n              existed_email:\n                type: boolean\n      summary: \"Check a user's email\"\n      tags:\n        - Users\n  /users/zpk:\n    get:\n      description: Check if the zpk is expired. The zpk is used to authenticate a user.\n      operationId: userZPK\n      parameters:\n        - description: User zpk\n          in: query\n          name: zpk\n          required: true\n          type: string\n      responses:\n        '200':\n          description: Success\n          schema:\n            properties:\n              expire_in:\n                type: integer\n      summary: \"Verify a user's zpk\"\n      tags:\n        - Users\n  '/users/{userId}':\n    delete:\n      description: Delete a user on your account\n      operationId: userDelete\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - default: disassociate\n          description: Delete action type\n          enum:\n            - disassociate\n            - delete\n          in: query\n          name: action\n          type: string\n          x-enum-descriptions:\n            - Disassociate a user\n            - Permanently delete a user\n      responses:\n        '204':\n          description: User deleted\n        '404':\n          description: User not found\n      summary: Delete a user\n      tags:\n        - Users\n    get:\n      description: Retrieve a user on your account\n      operationId: user\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - $ref: '#/parameters/LoginType'\n      responses:\n        '200':\n          description: User object returned\n          schema:\n            allOf:\n              - properties:\n                  id:\n                    description: User ID\n                    type: string\n              - $ref: '#/definitions/User'\n              - properties:\n                  pic_url:\n                    type: string\n                  vanity_url:\n                    type: string\n                  verified:\n                    type: integer\n        '404':\n          description: User not found\n      summary: Retrieve a user\n      tags:\n        - Users\n    patch:\n      description: Update a user on your account\n      operationId: userUpdate\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: User\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/UserUpdate'\n      responses:\n        '204':\n          description: User updated\n        '404':\n          description: User not found\n      summary: Update a user\n      tags:\n        - Users\n  '/users/{userId}/assistants':\n    delete:\n      description: \"Delete all of a user'sassitants\"\n      operationId: userAssistantsDelete\n      parameters:\n        - $ref: '#/parameters/UserId'\n      responses:\n        '204':\n          description: Assitants deleted.\n        '404':\n          description: User not found\n      summary: \"Delete a user's assistants\"\n      tags:\n        - Users\n    get:\n      description: \"List a user's assistants\"\n      operationId: userAssistants\n      parameters:\n        - $ref: '#/parameters/UserId'\n      responses:\n        '200':\n          description: Success\n          schema:\n            $ref: '#/definitions/UserAssistantsList'\n        '404':\n          description: User not found\n      summary: \"List a user's assistants\"\n      tags:\n        - Users\n    post:\n      description: Add assistants to a user\n      operationId: userAssistantCreate\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: User assistant\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/UserAssistantsList'\n      responses:\n        '201':\n          description: Assitant Added\n          headers:\n            Content-Location:\n              description: Location of created assistant\n              type: string\n          schema:\n            properties:\n              add_at:\n                format: date-time\n                type: string\n              ids:\n                description: User ID\n                type: string\n        '404':\n          description: User not found\n      summary: Add assistants\n      tags:\n        - Users\n  '/users/{userId}/assistants/{assistantId}':\n    delete:\n      description: \"Delete one of a user's assistants\"\n      operationId: userAssistantDelete\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: \"Assistant's ID\"\n          in: path\n          name: assistantId\n          required: true\n          type: string\n      responses:\n        '204':\n          description: Assitant deleted.\n        '404':\n          description: User or Assistant not found\n      summary: \"Delete a user's assistant\"\n      tags:\n        - Users\n  '/users/{userId}/meetings':\n    get:\n      description: List meetings for a user\n      operationId: meetings\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - $ref: '#/parameters/MeetingType'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: List of Meeting objects returned\n          schema:\n            $ref: '#/definitions/MeetingList'\n        '404':\n          description: User not found\n      summary: List meetings\n      tags:\n        - Meetings\n    post:\n      description: Create a meeting for a user\n      operationId: meetingCreate\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: Meeting object\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/Meeting'\n      responses:\n        '201':\n          description: Meeting Created\n          headers:\n            Content-Location:\n              description: Location of created Meeting\n              type: string\n          schema:\n            allOf:\n              - properties:\n                  host_id:\n                    description: ID of the user set as host of meeting\n                    type: string\n                  id:\n                    description: 'Meeting ID, also known as meeting number'\n                    type: string\n                  uuid:\n                    description: Meeting unique ID\n                    type: string\n                type: object\n              - $ref: '#/definitions/MeetingInfo'\n        '404':\n          description: User not found\n      summary: Create a meeting\n      tags:\n        - Meetings\n  '/users/{userId}/password':\n    put:\n      description: \"Update a user's password\"\n      operationId: userPassword\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: User password\n          in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              password:\n                description: User\u2019s password. Character length is less than 32.\n                type: string\n            required:\n              - password\n            type: object\n      responses:\n        '204':\n          description: Password updated\n        '404':\n          description: User not found\n      summary: \"Update a user's password\"\n      tags:\n        - Users\n  '/users/{userId}/picture':\n    post:\n      description: \"Upload a user's profile picture\"\n      operationId: userPicture\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: 'User picture file, must be a jpg/jpeg file'\n          in: formData\n          name: pic_file\n          required: true\n          type: file\n      responses:\n        '201':\n          description: Picture Uploaded\n          headers:\n            Content-Location:\n              description: \"Location of user's picture\"\n              type: string\n        '404':\n          description: User not found\n      summary: \"Upload a user's picture\"\n      tags:\n        - Users\n  '/users/{userId}/recordings':\n    get:\n      description: List all the recordings\n      operationId: recordingsList\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - $ref: '#/parameters/FromDate'\n        - $ref: '#/parameters/ToDate'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/NextPageToken'\n        - $ref: '#/parameters/Mc'\n        - $ref: '#/parameters/Trash'\n      responses:\n        '200':\n          description: List of Recording objects returned\n          schema:\n            $ref: '#/definitions/RecordingList'\n        '404':\n          description: User not found\n      summary: List all the recordings\n      tags:\n        - Cloud Recording\n  '/users/{userId}/settings':\n    get:\n      description: \"Retrieve a user's settings\"\n      operationId: userSettings\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - $ref: '#/parameters/LoginType'\n      responses:\n        '200':\n          description: User settings returned\n          schema:\n            $ref: '#/definitions/UserSettings'\n        '404':\n          description: User not found\n      summary: \"Retrieve a user's settings\"\n      tags:\n        - Users\n    patch:\n      description: \"Update a user's settings\"\n      operationId: userSettingsUpdate\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: User Settings\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/UserSettings'\n      responses:\n        '204':\n          description: \"User setting's updated\"\n        '404':\n          description: User not found\n      summary: \"Update a user's settings\"\n      tags:\n        - Users\n  '/users/{userId}/status':\n    put:\n      description: \"Update a user's status\"\n      operationId: userStatus\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: User status\n          in: body\n          name: body\n          required: true\n          schema:\n            description: The action\n            properties:\n              action:\n                description: The action type\n                enum:\n                  - activate\n                  - deactivate\n                type: string\n                x-enum-descriptions:\n                  - set users status to active\n                  - set users status to inactive\n            required:\n              - action\n            type: object\n      responses:\n        '204':\n          description: Status updated\n        '404':\n          description: User not found\n      summary: \"Update a user's status\"\n      tags:\n        - Users\n  '/users/{userId}/token':\n    delete:\n      description: \"Revoke a user's SSO token\"\n      operationId: userSSOTokenDelete\n      parameters:\n        - $ref: '#/parameters/UserId'\n      responses:\n        '204':\n          description: Token deleted\n        '404':\n          description: User not found\n      summary: \"Revoke a user's SSO token\"\n      tags:\n        - Users\n    get:\n      description: \"Retrieve a user's token\"\n      operationId: userToken\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: User token type\n          enum:\n            - token\n            - zpk\n          in: query\n          name: type\n          type: string\n          x-enum-descriptions:\n            - Used for starting meeting with client SDK.\n            - Used for generating the start meeting url.\n      responses:\n        '200':\n          description: Token returned\n          schema:\n            properties:\n              token:\n                description: User ID\n                type: string\n        '404':\n          description: User not found\n      summary: \"Retrieve a user's token\"\n      tags:\n        - Users\n  '/users/{userId}/tsp':\n    get:\n      description: \"List user's TSP accounts\"\n      operationId: userTSPs\n      parameters:\n        - $ref: '#/parameters/UserId'\n      responses:\n        '200':\n          description: TSP Account list returned\n          schema:\n            properties:\n              tsp_accounts:\n                items:\n                  $ref: '#/definitions/TSP'\n                type: array\n        '404':\n          description: User not found\n      summary: \"List user's TSP accounts\"\n      tags:\n        - TSP\n    post:\n      description: \"Add a user's TSP account\"\n      operationId: userTSPCreate\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: TSP Account\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/TSP'\n      responses:\n        '201':\n          description: TSP Account added\n          schema:\n            $ref: '#/definitions/TSP'\n      summary: \"Add a user's TSP account\"\n      tags:\n        - TSP\n  '/users/{userId}/tsp/{tspId}':\n    delete:\n      description: \"Delete a user's TSP account\"\n      operationId: userTSPDelete\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - $ref: '#/parameters/TSPId'\n      responses:\n        '204':\n          description: TSP Account deleted\n      summary: \"Delete a user's TSP account\"\n      tags:\n        - TSP\n    get:\n      description: \"Retrieve a user's TSP account\"\n      operationId: userTSP\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - $ref: '#/parameters/TSPId'\n      responses:\n        '200':\n          description: TSP Account returned\n          schema:\n            $ref: '#/definitions/TSP'\n      summary: \"Retrieve a user's TSP account\"\n      tags:\n        - TSP\n    patch:\n      description: \"Update a user's TSP account\"\n      operationId: userTSPUpdate\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - $ref: '#/parameters/TSPId'\n        - description: TSP Account\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/TSP'\n      responses:\n        '204':\n          description: TSP Account updated\n      summary: Update a TSP account\n      tags:\n        - TSP\n  '/users/{userId}/webinars':\n    get:\n      description: List webinars for a user\n      operationId: webinars\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: List of Webinar objects returned\n          schema:\n            $ref: '#/definitions/WebinarList'\n        '404':\n          description: User not found\n      summary: List webinars\n      tags:\n        - Webinars\n    post:\n      description: Create a webinar for a user\n      operationId: webinarCreate\n      parameters:\n        - $ref: '#/parameters/UserId'\n        - description: User\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/Webinar'\n      responses:\n        '201':\n          description: Webinar Created\n          headers:\n            Content-Location:\n              description: Location of created Webinar\n              type: string\n          schema:\n            allOf:\n              - properties:\n                  host_id:\n                    description: ID of the user set as host of Webinar\n                    type: string\n                  id:\n                    description: 'Webinar ID, also known as Webinar number'\n                    type: string\n                  uuid:\n                    description: Webinar unique ID\n                    type: string\n                type: object\n              - $ref: '#/definitions/WebinarInfo'\n        '404':\n          description: User not found\n      summary: Create a webinar\n      tags:\n        - Webinars\n  /webhooks:\n    get:\n      description: List webhooks for a account\n      operationId: webhooks\n      parameters: []\n      responses:\n        '200':\n          description: List of Webhook objects returned\n          schema:\n            $ref: '#/definitions/WebhookList'\n        '404':\n          description: Webhook not found\n      summary: List webhooks\n      tags:\n        - Webhooks\n    post:\n      description: Create a webhook for a account\n      operationId: webhookCreate\n      parameters:\n        - description: Webhook\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/Webhook'\n      responses:\n        '201':\n          description: Webhook Created\n          headers:\n            Content-Location:\n              description: Location of created Webhook\n              type: string\n          schema:\n            allOf:\n              - properties:\n                  webhook_id:\n                    description: Webhook Id.\n                    type: string\n              - $ref: '#/definitions/Webhook'\n              - properties:\n                  created_at:\n                    description: Webhook create time\n                    format: date-time\n                    type: string\n        '404':\n          description: Account not found\n      summary: Create a webhook\n      tags:\n        - Webhooks\n  /webhooks/options:\n    patch:\n      description: Switch webhook version\n      operationId: webhookSwitch\n      parameters:\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              version:\n                enum:\n                  - v1\n                  - v2\n                type: string\n                x-enum-descriptions:\n                  - Version 1\n                  - Version 2\n            required:\n              - version\n      responses:\n        '204':\n          description: Webhook Subscribe version update\n        '404':\n          description: Webhook Subscribe not found\n      summary: Switch webhook version\n      tags:\n        - Webhooks\n  '/webhooks/{webhookId}':\n    delete:\n      description: Delete a webhook\n      operationId: webhookDelete\n      parameters:\n        - $ref: '#/parameters/WebhookId'\n      responses:\n        '204':\n          description: Webhook deleted\n        '404':\n          description: Webhook not found\n      summary: Delete a webhook\n      tags:\n        - Webhooks\n    get:\n      description: Retrieve a webhook\n      operationId: webhook\n      parameters:\n        - $ref: '#/parameters/WebhookId'\n      responses:\n        '200':\n          description: Webhook object returned\n          schema:\n            allOf:\n              - properties:\n                  webhook_id:\n                    description: Webhook Id.\n                    type: string\n              - $ref: '#/definitions/Webhook'\n              - properties:\n                  created_at:\n                    description: Webhook create time\n                    format: date-time\n                    type: string\n        '404':\n          description: Webinar not found\n      summary: Retrieve a webhook\n      tags:\n        - Webhooks\n    patch:\n      description: Update a webhook\n      operationId: webhookUpdate\n      parameters:\n        - $ref: '#/parameters/WebhookId'\n        - description: Webhook\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/WebhookUpdate'\n      responses:\n        '204':\n          description: Webhook Updated\n        '404':\n          description: Webhook not found\n      summary: Update a webhook\n      tags:\n        - Webhooks\n  '/webinars/{webinarId}':\n    delete:\n      description: Delete a webinar\n      operationId: webinarDelete\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n        - $ref: '#/parameters/OccurrenceId'\n      responses:\n        '204':\n          description: Webinar deleted\n        '404':\n          description: Webinar not found\n      summary: Delete a webinar\n      tags:\n        - Webinars\n    get:\n      description: Retrieve a webinar\n      operationId: webinar\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n      responses:\n        '200':\n          description: Webinar object returned\n          schema:\n            allOf:\n              - properties:\n                  host_id:\n                    description: ID of the user set as host of webinar\n                    type: string\n                  id:\n                    description: 'Webinar ID, also know as webinar number'\n                    type: string\n                  uuid:\n                    description: Webinar unique ID\n                    type: string\n                type: object\n              - $ref: '#/definitions/WebinarInfo'\n        '404':\n          description: Webinar not found\n      summary: Retrieve a webinar\n      tags:\n        - Webinars\n    patch:\n      description: Update a webinar\n      operationId: webinarUpdate\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n        - description: Webinar\n          in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/WebinarUpdate'\n      responses:\n        '204':\n          description: Webinar Updated\n        '404':\n          description: Webinar not found\n      summary: Update a webinar\n      tags:\n        - Webinars\n  '/webinars/{webinarId}/panelists':\n    delete:\n      description: Remove all panelists from a webinar\n      operationId: webinarPanelistsDelete\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n      responses:\n        '204':\n          description: Panelists removed\n        '404':\n          description: Webinar not found\n      summary: \"Remove a webinar's panelists\"\n      tags:\n        - Webinars\n    get:\n      description: List panelists for a webinar\n      operationId: webinarPanelists\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n      responses:\n        '200':\n          description: Success\n          schema:\n            $ref: '#/definitions/WebinarPanelistList'\n        '404':\n          description: Webinar not found\n      summary: \"List a webinar's panelists\"\n      tags:\n        - Webinars\n    post:\n      description: Add panelist to webinar\n      operationId: webinarPanelistCreate\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/WebinarPanelist'\n      responses:\n        '201':\n          description: Panelist created\n          schema:\n            properties:\n              id:\n                description: Panelist ID\n                type: string\n              join_url:\n                description: Join URL for this panelist\n                type: string\n            type: object\n        '404':\n          description: Webinar not found\n      summary: Add a webinar panelist\n      tags:\n        - Webinars\n  '/webinars/{webinarId}/panelists/{panelistId}':\n    delete:\n      description: Remove a panelist from a webinar\n      operationId: webinarPanelistDelete\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n        - description: The panelist ID\n          in: path\n          name: panelistId\n          required: true\n          type: integer\n      responses:\n        '204':\n          description: Panelists removed\n        '404':\n          description: Webinar or Panelist not found\n      summary: Remove a webinar panelist\n      tags:\n        - Webinars\n  '/webinars/{webinarId}/registrants':\n    get:\n      description: List registrants for a webinar\n      operationId: webinarRegistrants\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n        - $ref: '#/parameters/OccurrenceId'\n        - $ref: '#/parameters/RegistrantStatus'\n        - $ref: '#/parameters/PageSize'\n        - $ref: '#/parameters/PageNumber'\n      responses:\n        '200':\n          description: Success\n          schema:\n            $ref: '#/definitions/WebinarRegistrantList'\n        '404':\n          description: Webinar not found\n      summary: \"List a webinar's registrants\"\n      tags:\n        - Webinars\n    post:\n      description: Add a registrant for a webinar\n      operationId: webinarRegistrantCreate\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n        - description: 'Occurrence IDs, could get this value from Webinar Get API. Multiple value separated by comma.'\n          in: query\n          name: occurrence_ids\n          type: string\n        - in: body\n          name: body\n          required: true\n          schema:\n            $ref: '#/definitions/WebinarRegistrant'\n      responses:\n        '201':\n          description: Registration created\n          schema:\n            properties:\n              id:\n                description: Registrant ID\n                type: string\n              join_url:\n                description: Join URL for this registrant\n                type: string\n              registrant_id:\n                description: Registrant ID\n                type: string\n              start_time:\n                description: Start time\n                format: date-time\n                type: string\n              topic:\n                description: Topic\n                type: string\n            type: object\n        '404':\n          description: Webinar not found\n      summary: Add a webinar registrant\n      tags:\n        - Webinars\n  '/webinars/{webinarId}/registrants/status':\n    put:\n      description: \"Update a webinar registrant's status\"\n      operationId: webinarRegistrantStatus\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n        - $ref: '#/parameters/OccurrenceId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              action:\n                enum:\n                  - approve\n                  - cancel\n                  - deny\n                type: string\n                x-enum-descriptions:\n                  - Approve registrant\n                  - Cancel registrant\n                  - Deny registrant\n              registrants:\n                description: List of registrants\n                items:\n                  properties:\n                    email:\n                      type: string\n                    id:\n                      type: string\n                maximum: 30\n                type: array\n            required:\n              - action\n      responses:\n        '204':\n          description: Registrant status updated\n        '404':\n          description: Webinar or Registrant not found\n      summary: \"Update a webinar registrant's status\"\n      tags:\n        - Webinars\n  '/webinars/{webinarId}/status':\n    put:\n      description: \"Update a webinar's status\"\n      operationId: webinarStatus\n      parameters:\n        - $ref: '#/parameters/WebinarId'\n        - in: body\n          name: body\n          required: true\n          schema:\n            properties:\n              status:\n                enum:\n                  - end\n                type: string\n                x-enum-descriptions:\n                  - end a webinar\n      responses:\n        '204':\n          description: Webinar updated\n        '404':\n          description: Webinar not found\n      summary: \"Update a webinar's status\"\n      tags:\n        - Webinars\ndefinitions:\n  Account:\n    description: \"The account object represents an account on zoom. The person who created the account, or who the account was created for, is referred to as the Account owner. You can read more about the Zoom account structure <a href='https://developer.zoom.us/blog/a-brief-look-at-zoom-account-structures/' target='_blank'>here</a>.\"\n    properties:\n      email:\n        description: \"User's email address.\"\n        type: string\n      first_name:\n        description: \"User's first name.\"\n        type: string\n      last_name:\n        description: \"User's last name.\"\n        type: string\n      options:\n        $ref: '#/definitions/AccountOptions'\n      password:\n        description: \"User's password.\"\n        type: string\n    required:\n      - email\n      - first_name\n      - last_name\n      - password\n    type: object\n  AccountList:\n    allOf:\n      - $ref: '#/definitions/Pagination'\n      - $ref: '#/definitions/AccountListItem'\n    description: List of Accounts\n    title: Account List\n    type: object\n  AccountListItem:\n    description: Account object in account list\n    properties:\n      accounts:\n        description: List of Account objects.\n        items:\n          properties:\n            account_name:\n              description: Account name\n              type: string\n            account_type:\n              description: Account type\n              type: string\n            created_at:\n              description: Account creation date/time\n              format: date-time\n              type: string\n            id:\n              description: Account ID\n              format: uuid\n              type: string\n            owner_email:\n              description: Account owner email\n              type: string\n            seats:\n              description: Account seats\n              type: integer\n            subscription_end_time:\n              description: Account subscription end date/time\n              format: date-time\n              type: string\n            subscription_start_time:\n              description: Account subscription start date/time\n              format: date-time\n              type: string\n        type: array\n    type: object\n  AccountOptions:\n    description: Account options object\n    properties:\n      meeting_connectors:\n        description: 'Meeting Connector, multiple value separated by comma.'\n        type: string\n      pay_mode:\n        default: master\n        description: Payee\n        enum:\n          - master\n          - sub\n        type: string\n        x-enum-descriptions:\n          - Master Account holder pays\n          - Sub Account holders pays\n      room_connectors:\n        description: 'Virtual Room Connector, multiple value separated by comma.'\n        type: string\n      share_mc:\n        default: false\n        description: Enable Share Meeting Connector.\n        type: boolean\n      share_rc:\n        default: false\n        description: Enable Share Virtual Room Connector.\n        type: boolean\n    type: object\n  AccountPlan:\n    description: Account plan object\n    properties:\n      hosts:\n        description: Account plan number of hosts\n        type: integer\n      type:\n        description: Account plan type\n        type: string\n    type: object\n  AccountPlanBaseRequired:\n    description: Account base plan object\n    properties:\n      hosts:\n        description: 'Account base plan number of hosts. For a Pro Plan, please select a value between 1 and 9. For a Business Plan, please select a value between 10 and 49. For a Education Plan, please select a value between 20 and 149. For a Free Trial Plan, please select a value between 1 and 9999.'\n        type: integer\n      type:\n        description: Account base plan type\n        type: string\n    required:\n      - type\n      - hosts\n    type: object\n  AccountPlanRequired:\n    description: Account plan object\n    properties:\n      hosts:\n        description: Account plan number of hosts.\n        type: integer\n      type:\n        description: 'Account <a href=\"#plans\">plan type</a>'\n        type: string\n    required:\n      - type\n      - hosts\n    type: object\n  AccountPlans:\n    description: Account Plans object\n    properties:\n      plan_audio:\n        description: Additional Audio Conferencing Plan type\n        properties:\n          callout_countries:\n            description: 'Call-out countries, multiple value separated by comma'\n            type: string\n          ddi_numbers:\n            description: Dedicated Dial-In Numbers\n            type: integer\n          premium_countries:\n            description: 'Premium countries, multiple value separated by comma'\n            type: string\n          tollfree_countries:\n            description: 'Toll-free countries, multiple value separated by comma'\n            type: string\n          type:\n            description: Additional Audio Conferencing Plan type\n            type: string\n        type: object\n      plan_base:\n        $ref: '#/definitions/AccountPlanBaseRequired'\n      plan_large_meeting:\n        description: Additional Large Meeting Plans\n        items:\n          $ref: '#/definitions/AccountPlan'\n        type: array\n      plan_recording:\n        description: Additional Cloud Recording Plan\n        type: string\n      plan_room_connector:\n        $ref: '#/definitions/AccountPlan'\n      plan_webinar:\n        description: Additional Webinar Plans\n        items:\n          $ref: '#/definitions/AccountPlan'\n        type: array\n      plan_zoom_rooms:\n        $ref: '#/definitions/AccountPlan'\n    type: object\n  AccountSettings:\n    properties:\n      email_notification:\n        $ref: '#/definitions/AccountSettingsEmailNotification'\n      feature:\n        $ref: '#/definitions/AccountSettingsFeature'\n      in_meeting:\n        $ref: '#/definitions/AccountSettingsInMeeting'\n      integration:\n        $ref: '#/definitions/AccountSettingsIntegration'\n      recording:\n        $ref: '#/definitions/AccountSettingsRecording'\n      schedule_meting:\n        $ref: '#/definitions/AccountSettingsScheduleMeeting'\n      security:\n        $ref: '#/definitions/AccountSettingsSecurity'\n      telephony:\n        $ref: '#/definitions/AccountSettingsTelephony'\n      zoom_rooms:\n        $ref: '#/definitions/AccountSettingsZoomRooms'\n    title: Account settings\n    type: object\n  AccountSettingsEmailNotification:\n    description: 'Account Settings: Notification'\n    properties:\n      alternative_host_reminder:\n        description: When an alternative host is set or removed from a meeting\n        type: boolean\n      cancel_meeting_reminder:\n        description: When a meeting is cancelled\n        type: boolean\n      cloud_recording_avaliable_reminder:\n        description: Allow keep recording from being automatically deleted\n        type: boolean\n      jbh_reminder:\n        description: When attendees join meeting before host\n        type: boolean\n      low_host_count_reminder:\n        description: When host licenses are running low\n        type: boolean\n    type: object\n  AccountSettingsFeature:\n    description: 'Account Settings: Feature'\n    properties:\n      meeting_capacity:\n        default: 100\n        description: Meeting capacity\n        type: integer\n    type: object\n  AccountSettingsInMeeting:\n    description: 'Account Settings: In Meeting'\n    properties:\n      alert_guest_join:\n        description: Identify guest participants in the meeting/webinar\n        type: boolean\n      allow_show_zoom_windows:\n        description: Allow to share Zoom windows in desktop sharing\n        type: boolean\n      annotation:\n        description: Annotation\n        type: boolean\n      anonymous_question_answer:\n        description: 'Allow Anonymous Q&A in Webinar'\n        type: boolean\n      attendee_on_hold:\n        description: Allow host to put attendee on hold\n        type: boolean\n      attention_tracking:\n        description: Attention tracking\n        type: boolean\n      auto_answer:\n        description: Enable Auto Answer Group\n        type: boolean\n      auto_saving_chat:\n        description: Auto Saving Chats\n        type: boolean\n      breakout_room:\n        description: Breakout room\n        type: boolean\n      chat:\n        description: Chat\n        type: boolean\n      closed_caption:\n        description: Closed caption\n        type: boolean\n      co_host:\n        description: Co-Host\n        type: boolean\n      dscp_audio:\n        description: DSCP Audio\n        maximum: 63\n        minimum: 1\n        type: integer\n      dscp_marking:\n        description: DSCP marking\n        type: boolean\n      dscp_video:\n        description: DSCP Video\n        maximum: 63\n        minimum: 1\n        type: integer\n      e2e_encryption:\n        description: End-to-End Encryption\n        type: boolean\n      far_end_camera_control:\n        description: Far end camera control\n        type: boolean\n      feedback:\n        description: Feedback to Zoom\n        type: boolean\n      file_transfer:\n        description: File transfer\n        type: boolean\n      group_hd:\n        description: Group HD video\n        type: boolean\n      original_audio:\n        description: Allow users to select original sound in their client settings\n        type: boolean\n      p2p_connetion:\n        description: Peer to Peer connection while only 2 people in a meeting\n        type: boolean\n      p2p_ports:\n        description: Listening ports range\n        type: boolean\n      polling:\n        description: Polling\n        type: boolean\n      ports_range:\n        default: ''\n        description: 'Listening ports range, separated by comma (ex 55,56). The ports range is between 1 to 65535'\n        type: string\n      post_meeting_feedback:\n        description: Display end-of-meeting experience feedback survey\n        type: boolean\n      private_chat:\n        description: Private Chat\n        type: boolean\n      remote_control:\n        description: Remote control\n        type: boolean\n      screen_sharing:\n        description: Screen sharing\n        type: boolean\n      sending_default_email_invites:\n        description: Only show default email when sending email invites\n        type: boolean\n      show_meeting_control_toolbar:\n        description: Always show meeting control toolbar\n        type: boolean\n      stereo_audio:\n        description: Allow users to select stereo audio in their client settings\n        type: boolean\n      use_html_format_email:\n        description: Use HTML format email for Outlook plugin\n        type: boolean\n      virtual_background:\n        description: Virtual background\n        type: boolean\n      watermark:\n        description: Add watermark when viewing shared screen\n        type: boolean\n      webinar_question_answer:\n        description: 'Q&A in webinar'\n        type: boolean\n      whiteboard:\n        description: Whiteboard\n        type: boolean\n    type: object\n  AccountSettingsIntegration:\n    description: 'Account Settings: Integration'\n    properties:\n      box:\n        description: Box\n        type: boolean\n      dropbox:\n        description: Dropbox\n        type: boolean\n      google_calendar:\n        description: Google Calendar\n        type: boolean\n      google_drive:\n        description: Google Drive\n        type: boolean\n      kubi:\n        description: Kubi\n        type: boolean\n      microsoft_one_drive:\n        description: Microsoft OneDrive\n        type: boolean\n    type: object\n  AccountSettingsRecording:\n    description: 'Account Settings: Recording'\n    properties:\n      account_user_access_recording:\n        description: Only users on my account can access cloud recordings\n        type: boolean\n      auto_delete_cmr:\n        description: Auto delete cloud recordings after days\n        type: boolean\n      auto_delete_cmr_days:\n        description: A specified number of days of auto delete cloud recordings\n        type: integer\n      auto_recording:\n        description: Automatic recording\n        enum:\n          - local\n          - cloud\n          - none\n        type: string\n        x-enum-descriptions:\n          - Record on local\n          - Record on cloud\n          - Disabled\n      cloud_recording:\n        description: Cloud recording\n        type: boolean\n      cloud_recording_download:\n        description: Cloud Recording Downloads\n        type: boolean\n      cloud_recording_download_host:\n        description: Only the host can download cloud recordings\n        type: boolean\n      local_recording:\n        description: Local recording\n        type: boolean\n      record_audio_file:\n        description: Record an audio only file\n        type: boolean\n      record_gallery_view:\n        description: Record the gallery view\n        type: boolean\n      record_speaker_view:\n        description: Record the active speaker view\n        type: boolean\n      recording_audio_transcript:\n        description: Audio transcript\n        type: boolean\n      save_chat_text:\n        description: Save chat text from the meeting\n        type: boolean\n      show_timestamp:\n        description: Show timestamp on video\n        type: boolean\n    type: object\n  AccountSettingsScheduleMeeting:\n    description: 'Account Settings: Schedule Meeting'\n    properties:\n      audio_type:\n        default: both\n        description: Audio Type\n        enum:\n          - both\n          - telephony\n          - voip\n          - thirdParty\n        type: string\n        x-enum-descriptions:\n          - Telephony and VoIP\n          - Audio PSTN telephony only\n          - VoIP only\n          - 3rd party audio conference\n      enforce_login:\n        description: Only signed-in users can join meetings\n        type: boolean\n      enforce_login_domains:\n        description: Only signed-in users with a specified domains\n        type: string\n      enforce_login_with_domains:\n        description: Only signed-in users with a specified domains can join meetings\n        type: boolean\n      force_pmi_jbh_password:\n        description: Require a password for Personal Meetings if attendees can join before host\n        type: boolean\n      host_video:\n        description: Host Video\n        type: boolean\n      join_before_host:\n        description: Join Before Host\n        type: boolean\n      not_store_meeting_topic:\n        description: 'Always display \"Zoom Meeting\" as the meeting topic'\n        type: boolean\n      participant_video:\n        description: Participants Video\n        type: boolean\n    type: object\n  AccountSettingsSecurity:\n    description: 'Account Settings: Security'\n    properties:\n      admin_change_name_pic:\n        description: \"Only account administrators can change user's username and picture\"\n        type: boolean\n      hide_billing_info:\n        description: Hide billing information\n        type: boolean\n      import_photos_from_devices:\n        description: \"Allow importing of photos from photo library on the user's device\"\n        type: boolean\n    type: object\n  AccountSettingsTelephony:\n    description: 'Account Settings: Telephony'\n    properties:\n      audio_conference_info:\n        description: 3rd party audio conference info\n        type: string\n      third_party_audio:\n        description: 3rd party audio conference\n        type: boolean\n    type: object\n  AccountSettingsZoomRooms:\n    description: 'Account Settings: Zoom Rooms'\n    properties:\n      auto_start_stop_scheduled_meetings:\n        description: Automatic start/stop scheduled meetings\n        type: boolean\n      cmr_for_instant_meeting:\n        description: Cloud recording for instant meetings\n        type: boolean\n      force_private_meeting:\n        description: Transform all meetings to private\n        type: boolean\n      hide_host_information:\n        description: Hide host and meeting ID from private meetings\n        type: boolean\n      list_meetings_with_calendar:\n        description: Display meeting list with calendar integration\n        type: boolean\n      start_airplay_manually:\n        description: Start AirPlay service manually\n        type: boolean\n      ultrasonic:\n        description: Automatic direct sharing using ultrasonic proximity signal\n        type: boolean\n      upcoming_meeting_alert:\n        description: Upcoming meeting alert\n        type: boolean\n      weekly_system_restart:\n        description: Weekly system restart\n        type: boolean\n      zr_post_meeting_feedback:\n        description: Zoom Room post meeting feedback\n        type: boolean\n    type: object\n  BillingContact:\n    description: Billing Contact object\n    properties:\n      address:\n        description: \"Billing Contact's address.\"\n        type: string\n      apt:\n        description: \"Billing Contact's apartment/suite.\"\n        type: string\n      city:\n        description: \"Billing Contact's city.\"\n        type: string\n      country:\n        description: \"Billing Contact's country.\"\n        type: string\n      email:\n        description: \"Billing Contact's email address.\"\n        type: string\n      first_name:\n        description: \"Billing Contact's first name.\"\n        type: string\n      last_name:\n        description: \"Billing Contact's last name.\"\n        type: string\n      phone_number:\n        description: \"Billing Contact's phone number.\"\n        type: string\n      state:\n        description: \"Billing Contact's state.\"\n        type: string\n      zip:\n        description: \"Billing Contact's zip/postal code.\"\n        type: string\n    type: object\n  BillingContactRequired:\n    description: Billing Contact object\n    properties:\n      address:\n        description: \"Billing Contact's address.\"\n        type: string\n      apt:\n        description: \"Billing Contact's apartment/suite.\"\n        type: string\n      city:\n        description: \"Billing Contact's city.\"\n        type: string\n      country:\n        description: \"Billing Contact's country.\"\n        type: string\n      email:\n        description: \"Billing Contact's email address.\"\n        type: string\n      first_name:\n        description: \"Billing Contact's first name.\"\n        type: string\n      last_name:\n        description: \"Billing Contact's last name.\"\n        type: string\n      phone_number:\n        description: \"Billing Contact's phone number.\"\n        type: string\n      state:\n        description: \"Billing Contact's state.\"\n        type: string\n      zip:\n        description: \"Billing Contact's zip/postal code.\"\n        type: string\n    required:\n      - first_name\n      - last_name\n      - email\n      - phone_number\n      - address\n      - city\n      - state\n      - zip\n      - country\n    type: object\n  CustomQuestion:\n    description: Custom Question\n    properties:\n      title:\n        type: string\n      value:\n        type: string\n    type: object\n  DateTime:\n    description: DateTime Object\n    properties:\n      from:\n        description: 'Start Date,'\n        format: date\n        type: string\n      to:\n        description: End Date\n        format: date\n        type: string\n    type: object\n  Group:\n    description: Group object\n    properties:\n      name:\n        description: Group name\n        type: string\n      total_members:\n        description: Total number of members in this group.\n        type: integer\n    type: object\n  GroupList:\n    description: List of Groups\n    properties:\n      groups:\n        description: List of Group objects.\n        items:\n          allOf:\n            - properties:\n                id:\n                  description: Group ID\n                  type: string\n            - $ref: '#/definitions/Group'\n        type: array\n      total_records:\n        description: Total records\n        type: integer\n    type: object\n  GroupMember:\n    description: Group member object\n    properties:\n      email:\n        description: User email\n        type: string\n      first_name:\n        description: User first name\n        type: string\n      id:\n        description: User ID\n        type: string\n      last_name:\n        description: User last name\n        type: string\n      type:\n        description: User type\n        type: integer\n    type: object\n  GroupMemberList:\n    allOf:\n      - $ref: '#/definitions/Pagination'\n      - properties:\n          members:\n            description: List of Group member objects.\n            items:\n              $ref: '#/definitions/GroupMember'\n            type: array\n    description: List of Group Members\n    title: Group Member List\n    type: object\n  IMGroup:\n    allOf:\n      - $ref: '#/definitions/Group'\n      - properties:\n          search_by_account:\n            description: Members can search others under same account\n            type: boolean\n          search_by_domain:\n            description: Members can search others in the same email domain\n            type: boolean\n          search_by_ma_account:\n            description: 'Members can search others under same master account, including all sub accounts'\n            type: boolean\n          type:\n            default: normal\n            description: IM Group type\n            enum:\n              - normal\n              - shared\n              - restricted\n            type: string\n            x-enum-descriptions:\n              - Only members can see the group automatically. Other people can search members in the group\n              - All people in the account can see the group and members automatically\n              - Nobody can see the group or search members except the members in the group\n    description: IM Group object\n    type: object\n  IMGroupList:\n    allOf:\n      - $ref: '#/definitions/Pagination'\n      - properties:\n          groups:\n            description: List of Group objects.\n            items:\n              allOf:\n                - properties:\n                    id:\n                      description: IM Group ID\n                      type: string\n                - $ref: '#/definitions/IMGroup'\n            type: array\n    description: List of IM Groups\n    title: IM Group List\n    type: object\n  Meeting:\n    allOf:\n      - $ref: '#/definitions/Session'\n    description: Meeting object\n    type: object\n  MeetingInfo:\n    description: Meeting object\n    properties:\n      agenda:\n        description: Agenda\n        type: string\n      created_at:\n        description: Create time\n        format: date-time\n        type: string\n      duration:\n        description: Meeting duration\n        type: integer\n      h323_password:\n        description: H.323/SIP room system password\n        type: string\n      join_url:\n        description: Join url\n        type: string\n      occurrences:\n        $ref: '#/definitions/Occurrences'\n      password:\n        description: Meeting password\n        type: string\n      settings:\n        $ref: '#/definitions/MeetingSettings'\n      start_time:\n        description: Meeting start time\n        format: date-time\n        type: string\n      start_url:\n        description: Start url\n        type: string\n      timezone:\n        description: Timezone to format start_time\n        type: string\n      topic:\n        description: Meeting topic\n        type: string\n      type:\n        default: 2\n        description: Meeting Type\n        enum:\n          - 1\n          - 2\n          - 3\n          - 8\n        type: integer\n        x-enum-descriptions:\n          - Instant Meeting\n          - Scheduled Meeting\n          - Recurring Meeting with no fixed time\n          - Recurring Meeting with fixed time\n    type: object\n  MeetingList:\n    allOf:\n      - $ref: '#/definitions/Pagination'\n      - properties:\n          meetings:\n            description: List of Meeting objects.\n            items:\n              allOf:\n                - properties:\n                    created_at:\n                      description: Create time\n                      format: date-time\n                      type: string\n                    duration:\n                      description: Meeting duration\n                      type: integer\n                    host_id:\n                      description: ID of the user set as host of meeting\n                      type: string\n                    id:\n                      description: 'Meeting ID, also know as meeting number'\n                      type: string\n                    join_url:\n                      description: Join url\n                      type: string\n                    start_time:\n                      description: Meeting start time\n                      format: date-time\n                      type: string\n                    timezone:\n                      description: Timezone to format start_time\n                      type: string\n                    topic:\n                      description: Meeting topic\n                      type: string\n                    type:\n                      description: Meeting Type\n                      enum:\n                        - 1\n                        - 2\n                        - 3\n                        - 8\n                      type: integer\n                      x-enum-descriptions:\n                        - Instant Meeting\n                        - Scheduled Meeting\n                        - Recurring Meeting with no fixed time\n                        - Recurring Meeting with fixed time\n                    uuid:\n                      description: Meeting unique ID\n                      type: string\n                  type: object\n            type: array\n    description: List of Meetings\n    title: Group List\n    type: object\n  MeetingMetric:\n    description: Meeting metric details\n    properties:\n      duration:\n        description: Meeting duration\n        type: string\n      email:\n        description: User email\n        type: string\n      end_time:\n        description: Meeting end time\n        format: date-time\n        type: string\n      has_3rd_party_audio:\n        description: ''\n        type: boolean\n      has_pstn:\n        description: ''\n        type: boolean\n      has_recording:\n        description: ''\n        type: boolean\n      has_screen_share:\n        description: ''\n        type: boolean\n      has_sip:\n        description: ''\n        type: boolean\n      has_video:\n        description: ''\n        type: boolean\n      has_voip:\n        description: ''\n        type: boolean\n      host:\n        description: User display name\n        type: string\n      id:\n        description: Meeting ID\n        type: integer\n      participants:\n        description: Meeting participant count\n        type: integer\n      start_time:\n        description: Meeting start time\n        format: date-time\n        type: string\n      topic:\n        description: Meeting topic\n        type: string\n      user_type:\n        description: User type\n        type: string\n      uuid:\n        description: Meeting UUID\n        format: uuid\n        type: string\n    title: Meeting Metrics\n    type: object\n  MeetingRegistrant:\n    allOf:\n      - $ref: '#/definitions/Registrant'\n    description: Meeting registrant\n    type: object\n  MeetingRegistrantList:\n    allOf:\n      - $ref: '#/definitions/RegistrantList'\n    description: List of Users\n    title: Registration List\n    type: object\n  MeetingSettings:\n    description: Meeting Settings\n    properties:\n      alternative_hosts:\n        description: Alternative hosts emails or IDs. Multiple value separated by comma.\n        type: string\n      approval_type:\n        default: 2\n        enum:\n          - 0\n          - 1\n          - 2\n        type: integer\n        x-enum-descriptions:\n          - Automatically Approve\n          - Manually Approve\n          - No Registration Required\n      audio:\n        default: both\n        description: Meeting audio options\n        enum:\n          - both\n          - telephony\n          - voip\n        type: string\n        x-enum-descriptions:\n          - Both Telephony and VoIP\n          - Telephony only\n          - VoIP only\n      auto_recording:\n        default: none\n        enum:\n          - local\n          - cloud\n          - none\n        type: string\n        x-enum-descriptions:\n          - Record to local device\n          - Record to cloud\n          - No Recording\n      cn_meeting:\n        default: false\n        description: Host meeting in China\n        type: boolean\n      enforce_login:\n        description: Only signed-in users can join this meeting\n        type: boolean\n      enforce_login_domains:\n        description: Only signed-in users with specified domains can join meetings\n        type: string\n      host_video:\n        description: Start video when host join meeting\n        type: boolean\n      in_meeting:\n        default: false\n        description: Host meeting in India\n        type: boolean\n      join_before_host:\n        default: false\n        description: Join meeting before host start the meeting. Only used for scheduled or recurring meetings\n        type: boolean\n      mute_upon_entry:\n        default: false\n        description: Mute participants upon entry\n        type: boolean\n      participant_video:\n        description: Start video when participants join meeting\n        type: boolean\n      registration_type:\n        default: 1\n        description: Registration type. Used for recurring meeting with fixed time only.\n        enum:\n          - 1\n          - 2\n          - 3\n        type: integer\n        x-enum-descriptions:\n          - Attendees register once and can attend any of the occurrences\n          - Attendees need to register for each occurrence to attend\n          - Attendees register once and can choose one or more occurrences to attend\n      use_pmi:\n        default: false\n        description: Use Personal Meeting ID. Only used for scheduled meetings and recurring meetings with no fixed time\n        type: boolean\n      watermark:\n        default: false\n        description: Enable watermark when viewing the shared screen\n        type: boolean\n    type: object\n  MeetingUpdate:\n    allOf:\n      - $ref: '#/definitions/SessionUpdate'\n    description: Meeting object\n    type: object\n  Occurrence:\n    description: Occurence object\n    properties:\n      duration:\n        description: Duration\n        type: integer\n      occurrence_id:\n        description: Occurrence Id\n        type: integer\n      start_time:\n        description: Start time\n        format: date-time\n        type: string\n      status:\n        description: Occurrence status\n        type: string\n    type: object\n  Occurrences:\n    description: Array of occurrence objects\n    items:\n      $ref: '#/definitions/Occurrence'\n    type: array\n  Pagination:\n    description: Pagination Object\n    properties:\n      page_count:\n        description: The number of items returned on this page.\n        type: integer\n      page_number:\n        default: 1\n        description: The page number of current results.\n        type: integer\n      page_size:\n        default: 30\n        description: The amount of records returns within a single API call.\n        maximum: 300\n        type: integer\n      total_records:\n        description: The number of all records available across pages.\n        type: integer\n    type: object\n  PaginationToken:\n    description: Pagination Object\n    properties:\n      next_page_token:\n        description: 'Next page token, used to paginate through large result sets. A next page token will be returned whenever the set of available result list exceeds page size. The expiration period is 15 minutes.'\n        type: string\n      page_count:\n        description: The number of items returned on this page.\n        type: integer\n      page_size:\n        default: 30\n        description: 'The amount of records returns within a single API call. '\n        maximum: 300\n        type: integer\n      total_records:\n        description: The number of all records available across pages.\n        type: integer\n    type: object\n  PaginationToken4Qos:\n    description: Pagination Object\n    properties:\n      next_page_token:\n        description: 'Next page token, used to paginate through large result sets. A next page token will be returned whenever the set of available result list exceeds page size. The expiration period is 15 minutes.'\n        type: string\n      page_count:\n        description: The number of items returned on this page.\n        format: int64\n        type: integer\n      page_size:\n        default: 1\n        description: The number of items per page.\n        maximum: 10\n        type: integer\n      total_records:\n        description: The number of all records available across pages.\n        format: int64\n        type: integer\n    type: object\n  Panelist:\n    description: Panelist base object\n    properties:\n      email:\n        description: \"Panelist's email\"\n        type: string\n      name:\n        description: \"Panelist's full name\"\n        type: string\n    type: object\n  PanelistList:\n    description: List of Panelist\n    properties:\n      panelists:\n        description: List of Panelist objects.\n        items:\n          allOf:\n            - properties:\n                id:\n                  description: \"Panelist's ID\"\n                  type: string\n            - $ref: '#/definitions/Panelist'\n            - properties:\n                join_url:\n                  description: Join url\n                  type: string\n        type: array\n      total_records:\n        description: Total records.\n        type: integer\n    title: Panelist List\n    type: object\n  QOSAudio:\n    description: Quality of Service object\n    properties:\n      avg_loss:\n        description: Average Loss\n        type: string\n      bitrate:\n        description: Bitrate\n        type: string\n      jitter:\n        description: Jitter\n        type: string\n      latency:\n        description: Latency\n        type: string\n      max_loss:\n        description: Max Loss\n        type: string\n    title: QOS Object\n    type: object\n  QOSParticipant:\n    description: Participant QOS\n    properties:\n      device:\n        description: Participant device\n        type: string\n      domain:\n        description: Participant domain\n        type: string\n      harddisk_id:\n        description: Participant hard disk id\n        type: string\n      ip_address:\n        description: Participant IP Address\n        type: string\n      join_time:\n        description: Participant join time\n        format: date-time\n        type: string\n      leave_time:\n        description: Participant leave time\n        format: date-time\n        type: string\n      location:\n        description: Participant location\n        type: string\n      mac_addr:\n        description: Participant MAC Address\n        type: string\n      pc_name:\n        description: Participant PC name\n        type: string\n      user_id:\n        description: Participant ID\n        format: uuid\n        type: string\n      user_name:\n        description: Participant display name\n        type: string\n      user_qos:\n        description: User quality of service\n        properties:\n          as_input:\n            $ref: '#/definitions/QOSVideo'\n          as_output:\n            $ref: '#/definitions/QOSVideo'\n          audio_input:\n            $ref: '#/definitions/QOSAudio'\n          audio_output:\n            $ref: '#/definitions/QOSAudio'\n          cpu_usage:\n            properties:\n              system_max_cpu_usage:\n                description: System Maximum CPU Usage\n                type: string\n              zoom_avg_cpu_usage:\n                description: Zoom Average CPU Usage\n                type: string\n              zoom_max_cpu_usage:\n                description: Zoom Maximum CPU Usage\n                type: string\n              zoom_min_cpu_usage:\n                description: Zoom Minimum CPU Usage\n                type: string\n          date_time:\n            description: Datetime of QOS\n            format: date-time\n            type: string\n          video_input:\n            $ref: '#/definitions/QOSVideo'\n          video_output:\n            $ref: '#/definitions/QOSVideo'\n        type: object\n      version:\n        description: Participant version\n        type: string\n    title: Participant QOS\n    type: object\n  QOSParticipantList:\n    allOf:\n      - $ref: '#/definitions/PaginationToken4Qos'\n      - properties:\n          participants:\n            description: Array of user objects\n            items:\n              $ref: '#/definitions/QOSParticipant'\n            type: array\n    description: Participant QOS List\n    title: Participant QOS List\n    type: object\n  QOSVideo:\n    allOf:\n      - $ref: '#/definitions/QOSAudio'\n      - properties:\n          frame_rate:\n            description: Frame Rate\n            type: string\n          resolution:\n            description: Resolution\n            type: string\n    description: Quality of Service object\n    title: QOS Object\n    type: object\n  Recording:\n    allOf:\n      - properties:\n          account_id:\n            description: ID of the user account\n            type: string\n          duration:\n            description: Meeting duration\n            type: integer\n          host_id:\n            description: ID of the user set as host of meeting\n            type: string\n          id:\n            description: 'Meeting ID, also know as meeting number'\n            type: string\n          recording_count:\n            description: Recording count\n            type: string\n          start_time:\n            description: Meeting start time\n            format: date-time\n            type: string\n          topic:\n            description: Meeting topic\n            type: string\n          total_size:\n            description: Total size\n            type: string\n          uuid:\n            description: Meeting unique ID\n            type: string\n      - $ref: '#/definitions/RecordingFileList'\n    description: The recording meeting object\n    type: object\n  RecordingFile:\n    description: RecordingFile Object\n    properties:\n      deleted_time:\n        description: The recording delete time.Response in trash query\n        type: string\n      download_url:\n        description: The recording download url.Response in general query\n        type: string\n      file_size:\n        description: The recording file size.\n        type: number\n      file_type:\n        description: The recording file type.\n        type: string\n      id:\n        description: The recording file ID.Response in general query\n        type: string\n      meeting_id:\n        description: 'The meeting ID. '\n        type: string\n      play_url:\n        description: The recording file play url.Response in general query\n        type: string\n      recording_end:\n        description: The recording end time.Response in general query\n        type: string\n      recording_start:\n        description: The recording start time.\n        type: string\n      status:\n        description: The recording status.Response in general query\n        type: string\n    type: object\n  RecordingFileList:\n    allOf:\n      - properties:\n          recording_files:\n            description: List of Recording file\n            items:\n              allOf:\n                - $ref: '#/definitions/RecordingFile'\n            title: Recording file List\n            type: array\n    description: List of Recording file\n    title: Recording file List\n    type: object\n  RecordingList:\n    allOf:\n      - $ref: '#/definitions/DateTime'\n      - $ref: '#/definitions/PaginationToken'\n      - properties:\n          meetings:\n            description: List of Recording\n            items:\n              allOf:\n                - $ref: '#/definitions/Recording'\n            title: Recording List\n            type: array\n    description: List of Recording\n    title: Recording List\n    type: object\n  Recurrence:\n    description: Recurrence object\n    properties:\n      end_date_time:\n        description: 'Recurrence Meeting End Date. Should be UTC time, such as 2017-11-25T12:00:00Z.'\n        format: date-time\n        type: string\n      end_times:\n        default: 1\n        description: Recurrence Meeting End occurrences times\n        maximum: 50\n        type: integer\n      monthly_day:\n        description: Recurrence Meeting Occurs on a month day. The value range is from 1 to 31\n        type: integer\n      monthly_week:\n        description: Recurrence Meeting Occurs on the week of a month.\n        enum:\n          - -1\n          - 1\n          - 2\n          - 3\n          - 4\n        type: integer\n        x-enum-descriptions:\n          - Last week\n          - First week\n          - Second week\n          - Third week\n          - Fourth week\n      monthly_week_day:\n        description: Recurrence Meeting Occurs on the week day of a month\n        enum:\n          - 1\n          - 2\n          - 3\n          - 4\n          - 5\n          - 6\n          - 7\n        type: integer\n        x-enum-descriptions:\n          - Sunday\n          - Monday\n          - Tuesday\n          - Wednesday\n          - Thursday\n          - Friday\n          - Saturday\n      repeat_interval:\n        description: 'Recurrence meeting repeat interval. For a Daily Meeting, max of 90. For a Weekly Meeting, max of 12. For a Monthly Meeting, max of 3.'\n        type: integer\n      type:\n        description: Recurrence meeting type\n        enum:\n          - 1\n          - 2\n          - 3\n        type: integer\n        x-enum-descriptions:\n          - Daily\n          - Weekly\n          - Monthly\n      weekly_days:\n        description: 'Recurrence Meeting Occurs on week days, multiple value separated by comma'\n        enum:\n          - 1\n          - 2\n          - 3\n          - 4\n          - 5\n          - 6\n          - 7\n        type: integer\n        x-enum-descriptions:\n          - Sunday\n          - Monday\n          - Tuesday\n          - Wednesday\n          - Thursday\n          - Friday\n          - Saturday\n    type: object\n  Registrant:\n    description: Registrant base object\n    properties:\n      address:\n        description: Address\n        type: string\n      city:\n        description: City\n        type: string\n      comments:\n        description: 'Questions & Comments'\n        type: string\n      country:\n        description: Country\n        type: string\n      custom_questions:\n        description: Custom Questions\n        items:\n          $ref: '#/definitions/CustomQuestion'\n        type: array\n      email:\n        description: A valid email address\n        type: string\n      first_name:\n        description: User\u2019s first name\n        type: string\n      industry:\n        description: Industry\n        type: string\n      job_title:\n        description: Job Title\n        type: string\n      last_name:\n        description: User\u2019s last name\n        type: string\n      no_of_employees:\n        description: Number of Employees\n        enum:\n          - 1-20\n          - 21-50\n          - 51-100\n          - 101-500\n          - '500-1,000'\n          - '1,001-5,000'\n          - '5,001-10,000'\n          - 'More than 10,000'\n        type: string\n      org:\n        description: Organization\n        type: string\n      phone:\n        description: Phone\n        type: string\n      purchasing_time_frame:\n        description: Purchasing Time Frame\n        enum:\n          - Within a month\n          - 1-3 months\n          - 4-6 months\n          - More than 6 months\n          - No timeframe\n        type: string\n      role_in_purchase_process:\n        description: Role in Purchase Process\n        enum:\n          - Decision Maker\n          - Evaluator/Recommender\n          - Influencer\n          - Not involved\n        type: string\n      state:\n        description: State/Province\n        type: string\n      zip:\n        description: Zip/Postal Code\n        type: string\n    required:\n      - email\n      - first_name\n      - last_name\n    type: object\n  RegistrantList:\n    allOf:\n      - $ref: '#/definitions/PaginationToken'\n      - properties:\n          registrants:\n            description: List of Registrant objects.\n            items:\n              allOf:\n                - properties:\n                    id:\n                      type: string\n                - $ref: '#/definitions/MeetingRegistrant'\n                - properties:\n                    create_time:\n                      format: date-time\n                      type: string\n                    status:\n                      type: string\n            type: array\n    description: List of Users\n    title: Registration List\n    type: object\n  RegistrantStatus:\n    description: Registrant Status\n    properties:\n      action:\n        enum:\n          - approve\n          - cancel\n          - deny\n        type: string\n        x-enum-descriptions:\n          - Approve registrant\n          - Cancel registrant\n          - Deny registrant\n      registrants:\n        description: List of registrants\n        items:\n          properties:\n            email:\n              type: string\n            id:\n              type: string\n        maximum: 30\n        type: array\n    required:\n      - action\n    type: object\n  Session:\n    description: Base object for sessions\n    properties:\n      agenda:\n        description: Meeting description\n        type: string\n      duration:\n        description: Meeting duration (minutes). Used for scheduled meeting only.\n        type: integer\n      password:\n        description: 'Password to join the meeting. Password may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.'\n        type: string\n      recurrence:\n        $ref: '#/definitions/Recurrence'\n      settings:\n        $ref: '#/definitions/MeetingSettings'\n      start_time:\n        description: \"Meeting start time, in the format \"yyyy-MM-dd'T'HH:mm:ss'Z'\", should be GMT time. In the format \"yyyy-MM-dd'T'HH:mm:ss\", should be local time, need to specify the time zone. Only used for scheduled meeting and recurring meeting with fixed time.\"\n        format: date-time\n        type: string\n      timezone:\n        description: 'Timezone to format start_time, like \"America/Los_Angeles\". For scheduled meeting only. For this parameter value please refer to the id value in [timezone](#timezones) list.'\n        type: string\n      topic:\n        description: Meeting topic\n        type: string\n      type:\n        default: 2\n        description: Meeting Type\n        enum:\n          - 1\n          - 2\n          - 3\n          - 8\n        type: integer\n        x-enum-descriptions:\n          - Instant Meeting\n          - Scheduled Meeting\n          - Recurring Meeting with no fixed time\n          - Recurring Meeting with fixed time\n    type: object\n  SessionUpdate:\n    description: Base object for sessions\n    properties:\n      agenda:\n        description: Meeting description\n        type: string\n      duration:\n        description: Meeting duration (minutes). Used for scheduled meeting only.\n        type: integer\n      password:\n        description: 'Password to join the meeting. Password may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.'\n        type: string\n      recurrence:\n        $ref: '#/definitions/Recurrence'\n      settings:\n        allOf:\n          - $ref: '#/definitions/MeetingSettings'\n          - properties:\n              registrants_confirmation_email:\n                description: Send confirmation Email to Registrants\n                type: boolean\n      start_time:\n        description: \"Meeting start time, in the format \"yyyy-MM-dd'T'HH:mm:ss'Z'\", should be GMT time. In the format \"yyyy-MM-dd'T'HH:mm:ss\", should be local time, need to specify the time zone. Only used for scheduled meeting and recurring meeting with fixed time.\"\n        format: date-time\n        type: string\n      timezone:\n        description: 'Timezone to format start_time, like \"America/Los_Angeles\". For scheduled meeting only. For this parameter value please refer to the id value in [timezone](#timezones) list.'\n        type: string\n      topic:\n        description: Meeting topic\n        type: string\n      type:\n        default: 2\n        description: Meeting Type\n        enum:\n          - 1\n          - 2\n          - 3\n          - 8\n        type: integer\n        x-enum-descriptions:\n          - Instant Meeting\n          - Scheduled Meeting\n          - Recurring Meeting with no fixed time\n          - Recurring Meeting with fixed time\n    type: object\n  SessionWebinar:\n    description: Base webinar object for sessions\n    properties:\n      agenda:\n        description: Webinar description\n        type: string\n      duration:\n        description: Webinar duration (minutes). Used for scheduled webinar only.\n        type: integer\n      password:\n        description: 'Webinar password. Password may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.'\n        type: string\n      recurrence:\n        $ref: '#/definitions/Recurrence'\n      settings:\n        $ref: '#/definitions/WebinarSettings'\n      start_time:\n        description: \"Webinar start time, in the format \"yyyy-MM-dd'T'HH:mm:ss'Z'\", should be GMT time. In the format \"yyyy-MM-dd'T'HH:mm:ss\", should be local time, need to specify the time zone. Only used for scheduled webinar and recurring webinar with fixed time.\"\n        format: date-time\n        type: string\n      timezone:\n        description: 'Timezone to format start_time, like \"America/Los_Angeles\". For scheduled webinar only. For this parameter value please refer to the id value in [timezone](#timezones) list.'\n        type: string\n      topic:\n        description: Webinar topic\n        type: string\n      type:\n        default: 5\n        description: Webinar Type\n        enum:\n          - 5\n          - 6\n          - 9\n        type: integer\n        x-enum-descriptions:\n          - Webinar\n          - Recurring Webinar with no fixed time\n          - Recurring Webinar with fixed time\n    type: object\n  SessionWebinarUpdate:\n    description: Base webinar object for sessions\n    properties:\n      agenda:\n        description: Webinar description\n        type: string\n      duration:\n        description: Webinar duration (minutes). Used for scheduled webinar only.\n        type: integer\n      password:\n        description: 'Webinar password. Password may only contain the following characters: [a-z A-Z 0-9 @ - _ *]. Max of 10 characters.'\n        type: string\n      recurrence:\n        $ref: '#/definitions/Recurrence'\n      settings:\n        allOf:\n          - $ref: '#/definitions/WebinarSettings'\n          - properties:\n              registrants_confirmation_email:\n                description: Send confirmation Email to Registrants\n                type: boolean\n      start_time:\n        description: \"Webinar start time, in the format \"yyyy-MM-dd'T'HH:mm:ss'Z'\", should be GMT time. In the format \"yyyy-MM-dd'T'HH:mm:ss\", should be local time, need to specify the time zone. Only used for scheduled webinar and recurring webinar with fixed time.\"\n        format: date-time\n        type: string\n      timezone:\n        description: 'Timezone to format start_time, like \"America/Los_Angeles\". For scheduled webinar only. For this parameter value please refer to the id value in [timezone](#timezones) list.'\n        type: string\n      topic:\n        description: Webinar topic\n        type: string\n      type:\n        default: 5\n        description: Webinar Type\n        enum:\n          - 5\n          - 6\n          - 9\n        type: integer\n        x-enum-descriptions:\n          - Webinar\n          - Recurring Webinar with no fixed time\n          - Recurring Webinar with fixed time\n    type: object\n  TSP:\n    description: TSP Account object\n    properties:\n      conference_code:\n        description: 'Conference code, numeric value, length is less than 16.'\n        type: string\n      dial_in_numbers:\n        description: Dial In Numbers object\n        properties:\n          code:\n            description: Country Code\n            type: string\n          number:\n            description: 'Dial-in number, length is less than 16.'\n            type: string\n        required:\n          - code\n          - number\n        type: object\n      leader_pin:\n        description: 'Leader PIN, numeric value, length is less than 16.'\n        type: string\n    required:\n      - conference_code\n      - leader_pin\n    type: object\n  User:\n    description: The user object represents a User on Zoom.\n    properties:\n      created_at:\n        description: User create time\n        format: date-time\n        type: string\n      dept:\n        description: Department\n        type: string\n      email:\n        description: \"User's email address.\"\n        type: string\n      first_name:\n        description: \"User's first name.\"\n        maxLength: 64\n        type: string\n      last_client_version:\n        description: User last login client version\n        type: string\n      last_login_time:\n        description: User last login time\n        format: date-time\n        type: string\n      last_name:\n        description: \"User's last name.\"\n        maxLength: 64\n        type: string\n      pmi:\n        description: Personal Meeting ID\n        type: string\n      timezone:\n        description: Time Zone\n        type: string\n      type:\n        description: \"User's type\"\n        enum:\n          - 1\n          - 2\n          - 3\n        type: integer\n        x-enum-descriptions:\n          - basic\n          - pro\n          - corp\n    required:\n      - email\n      - type\n    type: object\n  UserAssistantsList:\n    description: \"List of User's assistants\"\n    properties:\n      assistants:\n        description: \"List of User's assistants.\"\n        items:\n          properties:\n            email:\n              description: 'User email address. Must have id or email, if given id, the email is ignored.'\n              type: string\n            id:\n              description: User ID\n              type: string\n        maximum: 30\n        type: array\n    title: User assistants List\n    type: object\n  UserList:\n    allOf:\n      - $ref: '#/definitions/Pagination'\n      - properties:\n          users:\n            description: List of User objects.\n            items:\n              allOf:\n                - properties:\n                    id:\n                      description: User ID\n                      type: string\n                - $ref: '#/definitions/User'\n            type: array\n    description: List of Users\n    title: User List\n    type: object\n  UserSettings:\n    properties:\n      email_notification:\n        $ref: '#/definitions/UserSettingsEmailNotification'\n      feature:\n        $ref: '#/definitions/UserSettingsFeature'\n      in_meeting:\n        $ref: '#/definitions/UserSettingsInMeeting'\n      recording:\n        $ref: '#/definitions/UserSettingsRecording'\n      scheduled_meeting:\n        $ref: '#/definitions/UserSettingsScheduledMeeting'\n      telephony:\n        $ref: '#/definitions/UserSettingsTelephony'\n    title: User settings\n    type: object\n  UserSettingsEmailNotification:\n    description: ''\n    properties:\n      alternative_host_reminder:\n        default: false\n        description: When an alternative host is set or removed from a meeting\n        type: boolean\n      cancel_meeting_reminder:\n        default: false\n        description: When a meeting is cancelled\n        type: boolean\n      jbh_reminder:\n        default: false\n        description: When attendees join meeting before host\n        type: boolean\n    title: 'User settings: Notification settings'\n    type: object\n  UserSettingsFeature:\n    description: ''\n    properties:\n      large_meeting:\n        description: Large meting feature\n        type: boolean\n      large_meeting_capacity:\n        description: 'Large meeting capacity, can be 100, 200, 300 or 500, depends on if having related large meeting capacity plan subscription or not.'\n        type: integer\n      meeting_capacity:\n        description: User\u2019s meeting capacity.\n        type: integer\n      webinar:\n        description: Webinar feature\n        type: boolean\n      webinar_capacity:\n        description: 'Webinar capacity, can be 100, 500, 1000, 3000, 5000 or 10000, depends on if having related webinar capacity plan subscription or not.'\n        type: integer\n    title: 'User settings: Feature settings'\n    type: object\n  UserSettingsInMeeting:\n    description: ''\n    properties:\n      annotation:\n        default: false\n        description: Annotation\n        type: boolean\n      attendee_on_hold:\n        default: false\n        description: Allow host to put attendee on hold\n        type: boolean\n      attention_tracking:\n        default: false\n        description: Attention tracking\n        type: boolean\n      auto_saving_chat:\n        default: false\n        description: Auto saving chats\n        type: boolean\n      breakout_room:\n        default: false\n        description: Breakout room\n        type: boolean\n      chat:\n        default: false\n        description: Chat\n        type: boolean\n      closed_caption:\n        default: false\n        description: Closed caption\n        type: boolean\n      co_host:\n        default: false\n        description: Co-host\n        type: boolean\n      e2e_encryption:\n        description: End-to-end encryption\n        type: boolean\n      entry_exit_chime:\n        description: Play sound on join/leave\n        enum:\n          - host\n          - all\n          - none\n        type: string\n        x-enum-descriptions:\n          - when host joins/leaves\n          - when any participant joins/leaves\n          - no join/leave sound\n      far_end_camera_control:\n        default: false\n        description: Far end camera control\n        type: boolean\n      feedback:\n        default: false\n        description: Feedback to Zoom\n        type: boolean\n      file_transfer:\n        default: false\n        description: File transfer\n        type: boolean\n      group_hd:\n        default: false\n        description: Group HD video\n        type: boolean\n      non_verbal_feedback:\n        default: false\n        description: Non-verbal feedback\n        type: boolean\n      polling:\n        default: false\n        description: Polling\n        type: boolean\n      private_chat:\n        default: false\n        description: Private chat\n        type: boolean\n      record_play_voice:\n        description: Record and play their own voice\n        type: boolean\n      remote_control:\n        default: false\n        description: Remote control\n        type: boolean\n      remote_support:\n        default: false\n        description: Remote support\n        type: boolean\n      share_dual_camera:\n        default: false\n        description: Share dual camera\n        type: boolean\n      virtual_background:\n        default: false\n        description: Virtual background\n        type: boolean\n      waiting_room:\n        default: false\n        description: Waiting room\n        type: boolean\n    title: 'User settings: Meeting settings'\n    type: object\n  UserSettingsRecording:\n    description: ''\n    properties:\n      auto_delete_cmr:\n        default: false\n        description: Auto delete cloud recordings\n        type: boolean\n      auto_delete_cmr_days:\n        description: A specified number of days of auto delete cloud recordings\n        type: integer\n      auto_recording:\n        default: local\n        description: Automatic recording\n        enum:\n          - local\n          - cloud\n          - none\n        type: string\n        x-enum-descriptions:\n          - Record on local\n          - Record on cloud\n          - Disabled\n      cloud_recording:\n        default: false\n        description: Cloud recording\n        type: boolean\n      local_recording:\n        description: Local recording\n        type: boolean\n      record_audio_file:\n        default: false\n        description: Record an audio only file\n        type: boolean\n      record_gallery_view:\n        default: false\n        description: Record the gallery view\n        type: boolean\n      record_speaker_view:\n        default: false\n        description: Record the active speaker view\n        type: boolean\n      recording_audio_transcript:\n        description: Audio transcript\n        type: boolean\n      save_chat_text:\n        default: false\n        description: Save chat text from the meeting\n        type: boolean\n      show_timestamp:\n        default: false\n        description: Show timestamp on video\n        type: boolean\n    title: 'User settings: Recording settings'\n    type: object\n  UserSettingsScheduledMeeting:\n    description: ''\n    properties:\n      audio_type:\n        default: voip\n        description: Meeting audio\n        enum:\n          - both\n          - telephony\n          - voip\n          - thirdParty\n        type: string\n        x-enum-descriptions:\n          - Telephony and VoIP\n          - Audio PSTN telephony only\n          - VoIP only\n          - 3rd party audio conference\n      force_pmi_jbh_password:\n        description: Require a password for Personal Meetings if attendees can join before host\n        type: boolean\n      host_video:\n        description: Host video\n        type: boolean\n      join_before_host:\n        description: Join before host\n        type: boolean\n      participants_video:\n        description: Participants video\n        type: boolean\n      pstn_password_protected:\n        description: Generate and require password for participants joining by phone\n        type: boolean\n    title: 'User settings: Meeting settings'\n    type: object\n  UserSettingsTelephony:\n    description: ''\n    properties:\n      audio_conference_info:\n        default: ''\n        description: 3rd party audio conference info\n        type: string\n      show_international_numbers_link:\n        description: Show international numbers link on the invitation email\n        type: boolean\n      third_party_audio:\n        description: 3rd party audio conference\n        type: boolean\n    title: 'User settings: Meeting settings'\n    type: object\n  UserUpdate:\n    description: The user update object represents a User on Zoom.\n    properties:\n      cms_user_id:\n        description: Kaltura User Id.\n        type: string\n      dept:\n        description: 'Department for user profile, use for report.'\n        type: string\n      first_name:\n        description: \"User's first name. Cannot contain more than 5 Chinese words.\"\n        type: string\n      host_key:\n        description: 'Host Key, should be 6-digit number.'\n        type: string\n      last_name:\n        description: \"User's last name. Cannot contain more than 5 Chinese words.\"\n        type: string\n      pmi:\n        description: 'Personal Meeting ID,length must be 10.'\n        type: string\n      timezone:\n        description: 'The time zone id for user profile. For this parameter value please refer to the id value in [timezone](#timezones) list.'\n        format: date-time\n        type: string\n      type:\n        description: \"User's type\"\n        enum:\n          - 1\n          - 2\n          - 3\n        type: integer\n        x-enum-descriptions:\n          - basic\n          - pro\n          - corp\n      vanity_name:\n        description: Personal meeting room name.\n        type: string\n    type: object\n  Webhook:\n    description: 'Webhook base object, only available for version 2 webhook'\n    properties:\n      auth_password:\n        description: Webhook auth password.\n        maxLength: 64\n        type: string\n      auth_user:\n        description: Webhook auth user name.\n        maxLength: 128\n        type: string\n      events:\n        description: List of events objects.\n        enum:\n          - meeting_started\n          - meeting_ended\n          - meeting_jbh\n          - meeting_join\n          - recording_completed\n          - participant_joined\n          - participant_left\n        items:\n          type: string\n        type: array\n        x-enum-descriptions:\n          - The meeting has started.\n          - The meeting has ended.\n          - Attendee has joined a meeting before the host.\n          - 'Host hasn\u2019t launched the meeting, attendee is waiting.'\n          - All the Cloud Recordings have completed processing and is available.\n          - Participant has joined the meeting.\n          - Participant has leaved the meeting.\n      url:\n        description: Webhook endpoint\n        maxLength: 256\n        type: string\n    required:\n      - url\n      - auth_user\n      - auth_password\n      - events\n    type: object\n  WebhookList:\n    allOf:\n      - properties:\n          total_records:\n            description: The number of all records available across pages.\n            type: integer\n          webhooks:\n            description: List of Webhook objects.\n            items:\n              allOf:\n                - properties:\n                    webhook_id:\n                      description: Webhook Id.\n                      type: string\n                - $ref: '#/definitions/Webhook'\n            type: array\n    description: List of Webhooks\n    title: Webhook List\n    type: object\n  WebhookUpdate:\n    description: Webhook base object\n    properties:\n      auth_password:\n        description: Webhook auth password.\n        maxLength: 64\n        type: string\n      auth_user:\n        description: Webhook auth user name.\n        maxLength: 128\n        type: string\n      events:\n        description: List of events objects.\n        enum:\n          - meeting_started\n          - meeting_ended\n          - meeting_jbh\n          - meeting_join\n          - recording_completed\n          - participant_joined\n          - participant_left\n        items:\n          type: string\n        type: array\n        x-enum-descriptions:\n          - The meeting has started.\n          - The meeting has ended.\n          - Attendee has joined a meeting before the host.\n          - 'Host hasn\u2019t launched the meeting, attendee is waiting.'\n          - All the Cloud Recordings has completed processing and is available.\n          - Participant has joined the meeting.\n          - Participant has leaved the meeting.\n      url:\n        description: Webhook endpoint.\n        maxLength: 256\n        type: string\n    type: object\n  Webinar:\n    allOf:\n      - $ref: '#/definitions/SessionWebinar'\n    description: Webinar object\n    type: object\n  WebinarInfo:\n    description: Webinar object\n    properties:\n      agenda:\n        description: Webinar agenda\n        type: string\n      created_at:\n        description: Create time\n        format: date-time\n        type: string\n      duration:\n        description: Webinar duration\n        type: integer\n      join_url:\n        description: Join url\n        type: string\n      occurrences:\n        $ref: '#/definitions/Occurrences'\n      settings:\n        $ref: '#/definitions/WebinarSettings'\n      start_time:\n        description: Webinar start time\n        format: date-time\n        type: string\n      start_url:\n        description: Start url\n        type: string\n      timezone:\n        description: Timezone to format start_time\n        type: string\n      topic:\n        description: Webinar topic\n        type: string\n      type:\n        default: 5\n        description: Webinar Type\n        enum:\n          - 5\n          - 6\n          - 9\n        type: integer\n        x-enum-descriptions:\n          - Webinar\n          - Recurring Webinar with no fixed time\n          - Recurring Webinar with fixed time\n    type: object\n  WebinarList:\n    allOf:\n      - $ref: '#/definitions/Pagination'\n      - properties:\n          webinars:\n            description: List of Webinar objects.\n            items:\n              allOf:\n                - properties:\n                    created_at:\n                      description: Create time\n                      format: date-time\n                      type: string\n                    duration:\n                      description: Meeting duration\n                      type: integer\n                    host_id:\n                      description: ID of the user set as host of webinar\n                      type: string\n                    id:\n                      description: 'Webinar ID, also know as webinar number'\n                      type: string\n                    join_url:\n                      description: Join url\n                      type: string\n                    timezone:\n                      description: Timezone to format start_time\n                      type: string\n                    topic:\n                      description: Meeting topic\n                      type: string\n                    type:\n                      description: Meeting Type\n                      enum:\n                        - 5\n                        - 6\n                        - 9\n                      type: integer\n                      x-enum-descriptions:\n                        - Webinar\n                        - Recurring Webinar with no fixed time\n                        - Recurring Webinar with fixed time\n                    uuid:\n                      description: Webinar unique ID\n                      type: string\n                  type: object\n            type: array\n    description: List of Webinars\n    title: User List\n    type: object\n  WebinarMetric:\n    description: Webinar metric details\n    properties:\n      duration:\n        description: Webinar duration\n        type: string\n      email:\n        description: User email\n        type: string\n      end_time:\n        description: Webinar end time\n        format: date-time\n        type: string\n      has_3rd_party_audio:\n        description: ''\n        type: boolean\n      has_pstn:\n        description: ''\n        type: boolean\n      has_recording:\n        description: ''\n        type: boolean\n      has_screen_share:\n        description: ''\n        type: boolean\n      has_sip:\n        description: ''\n        type: boolean\n      has_video:\n        description: ''\n        type: boolean\n      has_voip:\n        description: ''\n        type: boolean\n      host:\n        description: User display name\n        type: string\n      id:\n        description: Webinar ID\n        type: integer\n      participants:\n        description: Webinar participant count\n        type: integer\n      start_time:\n        description: Webinar start time\n        format: date-time\n        type: string\n      topic:\n        description: Webinar topic\n        type: string\n      user_type:\n        description: User type\n        type: string\n      uuid:\n        description: Webinar UUID\n        format: uuid\n        type: string\n    title: Webinar Metrics\n    type: object\n  WebinarPanelist:\n    description: Webinar panelist\n    properties:\n      panelists:\n        description: List of Panelist objects.\n        items:\n          allOf:\n            - $ref: '#/definitions/Panelist'\n        type: array\n    type: object\n  WebinarPanelistList:\n    allOf:\n      - $ref: '#/definitions/PanelistList'\n    description: Webinar panelist\n    type: object\n  WebinarRegistrant:\n    allOf:\n      - $ref: '#/definitions/Registrant'\n    description: Webianr registrant\n    type: object\n  WebinarRegistrantList:\n    allOf:\n      - $ref: '#/definitions/RegistrantList'\n    description: List of Users\n    title: Registration List\n    type: object\n  WebinarSettings:\n    description: Webinar Settings\n    properties:\n      allow_multiple_devices:\n        description: Allow attendees to join from multiple devices.\n        type: boolean\n      alternative_hosts:\n        description: Alternative hosts emails or IDs. Multiple value separated by comma.\n        type: string\n      approval_type:\n        default: 2\n        enum:\n          - 0\n          - 1\n          - 2\n        type: integer\n        x-enum-descriptions:\n          - Automatically Approve\n          - Manually Approve\n          - No Registration Required\n      audio:\n        default: both\n        description: Meeting audio options\n        enum:\n          - both\n          - telephony\n          - voip\n        type: string\n        x-enum-descriptions:\n          - Both Telephony and VoIP\n          - Telephony only\n          - VoIP only\n      auto_recording:\n        default: none\n        enum:\n          - local\n          - cloud\n          - none\n        type: string\n        x-enum-descriptions:\n          - Record to local device\n          - Record to cloud\n          - No Recording\n      close_registration:\n        description: Close registration after event date.\n        type: boolean\n      enforce_login:\n        description: Only signed-in users can join this meeting\n        type: boolean\n      enforce_login_domains:\n        description: Only signed-in users with specified domains can join meetings\n        type: string\n      hd_video:\n        default: false\n        description: Default to HD Video\n        type: boolean\n      host_video:\n        description: Start video when host join webinar\n        type: boolean\n      panelists_video:\n        description: Start video when panelists join webinar\n        type: boolean\n      practice_session:\n        default: false\n        description: Enable Practice Session\n        type: boolean\n      registration_type:\n        default: 1\n        description: Registration type. Used for recurring webinar with fixed time only.\n        enum:\n          - 1\n          - 2\n          - 3\n        type: integer\n        x-enum-descriptions:\n          - Attendees register once and can attend any of the occurrences\n          - Attendees need to register for each occurrence to attend\n          - Attendees register once and can choose one or more occurrences to attend\n      show_share_button:\n        description: Show social share buttons on registration page.\n        type: boolean\n    type: object\n  WebinarUpdate:\n    allOf:\n      - $ref: '#/definitions/SessionWebinarUpdate'\n    description: Webinar object\n    type: object\n  ZoomRoom:\n    description: Zoom Room\n    properties:\n      account_type:\n        description: Zoom Room email type\n        type: string\n      camera:\n        description: Zoom Room camera\n        type: string\n      device_ip:\n        description: Zoom Room device IP\n        type: string\n      email:\n        description: Zoom Room email\n        type: string\n      id:\n        description: Zoom Room ID\n        type: string\n      last_start_time:\n        description: Zoom Room last start time\n        type: string\n      microphone:\n        description: Zoom Room microphone\n        type: string\n      room_name:\n        description: Zoom Room name\n        type: string\n      speaker:\n        description: Zoom Room speaker\n        type: string\n      status:\n        description: Zoom Room status\n        type: string\n    title: Zoom Room\n    type: object\n  ZoomRoomList:\n    allOf:\n      - $ref: '#/definitions/Pagination'\n      - properties:\n          zoom_rooms:\n            description: Array of Zoom Rooms\n            items:\n              $ref: '#/definitions/ZoomRoom'\n            type: array\n    description: Zoom Room List\n    title: Zoom Room List\n    type: object\n";
