export declare const todosApiBundled = "\nopenapi: 3.0.0\ninfo:\n  title: To-dos\n  version: 1.0.0\n  description: \"![](https://i.ibb.co/v3Yt03v/todo-api-background.png)\n\n## U0001F4AB Overview\n\nTo Do API provides a simple way for people to manage their tasks and plan their day. This API can be used to create mobile and web applications.This API is documented using **OpenAPI 3.0**. The implementation lives in this [GitHub repo](https://github.com/stoplightio/studio-demo/blob/master/reference/todos/todo.v1.yaml).\n\n### U0001F9F0 Cross-Origin Resource Sharing\nThis API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). CORS support is necessary to make calls from the request maker within the API docs.\n\n### U0001F3C1 Trying out your own API Specification\nElements can be used to generate API docs for any OpenAPI document. Replace this OpenAPI with a URL to your own OpenAPI document to get started. \"\n  contact:\n    name: Stoplight Support\n    email: support@stoplight.io\n    url: 'https://www.stoplight.io'\n  license:\n    name: MIT\n    url: 'https://spdx.org/licenses/MIT'\n  termsOfService: 'https://stoplight.io/terms/'\nservers:\n  - url: 'https://todos.stoplight.io'\n    description: Production\n  - description: Sandbox\n    url: 'https://todos-sandbox.stoplight.io'\npaths:\n  /todos:\n    get:\n      summary: List Todos\n      responses:\n        '200':\n          description: Returns a list of Todos\n          content:\n            application/json:\n              schema:\n                type: array\n                items:\n                  $ref: '#/components/schemas/Todos'\n              examples:\n                List of Todos:\n                  $ref: '#/components/examples/multiple-todos'\n        '403':\n          $ref: '#/components/responses/Unauthorized'\n        '404':\n          $ref: '#/components/responses/NotFound'\n      operationId: get-todos\n      description: >-\n        Returns a list of todos\n\n\n        *Markdown is supported in descriptions. Add information here for users\n        to get accustomed to endpoints*\n      parameters:\n        - $ref: '#/components/parameters/limit'\n        - $ref: '#/components/parameters/contentType'\n      security: []\n    post:\n      summary: Create Todo\n      operationId: post-todos\n      responses:\n        '201':\n          description: New Todo Created\n          content:\n            multipart/form-data:\n              schema:\n                $ref: '#/components/schemas/Todos'\n              examples:\n                Example Todo:\n                  $ref: '#/components/examples/todo'\n        '403':\n          $ref: '#/components/responses/Unauthorized'\n        '404':\n          $ref: '#/components/responses/NotFound'\n      description: >-\n        This creates a Todo object\n\n\n        *Markdown is supported in descriptions. Add information here for users\n        to get accustomed to endpoints*\n      requestBody:\n        content:\n          application/json:\n            schema:\n              $ref: '#/components/schemas/Todos'\n        description: Name of the Todo\n      parameters:\n        - $ref: '#/components/parameters/contentType'\n      security:\n        - API Key: []\n  '/todos/{id}':\n    get:\n      summary: Get Todo\n      responses:\n        '200':\n          description: Returns the Todo for the ID\n          content:\n            application/json:\n              schema:\n                $ref: '#/components/schemas/Todos'\n              examples:\n                Example Todo:\n                  $ref: '#/components/examples/todo'\n        '403':\n          $ref: '#/components/responses/Unauthorized'\n        '404':\n          $ref: '#/components/responses/NotFound'\n      operationId: get-todos-id\n      description: >-\n        Get a single todo using an ID\n\n\n        *Markdown is supported in descriptions. Add information here for users\n        to get accustomed to endpoints*\n      parameters: []\n      security: []\n    put:\n      summary: Replace Todo\n      operationId: put-todos-id\n      responses:\n        '200':\n          description: Todo Updated\n        '403':\n          $ref: '#/components/responses/Unauthorized'\n        '404':\n          $ref: '#/components/responses/NotFound'\n      requestBody:\n        content:\n          application/json:\n            schema:\n              $ref: '#/components/schemas/Todos'\n        description: ''\n      description: >-\n        Update a single todo using an ID\n\n\n        *Markdown is supported in descriptions. Add information here for users\n        to get accustomed to endpoints*\n      parameters:\n        - $ref: '#/components/parameters/contentType'\n      security:\n        - API Key: []\n    delete:\n      summary: Delete Todo\n      operationId: delete-todos-id\n      responses:\n        '200':\n          description: Todo Deleted\n          content:\n            application/json:\n              schema:\n                $ref: '#/components/schemas/Todos'\n              examples:\n                Example Todo:\n                  $ref: '#/components/examples/todo'\n        '403':\n          $ref: '#/components/responses/Unauthorized'\n        '404':\n          $ref: '#/components/responses/NotFound'\n      description: >-\n        Delete a todo using an ID\n\n\n        *Markdown is supported in descriptions. Add information here for users\n        to get accustomed to endpoints*\n      security:\n        - API Key: []\n    patch:\n      summary: Update Todo\n      operationId: patch-todos-id\n      responses:\n        '200':\n          description: Todo Updated\n        '403':\n          $ref: '#/components/responses/Unauthorized'\n        '404':\n          $ref: '#/components/responses/NotFound'\n      deprecated: true\n      description: >-\n        Don't use this endpoint. Notice it's deprecated.\n\n\n        *Markdown is supported in descriptions. Add information here for users\n        to get accustomed to endpoints*\n      requestBody:\n        content:\n          application/json:\n            schema:\n              $ref: '#/components/schemas/Todos'\n      security:\n        - API Key: []\n    parameters:\n      - $ref: '#/components/parameters/ID'\n  /users:\n    get:\n      summary: Get User\n      tags:\n        - Users\n      responses:\n        '200':\n          description: OK\n          content:\n            application/json:\n              schema:\n                type: array\n                items:\n                  $ref: '#/components/schemas/User'\n        '404':\n          $ref: '#/components/responses/NotFound'\n      operationId: get-users\n      description: >-\n        Get a user by ID\n\n\n        *Markdown is supported in descriptions. Add information here for users\n        to get accustomed to endpoints*\n      parameters:\n        - $ref: '#/components/parameters/contentType'\n      security: []\n    parameters: []\n    delete:\n      summary: Delete User\n      operationId: delete-users-userID\n      responses:\n        '200':\n          description: OK\n          content:\n            application/json:\n              schema:\n                $ref: '#/components/schemas/User'\n      description: Delete a user by ID\n      tags:\n        - Users\n      security:\n        - API Key: []\n    post:\n      summary: Create User\n      operationId: post-users-userID\n      responses:\n        '201':\n          description: User Created\n          content:\n            application/json:\n              schema:\n                $ref: '#/components/schemas/User'\n              examples:\n                Example User:\n                  $ref: '#/components/examples/user'\n      description: Create a User\n      requestBody:\n        content:\n          application/json:\n            schema:\n              $ref: '#/components/schemas/User'\n            examples: {}\n      tags:\n        - Users\n      parameters:\n        - $ref: '#/components/parameters/contentType'\n      security:\n        - API Key: []\ncomponents:\n  schemas:\n    Todos:\n      description: I'm a model's description.\n      type: object\n      x-examples: {}\n      title: Todo\n      properties:\n        id:\n          type: number\n          minimum: 0\n          maximum: 9999\n          description: ID of the task\n          readOnly: true\n        name:\n          type: string\n          minLength: 1\n          maxLength: 100\n          description: Name of the task\n        completed:\n          type: boolean\n          default: false\n          description: Boolean indicating if the task has been completed or not\n        completed_at:\n          type: string\n          format: date-time\n          description: Time when the task was completed\n          readOnly: true\n        created_at:\n          type: string\n          format: date-time\n          description: Time when the task was created\n          readOnly: true\n        updated_at:\n          type: string\n          format: date-time\n          description: Time when the task was updated\n          readOnly: true\n      required:\n        - id\n        - name\n        - completed_at\n        - created_at\n        - updated_at\n    User:\n      description: ''\n      type: object\n      title: User\n      properties:\n        userId:\n          type: number\n          description: ID of the user\n          readOnly: true\n        firstName:\n          type: string\n          minLength: 1\n          description: ''\n        lastName:\n          type: string\n          minLength: 1\n          description: ''\n        phoneNumber:\n          type: string\n          minLength: 1\n          description: Official Phone Number\n        emailAddress:\n          type: string\n          minLength: 1\n          description: Work Email Address\n      required:\n        - userId\n        - firstName\n        - lastName\n        - phoneNumber\n        - emailAddress\n  securitySchemes:\n    API Key:\n      name: apikey\n      type: apiKey\n      in: query\n      description: Just use `123`. It's super secure ;)\n  parameters:\n    limit:\n      name: limit\n      in: query\n      required: false\n      schema:\n        type: number\n      description: >-\n        Return a limited set of results *I'm a shared parameter. I can be reused\n        in multiple endpoints!*\n    contentType:\n      name: Content-Type\n      in: header\n      required: true\n      schema:\n        type: string\n        default: application/json\n      description: application/json\n    ID:\n      name: id\n      in: path\n      required: true\n      schema:\n        type: string\n      description: ID of the Todo\n  responses:\n    NotFound:\n      description: Resource not found\n      content:\n        application/json:\n          schema:\n            title: Error\n            type: object\n            description: A standard error object.\n            x-tags:\n              - Common\n            properties:\n              status:\n                type: string\n                description: A code.\n              error:\n                type: string\n            required:\n              - status\n              - error\n    Unauthorized:\n      description: Action not allowed\n      content:\n        application/json:\n          schema:\n            type: object\n            properties:\n              message:\n                type: string\n            required:\n              - message\n  examples:\n    todo:\n      value:\n        id: 0\n        name: string\n        completed: true\n        completed_at: '2019-08-24T14:15:22Z'\n        created_at: '2019-08-24T14:15:22Z'\n        updated_at: '2019-08-24T14:15:22Z'\n    multiple-todos:\n      value:\n        - id: 0\n          name: my todo\n          completed: true\n          completed_at: '2019-08-24T14:15:22Z'\n          created_at: '2019-08-24T14:15:22Z'\n          updated_at: '2019-08-24T14:15:22Z'\n        - id: 1\n          name: another todo\n          completed: false\n          completed_at: '2019-08-24T14:15:22Z'\n          created_at: '2019-08-24T14:15:22Z'\n          updated_at: '2019-08-24T14:15:22Z'\n        - id: 2\n          name: yet another todo\n          completed: false\n          completed_at: '2019-08-24T14:15:22Z'\n          created_at: '2019-08-24T14:15:22Z'\n          updated_at: '2019-08-24T14:15:22Z'\n    user:\n      value:\n        userId: 2\n        firstName: racks\n        lastName: jacson\n        phoneNumber: '123456'\n        emailAddress: racks.jacson@learningcontainer.com\ntags:\n  - name: Todos\n";
