import { RootNode, SchemaTreeRefDereferenceFn } from '@stoplight/json-schema-tree';
import * as React from 'react';
import { JSVOptions } from '../contexts';
import { JSONSchema } from '../types';
export type JsonSchemaProps = Partial<JSVOptions> & {
    schema: JSONSchema;
    emptyText?: string;
    className?: string;
    resolveRef?: SchemaTreeRefDereferenceFn;
    maxRefDepth?: number;
    onTreePopulated?: (props: {
        rootNode: RootNode;
        nodeCount: number;
    }) => void;
    maxHeight?: number;
    parentCrumbs?: string[];
    skipTopLevelDescription?: boolean;
};
export declare const JsonSchemaViewer: React.FunctionComponent<Partial<JSVOptions> & {
    schema: JSONSchema;
    emptyText?: string | undefined;
    className?: string | undefined;
    resolveRef?: SchemaTreeRefDereferenceFn | undefined;
    maxRefDepth?: number | undefined;
    onTreePopulated?: ((props: {
        rootNode: RootNode;
        nodeCount: number;
    }) => void) | undefined;
    maxHeight?: number | undefined;
    parentCrumbs?: string[] | undefined;
    skipTopLevelDescription?: boolean | undefined;
} & import("@stoplight/react-error-boundary").ErrorBoundaryProps<{}>>;
