import { type MirroredSchemaNode, type ReferenceNode, type RegularNode, type SchemaNode } from '@stoplight/json-schema-tree';
import type { ViewMode } from '../types';
import type { ArrayNode, ComplexArrayNode, ComplexDictionaryNode, DictionaryNode, FlattenableNode, PrimitiveArrayNode, PrimitiveDictionaryNode } from './types';
export type ChildNode = RegularNode | ReferenceNode | MirroredSchemaNode;
export declare const isNonEmptyParentNode: (node: SchemaNode) => node is RegularNode & {
    children: ChildNode[] & {
        0: ChildNode;
    };
};
export declare function isFlattenableNode(node: SchemaNode): node is FlattenableNode;
export declare function isPrimitiveArray(node: SchemaNode): node is PrimitiveArrayNode;
export declare function isPrimitiveDictionary(node: SchemaNode): node is PrimitiveDictionaryNode;
export declare function isComplexArray(node: SchemaNode): node is ComplexArrayNode;
export declare function isComplexDictionary(node: SchemaNode): node is ComplexDictionaryNode;
export declare function isDictionaryNode(node: SchemaNode): node is DictionaryNode;
export declare function isArrayNode(node: SchemaNode): node is ArrayNode;
export declare function visibleChildren(node: SchemaNode): SchemaNode[];
export declare function isPropertyRequired(schemaNode: SchemaNode): boolean;
export declare function shouldNodeBeIncluded(node: SchemaNode, viewMode?: ViewMode): boolean;
