export interface IMinimalActivatable {
    activate: () => Promise<void>;
    deactivate: () => Promise<void>;
}
export interface IActivatable extends IMinimalActivatable {
    readonly state: 'deactivated' | 'isActivating' | 'activated' | 'isDeactivating';
}
export declare abstract class Activatable implements IActivatable {
    protected _state: 'deactivated' | 'isActivating' | 'activated' | 'isDeactivating';
    get state(): "deactivated" | "isActivating" | "activated" | "isDeactivating";
    activate(): Promise<void>;
    deactivate(): Promise<void>;
    protected abstract doActivate(): Promise<void>;
    protected abstract doDeactivate(): Promise<void>;
}
export interface IActivatableCollection extends IActivatable {
}
export declare class ActivatableCollection<T extends IMinimalActivatable> extends Activatable implements IActivatableCollection {
    readonly activatables: T[];
    protected doActivate(): Promise<void>;
    protected doDeactivate(): Promise<void>;
    push(activatables: T): void;
}
