"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
class AsyncDisposableSet {
    constructor() {
        this.disposables = new Set();
    }
    get disposed() {
        return this.disposables.size === 0;
    }
    dispose() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            while (!this.disposed) {
                yield Promise.all([...this.disposables].map(disposable => disposable.dispose()));
            }
        });
    }
    push(disposable) {
        this.disposables.add(disposable);
        const originalDispose = disposable.dispose.bind(disposable);
        disposable.dispose = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield originalDispose();
            this.disposables.delete(disposable);
        });
        return disposable;
    }
    pushAll(disposables) {
        return disposables.map(disposable => this.push(disposable));
    }
}
exports.AsyncDisposableSet = AsyncDisposableSet;
//# sourceMappingURL=AsyncDisposableSet.js.map