"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const createDisposable_1 = require("./createDisposable");
class DisposableCollection {
    constructor() {
        this.disposables = [];
    }
    get disposed() {
        return this.disposables.length === 0;
    }
    dispose() {
        if (this.disposed)
            return;
        while (!this.disposed) {
            this.disposables.pop().dispose();
        }
    }
    push(disposable) {
        this.disposables.push(disposable);
        const originalDispose = disposable.dispose.bind(disposable);
        const toRemove = createDisposable_1.createDisposable(() => {
            const index = this.disposables.indexOf(disposable);
            if (index !== -1) {
                this.disposables.splice(index, 1);
            }
        });
        disposable.dispose = () => {
            toRemove.dispose();
            originalDispose();
        };
        return toRemove;
    }
    pushAll(disposables) {
        return disposables.map(disposable => this.push(disposable));
    }
}
exports.DisposableCollection = DisposableCollection;
//# sourceMappingURL=DisposableCollection.js.map