"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class DisposableSet {
    constructor() {
        this.disposables = new Set();
    }
    get disposed() {
        return this.disposables.size === 0;
    }
    dispose() {
        for (const disposable of this.disposables) {
            disposable.dispose();
        }
    }
    push(disposable) {
        this.disposables.add(disposable);
        const originalDispose = disposable.dispose.bind(disposable);
        disposable.dispose = () => {
            originalDispose();
            this.disposables.delete(disposable);
        };
        return disposable;
    }
    pushAll(disposables) {
        return disposables.map(disposable => this.push(disposable));
    }
}
exports.DisposableSet = DisposableSet;
//# sourceMappingURL=DisposableSet.js.map