import { IDisposable } from '../disposable';
export declare type EventMap = {
    [key: string]: (...args: any[]) => void;
};
export interface IEmitGroup<E extends EventMap> {
    queueCount: number;
    emit<P extends keyof E>(type: P, ...args: Parameters<E[P]>): void;
    flush: () => void;
    reset: () => void;
}
export interface IEventEmitter<E extends EventMap> extends IDisposable {
    on<P extends keyof E>(type: P, listener: E[P]): IDisposable;
    emit<P extends keyof E>(type: P, ...args: Parameters<E[P]>): void;
    hasListeners: boolean;
    createEmitGroup(): IEmitGroup<E>;
}
export declare class EventEmitter<E extends EventMap> implements IEventEmitter<E> {
    private readonly _emitter;
    private readonly _registeredListeners;
    on<P extends keyof E>(type: P, listener: E[P]): IDisposable;
    emit<P extends keyof E>(type: P, ...args: Parameters<E[P]>): void;
    get hasListeners(): boolean;
    dispose(): void;
    createEmitGroup(): IEmitGroup<E>;
}
