"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeOutput = exports.formatOutput = void 0;
const tslib_1 = require("tslib");
const process = (0, tslib_1.__importStar)(require("process"));
const fs_1 = require("fs");
const spectral_formatters_1 = require("@stoplight/spectral-formatters");
const version_1 = require("../version");
const formatters = {
    json: spectral_formatters_1.json,
    stylish: spectral_formatters_1.stylish,
    pretty: spectral_formatters_1.pretty,
    junit: spectral_formatters_1.junit,
    html: spectral_formatters_1.html,
    text: spectral_formatters_1.text,
    teamcity: spectral_formatters_1.teamcity,
    'github-actions': spectral_formatters_1.githubActions,
    sarif: spectral_formatters_1.sarif,
    'code-climate': spectral_formatters_1.codeClimate,
    gitlab: spectral_formatters_1.codeClimate,
    markdown: spectral_formatters_1.markdown,
};
function formatOutput(results, format, formatOptions, ruleset) {
    return formatters[format](results, formatOptions, {
        ruleset,
        spectralVersion: version_1.VERSION,
    });
}
exports.formatOutput = formatOutput;
async function writeOutput(outputStr, outputFile) {
    if (outputFile !== '<stdout>') {
        await fs_1.promises.writeFile(outputFile, outputStr);
    }
    else {
        process.stdout.write(outputStr);
    }
}
exports.writeOutput = writeOutput;
//# sourceMappingURL=output.js.map