"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.codeClimate = void 0;
const types_1 = require("@stoplight/types");
const path_1 = require("@stoplight/path");
const severityMap = {
    [types_1.DiagnosticSeverity.Error]: 'critical',
    [types_1.DiagnosticSeverity.Warning]: 'major',
    [types_1.DiagnosticSeverity.Information]: 'minor',
    [types_1.DiagnosticSeverity.Hint]: 'info',
};
const codeClimate = results => {
    const outputJson = results.map(result => {
        var _a;
        const relPath = (0, path_1.relative)(process.cwd(), (_a = result.source) !== null && _a !== void 0 ? _a : '').replace(/\\/g, '/');
        const fingerprint = `${relPath}:${result.path.join('.')}:${result.code}`;
        return {
            type: 'issue',
            check_name: result.code.toString(),
            description: result.message,
            categories: ['Style'],
            location: {
                path: relPath,
                positions: {
                    begin: { line: result.range.start.line, column: result.range.start.character },
                    end: { line: result.range.end.line, column: result.range.end.character },
                },
            },
            severity: severityMap[result.severity],
            fingerprint,
        };
    });
    return JSON.stringify(outputJson, null, '\t');
};
exports.codeClimate = codeClimate;
//# sourceMappingURL=code-climate.js.map