"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.githubActions = void 0;
const path_1 = require("@stoplight/path");
const types_1 = require("@stoplight/types");
const OUTPUT_TYPES = {
    [types_1.DiagnosticSeverity.Error]: 'error',
    [types_1.DiagnosticSeverity.Warning]: 'warning',
    [types_1.DiagnosticSeverity.Information]: 'notice',
    [types_1.DiagnosticSeverity.Hint]: 'notice',
};
const githubActions = results => {
    return results
        .map(result => {
        var _a;
        const file = (0, path_1.relative)(process.cwd(), (_a = result.source) !== null && _a !== void 0 ? _a : '');
        const params = {
            title: result.code.toString(),
            file,
            col: result.range.start.character + 1,
            endColumn: result.range.end.character + 1,
            line: result.range.start.line + 1,
            endLine: result.range.end.line + 1,
        };
        const paramsString = Object.entries(params)
            .map(p => p.join('='))
            .join(',');
        const message = result.message.replace(/\n/g, '%0A');
        return `::${OUTPUT_TYPES[result.severity]} ${paramsString}::${message}${result.documentationUrl ? `::${result.documentationUrl}` : ''}`;
    })
        .join('\n');
};
exports.githubActions = githubActions;
//# sourceMappingURL=github-actions.js.map