"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    "html-template-message.html": "<tr style=\"display:none\" class=\"f-<%= parentIndex %>\">\n    <td><%= line %>:<%= character %></td>\n    <td class=\"severity clr-<%= severity %>\"><%= severity %></td>\n    <td><%- message %></td>\n    <td><% if(documentationUrl) { %><a href=\"<%- documentationUrl %>\" target=\"_blank\">documentation</a><% } %></td>\n</tr>\n",
    "html-template-page.html": "<!DOCTYPE html>\n<html>\n<head>\n    <meta charset=\"UTF-8\">\n    <style>\n        body {\n            font-family:Arial, \"Helvetica Neue\", Helvetica, sans-serif;\n            font-size:16px;\n            font-weight:normal;\n            margin:0;\n            padding:0;\n            color:#333\n        }\n        #overview {\n            padding:20px 30px\n        }\n        td, th {\n            padding:5px 10px\n        }\n        h1 {\n            margin:0\n        }\n        table {\n            margin:30px;\n            width:calc(100% - 60px);\n            max-width:1000px;\n            border-radius:5px;\n            border:1px solid #ddd;\n            border-spacing:0px;\n        }\n        th {\n            font-weight:400;\n            font-size:medium;\n            text-align:left;\n            cursor:pointer\n        }\n        td.severity, th span {\n            font-weight:700\n        }\n        th span {\n            float:right;\n            margin-left:20px\n        }\n        th span:after {\n            content:\"\";\n            clear:both;\n            display:block\n        }\n        tr:last-child td {\n            border-bottom:none\n        }\n        tr td:first-child, tr td:last-child {\n            color:#9da0a4\n        }\n        #overview.bg-success, tr.bg-success th {\n            color:#468847;\n            background:#dff0d8;\n            border-bottom:1px solid #d6e9c6\n        }\n        #overview.bg-error, tr.bg-error th {\n            color:#b94a48;\n            background:#f2dede;\n            border-bottom:1px solid #eed3d7\n        }\n        #overview.bg-warning, tr.bg-warning th {\n            color:#f0ad4e;\n            background:#fcf8e3;\n            border-bottom:1px solid #fbeed5\n        }\n        #overview.bg-information, tr.bg-information th {\n            color:#4e95f0;\n            background:#deecfb;\n            border-bottom:1px solid #d3e3ee\n        }\n        td {\n            border-bottom:1px solid #ddd\n        }\n        td.clr-error {\n            color:#b94a48\n        }\n        td.clr-warning {\n            color:#f0ad4e\n        }\n        td.clr-information {\n            color:#4e95f0\n        }\n        td.clr-hint {\n            color:#5a5a5a\n        }\n    </style>\n    <title>Spectral Report</title>\n</head>\n<body>\n<div id=\"overview\" class=\"bg-<%= color %>\">\n    <h1>Spectral Report</h1>\n    <div>\n        <span><%= summary %></span> - Generated on <%= date %>\n    </div>\n</div>\n<table>\n    <tbody>\n    <%= results %>\n    </tbody>\n</table>\n<script type=\"text/javascript\">\n    var groups = document.querySelectorAll(\"tr[data-group]\");\n    for (var i = 0; i < groups.length; i++) {\n        groups[i].addEventListener(\"click\", function() {\n            var inGroup = document.getElementsByClassName(this.getAttribute(\"data-group\"));\n            this.innerHTML = (this.innerHTML.indexOf(\"+\") > -1) ? this.innerHTML.replace(\"+\", \"-\") : this.innerHTML.replace(\"-\", \"+\");\n            for (var j = 0; j < inGroup.length; j++) {\n                inGroup[j].style.display = (inGroup[j].style.display !== \"none\") ? \"none\" : \"table-row\";\n            }\n        });\n    }\n</script>\n</body>\n</html>\n",
    "html-template-result.html": "<tr class=\"bg-<%- color %>\" data-group=\"f-<%- index %>\">\n    <th colspan=\"4\">\n        [+] <%- filePath %>\n        <span><%- summary %></span>\n    </th>\n</tr>\n"
};
//# sourceMappingURL=templates.js.map