"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sarif = void 0;
const types_1 = require("@stoplight/types");
const path_1 = require("@stoplight/path");
const node_sarif_builder_1 = require("node-sarif-builder");
const OUTPUT_TYPES = {
    [types_1.DiagnosticSeverity.Error]: 'error',
    [types_1.DiagnosticSeverity.Warning]: 'warning',
    [types_1.DiagnosticSeverity.Information]: 'note',
    [types_1.DiagnosticSeverity.Hint]: 'note',
};
const sarif = (results, _, ctx) => {
    var _a, _b;
    if (ctx === void 0) {
        throw Error('sarif formatter requires ctx');
    }
    const sarifBuilder = new node_sarif_builder_1.SarifBuilder({
        $schema: 'http://json.schemastore.org/sarif-2.1.0-rtm.6.json',
        version: '2.1.0',
        runs: [],
    });
    const sarifRunBuilder = new node_sarif_builder_1.SarifRunBuilder().initSimple({
        toolDriverName: 'spectral',
        toolDriverVersion: ctx.spectralVersion,
        url: 'https://github.com/stoplightio/spectral',
    });
    for (const rule of Object.values(ctx.ruleset.rules)) {
        const sarifRuleBuilder = new node_sarif_builder_1.SarifRuleBuilder().initSimple({
            ruleId: rule.name,
            shortDescriptionText: (_a = rule.description) !== null && _a !== void 0 ? _a : 'No description.',
            helpUri: rule.documentationUrl !== null ? rule.documentationUrl : undefined,
        });
        sarifRunBuilder.addRule(sarifRuleBuilder);
    }
    for (const result of results) {
        const sarifResultBuilder = new node_sarif_builder_1.SarifResultBuilder();
        const severity = result.severity || types_1.DiagnosticSeverity.Error;
        sarifResultBuilder.initSimple({
            level: OUTPUT_TYPES[severity] || 'error',
            messageText: result.documentationUrl ? `${result.message} -- ${result.documentationUrl}` : result.message,
            ruleId: result.code.toString(),
            fileUri: (0, path_1.relative)(process.cwd(), (_b = result.source) !== null && _b !== void 0 ? _b : '').replace(/\\/g, '/'),
            startLine: result.range.start.line + 1,
            startColumn: result.range.start.character + 1,
            endLine: result.range.end.line + 1,
            endColumn: result.range.end.character + 1,
        });
        sarifRunBuilder.addResult(sarifResultBuilder);
    }
    sarifBuilder.addRun(sarifRunBuilder);
    return sarifBuilder.buildSarifJsonString({ indent: true });
};
exports.sarif = sarif;
//# sourceMappingURL=sarif.js.map