"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRuleDocumentationUrl = void 0;
function getRuleDocumentationUrl(ruleCode, ctx) {
    var _a;
    if (!(ctx === null || ctx === void 0 ? void 0 : ctx.ruleset)) {
        return undefined;
    }
    const rule = ctx.ruleset.rules[ruleCode.toString()];
    if (rule.documentationUrl != null && rule.documentationUrl) {
        return rule.documentationUrl;
    }
    const rulesetDocumentationUrl = (_a = rule.owner) === null || _a === void 0 ? void 0 : _a.definition.documentationUrl;
    if (rulesetDocumentationUrl != null && rulesetDocumentationUrl) {
        return `${rulesetDocumentationUrl}#${ruleCode}`;
    }
    return undefined;
}
exports.getRuleDocumentationUrl = getRuleDocumentationUrl;
//# sourceMappingURL=getDocumentationUrl.js.map