"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const spectral_core_1 = require("@stoplight/spectral-core");
const spectral_runtime_1 = require("@stoplight/spectral-runtime");
const optionSchemas_1 = require("./optionSchemas");
exports.default = (0, spectral_core_1.createRulesetFunction)({
    input: {
        type: 'object',
    },
    options: optionSchemas_1.optionSchemas.xor,
}, function xor(targetVal, { properties }) {
    const results = [];
    const intersection = Object.keys(targetVal).filter(key => properties.includes(key));
    if (intersection.length !== 1) {
        const formattedProperties = properties.map(prop => (0, spectral_runtime_1.printValue)(prop));
        const lastProperty = formattedProperties.pop();
        let message = formattedProperties.join(', ') + (lastProperty != undefined ? ` and ${lastProperty}` : '');
        message += ' must not be both defined or both undefined';
        results.push({
            message,
        });
    }
    return results;
});
//# sourceMappingURL=xor.js.map