"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.arazzo1_0 = exports.oas3_1 = exports.oas3_0 = exports.oas2_0 = void 0;
exports.oas2_0 = tt;
const e = { title: "A JSON Schema for Swagger 2.0 API.", $id: "http://swagger.io/v2/schema.json#", $schema: "https://json-schema.org/draft/2020-12/schema", type: "object", required: ["swagger", "info", "paths"], additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { swagger: { type: "string", enum: ["2.0"], description: "The Swagger version of this document." }, info: { $ref: "#/definitions/info" }, host: { type: "string", pattern: "^[^{}/ :\\\\]+(?::\\d+)?$", description: "The host (name or ip) of the API. Example: 'swagger.io'" }, basePath: { type: "string", pattern: "^/", description: "The base path to the API. Example: '/api'." }, schemes: { $ref: "#/definitions/schemesList" }, consumes: { description: "A list of MIME types accepted by the API.", allOf: [{ $ref: "#/definitions/mediaTypeList" }] }, produces: { description: "A list of MIME types the API can produce.", allOf: [{ $ref: "#/definitions/mediaTypeList" }] }, paths: { $ref: "#/definitions/paths" }, definitions: { $ref: "#/definitions/definitions" }, parameters: { $ref: "#/definitions/parameterDefinitions" }, responses: { $ref: "#/definitions/responseDefinitions" }, security: { $ref: "#/definitions/security" }, securityDefinitions: { $ref: "#/definitions/securityDefinitions" }, tags: { type: "array", items: { $ref: "#/definitions/tag" }, uniqueItems: !0 }, externalDocs: { $ref: "#/definitions/externalDocs" } }, definitions: { info: { type: "object", description: "General information about the API.", required: ["version", "title"], additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { title: { type: "string", description: "A unique and precise title of the API." }, version: { type: "string", description: "A semantic version number of the API." }, description: { type: "string", description: "A longer description of the API. Should be different from the title.  GitHub Flavored Markdown is allowed." }, termsOfService: { type: "string", description: "The terms of service for the API." }, contact: { $ref: "#/definitions/contact" }, license: { $ref: "#/definitions/license" } } }, contact: { type: "object", description: "Contact information for the owners of the API.", additionalProperties: !1, properties: { name: { type: "string", description: "The identifying name of the contact person/organization." }, url: { type: "string", description: "The URL pointing to the contact information.", format: "uri" }, email: { type: "string", description: "The email address of the contact person/organization.", format: "email" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, license: { type: "object", required: ["name"], additionalProperties: !1, properties: { name: { type: "string", description: "The name of the license type. It's encouraged to use an OSI compatible license." }, url: { type: "string", description: "The URL pointing to the license.", format: "uri" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, paths: { type: "object", description: "Relative paths to the individual endpoints. They must be relative to the 'basePath'.", patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" }, "^/": { $ref: "#/definitions/pathItem" } }, additionalProperties: !1 }, definitions: { type: "object", additionalProperties: { $ref: "#/definitions/schema" }, description: "One or more JSON objects describing the schemas being consumed and produced by the API." }, parameterDefinitions: { type: "object", additionalProperties: { $ref: "#/definitions/parameter" }, description: "One or more JSON representations for parameters" }, responseDefinitions: { type: "object", additionalProperties: { $ref: "#/definitions/response" }, description: "One or more JSON representations for responses" }, externalDocs: { type: "object", additionalProperties: !1, description: "information about external documentation", required: ["url"], properties: { description: { type: "string" }, url: { type: "string", format: "uri" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, examples: { type: "object", additionalProperties: !0 }, mimeType: { type: "string", description: "The MIME type of the HTTP message." }, operation: { type: "object", required: ["responses"], additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { tags: { type: "array", items: { type: "string" }, uniqueItems: !0 }, summary: { type: "string", description: "A brief summary of the operation." }, description: { type: "string", description: "A longer description of the operation, GitHub Flavored Markdown is allowed." }, externalDocs: { $ref: "#/definitions/externalDocs" }, operationId: { type: "string", description: "A unique identifier of the operation." }, produces: { description: "A list of MIME types the API can produce.", allOf: [{ $ref: "#/definitions/mediaTypeList" }] }, consumes: { description: "A list of MIME types the API can consume.", allOf: [{ $ref: "#/definitions/mediaTypeList" }] }, parameters: { $ref: "#/definitions/parametersList" }, responses: { $ref: "#/definitions/responses" }, schemes: { $ref: "#/definitions/schemesList" }, deprecated: { type: "boolean", default: !1 }, security: { $ref: "#/definitions/security" } } }, pathItem: { type: "object", additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { $ref: { type: "string" }, get: { $ref: "#/definitions/operation" }, put: { $ref: "#/definitions/operation" }, post: { $ref: "#/definitions/operation" }, delete: { $ref: "#/definitions/operation" }, options: { $ref: "#/definitions/operation" }, head: { $ref: "#/definitions/operation" }, patch: { $ref: "#/definitions/operation" }, parameters: { $ref: "#/definitions/parametersList" } } }, responses: { type: "object", description: "Response objects names can either be any valid HTTP status code or 'default'.", minProperties: 1, additionalProperties: !1, patternProperties: { "^([0-9]{3})$|^(default)$": { $ref: "#/definitions/responseValue" }, "^x-": { $ref: "#/definitions/vendorExtension" } }, not: { type: "object", additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } } }, responseValue: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/jsonReference" }, else: { $ref: "#/definitions/response" } }, response: { type: "object", required: ["description"], properties: { description: { type: "string" }, schema: { oneOf: [{ $ref: "#/definitions/schema" }, { $ref: "#/definitions/fileSchema" }] }, headers: { $ref: "#/definitions/headers" }, examples: { $ref: "#/definitions/examples" } }, additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, headers: { type: "object", additionalProperties: { $ref: "#/definitions/header" } }, header: { type: "object", additionalProperties: !1, required: ["type"], properties: { type: { type: "string", enum: ["string", "number", "integer", "boolean", "array"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormat" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, vendorExtension: { description: "Any property starting with x- is valid.", additionalProperties: !0, additionalItems: !0 }, bodyParameter: { type: "object", required: ["name", "in", "schema"], patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { description: { type: "string", description: "A brief description of the parameter. This could contain examples of use.  GitHub Flavored Markdown is allowed." }, name: { type: "string", description: "The name of the parameter." }, in: { type: "string", description: "Determines the location of the parameter.", enum: ["body"] }, required: { type: "boolean", description: "Determines whether or not this parameter is required or optional.", default: !1 }, schema: { $ref: "#/definitions/schema" } }, additionalProperties: !1 }, headerParameterSubSchema: { additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { required: { type: "boolean", description: "Determines whether or not this parameter is required or optional.", default: !1 }, in: { type: "string", description: "Determines the location of the parameter.", enum: ["header"] }, description: { type: "string", description: "A brief description of the parameter. This could contain examples of use.  GitHub Flavored Markdown is allowed." }, name: { type: "string", description: "The name of the parameter." }, type: { type: "string", enum: ["string", "number", "boolean", "integer", "array"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormat" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" } } }, queryParameterSubSchema: { additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { required: { type: "boolean", description: "Determines whether or not this parameter is required or optional.", default: !1 }, in: { type: "string", description: "Determines the location of the parameter.", enum: ["query"] }, description: { type: "string", description: "A brief description of the parameter. This could contain examples of use.  GitHub Flavored Markdown is allowed." }, name: { type: "string", description: "The name of the parameter." }, allowEmptyValue: { type: "boolean", default: !1, description: "allows sending a parameter by name only or with an empty value." }, type: { type: "string", enum: ["string", "number", "boolean", "integer", "array"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormatWithMulti" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" } } }, formDataParameterSubSchema: { additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { required: { type: "boolean", description: "Determines whether or not this parameter is required or optional.", default: !1 }, in: { type: "string", description: "Determines the location of the parameter.", enum: ["formData"] }, description: { type: "string", description: "A brief description of the parameter. This could contain examples of use.  GitHub Flavored Markdown is allowed." }, name: { type: "string", description: "The name of the parameter." }, allowEmptyValue: { type: "boolean", default: !1, description: "allows sending a parameter by name only or with an empty value." }, type: { type: "string", enum: ["string", "number", "boolean", "integer", "array", "file"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormatWithMulti" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" } } }, pathParameterSubSchema: { additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, required: ["required"], properties: { required: { type: "boolean", enum: [!0], description: "Determines whether or not this parameter is required or optional." }, in: { type: "string", description: "Determines the location of the parameter.", enum: ["path"] }, description: { type: "string", description: "A brief description of the parameter. This could contain examples of use.  GitHub Flavored Markdown is allowed." }, name: { type: "string", description: "The name of the parameter." }, type: { type: "string", enum: ["string", "number", "boolean", "integer", "array"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormat" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" } } }, nonBodyParameter: { type: "object", required: ["name", "in", "type"], oneOf: [{ $ref: "#/definitions/headerParameterSubSchema" }, { $ref: "#/definitions/formDataParameterSubSchema" }, { $ref: "#/definitions/queryParameterSubSchema" }, { $ref: "#/definitions/pathParameterSubSchema" }] }, parameter: { oneOf: [{ $ref: "#/definitions/bodyParameter" }, { $ref: "#/definitions/nonBodyParameter" }] }, schema: { type: "object", description: "A deterministic version of a JSON Schema object.", patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { $ref: { type: "string" }, format: { type: "string" }, title: { $ref: "http://json-schema.org/draft-04/schema#/properties/title" }, description: { $ref: "http://json-schema.org/draft-04/schema#/properties/description" }, default: { $ref: "http://json-schema.org/draft-04/schema#/properties/default" }, multipleOf: { $ref: "http://json-schema.org/draft-04/schema#/properties/multipleOf" }, maximum: { $ref: "http://json-schema.org/draft-04/schema#/properties/maximum" }, exclusiveMaximum: { $ref: "http://json-schema.org/draft-04/schema#/properties/exclusiveMaximum" }, minimum: { $ref: "http://json-schema.org/draft-04/schema#/properties/minimum" }, exclusiveMinimum: { $ref: "http://json-schema.org/draft-04/schema#/properties/exclusiveMinimum" }, maxLength: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveInteger" }, minLength: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveIntegerDefault0" }, pattern: { $ref: "http://json-schema.org/draft-04/schema#/properties/pattern" }, maxItems: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveInteger" }, minItems: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveIntegerDefault0" }, uniqueItems: { $ref: "http://json-schema.org/draft-04/schema#/properties/uniqueItems" }, maxProperties: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveInteger" }, minProperties: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveIntegerDefault0" }, required: { $ref: "http://json-schema.org/draft-04/schema#/definitions/stringArray" }, enum: { $ref: "http://json-schema.org/draft-04/schema#/properties/enum" }, additionalProperties: { if: { type: "object" }, then: { $ref: "#/definitions/schema" }, else: { if: { type: "boolean" }, then: !0, else: { not: !0, errorMessage: '"additionalProperties" property must be a valid schema' } }, default: {} }, type: { $ref: "http://json-schema.org/draft-04/schema#/properties/type" }, items: { anyOf: [{ $ref: "#/definitions/schema" }, { type: "array", minItems: 1, items: { $ref: "#/definitions/schema" } }], default: {} }, allOf: { type: "array", minItems: 1, items: { $ref: "#/definitions/schema" } }, oneOf: { type: "array", minItems: 1, items: { $ref: "#/definitions/schema" } }, anyOf: { type: "array", minItems: 1, items: { $ref: "#/definitions/schema" } }, properties: { type: "object", additionalProperties: { $ref: "#/definitions/schema" }, default: {} }, discriminator: { type: "string" }, readOnly: { type: "boolean", default: !1 }, xml: { $ref: "#/definitions/xml" }, externalDocs: { $ref: "#/definitions/externalDocs" }, example: {} }, additionalProperties: !1 }, fileSchema: { type: "object", description: "A deterministic version of a JSON Schema object.", patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, required: ["type"], properties: { format: { type: "string" }, title: { $ref: "http://json-schema.org/draft-04/schema#/properties/title" }, description: { $ref: "http://json-schema.org/draft-04/schema#/properties/description" }, default: { $ref: "http://json-schema.org/draft-04/schema#/properties/default" }, required: { $ref: "http://json-schema.org/draft-04/schema#/definitions/stringArray" }, type: { enum: ["file"] }, readOnly: { type: "boolean", default: !1 }, externalDocs: { $ref: "#/definitions/externalDocs" }, example: {} }, additionalProperties: !1 }, primitivesItems: { type: "object", additionalProperties: !1, properties: { type: { enum: ["string", "number", "integer", "boolean", "array"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormat" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, security: { type: "array", items: { $ref: "#/definitions/securityRequirement" }, uniqueItems: !0 }, securityRequirement: { type: "object", additionalProperties: { type: "array", items: { type: "string" }, uniqueItems: !0 } }, xml: { type: "object", additionalProperties: !1, properties: { name: { type: "string" }, namespace: { type: "string" }, prefix: { type: "string" }, attribute: { type: "boolean", default: !1 }, wrapped: { type: "boolean", default: !1 } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, tag: { type: "object", additionalProperties: !1, required: ["name"], properties: { name: { type: "string" }, description: { type: "string" }, externalDocs: { $ref: "#/definitions/externalDocs" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, securityDefinitions: { type: "object", additionalProperties: { oneOf: [{ $ref: "#/definitions/basicAuthenticationSecurity" }, { $ref: "#/definitions/apiKeySecurity" }, { $ref: "#/definitions/oauth2ImplicitSecurity" }, { $ref: "#/definitions/oauth2PasswordSecurity" }, { $ref: "#/definitions/oauth2ApplicationSecurity" }, { $ref: "#/definitions/oauth2AccessCodeSecurity" }] }, errorMessage: { properties: { basic: "Invalid basic authentication security definition", apiKey: "Invalid apiKey authentication security definition", oauth2: "Invalid oauth2 authentication security definition" }, _: "Invalid security securityDefinitions" } }, basicAuthenticationSecurity: { type: "object", additionalProperties: !1, required: ["type"], properties: { type: { enum: ["basic"] }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, apiKeySecurity: { type: "object", additionalProperties: !1, required: ["type", "name", "in"], properties: { type: { enum: ["apiKey"] }, name: { type: "string" }, in: { enum: ["header", "query"] }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, oauth2ImplicitSecurity: { type: "object", additionalProperties: !1, required: ["type", "flow", "authorizationUrl", "scopes"], properties: { type: { enum: ["oauth2"] }, flow: { enum: ["implicit"] }, scopes: { $ref: "#/definitions/oauth2Scopes" }, authorizationUrl: { type: "string", format: "uri" }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, oauth2PasswordSecurity: { type: "object", additionalProperties: !1, required: ["type", "flow", "tokenUrl", "scopes"], properties: { type: { enum: ["oauth2"] }, flow: { enum: ["password"] }, scopes: { $ref: "#/definitions/oauth2Scopes" }, tokenUrl: { type: "string", format: "uri" }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, oauth2ApplicationSecurity: { type: "object", additionalProperties: !1, required: ["type", "flow", "tokenUrl", "scopes"], properties: { type: { const: "oauth2" }, flow: { const: "application" }, scopes: { $ref: "#/definitions/oauth2Scopes" }, tokenUrl: { type: "string", format: "uri" }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, oauth2AccessCodeSecurity: { type: "object", additionalProperties: !1, required: ["type", "flow", "authorizationUrl", "tokenUrl", "scopes"], properties: { type: { const: "oauth2" }, flow: { const: "accessCode" }, scopes: { $ref: "#/definitions/oauth2Scopes" }, authorizationUrl: { type: "string", format: "uri" }, tokenUrl: { type: "string", format: "uri" }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, oauth2Scopes: { type: "object", additionalProperties: { type: "string" } }, mediaTypeList: { type: "array", items: { $ref: "#/definitions/mimeType" }, uniqueItems: !0 }, parametersList: { type: "array", description: "The parameters needed to send a valid API call.", additionalItems: !1, items: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/jsonReference" }, else: { $ref: "#/definitions/parameter" } }, uniqueItems: !0 }, schemesList: { type: "array", description: "The transfer protocol of the API.", items: { enum: ["http", "https", "ws", "wss"] }, uniqueItems: !0 }, collectionFormat: { enum: ["csv", "ssv", "tsv", "pipes"], default: "csv" }, collectionFormatWithMulti: { enum: ["csv", "ssv", "tsv", "pipes", "multi"], default: "csv" }, title: { $ref: "http://json-schema.org/draft-04/schema#/properties/title" }, description: { $ref: "http://json-schema.org/draft-04/schema#/properties/description" }, default: { $ref: "http://json-schema.org/draft-04/schema#/properties/default" }, multipleOf: { type: "number", exclusiveMinimum: 0 }, maximum: { $ref: "http://json-schema.org/draft-04/schema#/properties/maximum" }, exclusiveMaximum: { $ref: "http://json-schema.org/draft-04/schema#/properties/exclusiveMaximum" }, minimum: { $ref: "http://json-schema.org/draft-04/schema#/properties/minimum" }, exclusiveMinimum: { $ref: "http://json-schema.org/draft-04/schema#/properties/exclusiveMinimum" }, maxLength: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveInteger" }, minLength: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveIntegerDefault0" }, pattern: { $ref: "http://json-schema.org/draft-04/schema#/properties/pattern" }, maxItems: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveInteger" }, minItems: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveIntegerDefault0" }, uniqueItems: { $ref: "http://json-schema.org/draft-04/schema#/properties/uniqueItems" }, enum: { $ref: "http://json-schema.org/draft-04/schema#/properties/enum" }, jsonReference: { type: "object", required: ["$ref"], additionalProperties: !1, properties: { $ref: { type: "string" } } } } }, t = Object.prototype.hasOwnProperty, a = require("ajv/dist/runtime/equal").default, r = new RegExp("^x-", "u"), s = new RegExp("^[^{}/ :\\\\]+(?::\\d+)?$", "u"), n = new RegExp("^/", "u"), o = require("ajv-formats/dist/formats").fullFormats.uri, i = /^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i;
function p(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { const o = p.evaluated; return o.dynamicProps && (o.props = void 0), o.dynamicItems && (o.items = void 0), p.errors = null, !0; }
function c(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: l = {} } = {}) { let m = null, u = 0; const h = c.evaluated; if (h.dynamicProps && (h.props = void 0), h.dynamicItems && (h.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("name" !== a && "url" !== a && "email" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === m ? m = [e] : m.push(e), u++;
        }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === m ? m = [e] : m.push(e), u++;
    }
    if (void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === m ? m = [e] : m.push(e), u++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === m ? m = [e] : m.push(e), u++;
        }
    }
    if (void 0 !== e.email) {
        let a = e.email;
        if ("string" == typeof a) {
            if (!i.test(a)) {
                const e = { instancePath: t + "/email", schemaPath: "#/properties/email/format", keyword: "format", params: { format: "email" }, message: 'must match format "email"' };
                null === m ? m = [e] : m.push(e), u++;
            }
        }
        else {
            const e = { instancePath: t + "/email", schemaPath: "#/properties/email/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === m ? m = [e] : m.push(e), u++;
        }
    }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: l }) || (m = null === m ? p.errors : m.concat(p.errors), u = m.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === m ? m = [e] : m.push(e), u++;
} return c.errors = m, 0 === u; }
function l(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: i = {} } = {}) { let c = null, m = 0; const u = l.evaluated; if (u.dynamicProps && (u.props = void 0), u.dynamicItems && (u.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === c ? c = [e] : c.push(e), m++;
    }
    for (const a in e)
        if ("name" !== a && "url" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), m++;
        }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), m++;
    }
    if (void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === c ? c = [e] : c.push(e), m++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), m++;
        }
    }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), m = c.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), m++;
} return l.errors = c, 0 === m; }
function m(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, u = 0; const h = m.evaluated; if (h.dynamicProps && (h.props = void 0), h.dynamicItems && (h.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.version) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "version" }, message: "must have required property 'version'" };
        null === i ? i = [e] : i.push(e), u++;
    }
    if (void 0 === e.title) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "title" }, message: "must have required property 'title'" };
        null === i ? i = [e] : i.push(e), u++;
    }
    for (const a in e)
        if ("title" !== a && "version" !== a && "description" !== a && "termsOfService" !== a && "contact" !== a && "license" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), u++;
        }
    if (void 0 !== e.title && "string" != typeof e.title) {
        const e = { instancePath: t + "/title", schemaPath: "#/properties/title/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), u++;
    }
    if (void 0 !== e.version && "string" != typeof e.version) {
        const e = { instancePath: t + "/version", schemaPath: "#/properties/version/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), u++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), u++;
    }
    if (void 0 !== e.termsOfService && "string" != typeof e.termsOfService) {
        const e = { instancePath: t + "/termsOfService", schemaPath: "#/properties/termsOfService/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), u++;
    }
    void 0 !== e.contact && (c(e.contact, { instancePath: t + "/contact", parentData: e, parentDataProperty: "contact", rootData: n, dynamicAnchors: o }) || (i = null === i ? c.errors : i.concat(c.errors), u = i.length)), void 0 !== e.license && (l(e.license, { instancePath: t + "/license", parentData: e, parentDataProperty: "license", rootData: n, dynamicAnchors: o }) || (i = null === i ? l.errors : i.concat(l.errors), u = i.length));
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? p.errors : i.concat(p.errors), u = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), u++;
} return m.errors = i, 0 === u; }
p.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, c.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, l.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, m.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const u = { type: "array", description: "The transfer protocol of the API.", items: { enum: ["http", "https", "ws", "wss"] }, uniqueItems: !0 };
function h(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = h.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), Array.isArray(e)) {
    const r = e.length;
    for (let a = 0; a < r; a++) {
        let r = e[a];
        if ("http" !== r && "https" !== r && "ws" !== r && "wss" !== r) {
            const e = { instancePath: t + "/" + a, schemaPath: "#/items/enum", keyword: "enum", params: { allowedValues: u.items.enum }, message: "must be equal to one of the allowed values" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    let s, n = e.length;
    if (n > 1)
        e: for (; n--;)
            for (s = n; s--;)
                if (a(e[n], e[s])) {
                    const e = { instancePath: t, schemaPath: "#/uniqueItems", keyword: "uniqueItems", params: { i: n, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + n + " are identical)" };
                    null === i ? i = [e] : i.push(e), p++;
                    break e;
                }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === i ? i = [e] : i.push(e), p++;
} return h.errors = i, 0 === p; }
function d(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = d.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return d.errors = o, 0 === i; }
function y(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = y.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), Array.isArray(e)) {
    const r = e.length;
    for (let a = 0; a < r; a++)
        d(e[a], { instancePath: t + "/" + a, parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? d.errors : i.concat(d.errors), p = i.length);
    let s, c = e.length;
    if (c > 1)
        e: for (; c--;)
            for (s = c; s--;)
                if (a(e[c], e[s])) {
                    const e = { instancePath: t, schemaPath: "#/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                    null === i ? i = [e] : i.push(e), p++;
                    break e;
                }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === i ? i = [e] : i.push(e), p++;
} return y.errors = i, 0 === p; }
h.evaluated = { items: !0, dynamicProps: !1, dynamicItems: !1 }, d.evaluated = { dynamicProps: !1, dynamicItems: !1 }, y.evaluated = { items: !0, dynamicProps: !1, dynamicItems: !1 };
const f = { type: "object", additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { $ref: { type: "string" }, get: { $ref: "#/definitions/operation" }, put: { $ref: "#/definitions/operation" }, post: { $ref: "#/definitions/operation" }, delete: { $ref: "#/definitions/operation" }, options: { $ref: "#/definitions/operation" }, head: { $ref: "#/definitions/operation" }, patch: { $ref: "#/definitions/operation" }, parameters: { $ref: "#/definitions/parametersList" } } }, P = { type: "object", required: ["responses"], additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { tags: { type: "array", items: { type: "string" }, uniqueItems: !0 }, summary: { type: "string", description: "A brief summary of the operation." }, description: { type: "string", description: "A longer description of the operation, GitHub Flavored Markdown is allowed." }, externalDocs: { $ref: "#/definitions/externalDocs" }, operationId: { type: "string", description: "A unique identifier of the operation." }, produces: { description: "A list of MIME types the API can produce.", allOf: [{ $ref: "#/definitions/mediaTypeList" }] }, consumes: { description: "A list of MIME types the API can consume.", allOf: [{ $ref: "#/definitions/mediaTypeList" }] }, parameters: { $ref: "#/definitions/parametersList" }, responses: { $ref: "#/definitions/responses" }, schemes: { $ref: "#/definitions/schemesList" }, deprecated: { type: "boolean", default: !1 }, security: { $ref: "#/definitions/security" } } };
function g(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = g.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.url) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "url" }, message: "must have required property 'url'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const a in e)
        if ("description" !== a && "url" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === c ? c = [e] : c.push(e), l++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return g.errors = c, 0 === l; }
function v(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = v.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.$ref) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "$ref" }, message: "must have required property '$ref'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    for (const a in e)
        if ("$ref" !== a) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === o ? o = [e] : o.push(e), i++;
        }
    if (void 0 !== e.$ref && "string" != typeof e.$ref) {
        const e = { instancePath: t + "/$ref", schemaPath: "#/properties/%24ref/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return v.errors = o, 0 === i; }
g.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, v.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const b = { type: "object", required: ["name", "in", "schema"], patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { description: { type: "string", description: "A brief description of the parameter. This could contain examples of use.  GitHub Flavored Markdown is allowed." }, name: { type: "string", description: "The name of the parameter." }, in: { type: "string", description: "Determines the location of the parameter.", enum: ["body"] }, required: { type: "boolean", description: "Determines whether or not this parameter is required or optional.", default: !1 }, schema: { $ref: "#/definitions/schema" } }, additionalProperties: !1 }, D = { type: "object", description: "A deterministic version of a JSON Schema object.", patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { $ref: { type: "string" }, format: { type: "string" }, title: { $ref: "http://json-schema.org/draft-04/schema#/properties/title" }, description: { $ref: "http://json-schema.org/draft-04/schema#/properties/description" }, default: { $ref: "http://json-schema.org/draft-04/schema#/properties/default" }, multipleOf: { $ref: "http://json-schema.org/draft-04/schema#/properties/multipleOf" }, maximum: { $ref: "http://json-schema.org/draft-04/schema#/properties/maximum" }, exclusiveMaximum: { $ref: "http://json-schema.org/draft-04/schema#/properties/exclusiveMaximum" }, minimum: { $ref: "http://json-schema.org/draft-04/schema#/properties/minimum" }, exclusiveMinimum: { $ref: "http://json-schema.org/draft-04/schema#/properties/exclusiveMinimum" }, maxLength: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveInteger" }, minLength: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveIntegerDefault0" }, pattern: { $ref: "http://json-schema.org/draft-04/schema#/properties/pattern" }, maxItems: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveInteger" }, minItems: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveIntegerDefault0" }, uniqueItems: { $ref: "http://json-schema.org/draft-04/schema#/properties/uniqueItems" }, maxProperties: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveInteger" }, minProperties: { $ref: "http://json-schema.org/draft-04/schema#/definitions/positiveIntegerDefault0" }, required: { $ref: "http://json-schema.org/draft-04/schema#/definitions/stringArray" }, enum: { $ref: "http://json-schema.org/draft-04/schema#/properties/enum" }, additionalProperties: { if: { type: "object" }, then: { $ref: "#/definitions/schema" }, else: { if: { type: "boolean" }, then: !0, else: { not: !0, errorMessage: '"additionalProperties" property must be a valid schema' } }, default: {} }, type: { $ref: "http://json-schema.org/draft-04/schema#/properties/type" }, items: { anyOf: [{ $ref: "#/definitions/schema" }, { type: "array", minItems: 1, items: { $ref: "#/definitions/schema" } }], default: {} }, allOf: { type: "array", minItems: 1, items: { $ref: "#/definitions/schema" } }, oneOf: { type: "array", minItems: 1, items: { $ref: "#/definitions/schema" } }, anyOf: { type: "array", minItems: 1, items: { $ref: "#/definitions/schema" } }, properties: { type: "object", additionalProperties: { $ref: "#/definitions/schema" }, default: {} }, discriminator: { type: "string" }, readOnly: { type: "boolean", default: !1 }, xml: { $ref: "#/definitions/xml" }, externalDocs: { $ref: "#/definitions/externalDocs" }, example: {} }, additionalProperties: !1 };
function w(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = w.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return w.errors = o, 0 === i; }
function A(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = A.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return A.errors = o, 0 === i; }
function k(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { return k.errors = null, !0; }
function $(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = $.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" == typeof e) {
    if (e <= 0 || isNaN(e)) {
        const e = { instancePath: t, schemaPath: "#/exclusiveMinimum", keyword: "exclusiveMinimum", params: { comparison: ">", limit: 0 }, message: "must be > 0" };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "number" }, message: "must be number" };
    null === o ? o = [e] : o.push(e), i++;
} return $.errors = o, 0 === i; }
function j(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = j.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "number" }, message: "must be number" };
    null === o ? o = [e] : o.push(e), i++;
} return j.errors = o, 0 === i; }
function q(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = q.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
    null === o ? o = [e] : o.push(e), i++;
} return q.errors = o, 0 === i; }
function I(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = I.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "number" }, message: "must be number" };
    null === o ? o = [e] : o.push(e), i++;
} return I.errors = o, 0 === i; }
function x(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = x.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
    null === o ? o = [e] : o.push(e), i++;
} return x.errors = o, 0 === i; }
function O(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = O.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e || e % 1 || isNaN(e)) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
    null === o ? o = [e] : o.push(e), i++;
} if ("number" == typeof e && (e < 0 || isNaN(e))) {
    const e = { instancePath: t, schemaPath: "#/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
    null === o ? o = [e] : o.push(e), i++;
} return O.errors = o, 0 === i; }
function N(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = N.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e || e % 1 || isNaN(e)) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
    null === o ? o = [e] : o.push(e), i++;
} if ("number" == typeof e && (e < 0 || isNaN(e))) {
    const e = { instancePath: t, schemaPath: "#/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
    null === o ? o = [e] : o.push(e), i++;
} return N.errors = o, 0 === i; }
function U(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = U.evaluated; return p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), N(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? N.errors : o.concat(N.errors), i = o.length), U.errors = o, 0 === i; }
w.evaluated = { dynamicProps: !1, dynamicItems: !1 }, A.evaluated = { dynamicProps: !1, dynamicItems: !1 }, k.evaluated = { dynamicProps: !1, dynamicItems: !1 }, $.evaluated = { dynamicProps: !1, dynamicItems: !1 }, j.evaluated = { dynamicProps: !1, dynamicItems: !1 }, q.evaluated = { dynamicProps: !1, dynamicItems: !1 }, I.evaluated = { dynamicProps: !1, dynamicItems: !1 }, x.evaluated = { dynamicProps: !1, dynamicItems: !1 }, O.evaluated = { dynamicProps: !1, dynamicItems: !1 }, N.evaluated = { dynamicProps: !1, dynamicItems: !1 }, U.evaluated = { dynamicProps: !1, dynamicItems: !1 };
const T = require("ajv-formats/dist/formats").fullFormats.regex;
function M(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = M.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" == typeof e) {
    if (!T(e)) {
        const e = { instancePath: t, schemaPath: "#/format", keyword: "format", params: { format: "regex" }, message: 'must match format "regex"' };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return M.errors = o, 0 === i; }
function S(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = S.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
    null === o ? o = [e] : o.push(e), i++;
} return S.errors = o, 0 === i; }
function z(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = z.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), Array.isArray(e)) {
    if (e.length < 1) {
        const e = { instancePath: t, schemaPath: "#/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
        null === o ? o = [e] : o.push(e), i++;
    }
    const a = e.length;
    for (let r = 0; r < a; r++)
        if ("string" != typeof e[r]) {
            const e = { instancePath: t + "/" + r, schemaPath: "#/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    let r, s = e.length;
    if (s > 1) {
        const a = {};
        for (; s--;) {
            let n = e[s];
            if ("string" == typeof n) {
                if ("number" == typeof a[n]) {
                    r = a[n];
                    const e = { instancePath: t, schemaPath: "#/uniqueItems", keyword: "uniqueItems", params: { i: s, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + s + " are identical)" };
                    null === o ? o = [e] : o.push(e), i++;
                    break;
                }
                a[n] = s;
            }
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === o ? o = [e] : o.push(e), i++;
} return z.errors = o, 0 === i; }
function L(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = L.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), Array.isArray(e)) {
    if (e.length < 1) {
        const e = { instancePath: t, schemaPath: "#/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
        null === i ? i = [e] : i.push(e), p++;
    }
    let r, s = e.length;
    if (s > 1)
        e: for (; s--;)
            for (r = s; r--;)
                if (a(e[s], e[r])) {
                    const e = { instancePath: t, schemaPath: "#/uniqueItems", keyword: "uniqueItems", params: { i: s, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + s + " are identical)" };
                    null === i ? i = [e] : i.push(e), p++;
                    break e;
                }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === i ? i = [e] : i.push(e), p++;
} return L.errors = i, 0 === p; }
M.evaluated = { dynamicProps: !1, dynamicItems: !1 }, S.evaluated = { dynamicProps: !1, dynamicItems: !1 }, z.evaluated = { items: !0, dynamicProps: !1, dynamicItems: !1 }, L.evaluated = { dynamicProps: !1, dynamicItems: !1 };
const R = { enum: ["array", "boolean", "integer", "null", "number", "object", "string"] };
function C(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = C.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "array" !== e && "boolean" !== e && "integer" !== e && "null" !== e && "number" !== e && "object" !== e && "string" !== e) {
    const e = { instancePath: t, schemaPath: "#/enum", keyword: "enum", params: { allowedValues: R.enum }, message: "must be equal to one of the allowed values" };
    null === o ? o = [e] : o.push(e), i++;
} return C.errors = o, 0 === i; }
function E(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = E.evaluated; c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0); const l = p; let m = !1; const u = p; C(e, { instancePath: t, parentData: r, parentDataProperty: s, rootData: n, dynamicAnchors: o }) || (i = null === i ? C.errors : i.concat(C.errors), p = i.length); var h = u === p; m = m || h; const d = p; if (Array.isArray(e)) {
    if (e.length < 1) {
        const e = { instancePath: t, schemaPath: "#/anyOf/1/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
        null === i ? i = [e] : i.push(e), p++;
    }
    const r = e.length;
    for (let a = 0; a < r; a++)
        C(e[a], { instancePath: t + "/" + a, parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? C.errors : i.concat(C.errors), p = i.length);
    let s, c = e.length;
    if (c > 1)
        e: for (; c--;)
            for (s = c; s--;)
                if (a(e[c], e[s])) {
                    const e = { instancePath: t, schemaPath: "#/anyOf/1/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                    null === i ? i = [e] : i.push(e), p++;
                    break e;
                }
}
else {
    const e = { instancePath: t, schemaPath: "#/anyOf/1/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === i ? i = [e] : i.push(e), p++;
} if (h = d === p, m = m || h, h)
    var y = !0; if (m)
    p = l, null !== i && (l ? i.length = l : i = null);
else {
    const e = { instancePath: t, schemaPath: "#/anyOf", keyword: "anyOf", params: {}, message: "must match a schema in anyOf" };
    null === i ? i = [e] : i.push(e), p++;
} return E.errors = i, c.items = y, 0 === p; }
function V(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, c = 0; const l = V.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("name" !== a && "namespace" !== a && "prefix" !== a && "attribute" !== a && "wrapped" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), c++;
        }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.namespace && "string" != typeof e.namespace) {
        const e = { instancePath: t + "/namespace", schemaPath: "#/properties/namespace/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.prefix && "string" != typeof e.prefix) {
        const e = { instancePath: t + "/prefix", schemaPath: "#/properties/prefix/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.attribute && "boolean" != typeof e.attribute) {
        const e = { instancePath: t + "/attribute", schemaPath: "#/properties/attribute/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.wrapped && "boolean" != typeof e.wrapped) {
        const e = { instancePath: t + "/wrapped", schemaPath: "#/properties/wrapped/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === i ? i = [e] : i.push(e), c++;
    }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? p.errors : i.concat(p.errors), c = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), c++;
} return V.errors = i, 0 === c; }
C.evaluated = { dynamicProps: !1, dynamicItems: !1 }, E.evaluated = { dynamicProps: !1, dynamicItems: !0 }, V.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const K = { validate: F };
function F(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = F.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const s in e)
        if (!t.call(D.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.$ref && "string" != typeof e.$ref) {
        const e = { instancePath: a + "/$ref", schemaPath: "#/properties/%24ref/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.format && "string" != typeof e.format) {
        const e = { instancePath: a + "/format", schemaPath: "#/properties/format/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.title && (w(e.title, { instancePath: a + "/title", parentData: e, parentDataProperty: "title", rootData: o, dynamicAnchors: i }) || (c = null === c ? w.errors : c.concat(w.errors), l = c.length)), void 0 !== e.description && (A(e.description, { instancePath: a + "/description", parentData: e, parentDataProperty: "description", rootData: o, dynamicAnchors: i }) || (c = null === c ? A.errors : c.concat(A.errors), l = c.length)), void 0 !== e.default && (k(e.default, { instancePath: a + "/default", parentData: e, parentDataProperty: "default", rootData: o, dynamicAnchors: i }) || (c = null === c ? k.errors : c.concat(k.errors), l = c.length)), void 0 !== e.multipleOf && ($(e.multipleOf, { instancePath: a + "/multipleOf", parentData: e, parentDataProperty: "multipleOf", rootData: o, dynamicAnchors: i }) || (c = null === c ? $.errors : c.concat($.errors), l = c.length)), void 0 !== e.maximum && (j(e.maximum, { instancePath: a + "/maximum", parentData: e, parentDataProperty: "maximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? j.errors : c.concat(j.errors), l = c.length)), void 0 !== e.exclusiveMaximum && (q(e.exclusiveMaximum, { instancePath: a + "/exclusiveMaximum", parentData: e, parentDataProperty: "exclusiveMaximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? q.errors : c.concat(q.errors), l = c.length)), void 0 !== e.minimum && (I(e.minimum, { instancePath: a + "/minimum", parentData: e, parentDataProperty: "minimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? I.errors : c.concat(I.errors), l = c.length)), void 0 !== e.exclusiveMinimum && (x(e.exclusiveMinimum, { instancePath: a + "/exclusiveMinimum", parentData: e, parentDataProperty: "exclusiveMinimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? x.errors : c.concat(x.errors), l = c.length)), void 0 !== e.maxLength && (O(e.maxLength, { instancePath: a + "/maxLength", parentData: e, parentDataProperty: "maxLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? O.errors : c.concat(O.errors), l = c.length)), void 0 !== e.minLength && (U(e.minLength, { instancePath: a + "/minLength", parentData: e, parentDataProperty: "minLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? U.errors : c.concat(U.errors), l = c.length)), void 0 !== e.pattern && (M(e.pattern, { instancePath: a + "/pattern", parentData: e, parentDataProperty: "pattern", rootData: o, dynamicAnchors: i }) || (c = null === c ? M.errors : c.concat(M.errors), l = c.length)), void 0 !== e.maxItems && (O(e.maxItems, { instancePath: a + "/maxItems", parentData: e, parentDataProperty: "maxItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? O.errors : c.concat(O.errors), l = c.length)), void 0 !== e.minItems && (U(e.minItems, { instancePath: a + "/minItems", parentData: e, parentDataProperty: "minItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? U.errors : c.concat(U.errors), l = c.length)), void 0 !== e.uniqueItems && (S(e.uniqueItems, { instancePath: a + "/uniqueItems", parentData: e, parentDataProperty: "uniqueItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? S.errors : c.concat(S.errors), l = c.length)), void 0 !== e.maxProperties && (O(e.maxProperties, { instancePath: a + "/maxProperties", parentData: e, parentDataProperty: "maxProperties", rootData: o, dynamicAnchors: i }) || (c = null === c ? O.errors : c.concat(O.errors), l = c.length)), void 0 !== e.minProperties && (U(e.minProperties, { instancePath: a + "/minProperties", parentData: e, parentDataProperty: "minProperties", rootData: o, dynamicAnchors: i }) || (c = null === c ? U.errors : c.concat(U.errors), l = c.length)), void 0 !== e.required && (z(e.required, { instancePath: a + "/required", parentData: e, parentDataProperty: "required", rootData: o, dynamicAnchors: i }) || (c = null === c ? z.errors : c.concat(z.errors), l = c.length)), void 0 !== e.enum && (L(e.enum, { instancePath: a + "/enum", parentData: e, parentDataProperty: "enum", rootData: o, dynamicAnchors: i }) || (c = null === c ? L.errors : c.concat(L.errors), l = c.length)), void 0 !== e.additionalProperties) {
        let t = e.additionalProperties;
        const r = l;
        let s = !0;
        const n = l;
        if (!t || "object" != typeof t || Array.isArray(t)) {
            const e = {};
            null === c ? c = [e] : c.push(e), l++;
        }
        var u = n === l;
        let p;
        if (l = r, null !== c && (r ? c.length = r : c = null), u) {
            const r = l;
            K.validate(t, { instancePath: a + "/additionalProperties", parentData: e, parentDataProperty: "additionalProperties", rootData: o, dynamicAnchors: i }) || (c = null === c ? K.validate.errors : c.concat(K.validate.errors), l = c.length), s = u = r === l, p = "then";
        }
        else {
            const e = l, r = l;
            let n = !0;
            const o = l;
            if ("boolean" != typeof t) {
                const e = {};
                null === c ? c = [e] : c.push(e), l++;
            }
            var h = o === l;
            if (l = r, null !== c && (r ? c.length = r : c = null), !h) {
                const e = l, t = { instancePath: a + "/additionalProperties", schemaPath: "#/properties/additionalProperties/else/else/not", keyword: "not", params: {}, message: "must NOT be valid" };
                if (null === c ? c = [t] : c.push(t), l++, l > 0) {
                    const e = [];
                    for (const t of c)
                        "errorMessage" === t.keyword || t.emUsed || t.instancePath !== a + "/additionalProperties" && (0 !== t.instancePath.indexOf(a + "/additionalProperties") || "/" !== t.instancePath[a + 21]) || 0 !== t.schemaPath.indexOf("#/properties/additionalProperties/else/else") || "/" !== t.schemaPath[43] || (e.push(t), t.emUsed = !0);
                    if (e.length) {
                        const t = { instancePath: a + "/additionalProperties", schemaPath: "#/properties/additionalProperties/else/else/errorMessage", keyword: "errorMessage", params: { errors: e }, message: '"additionalProperties" property must be a valid schema' };
                        null === c ? c = [t] : c.push(t), l++;
                    }
                    const t = [];
                    for (const e of c)
                        e.emUsed || t.push(e);
                    c = t, l = t.length;
                }
                n = h = e === l;
            }
            if (!n) {
                const e = { instancePath: a + "/additionalProperties", schemaPath: "#/properties/additionalProperties/else/if", keyword: "if", params: { failingKeyword: "else" }, message: 'must match "else" schema' };
                null === c ? c = [e] : c.push(e), l++;
            }
            s = u = e === l, p = "else";
        }
        if (!s) {
            const e = { instancePath: a + "/additionalProperties", schemaPath: "#/properties/additionalProperties/if", keyword: "if", params: { failingKeyword: p }, message: 'must match "' + p + '" schema' };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.type && (E(e.type, { instancePath: a + "/type", parentData: e, parentDataProperty: "type", rootData: o, dynamicAnchors: i }) || (c = null === c ? E.errors : c.concat(E.errors), l = c.length)), void 0 !== e.items) {
        let t = e.items;
        const r = l;
        let s = !1;
        const n = l;
        if (K.validate(t, { instancePath: a + "/items", parentData: e, parentDataProperty: "items", rootData: o, dynamicAnchors: i }))
            var d = K.validate.evaluated.items;
        else
            c = null === c ? K.validate.errors : c.concat(K.validate.errors), l = c.length;
        var y = n === l;
        s = s || y;
        const p = l;
        if (Array.isArray(t)) {
            if (t.length < 1) {
                const e = { instancePath: a + "/items", schemaPath: "#/properties/items/anyOf/1/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === c ? c = [e] : c.push(e), l++;
            }
            const e = t.length;
            for (let r = 0; r < e; r++)
                K.validate(t[r], { instancePath: a + "/items/" + r, parentData: t, parentDataProperty: r, rootData: o, dynamicAnchors: i }) || (c = null === c ? K.validate.errors : c.concat(K.validate.errors), l = c.length);
        }
        else {
            const e = { instancePath: a + "/items", schemaPath: "#/properties/items/anyOf/1/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if (y = p === l, s = s || y, y && !0 !== d && (d = !0), s)
            l = r, null !== c && (r ? c.length = r : c = null);
        else {
            const e = { instancePath: a + "/items", schemaPath: "#/properties/items/anyOf", keyword: "anyOf", params: {}, message: "must match a schema in anyOf" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.allOf) {
        let t = e.allOf;
        if (Array.isArray(t)) {
            if (t.length < 1) {
                const e = { instancePath: a + "/allOf", schemaPath: "#/properties/allOf/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === c ? c = [e] : c.push(e), l++;
            }
            const e = t.length;
            for (let r = 0; r < e; r++)
                K.validate(t[r], { instancePath: a + "/allOf/" + r, parentData: t, parentDataProperty: r, rootData: o, dynamicAnchors: i }) || (c = null === c ? K.validate.errors : c.concat(K.validate.errors), l = c.length);
        }
        else {
            const e = { instancePath: a + "/allOf", schemaPath: "#/properties/allOf/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.oneOf) {
        let t = e.oneOf;
        if (Array.isArray(t)) {
            if (t.length < 1) {
                const e = { instancePath: a + "/oneOf", schemaPath: "#/properties/oneOf/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === c ? c = [e] : c.push(e), l++;
            }
            const e = t.length;
            for (let r = 0; r < e; r++)
                K.validate(t[r], { instancePath: a + "/oneOf/" + r, parentData: t, parentDataProperty: r, rootData: o, dynamicAnchors: i }) || (c = null === c ? K.validate.errors : c.concat(K.validate.errors), l = c.length);
        }
        else {
            const e = { instancePath: a + "/oneOf", schemaPath: "#/properties/oneOf/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.anyOf) {
        let t = e.anyOf;
        if (Array.isArray(t)) {
            if (t.length < 1) {
                const e = { instancePath: a + "/anyOf", schemaPath: "#/properties/anyOf/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === c ? c = [e] : c.push(e), l++;
            }
            const e = t.length;
            for (let r = 0; r < e; r++)
                K.validate(t[r], { instancePath: a + "/anyOf/" + r, parentData: t, parentDataProperty: r, rootData: o, dynamicAnchors: i }) || (c = null === c ? K.validate.errors : c.concat(K.validate.errors), l = c.length);
        }
        else {
            const e = { instancePath: a + "/anyOf", schemaPath: "#/properties/anyOf/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.properties) {
        let t = e.properties;
        if (t && "object" == typeof t && !Array.isArray(t))
            for (const e in t)
                K.validate(t[e], { instancePath: a + "/properties/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (c = null === c ? K.validate.errors : c.concat(K.validate.errors), l = c.length);
        else {
            const e = { instancePath: a + "/properties", schemaPath: "#/properties/properties/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.discriminator && "string" != typeof e.discriminator) {
        const e = { instancePath: a + "/discriminator", schemaPath: "#/properties/discriminator/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.readOnly && "boolean" != typeof e.readOnly) {
        const e = { instancePath: a + "/readOnly", schemaPath: "#/properties/readOnly/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === c ? c = [e] : c.push(e), l++;
    }
    void 0 !== e.xml && (V(e.xml, { instancePath: a + "/xml", parentData: e, parentDataProperty: "xml", rootData: o, dynamicAnchors: i }) || (c = null === c ? V.errors : c.concat(V.errors), l = c.length)), void 0 !== e.externalDocs && (g(e.externalDocs, { instancePath: a + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: o, dynamicAnchors: i }) || (c = null === c ? g.errors : c.concat(g.errors), l = c.length));
    for (const t in e)
        r.test(t) && (p(e[t], { instancePath: a + "/" + t.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: t, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: a, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return F.errors = c, 0 === l; }
function B(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, c = 0; const l = B.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 === e.in) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "in" }, message: "must have required property 'in'" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 === e.schema) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "schema" }, message: "must have required property 'schema'" };
        null === i ? i = [e] : i.push(e), c++;
    }
    for (const a in e)
        if ("description" !== a && "name" !== a && "in" !== a && "required" !== a && "schema" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), c++;
        }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.in) {
        let a = e.in;
        if ("string" != typeof a) {
            const e = { instancePath: t + "/in", schemaPath: "#/properties/in/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), c++;
        }
        if ("body" !== a) {
            const e = { instancePath: t + "/in", schemaPath: "#/properties/in/enum", keyword: "enum", params: { allowedValues: b.properties.in.enum }, message: "must be equal to one of the allowed values" };
            null === i ? i = [e] : i.push(e), c++;
        }
    }
    if (void 0 !== e.required && "boolean" != typeof e.required) {
        const e = { instancePath: t + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === i ? i = [e] : i.push(e), c++;
    }
    void 0 !== e.schema && (F(e.schema, { instancePath: t + "/schema", parentData: e, parentDataProperty: "schema", rootData: n, dynamicAnchors: o }) || (i = null === i ? F.errors : i.concat(F.errors), c = i.length));
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? p.errors : i.concat(p.errors), c = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), c++;
} return B.errors = i, 0 === c; }
F.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, B.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const _ = { additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { required: { type: "boolean", description: "Determines whether or not this parameter is required or optional.", default: !1 }, in: { type: "string", description: "Determines the location of the parameter.", enum: ["header"] }, description: { type: "string", description: "A brief description of the parameter. This could contain examples of use.  GitHub Flavored Markdown is allowed." }, name: { type: "string", description: "The name of the parameter." }, type: { type: "string", enum: ["string", "number", "boolean", "integer", "array"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormat" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" } } }, Z = { type: "object", additionalProperties: !1, properties: { type: { enum: ["string", "number", "integer", "boolean", "array"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormat" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } }, H = { validate: ce }, X = { enum: ["csv", "ssv", "tsv", "pipes"], default: "csv" };
function G(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = G.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "csv" !== e && "ssv" !== e && "tsv" !== e && "pipes" !== e) {
    const e = { instancePath: t, schemaPath: "#/enum", keyword: "enum", params: { allowedValues: X.enum }, message: "must be equal to one of the allowed values" };
    null === o ? o = [e] : o.push(e), i++;
} return G.errors = o, 0 === i; }
function J(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { return J.errors = null, !0; }
function W(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = W.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "number" }, message: "must be number" };
    null === o ? o = [e] : o.push(e), i++;
} return W.errors = o, 0 === i; }
function Y(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Y.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
    null === o ? o = [e] : o.push(e), i++;
} return Y.errors = o, 0 === i; }
function Q(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Q.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "number" }, message: "must be number" };
    null === o ? o = [e] : o.push(e), i++;
} return Q.errors = o, 0 === i; }
function ee(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ee.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
    null === o ? o = [e] : o.push(e), i++;
} return ee.errors = o, 0 === i; }
function te(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = te.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e || e % 1 || isNaN(e)) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
    null === o ? o = [e] : o.push(e), i++;
} if ("number" == typeof e && (e < 0 || isNaN(e))) {
    const e = { instancePath: t, schemaPath: "#/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
    null === o ? o = [e] : o.push(e), i++;
} return te.errors = o, 0 === i; }
function ae(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ae.evaluated; return p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), N(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? N.errors : o.concat(N.errors), i = o.length), ae.errors = o, 0 === i; }
function re(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = re.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" == typeof e) {
    if (!T(e)) {
        const e = { instancePath: t, schemaPath: "#/format", keyword: "format", params: { format: "regex" }, message: 'must match format "regex"' };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return re.errors = o, 0 === i; }
function se(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = se.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e || e % 1 || isNaN(e)) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
    null === o ? o = [e] : o.push(e), i++;
} if ("number" == typeof e && (e < 0 || isNaN(e))) {
    const e = { instancePath: t, schemaPath: "#/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
    null === o ? o = [e] : o.push(e), i++;
} return se.errors = o, 0 === i; }
function ne(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ne.evaluated; return p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), N(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? N.errors : o.concat(N.errors), i = o.length), ne.errors = o, 0 === i; }
function oe(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = oe.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
    null === o ? o = [e] : o.push(e), i++;
} return oe.errors = o, 0 === i; }
function ie(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = ie.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), Array.isArray(e)) {
    if (e.length < 1) {
        const e = { instancePath: t, schemaPath: "#/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
        null === i ? i = [e] : i.push(e), p++;
    }
    let r, s = e.length;
    if (s > 1)
        e: for (; s--;)
            for (r = s; r--;)
                if (a(e[s], e[r])) {
                    const e = { instancePath: t, schemaPath: "#/uniqueItems", keyword: "uniqueItems", params: { i: s, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + s + " are identical)" };
                    null === i ? i = [e] : i.push(e), p++;
                    break e;
                }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === i ? i = [e] : i.push(e), p++;
} return ie.errors = i, 0 === p; }
function pe(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = pe.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" == typeof e) {
    if (e <= 0 || isNaN(e)) {
        const e = { instancePath: t, schemaPath: "#/exclusiveMinimum", keyword: "exclusiveMinimum", params: { comparison: ">", limit: 0 }, message: "must be > 0" };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "number" }, message: "must be number" };
    null === o ? o = [e] : o.push(e), i++;
} return pe.errors = o, 0 === i; }
function ce(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = ce.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const s in e)
        if (!t.call(Z.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.type) {
        let t = e.type;
        if ("string" !== t && "number" !== t && "integer" !== t && "boolean" !== t && "array" !== t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: Z.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.format && "string" != typeof e.format) {
        const e = { instancePath: a + "/format", schemaPath: "#/properties/format/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    void 0 !== e.items && (H.validate(e.items, { instancePath: a + "/items", parentData: e, parentDataProperty: "items", rootData: o, dynamicAnchors: i }) || (c = null === c ? H.validate.errors : c.concat(H.validate.errors), l = c.length)), void 0 !== e.collectionFormat && (G(e.collectionFormat, { instancePath: a + "/collectionFormat", parentData: e, parentDataProperty: "collectionFormat", rootData: o, dynamicAnchors: i }) || (c = null === c ? G.errors : c.concat(G.errors), l = c.length)), void 0 !== e.default && (J(e.default, { instancePath: a + "/default", parentData: e, parentDataProperty: "default", rootData: o, dynamicAnchors: i }) || (c = null === c ? J.errors : c.concat(J.errors), l = c.length)), void 0 !== e.maximum && (W(e.maximum, { instancePath: a + "/maximum", parentData: e, parentDataProperty: "maximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? W.errors : c.concat(W.errors), l = c.length)), void 0 !== e.exclusiveMaximum && (Y(e.exclusiveMaximum, { instancePath: a + "/exclusiveMaximum", parentData: e, parentDataProperty: "exclusiveMaximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Y.errors : c.concat(Y.errors), l = c.length)), void 0 !== e.minimum && (Q(e.minimum, { instancePath: a + "/minimum", parentData: e, parentDataProperty: "minimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Q.errors : c.concat(Q.errors), l = c.length)), void 0 !== e.exclusiveMinimum && (ee(e.exclusiveMinimum, { instancePath: a + "/exclusiveMinimum", parentData: e, parentDataProperty: "exclusiveMinimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ee.errors : c.concat(ee.errors), l = c.length)), void 0 !== e.maxLength && (te(e.maxLength, { instancePath: a + "/maxLength", parentData: e, parentDataProperty: "maxLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? te.errors : c.concat(te.errors), l = c.length)), void 0 !== e.minLength && (ae(e.minLength, { instancePath: a + "/minLength", parentData: e, parentDataProperty: "minLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? ae.errors : c.concat(ae.errors), l = c.length)), void 0 !== e.pattern && (re(e.pattern, { instancePath: a + "/pattern", parentData: e, parentDataProperty: "pattern", rootData: o, dynamicAnchors: i }) || (c = null === c ? re.errors : c.concat(re.errors), l = c.length)), void 0 !== e.maxItems && (se(e.maxItems, { instancePath: a + "/maxItems", parentData: e, parentDataProperty: "maxItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? se.errors : c.concat(se.errors), l = c.length)), void 0 !== e.minItems && (ne(e.minItems, { instancePath: a + "/minItems", parentData: e, parentDataProperty: "minItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? ne.errors : c.concat(ne.errors), l = c.length)), void 0 !== e.uniqueItems && (oe(e.uniqueItems, { instancePath: a + "/uniqueItems", parentData: e, parentDataProperty: "uniqueItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? oe.errors : c.concat(oe.errors), l = c.length)), void 0 !== e.enum && (ie(e.enum, { instancePath: a + "/enum", parentData: e, parentDataProperty: "enum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ie.errors : c.concat(ie.errors), l = c.length)), void 0 !== e.multipleOf && (pe(e.multipleOf, { instancePath: a + "/multipleOf", parentData: e, parentDataProperty: "multipleOf", rootData: o, dynamicAnchors: i }) || (c = null === c ? pe.errors : c.concat(pe.errors), l = c.length));
    for (const t in e)
        r.test(t) && (p(e[t], { instancePath: a + "/" + t.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: t, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: a, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return ce.errors = c, 0 === l; }
function le(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = le.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const s in e)
        if (!t.call(_.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.required && "boolean" != typeof e.required) {
        const e = { instancePath: a + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.in) {
        let t = e.in;
        if ("string" != typeof t) {
            const e = { instancePath: a + "/in", schemaPath: "#/properties/in/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if ("header" !== t) {
            const e = { instancePath: a + "/in", schemaPath: "#/properties/in/enum", keyword: "enum", params: { allowedValues: _.properties.in.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: a + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: a + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.type) {
        let t = e.type;
        if ("string" != typeof t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if ("string" !== t && "number" !== t && "boolean" !== t && "integer" !== t && "array" !== t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: _.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.format && "string" != typeof e.format) {
        const e = { instancePath: a + "/format", schemaPath: "#/properties/format/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    void 0 !== e.items && (ce(e.items, { instancePath: a + "/items", parentData: e, parentDataProperty: "items", rootData: o, dynamicAnchors: i }) || (c = null === c ? ce.errors : c.concat(ce.errors), l = c.length)), void 0 !== e.collectionFormat && (G(e.collectionFormat, { instancePath: a + "/collectionFormat", parentData: e, parentDataProperty: "collectionFormat", rootData: o, dynamicAnchors: i }) || (c = null === c ? G.errors : c.concat(G.errors), l = c.length)), void 0 !== e.default && (J(e.default, { instancePath: a + "/default", parentData: e, parentDataProperty: "default", rootData: o, dynamicAnchors: i }) || (c = null === c ? J.errors : c.concat(J.errors), l = c.length)), void 0 !== e.maximum && (W(e.maximum, { instancePath: a + "/maximum", parentData: e, parentDataProperty: "maximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? W.errors : c.concat(W.errors), l = c.length)), void 0 !== e.exclusiveMaximum && (Y(e.exclusiveMaximum, { instancePath: a + "/exclusiveMaximum", parentData: e, parentDataProperty: "exclusiveMaximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Y.errors : c.concat(Y.errors), l = c.length)), void 0 !== e.minimum && (Q(e.minimum, { instancePath: a + "/minimum", parentData: e, parentDataProperty: "minimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Q.errors : c.concat(Q.errors), l = c.length)), void 0 !== e.exclusiveMinimum && (ee(e.exclusiveMinimum, { instancePath: a + "/exclusiveMinimum", parentData: e, parentDataProperty: "exclusiveMinimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ee.errors : c.concat(ee.errors), l = c.length)), void 0 !== e.maxLength && (te(e.maxLength, { instancePath: a + "/maxLength", parentData: e, parentDataProperty: "maxLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? te.errors : c.concat(te.errors), l = c.length)), void 0 !== e.minLength && (ae(e.minLength, { instancePath: a + "/minLength", parentData: e, parentDataProperty: "minLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? ae.errors : c.concat(ae.errors), l = c.length)), void 0 !== e.pattern && (re(e.pattern, { instancePath: a + "/pattern", parentData: e, parentDataProperty: "pattern", rootData: o, dynamicAnchors: i }) || (c = null === c ? re.errors : c.concat(re.errors), l = c.length)), void 0 !== e.maxItems && (se(e.maxItems, { instancePath: a + "/maxItems", parentData: e, parentDataProperty: "maxItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? se.errors : c.concat(se.errors), l = c.length)), void 0 !== e.minItems && (ne(e.minItems, { instancePath: a + "/minItems", parentData: e, parentDataProperty: "minItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? ne.errors : c.concat(ne.errors), l = c.length)), void 0 !== e.uniqueItems && (oe(e.uniqueItems, { instancePath: a + "/uniqueItems", parentData: e, parentDataProperty: "uniqueItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? oe.errors : c.concat(oe.errors), l = c.length)), void 0 !== e.enum && (ie(e.enum, { instancePath: a + "/enum", parentData: e, parentDataProperty: "enum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ie.errors : c.concat(ie.errors), l = c.length)), void 0 !== e.multipleOf && (pe(e.multipleOf, { instancePath: a + "/multipleOf", parentData: e, parentDataProperty: "multipleOf", rootData: o, dynamicAnchors: i }) || (c = null === c ? pe.errors : c.concat(pe.errors), l = c.length));
    for (const t in e)
        r.test(t) && (p(e[t], { instancePath: a + "/" + t.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: t, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
} return le.errors = c, 0 === l; }
G.evaluated = { dynamicProps: !1, dynamicItems: !1 }, J.evaluated = { dynamicProps: !1, dynamicItems: !1 }, W.evaluated = { dynamicProps: !1, dynamicItems: !1 }, Y.evaluated = { dynamicProps: !1, dynamicItems: !1 }, Q.evaluated = { dynamicProps: !1, dynamicItems: !1 }, ee.evaluated = { dynamicProps: !1, dynamicItems: !1 }, te.evaluated = { dynamicProps: !1, dynamicItems: !1 }, ae.evaluated = { dynamicProps: !1, dynamicItems: !1 }, re.evaluated = { dynamicProps: !1, dynamicItems: !1 }, se.evaluated = { dynamicProps: !1, dynamicItems: !1 }, ne.evaluated = { dynamicProps: !1, dynamicItems: !1 }, oe.evaluated = { dynamicProps: !1, dynamicItems: !1 }, ie.evaluated = { dynamicProps: !1, dynamicItems: !1 }, pe.evaluated = { dynamicProps: !1, dynamicItems: !1 }, ce.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, le.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const me = { additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { required: { type: "boolean", description: "Determines whether or not this parameter is required or optional.", default: !1 }, in: { type: "string", description: "Determines the location of the parameter.", enum: ["formData"] }, description: { type: "string", description: "A brief description of the parameter. This could contain examples of use.  GitHub Flavored Markdown is allowed." }, name: { type: "string", description: "The name of the parameter." }, allowEmptyValue: { type: "boolean", default: !1, description: "allows sending a parameter by name only or with an empty value." }, type: { type: "string", enum: ["string", "number", "boolean", "integer", "array", "file"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormatWithMulti" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" } } }, ue = { enum: ["csv", "ssv", "tsv", "pipes", "multi"], default: "csv" };
function he(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = he.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "csv" !== e && "ssv" !== e && "tsv" !== e && "pipes" !== e && "multi" !== e) {
    const e = { instancePath: t, schemaPath: "#/enum", keyword: "enum", params: { allowedValues: ue.enum }, message: "must be equal to one of the allowed values" };
    null === o ? o = [e] : o.push(e), i++;
} return he.errors = o, 0 === i; }
function de(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = de.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const s in e)
        if (!t.call(me.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.required && "boolean" != typeof e.required) {
        const e = { instancePath: a + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.in) {
        let t = e.in;
        if ("string" != typeof t) {
            const e = { instancePath: a + "/in", schemaPath: "#/properties/in/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if ("formData" !== t) {
            const e = { instancePath: a + "/in", schemaPath: "#/properties/in/enum", keyword: "enum", params: { allowedValues: me.properties.in.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: a + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: a + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.allowEmptyValue && "boolean" != typeof e.allowEmptyValue) {
        const e = { instancePath: a + "/allowEmptyValue", schemaPath: "#/properties/allowEmptyValue/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.type) {
        let t = e.type;
        if ("string" != typeof t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if ("string" !== t && "number" !== t && "boolean" !== t && "integer" !== t && "array" !== t && "file" !== t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: me.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.format && "string" != typeof e.format) {
        const e = { instancePath: a + "/format", schemaPath: "#/properties/format/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    void 0 !== e.items && (ce(e.items, { instancePath: a + "/items", parentData: e, parentDataProperty: "items", rootData: o, dynamicAnchors: i }) || (c = null === c ? ce.errors : c.concat(ce.errors), l = c.length)), void 0 !== e.collectionFormat && (he(e.collectionFormat, { instancePath: a + "/collectionFormat", parentData: e, parentDataProperty: "collectionFormat", rootData: o, dynamicAnchors: i }) || (c = null === c ? he.errors : c.concat(he.errors), l = c.length)), void 0 !== e.default && (J(e.default, { instancePath: a + "/default", parentData: e, parentDataProperty: "default", rootData: o, dynamicAnchors: i }) || (c = null === c ? J.errors : c.concat(J.errors), l = c.length)), void 0 !== e.maximum && (W(e.maximum, { instancePath: a + "/maximum", parentData: e, parentDataProperty: "maximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? W.errors : c.concat(W.errors), l = c.length)), void 0 !== e.exclusiveMaximum && (Y(e.exclusiveMaximum, { instancePath: a + "/exclusiveMaximum", parentData: e, parentDataProperty: "exclusiveMaximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Y.errors : c.concat(Y.errors), l = c.length)), void 0 !== e.minimum && (Q(e.minimum, { instancePath: a + "/minimum", parentData: e, parentDataProperty: "minimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Q.errors : c.concat(Q.errors), l = c.length)), void 0 !== e.exclusiveMinimum && (ee(e.exclusiveMinimum, { instancePath: a + "/exclusiveMinimum", parentData: e, parentDataProperty: "exclusiveMinimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ee.errors : c.concat(ee.errors), l = c.length)), void 0 !== e.maxLength && (te(e.maxLength, { instancePath: a + "/maxLength", parentData: e, parentDataProperty: "maxLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? te.errors : c.concat(te.errors), l = c.length)), void 0 !== e.minLength && (ae(e.minLength, { instancePath: a + "/minLength", parentData: e, parentDataProperty: "minLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? ae.errors : c.concat(ae.errors), l = c.length)), void 0 !== e.pattern && (re(e.pattern, { instancePath: a + "/pattern", parentData: e, parentDataProperty: "pattern", rootData: o, dynamicAnchors: i }) || (c = null === c ? re.errors : c.concat(re.errors), l = c.length)), void 0 !== e.maxItems && (se(e.maxItems, { instancePath: a + "/maxItems", parentData: e, parentDataProperty: "maxItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? se.errors : c.concat(se.errors), l = c.length)), void 0 !== e.minItems && (ne(e.minItems, { instancePath: a + "/minItems", parentData: e, parentDataProperty: "minItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? ne.errors : c.concat(ne.errors), l = c.length)), void 0 !== e.uniqueItems && (oe(e.uniqueItems, { instancePath: a + "/uniqueItems", parentData: e, parentDataProperty: "uniqueItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? oe.errors : c.concat(oe.errors), l = c.length)), void 0 !== e.enum && (ie(e.enum, { instancePath: a + "/enum", parentData: e, parentDataProperty: "enum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ie.errors : c.concat(ie.errors), l = c.length)), void 0 !== e.multipleOf && (pe(e.multipleOf, { instancePath: a + "/multipleOf", parentData: e, parentDataProperty: "multipleOf", rootData: o, dynamicAnchors: i }) || (c = null === c ? pe.errors : c.concat(pe.errors), l = c.length));
    for (const t in e)
        r.test(t) && (p(e[t], { instancePath: a + "/" + t.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: t, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
} return de.errors = c, 0 === l; }
he.evaluated = { dynamicProps: !1, dynamicItems: !1 }, de.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const ye = { additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, properties: { required: { type: "boolean", description: "Determines whether or not this parameter is required or optional.", default: !1 }, in: { type: "string", description: "Determines the location of the parameter.", enum: ["query"] }, description: { type: "string", description: "A brief description of the parameter. This could contain examples of use.  GitHub Flavored Markdown is allowed." }, name: { type: "string", description: "The name of the parameter." }, allowEmptyValue: { type: "boolean", default: !1, description: "allows sending a parameter by name only or with an empty value." }, type: { type: "string", enum: ["string", "number", "boolean", "integer", "array"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormatWithMulti" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" } } };
function fe(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = fe.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const s in e)
        if (!t.call(ye.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.required && "boolean" != typeof e.required) {
        const e = { instancePath: a + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.in) {
        let t = e.in;
        if ("string" != typeof t) {
            const e = { instancePath: a + "/in", schemaPath: "#/properties/in/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if ("query" !== t) {
            const e = { instancePath: a + "/in", schemaPath: "#/properties/in/enum", keyword: "enum", params: { allowedValues: ye.properties.in.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: a + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: a + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.allowEmptyValue && "boolean" != typeof e.allowEmptyValue) {
        const e = { instancePath: a + "/allowEmptyValue", schemaPath: "#/properties/allowEmptyValue/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.type) {
        let t = e.type;
        if ("string" != typeof t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if ("string" !== t && "number" !== t && "boolean" !== t && "integer" !== t && "array" !== t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: ye.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.format && "string" != typeof e.format) {
        const e = { instancePath: a + "/format", schemaPath: "#/properties/format/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    void 0 !== e.items && (ce(e.items, { instancePath: a + "/items", parentData: e, parentDataProperty: "items", rootData: o, dynamicAnchors: i }) || (c = null === c ? ce.errors : c.concat(ce.errors), l = c.length)), void 0 !== e.collectionFormat && (he(e.collectionFormat, { instancePath: a + "/collectionFormat", parentData: e, parentDataProperty: "collectionFormat", rootData: o, dynamicAnchors: i }) || (c = null === c ? he.errors : c.concat(he.errors), l = c.length)), void 0 !== e.default && (J(e.default, { instancePath: a + "/default", parentData: e, parentDataProperty: "default", rootData: o, dynamicAnchors: i }) || (c = null === c ? J.errors : c.concat(J.errors), l = c.length)), void 0 !== e.maximum && (W(e.maximum, { instancePath: a + "/maximum", parentData: e, parentDataProperty: "maximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? W.errors : c.concat(W.errors), l = c.length)), void 0 !== e.exclusiveMaximum && (Y(e.exclusiveMaximum, { instancePath: a + "/exclusiveMaximum", parentData: e, parentDataProperty: "exclusiveMaximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Y.errors : c.concat(Y.errors), l = c.length)), void 0 !== e.minimum && (Q(e.minimum, { instancePath: a + "/minimum", parentData: e, parentDataProperty: "minimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Q.errors : c.concat(Q.errors), l = c.length)), void 0 !== e.exclusiveMinimum && (ee(e.exclusiveMinimum, { instancePath: a + "/exclusiveMinimum", parentData: e, parentDataProperty: "exclusiveMinimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ee.errors : c.concat(ee.errors), l = c.length)), void 0 !== e.maxLength && (te(e.maxLength, { instancePath: a + "/maxLength", parentData: e, parentDataProperty: "maxLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? te.errors : c.concat(te.errors), l = c.length)), void 0 !== e.minLength && (ae(e.minLength, { instancePath: a + "/minLength", parentData: e, parentDataProperty: "minLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? ae.errors : c.concat(ae.errors), l = c.length)), void 0 !== e.pattern && (re(e.pattern, { instancePath: a + "/pattern", parentData: e, parentDataProperty: "pattern", rootData: o, dynamicAnchors: i }) || (c = null === c ? re.errors : c.concat(re.errors), l = c.length)), void 0 !== e.maxItems && (se(e.maxItems, { instancePath: a + "/maxItems", parentData: e, parentDataProperty: "maxItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? se.errors : c.concat(se.errors), l = c.length)), void 0 !== e.minItems && (ne(e.minItems, { instancePath: a + "/minItems", parentData: e, parentDataProperty: "minItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? ne.errors : c.concat(ne.errors), l = c.length)), void 0 !== e.uniqueItems && (oe(e.uniqueItems, { instancePath: a + "/uniqueItems", parentData: e, parentDataProperty: "uniqueItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? oe.errors : c.concat(oe.errors), l = c.length)), void 0 !== e.enum && (ie(e.enum, { instancePath: a + "/enum", parentData: e, parentDataProperty: "enum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ie.errors : c.concat(ie.errors), l = c.length)), void 0 !== e.multipleOf && (pe(e.multipleOf, { instancePath: a + "/multipleOf", parentData: e, parentDataProperty: "multipleOf", rootData: o, dynamicAnchors: i }) || (c = null === c ? pe.errors : c.concat(pe.errors), l = c.length));
    for (const t in e)
        r.test(t) && (p(e[t], { instancePath: a + "/" + t.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: t, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
} return fe.errors = c, 0 === l; }
fe.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Pe = { additionalProperties: !1, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, required: ["required"], properties: { required: { type: "boolean", enum: [!0], description: "Determines whether or not this parameter is required or optional." }, in: { type: "string", description: "Determines the location of the parameter.", enum: ["path"] }, description: { type: "string", description: "A brief description of the parameter. This could contain examples of use.  GitHub Flavored Markdown is allowed." }, name: { type: "string", description: "The name of the parameter." }, type: { type: "string", enum: ["string", "number", "boolean", "integer", "array"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormat" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" } } };
function ge(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = ge.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.required) {
        const e = { instancePath: a, schemaPath: "#/required", keyword: "required", params: { missingProperty: "required" }, message: "must have required property 'required'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const s in e)
        if (!t.call(Pe.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.required) {
        let t = e.required;
        if ("boolean" != typeof t) {
            const e = { instancePath: a + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if (!0 !== t) {
            const e = { instancePath: a + "/required", schemaPath: "#/properties/required/enum", keyword: "enum", params: { allowedValues: Pe.properties.required.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.in) {
        let t = e.in;
        if ("string" != typeof t) {
            const e = { instancePath: a + "/in", schemaPath: "#/properties/in/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if ("path" !== t) {
            const e = { instancePath: a + "/in", schemaPath: "#/properties/in/enum", keyword: "enum", params: { allowedValues: Pe.properties.in.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: a + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: a + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.type) {
        let t = e.type;
        if ("string" != typeof t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if ("string" !== t && "number" !== t && "boolean" !== t && "integer" !== t && "array" !== t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: Pe.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.format && "string" != typeof e.format) {
        const e = { instancePath: a + "/format", schemaPath: "#/properties/format/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    void 0 !== e.items && (ce(e.items, { instancePath: a + "/items", parentData: e, parentDataProperty: "items", rootData: o, dynamicAnchors: i }) || (c = null === c ? ce.errors : c.concat(ce.errors), l = c.length)), void 0 !== e.collectionFormat && (G(e.collectionFormat, { instancePath: a + "/collectionFormat", parentData: e, parentDataProperty: "collectionFormat", rootData: o, dynamicAnchors: i }) || (c = null === c ? G.errors : c.concat(G.errors), l = c.length)), void 0 !== e.default && (J(e.default, { instancePath: a + "/default", parentData: e, parentDataProperty: "default", rootData: o, dynamicAnchors: i }) || (c = null === c ? J.errors : c.concat(J.errors), l = c.length)), void 0 !== e.maximum && (W(e.maximum, { instancePath: a + "/maximum", parentData: e, parentDataProperty: "maximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? W.errors : c.concat(W.errors), l = c.length)), void 0 !== e.exclusiveMaximum && (Y(e.exclusiveMaximum, { instancePath: a + "/exclusiveMaximum", parentData: e, parentDataProperty: "exclusiveMaximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Y.errors : c.concat(Y.errors), l = c.length)), void 0 !== e.minimum && (Q(e.minimum, { instancePath: a + "/minimum", parentData: e, parentDataProperty: "minimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Q.errors : c.concat(Q.errors), l = c.length)), void 0 !== e.exclusiveMinimum && (ee(e.exclusiveMinimum, { instancePath: a + "/exclusiveMinimum", parentData: e, parentDataProperty: "exclusiveMinimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ee.errors : c.concat(ee.errors), l = c.length)), void 0 !== e.maxLength && (te(e.maxLength, { instancePath: a + "/maxLength", parentData: e, parentDataProperty: "maxLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? te.errors : c.concat(te.errors), l = c.length)), void 0 !== e.minLength && (ae(e.minLength, { instancePath: a + "/minLength", parentData: e, parentDataProperty: "minLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? ae.errors : c.concat(ae.errors), l = c.length)), void 0 !== e.pattern && (re(e.pattern, { instancePath: a + "/pattern", parentData: e, parentDataProperty: "pattern", rootData: o, dynamicAnchors: i }) || (c = null === c ? re.errors : c.concat(re.errors), l = c.length)), void 0 !== e.maxItems && (se(e.maxItems, { instancePath: a + "/maxItems", parentData: e, parentDataProperty: "maxItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? se.errors : c.concat(se.errors), l = c.length)), void 0 !== e.minItems && (ne(e.minItems, { instancePath: a + "/minItems", parentData: e, parentDataProperty: "minItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? ne.errors : c.concat(ne.errors), l = c.length)), void 0 !== e.uniqueItems && (oe(e.uniqueItems, { instancePath: a + "/uniqueItems", parentData: e, parentDataProperty: "uniqueItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? oe.errors : c.concat(oe.errors), l = c.length)), void 0 !== e.enum && (ie(e.enum, { instancePath: a + "/enum", parentData: e, parentDataProperty: "enum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ie.errors : c.concat(ie.errors), l = c.length)), void 0 !== e.multipleOf && (pe(e.multipleOf, { instancePath: a + "/multipleOf", parentData: e, parentDataProperty: "multipleOf", rootData: o, dynamicAnchors: i }) || (c = null === c ? pe.errors : c.concat(pe.errors), l = c.length));
    for (const t in e)
        r.test(t) && (p(e[t], { instancePath: a + "/" + t.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: t, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
} return ge.errors = c, 0 === l; }
function ve(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ve.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !1, m = null; const u = i; if (le(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? le.errors : o.concat(le.errors), i = o.length), y = u === i) {
    l = !0, m = 0;
    var h = !0;
} const d = i; if (de(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? de.errors : o.concat(de.errors), i = o.length), (y = d === i) && l)
    l = !1, m = [m, 1];
else {
    y && (l = !0, m = 1, !0 !== h && (h = !0));
    const p = i;
    if (fe(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? fe.errors : o.concat(fe.errors), i = o.length), (y = p === i) && l)
        l = !1, m = [m, 2];
    else {
        y && (l = !0, m = 2, !0 !== h && (h = !0));
        const p = i;
        var y;
        ge(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? ge.errors : o.concat(ge.errors), i = o.length), (y = p === i) && l ? (l = !1, m = [m, 3]) : y && (l = !0, m = 3, !0 !== h && (h = !0));
    }
} if (l)
    i = c, null !== o && (c ? o.length = c : o = null);
else {
    const e = { instancePath: t, schemaPath: "#/oneOf", keyword: "oneOf", params: { passingSchemas: m }, message: "must match exactly one schema in oneOf" };
    null === o ? o = [e] : o.push(e), i++;
} if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.in) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "in" }, message: "must have required property 'in'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return ve.errors = o, p.props = h, 0 === i; }
function be(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = be.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !1, m = null; const u = i; if (B(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? B.errors : o.concat(B.errors), i = o.length), u === i) {
    l = !0, m = 0;
    var h = !0;
} const d = i; if (ve(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var y = ve.evaluated.props;
else
    o = null === o ? ve.errors : o.concat(ve.errors), i = o.length; var f; if ((f = d === i) && l ? (l = !1, m = [m, 1]) : f && (l = !0, m = 1, !0 !== h && void 0 !== y && (!0 === y ? h = !0 : (h = h || {}, Object.assign(h, y)))), l)
    i = c, null !== o && (c ? o.length = c : o = null);
else {
    const e = { instancePath: t, schemaPath: "#/oneOf", keyword: "oneOf", params: { passingSchemas: m }, message: "must match exactly one schema in oneOf" };
    null === o ? o = [e] : o.push(e), i++;
} return be.errors = o, p.props = h, 0 === i; }
function De(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = De.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), Array.isArray(e)) {
    const r = e.length;
    for (let a = 0; a < r; a++) {
        let r = e[a];
        const s = p;
        let c = !0;
        const h = p;
        if (p === h)
            if (r && "object" == typeof r && !Array.isArray(r)) {
                let e;
                if (void 0 === r.$ref && (e = "$ref")) {
                    const e = {};
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
            else {
                const e = {};
                null === i ? i = [e] : i.push(e), p++;
            }
        var l = h === p;
        let d;
        if (p = s, null !== i && (s ? i.length = s : i = null), l) {
            const s = p;
            if (v(r, { instancePath: t + "/" + a, parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? v.errors : i.concat(v.errors), p = i.length), c = l = s === p, c)
                var m = !0;
            d = "then";
        }
        else {
            const s = p;
            if (be(r, { instancePath: t + "/" + a, parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }))
                var u = be.evaluated.props;
            else
                i = null === i ? be.errors : i.concat(be.errors), p = i.length;
            c = l = s === p, c && !0 !== m && void 0 !== u && (!0 === u ? m = !0 : (m = m || {}, Object.assign(m, u))), d = "else";
        }
        if (!c) {
            const e = { instancePath: t + "/" + a, schemaPath: "#/items/if", keyword: "if", params: { failingKeyword: d }, message: 'must match "' + d + '" schema' };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    let s, c = e.length;
    if (c > 1)
        e: for (; c--;)
            for (s = c; s--;)
                if (a(e[c], e[s])) {
                    const e = { instancePath: t, schemaPath: "#/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                    null === i ? i = [e] : i.push(e), p++;
                    break e;
                }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === i ? i = [e] : i.push(e), p++;
} return De.errors = i, 0 === p; }
ge.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ve.evaluated = { dynamicProps: !0, dynamicItems: !1 }, be.evaluated = { dynamicProps: !0, dynamicItems: !1 }, De.evaluated = { items: !0, dynamicProps: !1, dynamicItems: !1 };
const we = new RegExp("^([0-9]{3})$|^(default)$", "u"), Ae = { type: "object", description: "A deterministic version of a JSON Schema object.", patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } }, required: ["type"], properties: { format: { type: "string" }, title: { $ref: "http://json-schema.org/draft-04/schema#/properties/title" }, description: { $ref: "http://json-schema.org/draft-04/schema#/properties/description" }, default: { $ref: "http://json-schema.org/draft-04/schema#/properties/default" }, required: { $ref: "http://json-schema.org/draft-04/schema#/definitions/stringArray" }, type: { enum: ["file"] }, readOnly: { type: "boolean", default: !1 }, externalDocs: { $ref: "#/definitions/externalDocs" }, example: {} }, additionalProperties: !1 };
function ke(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = ke.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: a, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const s in e)
        if (!t.call(Ae.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.format && "string" != typeof e.format) {
        const e = { instancePath: a + "/format", schemaPath: "#/properties/format/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.title && (w(e.title, { instancePath: a + "/title", parentData: e, parentDataProperty: "title", rootData: o, dynamicAnchors: i }) || (c = null === c ? w.errors : c.concat(w.errors), l = c.length)), void 0 !== e.description && (A(e.description, { instancePath: a + "/description", parentData: e, parentDataProperty: "description", rootData: o, dynamicAnchors: i }) || (c = null === c ? A.errors : c.concat(A.errors), l = c.length)), void 0 !== e.default && (k(e.default, { instancePath: a + "/default", parentData: e, parentDataProperty: "default", rootData: o, dynamicAnchors: i }) || (c = null === c ? k.errors : c.concat(k.errors), l = c.length)), void 0 !== e.required && (z(e.required, { instancePath: a + "/required", parentData: e, parentDataProperty: "required", rootData: o, dynamicAnchors: i }) || (c = null === c ? z.errors : c.concat(z.errors), l = c.length)), void 0 !== e.type && "file" !== e.type) {
        const e = { instancePath: a + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: Ae.properties.type.enum }, message: "must be equal to one of the allowed values" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.readOnly && "boolean" != typeof e.readOnly) {
        const e = { instancePath: a + "/readOnly", schemaPath: "#/properties/readOnly/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === c ? c = [e] : c.push(e), l++;
    }
    void 0 !== e.externalDocs && (g(e.externalDocs, { instancePath: a + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: o, dynamicAnchors: i }) || (c = null === c ? g.errors : c.concat(g.errors), l = c.length));
    for (const t in e)
        r.test(t) && (p(e[t], { instancePath: a + "/" + t.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: t, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: a, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return ke.errors = c, 0 === l; }
ke.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const $e = { type: "object", additionalProperties: !1, required: ["type"], properties: { type: { type: "string", enum: ["string", "number", "integer", "boolean", "array"] }, format: { type: "string" }, items: { $ref: "#/definitions/primitivesItems" }, collectionFormat: { $ref: "#/definitions/collectionFormat" }, default: { $ref: "#/definitions/default" }, maximum: { $ref: "#/definitions/maximum" }, exclusiveMaximum: { $ref: "#/definitions/exclusiveMaximum" }, minimum: { $ref: "#/definitions/minimum" }, exclusiveMinimum: { $ref: "#/definitions/exclusiveMinimum" }, maxLength: { $ref: "#/definitions/maxLength" }, minLength: { $ref: "#/definitions/minLength" }, pattern: { $ref: "#/definitions/pattern" }, maxItems: { $ref: "#/definitions/maxItems" }, minItems: { $ref: "#/definitions/minItems" }, uniqueItems: { $ref: "#/definitions/uniqueItems" }, enum: { $ref: "#/definitions/enum" }, multipleOf: { $ref: "#/definitions/multipleOf" }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } };
function je(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = je.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: a, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const s in e)
        if (!t.call($e.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.type) {
        let t = e.type;
        if ("string" != typeof t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
        if ("string" !== t && "number" !== t && "integer" !== t && "boolean" !== t && "array" !== t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: $e.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.format && "string" != typeof e.format) {
        const e = { instancePath: a + "/format", schemaPath: "#/properties/format/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.items && (ce(e.items, { instancePath: a + "/items", parentData: e, parentDataProperty: "items", rootData: o, dynamicAnchors: i }) || (c = null === c ? ce.errors : c.concat(ce.errors), l = c.length)), void 0 !== e.collectionFormat && (G(e.collectionFormat, { instancePath: a + "/collectionFormat", parentData: e, parentDataProperty: "collectionFormat", rootData: o, dynamicAnchors: i }) || (c = null === c ? G.errors : c.concat(G.errors), l = c.length)), void 0 !== e.default && (J(e.default, { instancePath: a + "/default", parentData: e, parentDataProperty: "default", rootData: o, dynamicAnchors: i }) || (c = null === c ? J.errors : c.concat(J.errors), l = c.length)), void 0 !== e.maximum && (W(e.maximum, { instancePath: a + "/maximum", parentData: e, parentDataProperty: "maximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? W.errors : c.concat(W.errors), l = c.length)), void 0 !== e.exclusiveMaximum && (Y(e.exclusiveMaximum, { instancePath: a + "/exclusiveMaximum", parentData: e, parentDataProperty: "exclusiveMaximum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Y.errors : c.concat(Y.errors), l = c.length)), void 0 !== e.minimum && (Q(e.minimum, { instancePath: a + "/minimum", parentData: e, parentDataProperty: "minimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? Q.errors : c.concat(Q.errors), l = c.length)), void 0 !== e.exclusiveMinimum && (ee(e.exclusiveMinimum, { instancePath: a + "/exclusiveMinimum", parentData: e, parentDataProperty: "exclusiveMinimum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ee.errors : c.concat(ee.errors), l = c.length)), void 0 !== e.maxLength && (te(e.maxLength, { instancePath: a + "/maxLength", parentData: e, parentDataProperty: "maxLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? te.errors : c.concat(te.errors), l = c.length)), void 0 !== e.minLength && (ae(e.minLength, { instancePath: a + "/minLength", parentData: e, parentDataProperty: "minLength", rootData: o, dynamicAnchors: i }) || (c = null === c ? ae.errors : c.concat(ae.errors), l = c.length)), void 0 !== e.pattern && (re(e.pattern, { instancePath: a + "/pattern", parentData: e, parentDataProperty: "pattern", rootData: o, dynamicAnchors: i }) || (c = null === c ? re.errors : c.concat(re.errors), l = c.length)), void 0 !== e.maxItems && (se(e.maxItems, { instancePath: a + "/maxItems", parentData: e, parentDataProperty: "maxItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? se.errors : c.concat(se.errors), l = c.length)), void 0 !== e.minItems && (ne(e.minItems, { instancePath: a + "/minItems", parentData: e, parentDataProperty: "minItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? ne.errors : c.concat(ne.errors), l = c.length)), void 0 !== e.uniqueItems && (oe(e.uniqueItems, { instancePath: a + "/uniqueItems", parentData: e, parentDataProperty: "uniqueItems", rootData: o, dynamicAnchors: i }) || (c = null === c ? oe.errors : c.concat(oe.errors), l = c.length)), void 0 !== e.enum && (ie(e.enum, { instancePath: a + "/enum", parentData: e, parentDataProperty: "enum", rootData: o, dynamicAnchors: i }) || (c = null === c ? ie.errors : c.concat(ie.errors), l = c.length)), void 0 !== e.multipleOf && (pe(e.multipleOf, { instancePath: a + "/multipleOf", parentData: e, parentDataProperty: "multipleOf", rootData: o, dynamicAnchors: i }) || (c = null === c ? pe.errors : c.concat(pe.errors), l = c.length)), void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: a + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const t in e)
        r.test(t) && (p(e[t], { instancePath: a + "/" + t.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: t, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: a, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return je.errors = c, 0 === l; }
function qe(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = qe.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e)
        je(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? je.errors : o.concat(je.errors), i = o.length);
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return qe.errors = o, 0 === i; }
function Ie(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ie.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    ;
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Ie.errors = o, 0 === i; }
function xe(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, c = 0; const l = xe.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.description) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "description" }, message: "must have required property 'description'" };
        null === i ? i = [e] : i.push(e), c++;
    }
    for (const a in e)
        if ("description" !== a && "schema" !== a && "headers" !== a && "examples" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), c++;
        }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.schema) {
        let a = e.schema;
        const r = c;
        let s = !1, p = null;
        const l = c;
        if (F(a, { instancePath: t + "/schema", parentData: e, parentDataProperty: "schema", rootData: n, dynamicAnchors: o }) || (i = null === i ? F.errors : i.concat(F.errors), c = i.length), l === c) {
            s = !0, p = 0;
            var m = !0;
        }
        const h = c;
        var u;
        if (ke(a, { instancePath: t + "/schema", parentData: e, parentDataProperty: "schema", rootData: n, dynamicAnchors: o }) || (i = null === i ? ke.errors : i.concat(ke.errors), c = i.length), (u = h === c) && s ? (s = !1, p = [p, 1]) : u && (s = !0, p = 1, !0 !== m && (m = !0)), s)
            c = r, null !== i && (r ? i.length = r : i = null);
        else {
            const e = { instancePath: t + "/schema", schemaPath: "#/properties/schema/oneOf", keyword: "oneOf", params: { passingSchemas: p }, message: "must match exactly one schema in oneOf" };
            null === i ? i = [e] : i.push(e), c++;
        }
    }
    void 0 !== e.headers && (qe(e.headers, { instancePath: t + "/headers", parentData: e, parentDataProperty: "headers", rootData: n, dynamicAnchors: o }) || (i = null === i ? qe.errors : i.concat(qe.errors), c = i.length)), void 0 !== e.examples && (Ie(e.examples, { instancePath: t + "/examples", parentData: e, parentDataProperty: "examples", rootData: n, dynamicAnchors: o }) || (i = null === i ? Ie.errors : i.concat(Ie.errors), c = i.length));
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? p.errors : i.concat(p.errors), c = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), c++;
} return xe.errors = i, 0 === c; }
function Oe(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Oe.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.$ref && (t = "$ref")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (v(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? v.errors : o.concat(v.errors), i = o.length), l = u = p === i, l)
        var d = !0;
    h = "then";
}
else {
    const p = i;
    xe(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? xe.errors : o.concat(xe.errors), i = o.length), l = u = p === i, l && !0 !== d && (d = !0), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Oe.errors = o, p.props = d, 0 === i; }
function Ne(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, c = 0; const l = Ne.evaluated; l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0); const m = c, u = c; if (c === u)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        const a = c;
        for (const t in e)
            if (!r.test(t)) {
                const e = {};
                null === i ? i = [e] : i.push(e), c++;
                break;
            }
        if (a === c)
            for (const a in e)
                if (r.test(a)) {
                    const r = c;
                    if (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? p.errors : i.concat(p.errors), c = i.length), r !== c)
                        break;
                }
    }
    else {
        const e = {};
        null === i ? i = [e] : i.push(e), c++;
    } if (u === c) {
    const e = { instancePath: t, schemaPath: "#/not", keyword: "not", params: {}, message: "must NOT be valid" };
    null === i ? i = [e] : i.push(e), c++;
}
else
    c = m, null !== i && (m ? i.length = m : i = null); if (e && "object" == typeof e && !Array.isArray(e)) {
    if (Object.keys(e).length < 1) {
        const e = { instancePath: t, schemaPath: "#/minProperties", keyword: "minProperties", params: { limit: 1 }, message: "must NOT have fewer than 1 properties" };
        null === i ? i = [e] : i.push(e), c++;
    }
    for (const a in e)
        if (!we.test(a) && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), c++;
        }
    for (const a in e)
        we.test(a) && (Oe(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Oe.errors : i.concat(Oe.errors), c = i.length));
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? p.errors : i.concat(p.errors), c = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), c++;
} return Ne.errors = i, 0 === c; }
function Ue(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ue.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e) {
        let r = e[a];
        if (Array.isArray(r)) {
            const e = r.length;
            for (let s = 0; s < e; s++)
                if ("string" != typeof r[s]) {
                    const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1") + "/" + s, schemaPath: "#/additionalProperties/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === o ? o = [e] : o.push(e), i++;
                }
            let s, n = r.length;
            if (n > 1) {
                const e = {};
                for (; n--;) {
                    let p = r[n];
                    if ("string" == typeof p) {
                        if ("number" == typeof e[p]) {
                            s = e[p];
                            const r = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/additionalProperties/uniqueItems", keyword: "uniqueItems", params: { i: n, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + n + " are identical)" };
                            null === o ? o = [r] : o.push(r), i++;
                            break;
                        }
                        e[p] = n;
                    }
                }
            }
        }
        else {
            const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/additionalProperties/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Ue.errors = o, 0 === i; }
function Te(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Te.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), Array.isArray(e)) {
    const r = e.length;
    for (let a = 0; a < r; a++)
        Ue(e[a], { instancePath: t + "/" + a, parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ue.errors : i.concat(Ue.errors), p = i.length);
    let s, c = e.length;
    if (c > 1)
        e: for (; c--;)
            for (s = c; s--;)
                if (a(e[c], e[s])) {
                    const e = { instancePath: t, schemaPath: "#/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                    null === i ? i = [e] : i.push(e), p++;
                    break e;
                }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === i ? i = [e] : i.push(e), p++;
} return Te.errors = i, 0 === p; }
function Me(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = Me.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.responses) {
        const e = { instancePath: a, schemaPath: "#/required", keyword: "required", params: { missingProperty: "responses" }, message: "must have required property 'responses'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const s in e)
        if (!t.call(P.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.tags) {
        let t = e.tags;
        if (Array.isArray(t)) {
            const e = t.length;
            for (let r = 0; r < e; r++)
                if ("string" != typeof t[r]) {
                    const e = { instancePath: a + "/tags/" + r, schemaPath: "#/properties/tags/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === c ? c = [e] : c.push(e), l++;
                }
            let r, s = t.length;
            if (s > 1) {
                const e = {};
                for (; s--;) {
                    let n = t[s];
                    if ("string" == typeof n) {
                        if ("number" == typeof e[n]) {
                            r = e[n];
                            const t = { instancePath: a + "/tags", schemaPath: "#/properties/tags/uniqueItems", keyword: "uniqueItems", params: { i: s, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + s + " are identical)" };
                            null === c ? c = [t] : c.push(t), l++;
                            break;
                        }
                        e[n] = s;
                    }
                }
            }
        }
        else {
            const e = { instancePath: a + "/tags", schemaPath: "#/properties/tags/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: a + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: a + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.externalDocs && (g(e.externalDocs, { instancePath: a + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: o, dynamicAnchors: i }) || (c = null === c ? g.errors : c.concat(g.errors), l = c.length)), void 0 !== e.operationId && "string" != typeof e.operationId) {
        const e = { instancePath: a + "/operationId", schemaPath: "#/properties/operationId/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.produces && (y(e.produces, { instancePath: a + "/produces", parentData: e, parentDataProperty: "produces", rootData: o, dynamicAnchors: i }) || (c = null === c ? y.errors : c.concat(y.errors), l = c.length)), void 0 !== e.consumes && (y(e.consumes, { instancePath: a + "/consumes", parentData: e, parentDataProperty: "consumes", rootData: o, dynamicAnchors: i }) || (c = null === c ? y.errors : c.concat(y.errors), l = c.length)), void 0 !== e.parameters && (De(e.parameters, { instancePath: a + "/parameters", parentData: e, parentDataProperty: "parameters", rootData: o, dynamicAnchors: i }) || (c = null === c ? De.errors : c.concat(De.errors), l = c.length)), void 0 !== e.responses && (Ne(e.responses, { instancePath: a + "/responses", parentData: e, parentDataProperty: "responses", rootData: o, dynamicAnchors: i }) || (c = null === c ? Ne.errors : c.concat(Ne.errors), l = c.length)), void 0 !== e.schemes && (h(e.schemes, { instancePath: a + "/schemes", parentData: e, parentDataProperty: "schemes", rootData: o, dynamicAnchors: i }) || (c = null === c ? h.errors : c.concat(h.errors), l = c.length)), void 0 !== e.deprecated && "boolean" != typeof e.deprecated) {
        const e = { instancePath: a + "/deprecated", schemaPath: "#/properties/deprecated/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === c ? c = [e] : c.push(e), l++;
    }
    void 0 !== e.security && (Te(e.security, { instancePath: a + "/security", parentData: e, parentDataProperty: "security", rootData: o, dynamicAnchors: i }) || (c = null === c ? Te.errors : c.concat(Te.errors), l = c.length));
    for (const t in e)
        r.test(t) && (p(e[t], { instancePath: a + "/" + t.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: t, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: a, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return Me.errors = c, 0 === l; }
function Se(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = Se.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const s in e)
        if (!t.call(f.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.$ref && "string" != typeof e.$ref) {
        const e = { instancePath: a + "/$ref", schemaPath: "#/properties/%24ref/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    void 0 !== e.get && (Me(e.get, { instancePath: a + "/get", parentData: e, parentDataProperty: "get", rootData: o, dynamicAnchors: i }) || (c = null === c ? Me.errors : c.concat(Me.errors), l = c.length)), void 0 !== e.put && (Me(e.put, { instancePath: a + "/put", parentData: e, parentDataProperty: "put", rootData: o, dynamicAnchors: i }) || (c = null === c ? Me.errors : c.concat(Me.errors), l = c.length)), void 0 !== e.post && (Me(e.post, { instancePath: a + "/post", parentData: e, parentDataProperty: "post", rootData: o, dynamicAnchors: i }) || (c = null === c ? Me.errors : c.concat(Me.errors), l = c.length)), void 0 !== e.delete && (Me(e.delete, { instancePath: a + "/delete", parentData: e, parentDataProperty: "delete", rootData: o, dynamicAnchors: i }) || (c = null === c ? Me.errors : c.concat(Me.errors), l = c.length)), void 0 !== e.options && (Me(e.options, { instancePath: a + "/options", parentData: e, parentDataProperty: "options", rootData: o, dynamicAnchors: i }) || (c = null === c ? Me.errors : c.concat(Me.errors), l = c.length)), void 0 !== e.head && (Me(e.head, { instancePath: a + "/head", parentData: e, parentDataProperty: "head", rootData: o, dynamicAnchors: i }) || (c = null === c ? Me.errors : c.concat(Me.errors), l = c.length)), void 0 !== e.patch && (Me(e.patch, { instancePath: a + "/patch", parentData: e, parentDataProperty: "patch", rootData: o, dynamicAnchors: i }) || (c = null === c ? Me.errors : c.concat(Me.errors), l = c.length)), void 0 !== e.parameters && (De(e.parameters, { instancePath: a + "/parameters", parentData: e, parentDataProperty: "parameters", rootData: o, dynamicAnchors: i }) || (c = null === c ? De.errors : c.concat(De.errors), l = c.length));
    for (const t in e)
        r.test(t) && (p(e[t], { instancePath: a + "/" + t.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: t, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: a, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return Se.errors = c, 0 === l; }
function ze(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: o = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = ze.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if (!r.test(a) && !n.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: o, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
    for (const a in e)
        n.test(a) && (Se(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: o, dynamicAnchors: i }) || (c = null === c ? Se.errors : c.concat(Se.errors), l = c.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return ze.errors = c, 0 === l; }
function Le(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Le.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e)
        F(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? F.errors : o.concat(F.errors), i = o.length);
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Le.errors = o, 0 === i; }
function Re(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Re.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e)
        be(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? be.errors : o.concat(be.errors), i = o.length);
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Re.errors = o, 0 === i; }
function Ce(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ce.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e)
        xe(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? xe.errors : o.concat(xe.errors), i = o.length);
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Ce.errors = o, 0 === i; }
je.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, qe.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ie.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, xe.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Oe.evaluated = { dynamicProps: !0, dynamicItems: !1 }, Ne.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ue.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Te.evaluated = { items: !0, dynamicProps: !1, dynamicItems: !1 }, Me.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Se.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ze.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Le.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Re.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ce.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Ee = { type: "object", additionalProperties: { oneOf: [{ $ref: "#/definitions/basicAuthenticationSecurity" }, { $ref: "#/definitions/apiKeySecurity" }, { $ref: "#/definitions/oauth2ImplicitSecurity" }, { $ref: "#/definitions/oauth2PasswordSecurity" }, { $ref: "#/definitions/oauth2ApplicationSecurity" }, { $ref: "#/definitions/oauth2AccessCodeSecurity" }] }, errorMessage: { properties: { basic: "Invalid basic authentication security definition", apiKey: "Invalid apiKey authentication security definition", oauth2: "Invalid oauth2 authentication security definition" }, _: "Invalid security securityDefinitions" } }, Ve = { type: "object", additionalProperties: !1, required: ["type"], properties: { type: { enum: ["basic"] }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } };
function Ke(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, c = 0; const l = Ke.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === i ? i = [e] : i.push(e), c++;
    }
    for (const a in e)
        if ("type" !== a && "description" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), c++;
        }
    if (void 0 !== e.type && "basic" !== e.type) {
        const e = { instancePath: t + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: Ve.properties.type.enum }, message: "must be equal to one of the allowed values" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? p.errors : i.concat(p.errors), c = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), c++;
} return Ke.errors = i, 0 === c; }
Ke.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Fe = { type: "object", additionalProperties: !1, required: ["type", "name", "in"], properties: { type: { enum: ["apiKey"] }, name: { type: "string" }, in: { enum: ["header", "query"] }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } };
function Be(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, c = 0; const l = Be.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 === e.in) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "in" }, message: "must have required property 'in'" };
        null === i ? i = [e] : i.push(e), c++;
    }
    for (const a in e)
        if ("type" !== a && "name" !== a && "in" !== a && "description" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), c++;
        }
    if (void 0 !== e.type && "apiKey" !== e.type) {
        const e = { instancePath: t + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: Fe.properties.type.enum }, message: "must be equal to one of the allowed values" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.in) {
        let a = e.in;
        if ("header" !== a && "query" !== a) {
            const e = { instancePath: t + "/in", schemaPath: "#/properties/in/enum", keyword: "enum", params: { allowedValues: Fe.properties.in.enum }, message: "must be equal to one of the allowed values" };
            null === i ? i = [e] : i.push(e), c++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? p.errors : i.concat(p.errors), c = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), c++;
} return Be.errors = i, 0 === c; }
Be.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const _e = { type: "object", additionalProperties: !1, required: ["type", "flow", "authorizationUrl", "scopes"], properties: { type: { enum: ["oauth2"] }, flow: { enum: ["implicit"] }, scopes: { $ref: "#/definitions/oauth2Scopes" }, authorizationUrl: { type: "string", format: "uri" }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } };
function Ze(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ze.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("string" != typeof e[a]) {
            const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/additionalProperties/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Ze.errors = o, 0 === i; }
function He(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = He.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.flow) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "flow" }, message: "must have required property 'flow'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.authorizationUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "authorizationUrl" }, message: "must have required property 'authorizationUrl'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const a in e)
        if ("type" !== a && "flow" !== a && "scopes" !== a && "authorizationUrl" !== a && "description" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.type && "oauth2" !== e.type) {
        const e = { instancePath: t + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: _e.properties.type.enum }, message: "must be equal to one of the allowed values" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.flow && "implicit" !== e.flow) {
        const e = { instancePath: t + "/flow", schemaPath: "#/properties/flow/enum", keyword: "enum", params: { allowedValues: _e.properties.flow.enum }, message: "must be equal to one of the allowed values" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.scopes && (Ze(e.scopes, { instancePath: t + "/scopes", parentData: e, parentDataProperty: "scopes", rootData: n, dynamicAnchors: i }) || (c = null === c ? Ze.errors : c.concat(Ze.errors), l = c.length)), void 0 !== e.authorizationUrl) {
        let a = e.authorizationUrl;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === c ? c = [e] : c.push(e), l++;
            }
        }
        else {
            const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return He.errors = c, 0 === l; }
Ze.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, He.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Xe = { type: "object", additionalProperties: !1, required: ["type", "flow", "tokenUrl", "scopes"], properties: { type: { enum: ["oauth2"] }, flow: { enum: ["password"] }, scopes: { $ref: "#/definitions/oauth2Scopes" }, tokenUrl: { type: "string", format: "uri" }, description: { type: "string" } }, patternProperties: { "^x-": { $ref: "#/definitions/vendorExtension" } } };
function Ge(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = Ge.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.flow) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "flow" }, message: "must have required property 'flow'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.tokenUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "tokenUrl" }, message: "must have required property 'tokenUrl'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const a in e)
        if ("type" !== a && "flow" !== a && "scopes" !== a && "tokenUrl" !== a && "description" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.type && "oauth2" !== e.type) {
        const e = { instancePath: t + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: Xe.properties.type.enum }, message: "must be equal to one of the allowed values" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.flow && "password" !== e.flow) {
        const e = { instancePath: t + "/flow", schemaPath: "#/properties/flow/enum", keyword: "enum", params: { allowedValues: Xe.properties.flow.enum }, message: "must be equal to one of the allowed values" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.scopes && (Ze(e.scopes, { instancePath: t + "/scopes", parentData: e, parentDataProperty: "scopes", rootData: n, dynamicAnchors: i }) || (c = null === c ? Ze.errors : c.concat(Ze.errors), l = c.length)), void 0 !== e.tokenUrl) {
        let a = e.tokenUrl;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === c ? c = [e] : c.push(e), l++;
            }
        }
        else {
            const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return Ge.errors = c, 0 === l; }
function Je(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = Je.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.flow) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "flow" }, message: "must have required property 'flow'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.tokenUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "tokenUrl" }, message: "must have required property 'tokenUrl'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const a in e)
        if ("type" !== a && "flow" !== a && "scopes" !== a && "tokenUrl" !== a && "description" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.type && "oauth2" !== e.type) {
        const e = { instancePath: t + "/type", schemaPath: "#/properties/type/const", keyword: "const", params: { allowedValue: "oauth2" }, message: "must be equal to constant" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.flow && "application" !== e.flow) {
        const e = { instancePath: t + "/flow", schemaPath: "#/properties/flow/const", keyword: "const", params: { allowedValue: "application" }, message: "must be equal to constant" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.scopes && (Ze(e.scopes, { instancePath: t + "/scopes", parentData: e, parentDataProperty: "scopes", rootData: n, dynamicAnchors: i }) || (c = null === c ? Ze.errors : c.concat(Ze.errors), l = c.length)), void 0 !== e.tokenUrl) {
        let a = e.tokenUrl;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === c ? c = [e] : c.push(e), l++;
            }
        }
        else {
            const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return Je.errors = c, 0 === l; }
function We(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: i = {} } = {}) { let c = null, l = 0; const m = We.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.flow) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "flow" }, message: "must have required property 'flow'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.authorizationUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "authorizationUrl" }, message: "must have required property 'authorizationUrl'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.tokenUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "tokenUrl" }, message: "must have required property 'tokenUrl'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const a in e)
        if ("type" !== a && "flow" !== a && "scopes" !== a && "authorizationUrl" !== a && "tokenUrl" !== a && "description" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.type && "oauth2" !== e.type) {
        const e = { instancePath: t + "/type", schemaPath: "#/properties/type/const", keyword: "const", params: { allowedValue: "oauth2" }, message: "must be equal to constant" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.flow && "accessCode" !== e.flow) {
        const e = { instancePath: t + "/flow", schemaPath: "#/properties/flow/const", keyword: "const", params: { allowedValue: "accessCode" }, message: "must be equal to constant" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.scopes && (Ze(e.scopes, { instancePath: t + "/scopes", parentData: e, parentDataProperty: "scopes", rootData: n, dynamicAnchors: i }) || (c = null === c ? Ze.errors : c.concat(Ze.errors), l = c.length)), void 0 !== e.authorizationUrl) {
        let a = e.authorizationUrl;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === c ? c = [e] : c.push(e), l++;
            }
        }
        else {
            const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.tokenUrl) {
        let a = e.tokenUrl;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === c ? c = [e] : c.push(e), l++;
            }
        }
        else {
            const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: i }) || (c = null === c ? p.errors : c.concat(p.errors), l = c.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return We.errors = c, 0 === l; }
Ge.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Je.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, We.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Ye = new RegExp("^/([^/]*)(?:/|$)");
function Qe(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Qe.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e) {
        let r = e[a];
        const p = i;
        let m = !1, u = null;
        const h = i;
        if (Ke(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ke.errors : o.concat(Ke.errors), i = o.length), l = h === i) {
            m = !0, u = 0;
            var c = !0;
        }
        const d = i;
        if (Be(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? Be.errors : o.concat(Be.errors), i = o.length), (l = d === i) && m)
            m = !1, u = [u, 1];
        else {
            l && (m = !0, u = 1, !0 !== c && (c = !0));
            const p = i;
            if (He(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? He.errors : o.concat(He.errors), i = o.length), (l = p === i) && m)
                m = !1, u = [u, 2];
            else {
                l && (m = !0, u = 2, !0 !== c && (c = !0));
                const p = i;
                if (Ge(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ge.errors : o.concat(Ge.errors), i = o.length), (l = p === i) && m)
                    m = !1, u = [u, 3];
                else {
                    l && (m = !0, u = 3, !0 !== c && (c = !0));
                    const p = i;
                    if (Je(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? Je.errors : o.concat(Je.errors), i = o.length), (l = p === i) && m)
                        m = !1, u = [u, 4];
                    else {
                        l && (m = !0, u = 4, !0 !== c && (c = !0));
                        const p = i;
                        var l;
                        We(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? We.errors : o.concat(We.errors), i = o.length), (l = p === i) && m ? (m = !1, u = [u, 5]) : l && (m = !0, u = 5, !0 !== c && (c = !0));
                    }
                }
            }
        }
        if (m)
            i = p, null !== o && (p ? o.length = p : o = null);
        else {
            const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/additionalProperties/oneOf", keyword: "oneOf", params: { passingSchemas: u }, message: "must match exactly one schema in oneOf" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} if (i > 0) {
    const a = { _: [] }, r = {};
    for (const e of o)
        "errorMessage" !== e.keyword && !e.emUsed && e.instancePath === t && e.keyword in a && 0 === e.schemaPath.indexOf("#") && /^\/[^\/]*$/.test(e.schemaPath.slice(1)) && (a[e.keyword].push(e), e.emUsed = !0);
    for (const e in a)
        if (a[e].length) {
            const s = { instancePath: t, schemaPath: "#/errorMessage", keyword: "errorMessage", params: { errors: a[e] }, message: e in r ? r[e]() : Ee.errorMessage[e] };
            null === o ? o = [s] : o.push(s), i++;
        }
    let s, n;
    if ("object" == typeof e && !Array.isArray(e)) {
        s = { basic: [], apiKey: [], oauth2: [] }, n = {};
        for (const e of o)
            if ("errorMessage" !== e.keyword && !e.emUsed && 0 === e.instancePath.indexOf(t)) {
                const a = Ye.exec(e.instancePath.slice(t.length)), r = a && a[1].replace(/~1/g, "/").replace(/~0/g, "~");
                void 0 !== r && r in s && (s[r].push(e), e.emUsed = !0);
            }
        for (const e in s)
            if (s[e].length) {
                const a = { instancePath: t, schemaPath: "#/errorMessage", keyword: "errorMessage", params: { errors: s[e] }, message: e in n ? n[e]() : Ee.errorMessage.properties[e] };
                null === o ? o = [a] : o.push(a), i++, o[i - 1].instancePath = t + "/" + e.replace(/~/g, "~0").replace(/\//g, "~1");
            }
    }
    const p = [];
    for (const e of o)
        "errorMessage" === e.keyword || e.emUsed || e.instancePath !== t && (0 !== e.instancePath.indexOf(t) || "/" !== e.instancePath[t.length]) || 0 !== e.schemaPath.indexOf("#") || "/" !== e.schemaPath[1] || (p.push(e), e.emUsed = !0);
    if (p.length) {
        const e = { instancePath: t, schemaPath: "#/errorMessage", keyword: "errorMessage", params: { errors: p }, message: "Invalid security securityDefinitions" };
        null === o ? o = [e] : o.push(e), i++;
    }
    const c = [];
    for (const e of o)
        e.emUsed || c.push(e);
    o = c, i = c.length;
} return Qe.errors = o, 0 === i; }
function et(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, c = 0; const l = et.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === i ? i = [e] : i.push(e), c++;
    }
    for (const a in e)
        if ("name" !== a && "description" !== a && "externalDocs" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), c++;
        }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), c++;
    }
    void 0 !== e.externalDocs && (g(e.externalDocs, { instancePath: t + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: n, dynamicAnchors: o }) || (i = null === i ? g.errors : i.concat(g.errors), c = i.length));
    for (const a in e)
        r.test(a) && (p(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? p.errors : i.concat(p.errors), c = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), c++;
} return et.errors = i, 0 === c; }
function tt(o, { instancePath: i = "", parentData: c, parentDataProperty: l, rootData: u = o, dynamicAnchors: d = {} } = {}) { let f = null, P = 0; const v = tt.evaluated; if (v.dynamicProps && (v.props = void 0), v.dynamicItems && (v.items = void 0), o && "object" == typeof o && !Array.isArray(o)) {
    if (void 0 === o.swagger) {
        const e = { instancePath: i, schemaPath: "#/required", keyword: "required", params: { missingProperty: "swagger" }, message: "must have required property 'swagger'" };
        null === f ? f = [e] : f.push(e), P++;
    }
    if (void 0 === o.info) {
        const e = { instancePath: i, schemaPath: "#/required", keyword: "required", params: { missingProperty: "info" }, message: "must have required property 'info'" };
        null === f ? f = [e] : f.push(e), P++;
    }
    if (void 0 === o.paths) {
        const e = { instancePath: i, schemaPath: "#/required", keyword: "required", params: { missingProperty: "paths" }, message: "must have required property 'paths'" };
        null === f ? f = [e] : f.push(e), P++;
    }
    for (const a in o)
        if (!t.call(e.properties, a) && !r.test(a)) {
            const e = { instancePath: i, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === f ? f = [e] : f.push(e), P++;
        }
    if (void 0 !== o.swagger) {
        let t = o.swagger;
        if ("string" != typeof t) {
            const e = { instancePath: i + "/swagger", schemaPath: "#/properties/swagger/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === f ? f = [e] : f.push(e), P++;
        }
        if ("2.0" !== t) {
            const t = { instancePath: i + "/swagger", schemaPath: "#/properties/swagger/enum", keyword: "enum", params: { allowedValues: e.properties.swagger.enum }, message: "must be equal to one of the allowed values" };
            null === f ? f = [t] : f.push(t), P++;
        }
    }
    if (void 0 !== o.info && (m(o.info, { instancePath: i + "/info", parentData: o, parentDataProperty: "info", rootData: u, dynamicAnchors: d }) || (f = null === f ? m.errors : f.concat(m.errors), P = f.length)), void 0 !== o.host) {
        let e = o.host;
        if ("string" == typeof e) {
            if (!s.test(e)) {
                const e = { instancePath: i + "/host", schemaPath: "#/properties/host/pattern", keyword: "pattern", params: { pattern: "^[^{}/ :\\\\]+(?::\\d+)?$" }, message: 'must match pattern "^[^{}/ :\\\\]+(?::\\d+)?$"' };
                null === f ? f = [e] : f.push(e), P++;
            }
        }
        else {
            const e = { instancePath: i + "/host", schemaPath: "#/properties/host/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === f ? f = [e] : f.push(e), P++;
        }
    }
    if (void 0 !== o.basePath) {
        let e = o.basePath;
        if ("string" == typeof e) {
            if (!n.test(e)) {
                const e = { instancePath: i + "/basePath", schemaPath: "#/properties/basePath/pattern", keyword: "pattern", params: { pattern: "^/" }, message: 'must match pattern "^/"' };
                null === f ? f = [e] : f.push(e), P++;
            }
        }
        else {
            const e = { instancePath: i + "/basePath", schemaPath: "#/properties/basePath/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === f ? f = [e] : f.push(e), P++;
        }
    }
    if (void 0 !== o.schemes && (h(o.schemes, { instancePath: i + "/schemes", parentData: o, parentDataProperty: "schemes", rootData: u, dynamicAnchors: d }) || (f = null === f ? h.errors : f.concat(h.errors), P = f.length)), void 0 !== o.consumes && (y(o.consumes, { instancePath: i + "/consumes", parentData: o, parentDataProperty: "consumes", rootData: u, dynamicAnchors: d }) || (f = null === f ? y.errors : f.concat(y.errors), P = f.length)), void 0 !== o.produces && (y(o.produces, { instancePath: i + "/produces", parentData: o, parentDataProperty: "produces", rootData: u, dynamicAnchors: d }) || (f = null === f ? y.errors : f.concat(y.errors), P = f.length)), void 0 !== o.paths && (ze(o.paths, { instancePath: i + "/paths", parentData: o, parentDataProperty: "paths", rootData: u, dynamicAnchors: d }) || (f = null === f ? ze.errors : f.concat(ze.errors), P = f.length)), void 0 !== o.definitions && (Le(o.definitions, { instancePath: i + "/definitions", parentData: o, parentDataProperty: "definitions", rootData: u, dynamicAnchors: d }) || (f = null === f ? Le.errors : f.concat(Le.errors), P = f.length)), void 0 !== o.parameters && (Re(o.parameters, { instancePath: i + "/parameters", parentData: o, parentDataProperty: "parameters", rootData: u, dynamicAnchors: d }) || (f = null === f ? Re.errors : f.concat(Re.errors), P = f.length)), void 0 !== o.responses && (Ce(o.responses, { instancePath: i + "/responses", parentData: o, parentDataProperty: "responses", rootData: u, dynamicAnchors: d }) || (f = null === f ? Ce.errors : f.concat(Ce.errors), P = f.length)), void 0 !== o.security && (Te(o.security, { instancePath: i + "/security", parentData: o, parentDataProperty: "security", rootData: u, dynamicAnchors: d }) || (f = null === f ? Te.errors : f.concat(Te.errors), P = f.length)), void 0 !== o.securityDefinitions && (Qe(o.securityDefinitions, { instancePath: i + "/securityDefinitions", parentData: o, parentDataProperty: "securityDefinitions", rootData: u, dynamicAnchors: d }) || (f = null === f ? Qe.errors : f.concat(Qe.errors), P = f.length)), void 0 !== o.tags) {
        let e = o.tags;
        if (Array.isArray(e)) {
            const t = e.length;
            for (let a = 0; a < t; a++)
                et(e[a], { instancePath: i + "/tags/" + a, parentData: e, parentDataProperty: a, rootData: u, dynamicAnchors: d }) || (f = null === f ? et.errors : f.concat(et.errors), P = f.length);
            let r, s = e.length;
            if (s > 1)
                e: for (; s--;)
                    for (r = s; r--;)
                        if (a(e[s], e[r])) {
                            const e = { instancePath: i + "/tags", schemaPath: "#/properties/tags/uniqueItems", keyword: "uniqueItems", params: { i: s, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + s + " are identical)" };
                            null === f ? f = [e] : f.push(e), P++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: i + "/tags", schemaPath: "#/properties/tags/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === f ? f = [e] : f.push(e), P++;
        }
    }
    void 0 !== o.externalDocs && (g(o.externalDocs, { instancePath: i + "/externalDocs", parentData: o, parentDataProperty: "externalDocs", rootData: u, dynamicAnchors: d }) || (f = null === f ? g.errors : f.concat(g.errors), P = f.length));
    for (const e in o)
        r.test(e) && (p(o[e], { instancePath: i + "/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: o, parentDataProperty: e, rootData: u, dynamicAnchors: d }) || (f = null === f ? p.errors : f.concat(p.errors), P = f.length));
}
else {
    const e = { instancePath: i, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === f ? f = [e] : f.push(e), P++;
} return tt.errors = f, 0 === P; }
Qe.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, et.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, tt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
exports.oas3_0 = oa;
const at = new RegExp("^3\\.0\\.\\d(-.+)?$", "u"), rt = /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
function st(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let p = null, c = 0; const l = st.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("name" !== a && "url" !== a && "email" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === p ? p = [e] : p.push(e), c++;
        }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === p ? p = [e] : p.push(e), c++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.email) {
        let a = e.email;
        if ("string" == typeof a) {
            if (!i.test(a)) {
                const e = { instancePath: t + "/email", schemaPath: "#/properties/email/format", keyword: "format", params: { format: "email" }, message: 'must match format "email"' };
                null === p ? p = [e] : p.push(e), c++;
            }
        }
        else {
            const e = { instancePath: t + "/email", schemaPath: "#/properties/email/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === p ? p = [e] : p.push(e), c++;
} return st.errors = p, 0 === c; }
function nt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = nt.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("name" !== a && "url" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return nt.errors = i, 0 === p; }
function ot(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = ot.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.title) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "title" }, message: "must have required property 'title'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.version) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "version" }, message: "must have required property 'version'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("title" !== a && "description" !== a && "termsOfService" !== a && "contact" !== a && "license" !== a && "version" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.title && "string" != typeof e.title) {
        const e = { instancePath: t + "/title", schemaPath: "#/properties/title/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.termsOfService) {
        let a = e.termsOfService;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/termsOfService", schemaPath: "#/properties/termsOfService/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/termsOfService", schemaPath: "#/properties/termsOfService/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.contact && (st(e.contact, { instancePath: t + "/contact", parentData: e, parentDataProperty: "contact", rootData: n, dynamicAnchors: o }) || (i = null === i ? st.errors : i.concat(st.errors), p = i.length)), void 0 !== e.license && (nt(e.license, { instancePath: t + "/license", parentData: e, parentDataProperty: "license", rootData: n, dynamicAnchors: o }) || (i = null === i ? nt.errors : i.concat(nt.errors), p = i.length)), void 0 !== e.version && "string" != typeof e.version) {
        const e = { instancePath: t + "/version", schemaPath: "#/properties/version/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return ot.errors = i, 0 === p; }
function it(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = it.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.url) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "url" }, message: "must have required property 'url'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("description" !== a && "url" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return it.errors = i, 0 === p; }
function pt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = pt.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.default) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "default" }, message: "must have required property 'default'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("enum" !== a && "default" !== a && "description" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.enum) {
        let a = e.enum;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                if ("string" != typeof a[r]) {
                    const e = { instancePath: t + "/enum/" + r, schemaPath: "#/properties/enum/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === i ? i = [e] : i.push(e), p++;
                }
        }
        else {
            const e = { instancePath: t + "/enum", schemaPath: "#/properties/enum/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.default && "string" != typeof e.default) {
        const e = { instancePath: t + "/default", schemaPath: "#/properties/default/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return pt.errors = i, 0 === p; }
function ct(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = ct.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.url) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "url" }, message: "must have required property 'url'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("url" !== a && "description" !== a && "variables" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.url && "string" != typeof e.url) {
        const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.variables) {
        let a = e.variables;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                pt(a[e], { instancePath: t + "/variables/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }) || (i = null === i ? pt.errors : i.concat(pt.errors), p = i.length);
        else {
            const e = { instancePath: t + "/variables", schemaPath: "#/properties/variables/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return ct.errors = i, 0 === p; }
function lt(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = lt.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e) {
        let r = e[a];
        if (Array.isArray(r)) {
            const e = r.length;
            for (let s = 0; s < e; s++)
                if ("string" != typeof r[s]) {
                    const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1") + "/" + s, schemaPath: "#/additionalProperties/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === o ? o = [e] : o.push(e), i++;
                }
        }
        else {
            const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/additionalProperties/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return lt.errors = o, 0 === i; }
function mt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = mt.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("name" !== a && "description" !== a && "externalDocs" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    void 0 !== e.externalDocs && (it(e.externalDocs, { instancePath: t + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: n, dynamicAnchors: o }) || (i = null === i ? it.errors : i.concat(it.errors), p = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return mt.errors = i, 0 === p; }
st.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, nt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ot.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, it.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, pt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ct.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, lt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, mt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const ut = new RegExp("^(get|put|post|delete|options|head|patch|trace)$", "u"), ht = new RegExp("^\\$ref$", "u");
function dt(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = dt.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.$ref) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "$ref" }, message: "must have required property '$ref'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    var c = {};
    for (const a in e)
        if (ht.test(a)) {
            let r = e[a];
            if ("string" == typeof r) {
                if (!rt.test(r)) {
                    const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/patternProperties/%5E%5C%24ref%24/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                    null === o ? o = [e] : o.push(e), i++;
                }
            }
            else {
                const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/patternProperties/%5E%5C%24ref%24/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                null === o ? o = [e] : o.push(e), i++;
            }
            c[a] = !0;
        }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return dt.errors = o, p.props = c, 0 === i; }
dt.evaluated = { dynamicProps: !0, dynamicItems: !1 };
const yt = { type: "object", properties: { name: { type: "string" }, in: { type: "string" }, description: { type: "string" }, required: { type: "boolean", default: !1 }, deprecated: { type: "boolean", default: !1 }, allowEmptyValue: { type: "boolean", default: !1 }, style: { type: "string" }, explode: { type: "boolean" }, allowReserved: { type: "boolean", default: !1 }, schema: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Schema" } }, content: { type: "object", additionalProperties: { $ref: "#/definitions/MediaType" }, minProperties: 1, maxProperties: 1 }, example: {}, examples: { type: "object", additionalProperties: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Example" } } } }, patternProperties: { "^x-": {} }, additionalProperties: !1, required: ["name"], allOf: [{ $ref: "#/definitions/ExampleXORExamples" }, { $ref: "#/definitions/SchemaXORContent" }, { $ref: "#/definitions/ParameterLocation" }] };
function ft(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ft.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i, l = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.example && (t = "example") || void 0 === e.examples && (t = "examples")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} if (l === i) {
    const e = { instancePath: t, schemaPath: "#/not", keyword: "not", params: {}, message: "must NOT be valid" };
    null === o ? o = [e] : o.push(e), i++;
}
else
    i = c, null !== o && (c ? o.length = c : o = null); return ft.errors = o, 0 === i; }
ft.evaluated = { dynamicProps: !1, dynamicItems: !1 };
const Pt = { description: "Schema and content are mutually exclusive, at least one is required", errorMessage: { not: "Schema and content are mutually exclusive, at least one is required" }, not: { required: ["schema", "content"] }, if: { type: "object", required: ["schema"] }, then: !0, else: { if: { type: "object", required: ["content"] }, then: { description: "Some properties are not allowed if content is present", allOf: [{ not: { required: ["style"] } }, { not: { required: ["explode"] } }, { not: { required: ["allowReserved"] } }, { not: { required: ["example"] } }, { not: { required: ["examples"] } }] }, else: { not: !0, errorMessage: { not: '"schema" or "content" must be present' } } } };
function gt(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = gt.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i, l = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.schema && (t = "schema") || void 0 === e.content && (t = "content")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} if (l === i) {
    const e = { instancePath: t, schemaPath: "#/not", keyword: "not", params: {}, message: "must NOT be valid" };
    null === o ? o = [e] : o.push(e), i++;
}
else
    i = c, null !== o && (c ? o.length = c : o = null); const m = i; let u = !0; const h = i; if (i === h)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.schema && (t = "schema")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var d = h === i; if (i = m, null !== o && (m ? o.length = m : o = null), !d) {
    const a = i, r = i;
    let s = !0;
    const n = i;
    if (i === n)
        if (e && "object" == typeof e && !Array.isArray(e)) {
            let t;
            if (void 0 === e.content && (t = "content")) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    var y = n === i;
    let p;
    if (i = r, null !== o && (r ? o.length = r : o = null), y) {
        const a = i, r = i, n = i;
        if (e && "object" == typeof e && !Array.isArray(e)) {
            let t;
            if (void 0 === e.style && (t = "style")) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        if (n === i) {
            const e = { instancePath: t, schemaPath: "#/else/then/allOf/0/not", keyword: "not", params: {}, message: "must NOT be valid" };
            null === o ? o = [e] : o.push(e), i++;
        }
        else
            i = r, null !== o && (r ? o.length = r : o = null);
        const c = i, l = i;
        if (e && "object" == typeof e && !Array.isArray(e)) {
            let t;
            if (void 0 === e.explode && (t = "explode")) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        if (l === i) {
            const e = { instancePath: t, schemaPath: "#/else/then/allOf/1/not", keyword: "not", params: {}, message: "must NOT be valid" };
            null === o ? o = [e] : o.push(e), i++;
        }
        else
            i = c, null !== o && (c ? o.length = c : o = null);
        const m = i, u = i;
        if (e && "object" == typeof e && !Array.isArray(e)) {
            let t;
            if (void 0 === e.allowReserved && (t = "allowReserved")) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        if (u === i) {
            const e = { instancePath: t, schemaPath: "#/else/then/allOf/2/not", keyword: "not", params: {}, message: "must NOT be valid" };
            null === o ? o = [e] : o.push(e), i++;
        }
        else
            i = m, null !== o && (m ? o.length = m : o = null);
        const h = i, d = i;
        if (e && "object" == typeof e && !Array.isArray(e)) {
            let t;
            if (void 0 === e.example && (t = "example")) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        if (d === i) {
            const e = { instancePath: t, schemaPath: "#/else/then/allOf/3/not", keyword: "not", params: {}, message: "must NOT be valid" };
            null === o ? o = [e] : o.push(e), i++;
        }
        else
            i = h, null !== o && (h ? o.length = h : o = null);
        const f = i, P = i;
        if (e && "object" == typeof e && !Array.isArray(e)) {
            let t;
            if (void 0 === e.examples && (t = "examples")) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        if (P === i) {
            const e = { instancePath: t, schemaPath: "#/else/then/allOf/4/not", keyword: "not", params: {}, message: "must NOT be valid" };
            null === o ? o = [e] : o.push(e), i++;
        }
        else
            i = f, null !== o && (f ? o.length = f : o = null);
        s = y = a === i, p = "then";
    }
    else {
        const e = i, a = { instancePath: t, schemaPath: "#/else/else/not", keyword: "not", params: {}, message: "must NOT be valid" };
        if (null === o ? o = [a] : o.push(a), i++, i > 0) {
            const e = { not: [] }, a = {};
            for (const a of o)
                "errorMessage" !== a.keyword && !a.emUsed && a.instancePath === t && a.keyword in e && 0 === a.schemaPath.indexOf("#/else/else") && /^\/[^\/]*$/.test(a.schemaPath.slice(11)) && (e[a.keyword].push(a), a.emUsed = !0);
            for (const r in e)
                if (e[r].length) {
                    const s = { instancePath: t, schemaPath: "#/else/else/errorMessage", keyword: "errorMessage", params: { errors: e[r] }, message: r in a ? a[r]() : Pt.else.else.errorMessage[r] };
                    null === o ? o = [s] : o.push(s), i++;
                }
            const r = [];
            for (const e of o)
                e.emUsed || r.push(e);
            o = r, i = r.length;
        }
        s = y = e === i, p = "else";
    }
    if (!s) {
        const e = { instancePath: t, schemaPath: "#/else/if", keyword: "if", params: { failingKeyword: p }, message: 'must match "' + p + '" schema' };
        null === o ? o = [e] : o.push(e), i++;
    }
    u = d = a === i;
} if (!u) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "else" }, message: 'must match "else" schema' };
    null === o ? o = [e] : o.push(e), i++;
} if (i > 0) {
    const e = { not: [] }, a = {};
    for (const a of o)
        "errorMessage" !== a.keyword && !a.emUsed && a.instancePath === t && a.keyword in e && 0 === a.schemaPath.indexOf("#") && /^\/[^\/]*$/.test(a.schemaPath.slice(1)) && (e[a.keyword].push(a), a.emUsed = !0);
    for (const r in e)
        if (e[r].length) {
            const s = { instancePath: t, schemaPath: "#/errorMessage", keyword: "errorMessage", params: { errors: e[r] }, message: r in a ? a[r]() : Pt.errorMessage[r] };
            null === o ? o = [s] : o.push(s), i++;
        }
    const r = [];
    for (const e of o)
        e.emUsed || r.push(e);
    o = r, i = r.length;
} return gt.errors = o, 0 === i; }
gt.evaluated = { dynamicProps: !1, dynamicItems: !1 };
const vt = { description: "Parameter location", type: "object", if: { type: "object", properties: { in: { const: "path" } }, required: ["in"] }, then: { description: "Parameter in path", required: ["required"], properties: { style: { enum: ["matrix", "label", "simple"], default: "simple" }, required: { const: !0 } } }, else: { if: { type: "object", properties: { in: { const: "query" } }, required: ["in"] }, then: { description: "Parameter in query", properties: { style: { enum: ["form", "spaceDelimited", "pipeDelimited", "deepObject"], default: "form" } } }, else: { if: { type: "object", properties: { in: { const: "header" } }, required: ["in"] }, then: { description: "Parameter in header", properties: { style: { const: "simple", default: "simple" } } }, else: { if: { type: "object", properties: { in: { const: "cookie" } }, required: ["in"] }, then: { description: "Parameter in cookie", properties: { style: { const: "form", default: "form" } } }, else: { type: "object", properties: { in: { enum: ["path", "query", "header", "cookie"] } }, required: ["in"], errorMessage: { required: 'Parameter must have a valid "in" property' } } } } } };
function bt(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = bt.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), !e || "object" != typeof e || Array.isArray(e)) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.in && (t = "in")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
        else if (void 0 !== e.in && "path" !== e.in) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e)) {
        if (void 0 === e.required) {
            const e = { instancePath: t, schemaPath: "#/then/required", keyword: "required", params: { missingProperty: "required" }, message: "must have required property 'required'" };
            null === o ? o = [e] : o.push(e), i++;
        }
        if (void 0 !== e.style) {
            let a = e.style;
            if ("matrix" !== a && "label" !== a && "simple" !== a) {
                const e = { instancePath: t + "/style", schemaPath: "#/then/properties/style/enum", keyword: "enum", params: { allowedValues: vt.then.properties.style.enum }, message: "must be equal to one of the allowed values" };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        if (void 0 !== e.required && !0 !== e.required) {
            const e = { instancePath: t + "/required", schemaPath: "#/then/properties/required/const", keyword: "const", params: { allowedValue: !0 }, message: "must be equal to constant" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (l = u = a === i, l)
        var d = { style: !0, required: !0, in: !0 };
    h = "then";
}
else {
    const a = i, r = i;
    let s = !0;
    const n = i;
    if (i === n)
        if (e && "object" == typeof e && !Array.isArray(e)) {
            let t;
            if (void 0 === e.in && (t = "in")) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
            else if (void 0 !== e.in && "query" !== e.in) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    var y = n === i;
    let p;
    if (i = r, null !== o && (r ? o.length = r : o = null), y) {
        const a = i;
        if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.style) {
            let a = e.style;
            if ("form" !== a && "spaceDelimited" !== a && "pipeDelimited" !== a && "deepObject" !== a) {
                const e = { instancePath: t + "/style", schemaPath: "#/else/then/properties/style/enum", keyword: "enum", params: { allowedValues: vt.else.then.properties.style.enum }, message: "must be equal to one of the allowed values" };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        if (s = y = a === i, s)
            var f = { style: !0, in: !0 };
        p = "then";
    }
    else {
        const a = i, r = i;
        let n = !0;
        const c = i;
        if (i === c)
            if (e && "object" == typeof e && !Array.isArray(e)) {
                let t;
                if (void 0 === e.in && (t = "in")) {
                    const e = {};
                    null === o ? o = [e] : o.push(e), i++;
                }
                else if (void 0 !== e.in && "header" !== e.in) {
                    const e = {};
                    null === o ? o = [e] : o.push(e), i++;
                }
            }
            else {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
        var P = c === i;
        let l;
        if (i = r, null !== o && (r ? o.length = r : o = null), P) {
            const a = i;
            if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.style && "simple" !== e.style) {
                const e = { instancePath: t + "/style", schemaPath: "#/else/else/then/properties/style/const", keyword: "const", params: { allowedValue: "simple" }, message: "must be equal to constant" };
                null === o ? o = [e] : o.push(e), i++;
            }
            if (n = P = a === i, n)
                var g = { style: !0, in: !0 };
            l = "then";
        }
        else {
            const a = i, r = i;
            let s = !0;
            const p = i;
            if (i === p)
                if (e && "object" == typeof e && !Array.isArray(e)) {
                    let t;
                    if (void 0 === e.in && (t = "in")) {
                        const e = {};
                        null === o ? o = [e] : o.push(e), i++;
                    }
                    else if (void 0 !== e.in && "cookie" !== e.in) {
                        const e = {};
                        null === o ? o = [e] : o.push(e), i++;
                    }
                }
                else {
                    const e = {};
                    null === o ? o = [e] : o.push(e), i++;
                }
            var v = p === i;
            let c;
            if (i = r, null !== o && (r ? o.length = r : o = null), v) {
                const a = i;
                if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.style && "form" !== e.style) {
                    const e = { instancePath: t + "/style", schemaPath: "#/else/else/else/then/properties/style/const", keyword: "const", params: { allowedValue: "form" }, message: "must be equal to constant" };
                    null === o ? o = [e] : o.push(e), i++;
                }
                if (s = v = a === i, s)
                    var b = { style: !0, in: !0 };
                c = "then";
            }
            else {
                const a = i;
                if (e && "object" == typeof e && !Array.isArray(e)) {
                    if (void 0 === e.in) {
                        const e = { instancePath: t, schemaPath: "#/else/else/else/else/required", keyword: "required", params: { missingProperty: "in" }, message: "must have required property 'in'" };
                        null === o ? o = [e] : o.push(e), i++;
                    }
                    if (void 0 !== e.in) {
                        let a = e.in;
                        if ("path" !== a && "query" !== a && "header" !== a && "cookie" !== a) {
                            const e = { instancePath: t + "/in", schemaPath: "#/else/else/else/else/properties/in/enum", keyword: "enum", params: { allowedValues: vt.else.else.else.else.properties.in.enum }, message: "must be equal to one of the allowed values" };
                            null === o ? o = [e] : o.push(e), i++;
                        }
                    }
                }
                else {
                    const e = { instancePath: t, schemaPath: "#/else/else/else/else/type", keyword: "type", params: { type: "object" }, message: "must be object" };
                    null === o ? o = [e] : o.push(e), i++;
                }
                if (i > 0) {
                    const e = { required: [] }, a = {};
                    for (const a of o)
                        "errorMessage" !== a.keyword && !a.emUsed && a.instancePath === t && a.keyword in e && 0 === a.schemaPath.indexOf("#/else/else/else/else") && /^\/[^\/]*$/.test(a.schemaPath.slice(21)) && (e[a.keyword].push(a), a.emUsed = !0);
                    for (const r in e)
                        if (e[r].length) {
                            const s = { instancePath: t, schemaPath: "#/else/else/else/else/errorMessage", keyword: "errorMessage", params: { errors: e[r] }, message: r in a ? a[r]() : vt.else.else.else.else.errorMessage[r] };
                            null === o ? o = [s] : o.push(s), i++;
                        }
                    const r = [];
                    for (const e of o)
                        e.emUsed || r.push(e);
                    o = r, i = r.length;
                }
                s = v = a === i, s && !0 !== b && ((b = b || {}).in = !0), c = "else";
            }
            if (!s) {
                const e = { instancePath: t, schemaPath: "#/else/else/else/if", keyword: "if", params: { failingKeyword: c }, message: 'must match "' + c + '" schema' };
                null === o ? o = [e] : o.push(e), i++;
            }
            n = P = a === i, n && !0 !== g && void 0 !== b && (!0 === b ? g = !0 : (g = g || {}, Object.assign(g, b))), l = "else";
        }
        if (!n) {
            const e = { instancePath: t, schemaPath: "#/else/else/if", keyword: "if", params: { failingKeyword: l }, message: 'must match "' + l + '" schema' };
            null === o ? o = [e] : o.push(e), i++;
        }
        s = y = a === i, s && !0 !== f && void 0 !== g && (!0 === g ? f = !0 : (f = f || {}, Object.assign(f, g))), p = "else";
    }
    if (!s) {
        const e = { instancePath: t, schemaPath: "#/else/if", keyword: "if", params: { failingKeyword: p }, message: 'must match "' + p + '" schema' };
        null === o ? o = [e] : o.push(e), i++;
    }
    l = u = a === i, l && !0 !== d && void 0 !== f && (!0 === f ? d = !0 : (d = d || {}, Object.assign(d, f))), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return bt.errors = o, p.props = d, 0 === i; }
bt.evaluated = { dynamicProps: !0, dynamicItems: !1 };
const Dt = { type: "object", properties: { title: { type: "string" }, multipleOf: { type: "number", exclusiveMinimum: 0 }, maximum: { type: "number" }, exclusiveMaximum: { type: "boolean", default: !1 }, minimum: { type: "number" }, exclusiveMinimum: { type: "boolean", default: !1 }, maxLength: { type: "integer", minimum: 0 }, minLength: { type: "integer", minimum: 0, default: 0 }, pattern: { type: "string", format: "regex" }, maxItems: { type: "integer", minimum: 0 }, minItems: { type: "integer", minimum: 0, default: 0 }, uniqueItems: { type: "boolean", default: !1 }, maxProperties: { type: "integer", minimum: 0 }, minProperties: { type: "integer", minimum: 0, default: 0 }, required: { type: "array", items: { type: "string" }, minItems: 1, uniqueItems: !0 }, enum: { type: "array", items: {}, minItems: 1, uniqueItems: !1 }, type: { enum: ["array", "boolean", "integer", "number", "object", "string"] }, not: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Schema" } }, allOf: { type: "array", items: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Schema" } } }, oneOf: { type: "array", items: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Schema" } } }, anyOf: { type: "array", items: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Schema" } } }, items: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Schema" } }, properties: { type: "object", additionalProperties: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Schema" } } }, additionalProperties: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { if: { type: "object" }, then: { $ref: "#/definitions/Schema" }, else: { if: { type: "boolean" }, then: !0, else: { not: !0, errorMessage: '"additionalProperties" property must be a valid Schema Object' } } }, default: !0 }, description: { type: "string" }, format: { type: "string" }, default: {}, nullable: { type: "boolean", default: !1 }, discriminator: { $ref: "#/definitions/Discriminator" }, readOnly: { type: "boolean", default: !1 }, writeOnly: { type: "boolean", default: !1 }, example: {}, externalDocs: { $ref: "#/definitions/ExternalDocumentation" }, deprecated: { type: "boolean", default: !1 }, xml: { $ref: "#/definitions/XML" } }, patternProperties: { "^x-": {} }, additionalProperties: !1 };
function wt(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = wt.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.propertyName) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "propertyName" }, message: "must have required property 'propertyName'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.propertyName && "string" != typeof e.propertyName) {
        const e = { instancePath: t + "/propertyName", schemaPath: "#/properties/propertyName/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.mapping) {
        let a = e.mapping;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            for (const e in a)
                if ("string" != typeof a[e]) {
                    const a = { instancePath: t + "/mapping/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/mapping/additionalProperties/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === o ? o = [a] : o.push(a), i++;
                }
        }
        else {
            const e = { instancePath: t + "/mapping", schemaPath: "#/properties/mapping/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return wt.errors = o, 0 === i; }
function At(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: i = {} } = {}) { let p = null, c = 0; const l = At.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("name" !== a && "namespace" !== a && "prefix" !== a && "attribute" !== a && "wrapped" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === p ? p = [e] : p.push(e), c++;
        }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.namespace) {
        let a = e.namespace;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/namespace", schemaPath: "#/properties/namespace/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === p ? p = [e] : p.push(e), c++;
            }
        }
        else {
            const e = { instancePath: t + "/namespace", schemaPath: "#/properties/namespace/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.prefix && "string" != typeof e.prefix) {
        const e = { instancePath: t + "/prefix", schemaPath: "#/properties/prefix/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.attribute && "boolean" != typeof e.attribute) {
        const e = { instancePath: t + "/attribute", schemaPath: "#/properties/attribute/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.wrapped && "boolean" != typeof e.wrapped) {
        const e = { instancePath: t + "/wrapped", schemaPath: "#/properties/wrapped/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === p ? p = [e] : p.push(e), c++;
} return At.errors = p, 0 === c; }
wt.evaluated = { props: { propertyName: !0, mapping: !0 }, dynamicProps: !1, dynamicItems: !1 }, At.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const kt = { validate: $t };
function $t(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let p = null, c = 0; const l = $t.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const s in e)
        if (!t.call(Dt.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === p ? p = [e] : p.push(e), c++;
        }
    if (void 0 !== e.title && "string" != typeof e.title) {
        const e = { instancePath: a + "/title", schemaPath: "#/properties/title/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.multipleOf) {
        let t = e.multipleOf;
        if ("number" == typeof t) {
            if (t <= 0 || isNaN(t)) {
                const e = { instancePath: a + "/multipleOf", schemaPath: "#/properties/multipleOf/exclusiveMinimum", keyword: "exclusiveMinimum", params: { comparison: ">", limit: 0 }, message: "must be > 0" };
                null === p ? p = [e] : p.push(e), c++;
            }
        }
        else {
            const e = { instancePath: a + "/multipleOf", schemaPath: "#/properties/multipleOf/type", keyword: "type", params: { type: "number" }, message: "must be number" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.maximum && "number" != typeof e.maximum) {
        const e = { instancePath: a + "/maximum", schemaPath: "#/properties/maximum/type", keyword: "type", params: { type: "number" }, message: "must be number" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.exclusiveMaximum && "boolean" != typeof e.exclusiveMaximum) {
        const e = { instancePath: a + "/exclusiveMaximum", schemaPath: "#/properties/exclusiveMaximum/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.minimum && "number" != typeof e.minimum) {
        const e = { instancePath: a + "/minimum", schemaPath: "#/properties/minimum/type", keyword: "type", params: { type: "number" }, message: "must be number" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.exclusiveMinimum && "boolean" != typeof e.exclusiveMinimum) {
        const e = { instancePath: a + "/exclusiveMinimum", schemaPath: "#/properties/exclusiveMinimum/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.maxLength) {
        let t = e.maxLength;
        if ("number" != typeof t || t % 1 || isNaN(t)) {
            const e = { instancePath: a + "/maxLength", schemaPath: "#/properties/maxLength/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
            null === p ? p = [e] : p.push(e), c++;
        }
        if ("number" == typeof t && (t < 0 || isNaN(t))) {
            const e = { instancePath: a + "/maxLength", schemaPath: "#/properties/maxLength/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.minLength) {
        let t = e.minLength;
        if ("number" != typeof t || t % 1 || isNaN(t)) {
            const e = { instancePath: a + "/minLength", schemaPath: "#/properties/minLength/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
            null === p ? p = [e] : p.push(e), c++;
        }
        if ("number" == typeof t && (t < 0 || isNaN(t))) {
            const e = { instancePath: a + "/minLength", schemaPath: "#/properties/minLength/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.pattern) {
        let t = e.pattern;
        if ("string" == typeof t) {
            if (!T(t)) {
                const e = { instancePath: a + "/pattern", schemaPath: "#/properties/pattern/format", keyword: "format", params: { format: "regex" }, message: 'must match format "regex"' };
                null === p ? p = [e] : p.push(e), c++;
            }
        }
        else {
            const e = { instancePath: a + "/pattern", schemaPath: "#/properties/pattern/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.maxItems) {
        let t = e.maxItems;
        if ("number" != typeof t || t % 1 || isNaN(t)) {
            const e = { instancePath: a + "/maxItems", schemaPath: "#/properties/maxItems/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
            null === p ? p = [e] : p.push(e), c++;
        }
        if ("number" == typeof t && (t < 0 || isNaN(t))) {
            const e = { instancePath: a + "/maxItems", schemaPath: "#/properties/maxItems/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.minItems) {
        let t = e.minItems;
        if ("number" != typeof t || t % 1 || isNaN(t)) {
            const e = { instancePath: a + "/minItems", schemaPath: "#/properties/minItems/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
            null === p ? p = [e] : p.push(e), c++;
        }
        if ("number" == typeof t && (t < 0 || isNaN(t))) {
            const e = { instancePath: a + "/minItems", schemaPath: "#/properties/minItems/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.uniqueItems && "boolean" != typeof e.uniqueItems) {
        const e = { instancePath: a + "/uniqueItems", schemaPath: "#/properties/uniqueItems/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.maxProperties) {
        let t = e.maxProperties;
        if ("number" != typeof t || t % 1 || isNaN(t)) {
            const e = { instancePath: a + "/maxProperties", schemaPath: "#/properties/maxProperties/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
            null === p ? p = [e] : p.push(e), c++;
        }
        if ("number" == typeof t && (t < 0 || isNaN(t))) {
            const e = { instancePath: a + "/maxProperties", schemaPath: "#/properties/maxProperties/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.minProperties) {
        let t = e.minProperties;
        if ("number" != typeof t || t % 1 || isNaN(t)) {
            const e = { instancePath: a + "/minProperties", schemaPath: "#/properties/minProperties/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
            null === p ? p = [e] : p.push(e), c++;
        }
        if ("number" == typeof t && (t < 0 || isNaN(t))) {
            const e = { instancePath: a + "/minProperties", schemaPath: "#/properties/minProperties/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.required) {
        let t = e.required;
        if (Array.isArray(t)) {
            if (t.length < 1) {
                const e = { instancePath: a + "/required", schemaPath: "#/properties/required/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === p ? p = [e] : p.push(e), c++;
            }
            const e = t.length;
            for (let r = 0; r < e; r++)
                if ("string" != typeof t[r]) {
                    const e = { instancePath: a + "/required/" + r, schemaPath: "#/properties/required/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === p ? p = [e] : p.push(e), c++;
                }
            let r, s = t.length;
            if (s > 1) {
                const e = {};
                for (; s--;) {
                    let n = t[s];
                    if ("string" == typeof n) {
                        if ("number" == typeof e[n]) {
                            r = e[n];
                            const t = { instancePath: a + "/required", schemaPath: "#/properties/required/uniqueItems", keyword: "uniqueItems", params: { i: s, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + s + " are identical)" };
                            null === p ? p = [t] : p.push(t), c++;
                            break;
                        }
                        e[n] = s;
                    }
                }
            }
        }
        else {
            const e = { instancePath: a + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.enum) {
        let t = e.enum;
        if (Array.isArray(t)) {
            if (t.length < 1) {
                const e = { instancePath: a + "/enum", schemaPath: "#/properties/enum/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === p ? p = [e] : p.push(e), c++;
            }
        }
        else {
            const e = { instancePath: a + "/enum", schemaPath: "#/properties/enum/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.type) {
        let t = e.type;
        if ("array" !== t && "boolean" !== t && "integer" !== t && "number" !== t && "object" !== t && "string" !== t) {
            const e = { instancePath: a + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: Dt.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.not) {
        let t = e.not;
        const r = c;
        let s = !0;
        const n = c;
        if (c === n)
            if (t && "object" == typeof t && !Array.isArray(t)) {
                let e;
                if (void 0 === t.$ref && (e = "$ref")) {
                    const e = {};
                    null === p ? p = [e] : p.push(e), c++;
                }
            }
            else {
                const e = {};
                null === p ? p = [e] : p.push(e), c++;
            }
        var m = n === c;
        let l;
        if (c = r, null !== p && (r ? p.length = r : p = null), m) {
            const r = c;
            if (dt(t, { instancePath: a + "/not", parentData: e, parentDataProperty: "not", rootData: o, dynamicAnchors: i }))
                var u = dt.evaluated.props;
            else
                p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
            s = m = r === c, l = "then";
        }
        else {
            const r = c;
            if (kt.validate(t, { instancePath: a + "/not", parentData: e, parentDataProperty: "not", rootData: o, dynamicAnchors: i }))
                var h = kt.validate.evaluated.props;
            else
                p = null === p ? kt.validate.errors : p.concat(kt.validate.errors), c = p.length;
            s = m = r === c, s && !0 !== u && void 0 !== h && (!0 === h ? u = !0 : (u = u || {}, Object.assign(u, h))), l = "else";
        }
        if (!s) {
            const e = { instancePath: a + "/not", schemaPath: "#/properties/not/if", keyword: "if", params: { failingKeyword: l }, message: 'must match "' + l + '" schema' };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.allOf) {
        let t = e.allOf;
        if (Array.isArray(t)) {
            const e = t.length;
            for (let r = 0; r < e; r++) {
                let e = t[r];
                const s = c;
                let n = !0;
                const l = c;
                if (c === l)
                    if (e && "object" == typeof e && !Array.isArray(e)) {
                        let t;
                        if (void 0 === e.$ref && (t = "$ref")) {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    }
                    else {
                        const e = {};
                        null === p ? p = [e] : p.push(e), c++;
                    }
                var d = l === c;
                let m;
                if (c = s, null !== p && (s ? p.length = s : p = null), d) {
                    const s = c;
                    if (dt(e, { instancePath: a + "/allOf/" + r, parentData: t, parentDataProperty: r, rootData: o, dynamicAnchors: i }))
                        var y = dt.evaluated.props;
                    else
                        p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                    n = d = s === c, m = "then";
                }
                else {
                    const s = c;
                    if (kt.validate(e, { instancePath: a + "/allOf/" + r, parentData: t, parentDataProperty: r, rootData: o, dynamicAnchors: i }))
                        var f = kt.validate.evaluated.props;
                    else
                        p = null === p ? kt.validate.errors : p.concat(kt.validate.errors), c = p.length;
                    n = d = s === c, n && !0 !== y && void 0 !== f && (!0 === f ? y = !0 : (y = y || {}, Object.assign(y, f))), m = "else";
                }
                if (!n) {
                    const e = { instancePath: a + "/allOf/" + r, schemaPath: "#/properties/allOf/items/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                    null === p ? p = [e] : p.push(e), c++;
                }
            }
        }
        else {
            const e = { instancePath: a + "/allOf", schemaPath: "#/properties/allOf/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.oneOf) {
        let t = e.oneOf;
        if (Array.isArray(t)) {
            const e = t.length;
            for (let r = 0; r < e; r++) {
                let e = t[r];
                const s = c;
                let n = !0;
                const l = c;
                if (c === l)
                    if (e && "object" == typeof e && !Array.isArray(e)) {
                        let t;
                        if (void 0 === e.$ref && (t = "$ref")) {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    }
                    else {
                        const e = {};
                        null === p ? p = [e] : p.push(e), c++;
                    }
                var P = l === c;
                let m;
                if (c = s, null !== p && (s ? p.length = s : p = null), P) {
                    const s = c;
                    if (dt(e, { instancePath: a + "/oneOf/" + r, parentData: t, parentDataProperty: r, rootData: o, dynamicAnchors: i }))
                        var g = dt.evaluated.props;
                    else
                        p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                    n = P = s === c, m = "then";
                }
                else {
                    const s = c;
                    if (kt.validate(e, { instancePath: a + "/oneOf/" + r, parentData: t, parentDataProperty: r, rootData: o, dynamicAnchors: i }))
                        var v = kt.validate.evaluated.props;
                    else
                        p = null === p ? kt.validate.errors : p.concat(kt.validate.errors), c = p.length;
                    n = P = s === c, n && !0 !== g && void 0 !== v && (!0 === v ? g = !0 : (g = g || {}, Object.assign(g, v))), m = "else";
                }
                if (!n) {
                    const e = { instancePath: a + "/oneOf/" + r, schemaPath: "#/properties/oneOf/items/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                    null === p ? p = [e] : p.push(e), c++;
                }
            }
        }
        else {
            const e = { instancePath: a + "/oneOf", schemaPath: "#/properties/oneOf/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.anyOf) {
        let t = e.anyOf;
        if (Array.isArray(t)) {
            const e = t.length;
            for (let r = 0; r < e; r++) {
                let e = t[r];
                const s = c;
                let n = !0;
                const l = c;
                if (c === l)
                    if (e && "object" == typeof e && !Array.isArray(e)) {
                        let t;
                        if (void 0 === e.$ref && (t = "$ref")) {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    }
                    else {
                        const e = {};
                        null === p ? p = [e] : p.push(e), c++;
                    }
                var b = l === c;
                let m;
                if (c = s, null !== p && (s ? p.length = s : p = null), b) {
                    const s = c;
                    if (dt(e, { instancePath: a + "/anyOf/" + r, parentData: t, parentDataProperty: r, rootData: o, dynamicAnchors: i }))
                        var D = dt.evaluated.props;
                    else
                        p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                    n = b = s === c, m = "then";
                }
                else {
                    const s = c;
                    if (kt.validate(e, { instancePath: a + "/anyOf/" + r, parentData: t, parentDataProperty: r, rootData: o, dynamicAnchors: i }))
                        var w = kt.validate.evaluated.props;
                    else
                        p = null === p ? kt.validate.errors : p.concat(kt.validate.errors), c = p.length;
                    n = b = s === c, n && !0 !== D && void 0 !== w && (!0 === w ? D = !0 : (D = D || {}, Object.assign(D, w))), m = "else";
                }
                if (!n) {
                    const e = { instancePath: a + "/anyOf/" + r, schemaPath: "#/properties/anyOf/items/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                    null === p ? p = [e] : p.push(e), c++;
                }
            }
        }
        else {
            const e = { instancePath: a + "/anyOf", schemaPath: "#/properties/anyOf/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.items) {
        let t = e.items;
        const r = c;
        let s = !0;
        const n = c;
        if (c === n)
            if (t && "object" == typeof t && !Array.isArray(t)) {
                let e;
                if (void 0 === t.$ref && (e = "$ref")) {
                    const e = {};
                    null === p ? p = [e] : p.push(e), c++;
                }
            }
            else {
                const e = {};
                null === p ? p = [e] : p.push(e), c++;
            }
        var A = n === c;
        let l;
        if (c = r, null !== p && (r ? p.length = r : p = null), A) {
            const r = c;
            if (dt(t, { instancePath: a + "/items", parentData: e, parentDataProperty: "items", rootData: o, dynamicAnchors: i }))
                var k = dt.evaluated.props;
            else
                p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
            s = A = r === c, l = "then";
        }
        else {
            const r = c;
            if (kt.validate(t, { instancePath: a + "/items", parentData: e, parentDataProperty: "items", rootData: o, dynamicAnchors: i }))
                var $ = kt.validate.evaluated.props;
            else
                p = null === p ? kt.validate.errors : p.concat(kt.validate.errors), c = p.length;
            s = A = r === c, s && !0 !== k && void 0 !== $ && (!0 === $ ? k = !0 : (k = k || {}, Object.assign(k, $))), l = "else";
        }
        if (!s) {
            const e = { instancePath: a + "/items", schemaPath: "#/properties/items/if", keyword: "if", params: { failingKeyword: l }, message: 'must match "' + l + '" schema' };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.properties) {
        let t = e.properties;
        if (t && "object" == typeof t && !Array.isArray(t))
            for (const e in t) {
                let r = t[e];
                const s = c;
                let n = !0;
                const l = c;
                if (c === l)
                    if (r && "object" == typeof r && !Array.isArray(r)) {
                        let e;
                        if (void 0 === r.$ref && (e = "$ref")) {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    }
                    else {
                        const e = {};
                        null === p ? p = [e] : p.push(e), c++;
                    }
                var j = l === c;
                let m;
                if (c = s, null !== p && (s ? p.length = s : p = null), j) {
                    const s = c;
                    if (dt(r, { instancePath: a + "/properties/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                        var q = dt.evaluated.props;
                    else
                        p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                    n = j = s === c, m = "then";
                }
                else {
                    const s = c;
                    if (kt.validate(r, { instancePath: a + "/properties/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                        var I = kt.validate.evaluated.props;
                    else
                        p = null === p ? kt.validate.errors : p.concat(kt.validate.errors), c = p.length;
                    n = j = s === c, n && !0 !== q && void 0 !== I && (!0 === I ? q = !0 : (q = q || {}, Object.assign(q, I))), m = "else";
                }
                if (!n) {
                    const t = { instancePath: a + "/properties/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/properties/additionalProperties/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                    null === p ? p = [t] : p.push(t), c++;
                }
            }
        else {
            const e = { instancePath: a + "/properties", schemaPath: "#/properties/properties/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.additionalProperties) {
        let t = e.additionalProperties;
        const r = c;
        let s = !0;
        const n = c;
        if (c === n)
            if (t && "object" == typeof t && !Array.isArray(t)) {
                let e;
                if (void 0 === t.$ref && (e = "$ref")) {
                    const e = {};
                    null === p ? p = [e] : p.push(e), c++;
                }
            }
            else {
                const e = {};
                null === p ? p = [e] : p.push(e), c++;
            }
        var x = n === c;
        let l;
        if (c = r, null !== p && (r ? p.length = r : p = null), x) {
            const r = c;
            if (dt(t, { instancePath: a + "/additionalProperties", parentData: e, parentDataProperty: "additionalProperties", rootData: o, dynamicAnchors: i }))
                var O = dt.evaluated.props;
            else
                p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
            s = x = r === c, l = "then";
        }
        else {
            const r = c, n = c;
            let m = !0;
            const u = c;
            if (!t || "object" != typeof t || Array.isArray(t)) {
                const e = {};
                null === p ? p = [e] : p.push(e), c++;
            }
            var N = u === c;
            let h;
            if (c = n, null !== p && (n ? p.length = n : p = null), N) {
                const r = c;
                if (kt.validate(t, { instancePath: a + "/additionalProperties", parentData: e, parentDataProperty: "additionalProperties", rootData: o, dynamicAnchors: i }))
                    var U = kt.validate.evaluated.props;
                else
                    p = null === p ? kt.validate.errors : p.concat(kt.validate.errors), c = p.length;
                m = N = r === c, h = "then";
            }
            else {
                const e = c, r = c;
                let s = !0;
                const n = c;
                if ("boolean" != typeof t) {
                    const e = {};
                    null === p ? p = [e] : p.push(e), c++;
                }
                var M = n === c;
                if (c = r, null !== p && (r ? p.length = r : p = null), !M) {
                    const e = c, t = { instancePath: a + "/additionalProperties", schemaPath: "#/properties/additionalProperties/else/else/else/not", keyword: "not", params: {}, message: "must NOT be valid" };
                    if (null === p ? p = [t] : p.push(t), c++, c > 0) {
                        const e = [];
                        for (const t of p)
                            "errorMessage" === t.keyword || t.emUsed || t.instancePath !== a + "/additionalProperties" && (0 !== t.instancePath.indexOf(a + "/additionalProperties") || "/" !== t.instancePath[a + 21]) || 0 !== t.schemaPath.indexOf("#/properties/additionalProperties/else/else/else") || "/" !== t.schemaPath[48] || (e.push(t), t.emUsed = !0);
                        if (e.length) {
                            const t = { instancePath: a + "/additionalProperties", schemaPath: "#/properties/additionalProperties/else/else/else/errorMessage", keyword: "errorMessage", params: { errors: e }, message: '"additionalProperties" property must be a valid Schema Object' };
                            null === p ? p = [t] : p.push(t), c++;
                        }
                        const t = [];
                        for (const e of p)
                            e.emUsed || t.push(e);
                        p = t, c = t.length;
                    }
                    s = M = e === c;
                }
                if (!s) {
                    const e = { instancePath: a + "/additionalProperties", schemaPath: "#/properties/additionalProperties/else/else/if", keyword: "if", params: { failingKeyword: "else" }, message: 'must match "else" schema' };
                    null === p ? p = [e] : p.push(e), c++;
                }
                m = N = e === c, h = "else";
            }
            if (!m) {
                const e = { instancePath: a + "/additionalProperties", schemaPath: "#/properties/additionalProperties/else/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
                null === p ? p = [e] : p.push(e), c++;
            }
            s = x = r === c, s && !0 !== O && void 0 !== U && (!0 === U ? O = !0 : (O = O || {}, Object.assign(O, U))), l = "else";
        }
        if (!s) {
            const e = { instancePath: a + "/additionalProperties", schemaPath: "#/properties/additionalProperties/if", keyword: "if", params: { failingKeyword: l }, message: 'must match "' + l + '" schema' };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: a + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.format && "string" != typeof e.format) {
        const e = { instancePath: a + "/format", schemaPath: "#/properties/format/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.nullable && "boolean" != typeof e.nullable) {
        const e = { instancePath: a + "/nullable", schemaPath: "#/properties/nullable/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.discriminator && (wt(e.discriminator, { instancePath: a + "/discriminator", parentData: e, parentDataProperty: "discriminator", rootData: o, dynamicAnchors: i }) || (p = null === p ? wt.errors : p.concat(wt.errors), c = p.length)), void 0 !== e.readOnly && "boolean" != typeof e.readOnly) {
        const e = { instancePath: a + "/readOnly", schemaPath: "#/properties/readOnly/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.writeOnly && "boolean" != typeof e.writeOnly) {
        const e = { instancePath: a + "/writeOnly", schemaPath: "#/properties/writeOnly/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.externalDocs && (it(e.externalDocs, { instancePath: a + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: o, dynamicAnchors: i }) || (p = null === p ? it.errors : p.concat(it.errors), c = p.length)), void 0 !== e.deprecated && "boolean" != typeof e.deprecated) {
        const e = { instancePath: a + "/deprecated", schemaPath: "#/properties/deprecated/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    void 0 !== e.xml && (At(e.xml, { instancePath: a + "/xml", parentData: e, parentDataProperty: "xml", rootData: o, dynamicAnchors: i }) || (p = null === p ? At.errors : p.concat(At.errors), c = p.length));
}
else {
    const e = { instancePath: a, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === p ? p = [e] : p.push(e), c++;
} return $t.errors = p, 0 === c; }
function jt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = jt.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("summary" !== a && "description" !== a && "value" !== a && "externalValue" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: t + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.externalValue) {
        let a = e.externalValue;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/externalValue", schemaPath: "#/properties/externalValue/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/externalValue", schemaPath: "#/properties/externalValue/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return jt.errors = i, 0 === p; }
$t.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, jt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const qt = { type: "object", properties: { contentType: { type: "string" }, headers: { type: "object", additionalProperties: { $ref: "#/definitions/Header" } }, style: { enum: ["form", "spaceDelimited", "pipeDelimited", "deepObject"] }, explode: { type: "boolean" }, allowReserved: { type: "boolean", default: !1 } }, additionalProperties: !1 }, It = { type: "object", properties: { description: { type: "string" }, required: { type: "boolean", default: !1 }, deprecated: { type: "boolean", default: !1 }, allowEmptyValue: { type: "boolean", default: !1 }, style: { const: "simple", default: "simple" }, explode: { type: "boolean" }, allowReserved: { type: "boolean", default: !1 }, schema: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Schema" } }, content: { type: "object", additionalProperties: { $ref: "#/definitions/MediaType" }, minProperties: 1, maxProperties: 1 }, example: {}, examples: { type: "object", additionalProperties: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Example" } } } }, patternProperties: { "^x-": {} }, additionalProperties: !1, allOf: [{ $ref: "#/definitions/ExampleXORExamples" }, { $ref: "#/definitions/SchemaXORContent" }] }, xt = { validate: Ut };
function Ot(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let p = null, c = 0; const l = Ot.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), ft(e, { instancePath: a, parentData: s, parentDataProperty: n, rootData: o, dynamicAnchors: i }) || (p = null === p ? ft.errors : p.concat(ft.errors), c = p.length), gt(e, { instancePath: a, parentData: s, parentDataProperty: n, rootData: o, dynamicAnchors: i }) || (p = null === p ? gt.errors : p.concat(gt.errors), c = p.length), e && "object" == typeof e && !Array.isArray(e)) {
    for (const s in e)
        if (!t.call(It.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === p ? p = [e] : p.push(e), c++;
        }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: a + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.required && "boolean" != typeof e.required) {
        const e = { instancePath: a + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.deprecated && "boolean" != typeof e.deprecated) {
        const e = { instancePath: a + "/deprecated", schemaPath: "#/properties/deprecated/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.allowEmptyValue && "boolean" != typeof e.allowEmptyValue) {
        const e = { instancePath: a + "/allowEmptyValue", schemaPath: "#/properties/allowEmptyValue/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.style && "simple" !== e.style) {
        const e = { instancePath: a + "/style", schemaPath: "#/properties/style/const", keyword: "const", params: { allowedValue: "simple" }, message: "must be equal to constant" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.explode && "boolean" != typeof e.explode) {
        const e = { instancePath: a + "/explode", schemaPath: "#/properties/explode/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.allowReserved && "boolean" != typeof e.allowReserved) {
        const e = { instancePath: a + "/allowReserved", schemaPath: "#/properties/allowReserved/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.schema) {
        let t = e.schema;
        const r = c;
        let s = !0;
        const n = c;
        if (c === n)
            if (t && "object" == typeof t && !Array.isArray(t)) {
                let e;
                if (void 0 === t.$ref && (e = "$ref")) {
                    const e = {};
                    null === p ? p = [e] : p.push(e), c++;
                }
            }
            else {
                const e = {};
                null === p ? p = [e] : p.push(e), c++;
            }
        var m = n === c;
        let l;
        if (c = r, null !== p && (r ? p.length = r : p = null), m) {
            const r = c;
            if (dt(t, { instancePath: a + "/schema", parentData: e, parentDataProperty: "schema", rootData: o, dynamicAnchors: i }))
                var u = dt.evaluated.props;
            else
                p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
            s = m = r === c, l = "then";
        }
        else {
            const r = c;
            $t(t, { instancePath: a + "/schema", parentData: e, parentDataProperty: "schema", rootData: o, dynamicAnchors: i }) || (p = null === p ? $t.errors : p.concat($t.errors), c = p.length), s = m = r === c, s && !0 !== u && (u = !0), l = "else";
        }
        if (!s) {
            const e = { instancePath: a + "/schema", schemaPath: "#/properties/schema/if", keyword: "if", params: { failingKeyword: l }, message: 'must match "' + l + '" schema' };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.content) {
        let t = e.content;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            if (Object.keys(t).length > 1) {
                const e = { instancePath: a + "/content", schemaPath: "#/properties/content/maxProperties", keyword: "maxProperties", params: { limit: 1 }, message: "must NOT have more than 1 properties" };
                null === p ? p = [e] : p.push(e), c++;
            }
            if (Object.keys(t).length < 1) {
                const e = { instancePath: a + "/content", schemaPath: "#/properties/content/minProperties", keyword: "minProperties", params: { limit: 1 }, message: "must NOT have fewer than 1 properties" };
                null === p ? p = [e] : p.push(e), c++;
            }
            for (const e in t)
                xt.validate(t[e], { instancePath: a + "/content/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? xt.validate.errors : p.concat(xt.validate.errors), c = p.length);
        }
        else {
            const e = { instancePath: a + "/content", schemaPath: "#/properties/content/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.examples) {
        let t = e.examples;
        if (t && "object" == typeof t && !Array.isArray(t))
            for (const e in t) {
                let r = t[e];
                const s = c;
                let n = !0;
                const l = c;
                if (c === l)
                    if (r && "object" == typeof r && !Array.isArray(r)) {
                        let e;
                        if (void 0 === r.$ref && (e = "$ref")) {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    }
                    else {
                        const e = {};
                        null === p ? p = [e] : p.push(e), c++;
                    }
                var h = l === c;
                let m;
                if (c = s, null !== p && (s ? p.length = s : p = null), h) {
                    const s = c;
                    if (dt(r, { instancePath: a + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                        var d = dt.evaluated.props;
                    else
                        p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                    n = h = s === c, m = "then";
                }
                else {
                    const s = c;
                    jt(r, { instancePath: a + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? jt.errors : p.concat(jt.errors), c = p.length), n = h = s === c, n && !0 !== d && (d = !0), m = "else";
                }
                if (!n) {
                    const t = { instancePath: a + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/examples/additionalProperties/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                    null === p ? p = [t] : p.push(t), c++;
                }
            }
        else {
            const e = { instancePath: a + "/examples", schemaPath: "#/properties/examples/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
}
else {
    const e = { instancePath: a, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === p ? p = [e] : p.push(e), c++;
} return Ot.errors = p, 0 === c; }
function Nt(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Nt.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("contentType" !== a && "headers" !== a && "style" !== a && "explode" !== a && "allowReserved" !== a) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === o ? o = [e] : o.push(e), i++;
        }
    if (void 0 !== e.contentType && "string" != typeof e.contentType) {
        const e = { instancePath: t + "/contentType", schemaPath: "#/properties/contentType/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.headers) {
        let a = e.headers;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Ot(a[e], { instancePath: t + "/headers/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ot.errors : o.concat(Ot.errors), i = o.length);
        else {
            const e = { instancePath: t + "/headers", schemaPath: "#/properties/headers/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.style) {
        let a = e.style;
        if ("form" !== a && "spaceDelimited" !== a && "pipeDelimited" !== a && "deepObject" !== a) {
            const e = { instancePath: t + "/style", schemaPath: "#/properties/style/enum", keyword: "enum", params: { allowedValues: qt.properties.style.enum }, message: "must be equal to one of the allowed values" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.explode && "boolean" != typeof e.explode) {
        const e = { instancePath: t + "/explode", schemaPath: "#/properties/explode/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.allowReserved && "boolean" != typeof e.allowReserved) {
        const e = { instancePath: t + "/allowReserved", schemaPath: "#/properties/allowReserved/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Nt.errors = o, 0 === i; }
function Ut(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Ut.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), ft(e, { instancePath: t, parentData: a, parentDataProperty: s, rootData: n, dynamicAnchors: o }) || (i = null === i ? ft.errors : i.concat(ft.errors), p = i.length), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("schema" !== a && "example" !== a && "examples" !== a && "encoding" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.schema) {
        let a = e.schema;
        const r = p;
        let s = !0;
        const c = p;
        if (p === c)
            if (a && "object" == typeof a && !Array.isArray(a)) {
                let e;
                if (void 0 === a.$ref && (e = "$ref")) {
                    const e = {};
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
            else {
                const e = {};
                null === i ? i = [e] : i.push(e), p++;
            }
        var l = c === p;
        let u;
        if (p = r, null !== i && (r ? i.length = r : i = null), l) {
            const r = p;
            if (dt(a, { instancePath: t + "/schema", parentData: e, parentDataProperty: "schema", rootData: n, dynamicAnchors: o }))
                var m = dt.evaluated.props;
            else
                i = null === i ? dt.errors : i.concat(dt.errors), p = i.length;
            s = l = r === p, u = "then";
        }
        else {
            const r = p;
            $t(a, { instancePath: t + "/schema", parentData: e, parentDataProperty: "schema", rootData: n, dynamicAnchors: o }) || (i = null === i ? $t.errors : i.concat($t.errors), p = i.length), s = l = r === p, s && !0 !== m && (m = !0), u = "else";
        }
        if (!s) {
            const e = { instancePath: t + "/schema", schemaPath: "#/properties/schema/if", keyword: "if", params: { failingKeyword: u }, message: 'must match "' + u + '" schema' };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.examples) {
        let a = e.examples;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a) {
                let r = a[e];
                const s = p;
                let c = !0;
                const l = p;
                if (p === l)
                    if (r && "object" == typeof r && !Array.isArray(r)) {
                        let e;
                        if (void 0 === r.$ref && (e = "$ref")) {
                            const e = {};
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                    else {
                        const e = {};
                        null === i ? i = [e] : i.push(e), p++;
                    }
                var u = l === p;
                let m;
                if (p = s, null !== i && (s ? i.length = s : i = null), u) {
                    const s = p;
                    if (dt(r, { instancePath: t + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }))
                        var h = dt.evaluated.props;
                    else
                        i = null === i ? dt.errors : i.concat(dt.errors), p = i.length;
                    c = u = s === p, m = "then";
                }
                else {
                    const s = p;
                    jt(r, { instancePath: t + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }) || (i = null === i ? jt.errors : i.concat(jt.errors), p = i.length), c = u = s === p, c && !0 !== h && (h = !0), m = "else";
                }
                if (!c) {
                    const a = { instancePath: t + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/examples/additionalProperties/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                    null === i ? i = [a] : i.push(a), p++;
                }
            }
        else {
            const e = { instancePath: t + "/examples", schemaPath: "#/properties/examples/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.encoding) {
        let a = e.encoding;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Nt(a[e], { instancePath: t + "/encoding/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }) || (i = null === i ? Nt.errors : i.concat(Nt.errors), p = i.length);
        else {
            const e = { instancePath: t + "/encoding", schemaPath: "#/properties/encoding/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Ut.errors = i, 0 === p; }
function Tt(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let p = null, c = 0; const l = Tt.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), ft(e, { instancePath: a, parentData: s, parentDataProperty: n, rootData: o, dynamicAnchors: i }) || (p = null === p ? ft.errors : p.concat(ft.errors), c = p.length), gt(e, { instancePath: a, parentData: s, parentDataProperty: n, rootData: o, dynamicAnchors: i }) || (p = null === p ? gt.errors : p.concat(gt.errors), c = p.length), bt(e, { instancePath: a, parentData: s, parentDataProperty: n, rootData: o, dynamicAnchors: i }) || (p = null === p ? bt.errors : p.concat(bt.errors), c = p.length), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: a, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === p ? p = [e] : p.push(e), c++;
    }
    for (const s in e)
        if (!t.call(yt.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === p ? p = [e] : p.push(e), c++;
        }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: a + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.in && "string" != typeof e.in) {
        const e = { instancePath: a + "/in", schemaPath: "#/properties/in/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: a + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.required && "boolean" != typeof e.required) {
        const e = { instancePath: a + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.deprecated && "boolean" != typeof e.deprecated) {
        const e = { instancePath: a + "/deprecated", schemaPath: "#/properties/deprecated/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.allowEmptyValue && "boolean" != typeof e.allowEmptyValue) {
        const e = { instancePath: a + "/allowEmptyValue", schemaPath: "#/properties/allowEmptyValue/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.style && "string" != typeof e.style) {
        const e = { instancePath: a + "/style", schemaPath: "#/properties/style/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.explode && "boolean" != typeof e.explode) {
        const e = { instancePath: a + "/explode", schemaPath: "#/properties/explode/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.allowReserved && "boolean" != typeof e.allowReserved) {
        const e = { instancePath: a + "/allowReserved", schemaPath: "#/properties/allowReserved/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.schema) {
        let t = e.schema;
        const r = c;
        let s = !0;
        const n = c;
        if (c === n)
            if (t && "object" == typeof t && !Array.isArray(t)) {
                let e;
                if (void 0 === t.$ref && (e = "$ref")) {
                    const e = {};
                    null === p ? p = [e] : p.push(e), c++;
                }
            }
            else {
                const e = {};
                null === p ? p = [e] : p.push(e), c++;
            }
        var m = n === c;
        let l;
        if (c = r, null !== p && (r ? p.length = r : p = null), m) {
            const r = c;
            if (dt(t, { instancePath: a + "/schema", parentData: e, parentDataProperty: "schema", rootData: o, dynamicAnchors: i }))
                var u = dt.evaluated.props;
            else
                p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
            s = m = r === c, l = "then";
        }
        else {
            const r = c;
            $t(t, { instancePath: a + "/schema", parentData: e, parentDataProperty: "schema", rootData: o, dynamicAnchors: i }) || (p = null === p ? $t.errors : p.concat($t.errors), c = p.length), s = m = r === c, s && !0 !== u && (u = !0), l = "else";
        }
        if (!s) {
            const e = { instancePath: a + "/schema", schemaPath: "#/properties/schema/if", keyword: "if", params: { failingKeyword: l }, message: 'must match "' + l + '" schema' };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.content) {
        let t = e.content;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            if (Object.keys(t).length > 1) {
                const e = { instancePath: a + "/content", schemaPath: "#/properties/content/maxProperties", keyword: "maxProperties", params: { limit: 1 }, message: "must NOT have more than 1 properties" };
                null === p ? p = [e] : p.push(e), c++;
            }
            if (Object.keys(t).length < 1) {
                const e = { instancePath: a + "/content", schemaPath: "#/properties/content/minProperties", keyword: "minProperties", params: { limit: 1 }, message: "must NOT have fewer than 1 properties" };
                null === p ? p = [e] : p.push(e), c++;
            }
            for (const e in t)
                Ut(t[e], { instancePath: a + "/content/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? Ut.errors : p.concat(Ut.errors), c = p.length);
        }
        else {
            const e = { instancePath: a + "/content", schemaPath: "#/properties/content/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.examples) {
        let t = e.examples;
        if (t && "object" == typeof t && !Array.isArray(t))
            for (const e in t) {
                let r = t[e];
                const s = c;
                let n = !0;
                const l = c;
                if (c === l)
                    if (r && "object" == typeof r && !Array.isArray(r)) {
                        let e;
                        if (void 0 === r.$ref && (e = "$ref")) {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    }
                    else {
                        const e = {};
                        null === p ? p = [e] : p.push(e), c++;
                    }
                var h = l === c;
                let m;
                if (c = s, null !== p && (s ? p.length = s : p = null), h) {
                    const s = c;
                    if (dt(r, { instancePath: a + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                        var d = dt.evaluated.props;
                    else
                        p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                    n = h = s === c, m = "then";
                }
                else {
                    const s = c;
                    jt(r, { instancePath: a + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? jt.errors : p.concat(jt.errors), c = p.length), n = h = s === c, n && !0 !== d && (d = !0), m = "else";
                }
                if (!n) {
                    const t = { instancePath: a + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/examples/additionalProperties/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                    null === p ? p = [t] : p.push(t), c++;
                }
            }
        else {
            const e = { instancePath: a + "/examples", schemaPath: "#/properties/examples/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
}
else {
    const e = { instancePath: a, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === p ? p = [e] : p.push(e), c++;
} return Tt.errors = p, 0 === c; }
Ot.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Nt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ut.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Tt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Mt = { type: "object", required: ["responses"], properties: { tags: { type: "array", items: { type: "string" } }, summary: { type: "string" }, description: { type: "string" }, externalDocs: { $ref: "#/definitions/ExternalDocumentation" }, operationId: { type: "string" }, parameters: { type: "array", items: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Parameter" } }, uniqueItems: !0 }, requestBody: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/RequestBody" } }, responses: { $ref: "#/definitions/Responses" }, callbacks: { type: "object", additionalProperties: { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Callback" } } }, deprecated: { type: "boolean", default: !1 }, security: { type: "array", items: { $ref: "#/definitions/SecurityRequirement" } }, servers: { type: "array", items: { $ref: "#/definitions/Server" } } }, patternProperties: { "^x-": {} }, additionalProperties: !1 };
function St(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = St.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.content) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "content" }, message: "must have required property 'content'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("description" !== a && "content" !== a && "required" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.content) {
        let a = e.content;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Ut(a[e], { instancePath: t + "/content/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ut.errors : i.concat(Ut.errors), p = i.length);
        else {
            const e = { instancePath: t + "/content", schemaPath: "#/properties/content/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.required && "boolean" != typeof e.required) {
        const e = { instancePath: t + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === i ? i = [e] : i.push(e), p++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return St.errors = i, 0 === p; }
St.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const zt = new RegExp("^[1-5](?:\\d{2}|XX)$", "u");
function Lt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Lt.evaluated; c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0); const l = p, m = p; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.operationId && (t = "operationId") || void 0 === e.operationRef && (t = "operationRef")) {
        const e = {};
        null === i ? i = [e] : i.push(e), p++;
    }
} if (m === p) {
    const e = { instancePath: t, schemaPath: "#/not", keyword: "not", params: {}, message: "must NOT be valid" };
    null === i ? i = [e] : i.push(e), p++;
}
else
    p = l, null !== i && (l ? i.length = l : i = null); if (e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("operationId" !== a && "operationRef" !== a && "parameters" !== a && "requestBody" !== a && "description" !== a && "server" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.operationId && "string" != typeof e.operationId) {
        const e = { instancePath: t + "/operationId", schemaPath: "#/properties/operationId/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.operationRef) {
        let a = e.operationRef;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/operationRef", schemaPath: "#/properties/operationRef/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/operationRef", schemaPath: "#/properties/operationRef/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.parameters) {
        let a = e.parameters;
        if (a && "object" == typeof a && !Array.isArray(a))
            ;
        else {
            const e = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    void 0 !== e.server && (ct(e.server, { instancePath: t + "/server", parentData: e, parentDataProperty: "server", rootData: n, dynamicAnchors: o }) || (i = null === i ? ct.errors : i.concat(ct.errors), p = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Lt.errors = i, 0 === p; }
function Rt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Rt.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.description) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "description" }, message: "must have required property 'description'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("description" !== a && "headers" !== a && "content" !== a && "links" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.headers) {
        let a = e.headers;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a) {
                let r = a[e];
                const s = p;
                let c = !0;
                const u = p;
                if (p === u)
                    if (r && "object" == typeof r && !Array.isArray(r)) {
                        let e;
                        if (void 0 === r.$ref && (e = "$ref")) {
                            const e = {};
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                    else {
                        const e = {};
                        null === i ? i = [e] : i.push(e), p++;
                    }
                var l = u === p;
                let h;
                if (p = s, null !== i && (s ? i.length = s : i = null), l) {
                    const s = p;
                    if (dt(r, { instancePath: t + "/headers/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }))
                        var m = dt.evaluated.props;
                    else
                        i = null === i ? dt.errors : i.concat(dt.errors), p = i.length;
                    c = l = s === p, h = "then";
                }
                else {
                    const s = p;
                    Ot(r, { instancePath: t + "/headers/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ot.errors : i.concat(Ot.errors), p = i.length), c = l = s === p, c && !0 !== m && (m = !0), h = "else";
                }
                if (!c) {
                    const a = { instancePath: t + "/headers/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/headers/additionalProperties/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
                    null === i ? i = [a] : i.push(a), p++;
                }
            }
        else {
            const e = { instancePath: t + "/headers", schemaPath: "#/properties/headers/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.content) {
        let a = e.content;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Ut(a[e], { instancePath: t + "/content/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ut.errors : i.concat(Ut.errors), p = i.length);
        else {
            const e = { instancePath: t + "/content", schemaPath: "#/properties/content/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.links) {
        let a = e.links;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a) {
                let r = a[e];
                const s = p;
                let c = !0;
                const l = p;
                if (p === l)
                    if (r && "object" == typeof r && !Array.isArray(r)) {
                        let e;
                        if (void 0 === r.$ref && (e = "$ref")) {
                            const e = {};
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                    else {
                        const e = {};
                        null === i ? i = [e] : i.push(e), p++;
                    }
                var u = l === p;
                let m;
                if (p = s, null !== i && (s ? i.length = s : i = null), u) {
                    const s = p;
                    if (dt(r, { instancePath: t + "/links/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }))
                        var h = dt.evaluated.props;
                    else
                        i = null === i ? dt.errors : i.concat(dt.errors), p = i.length;
                    c = u = s === p, m = "then";
                }
                else {
                    const s = p;
                    Lt(r, { instancePath: t + "/links/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }) || (i = null === i ? Lt.errors : i.concat(Lt.errors), p = i.length), c = u = s === p, c && !0 !== h && (h = !0), m = "else";
                }
                if (!c) {
                    const a = { instancePath: t + "/links/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/links/additionalProperties/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                    null === i ? i = [a] : i.push(a), p++;
                }
            }
        else {
            const e = { instancePath: t + "/links", schemaPath: "#/properties/links/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Rt.errors = i, 0 === p; }
function Ct(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Ct.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (Object.keys(e).length < 1) {
        const e = { instancePath: t, schemaPath: "#/minProperties", keyword: "minProperties", params: { limit: 1 }, message: "must NOT have fewer than 1 properties" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("default" !== a && !zt.test(a) && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.default) {
        let a = e.default;
        const r = p;
        let s = !0;
        const c = p;
        if (p === c)
            if (a && "object" == typeof a && !Array.isArray(a)) {
                let e;
                if (void 0 === a.$ref && (e = "$ref")) {
                    const e = {};
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
            else {
                const e = {};
                null === i ? i = [e] : i.push(e), p++;
            }
        var l = c === p;
        let u;
        if (p = r, null !== i && (r ? i.length = r : i = null), l) {
            const r = p;
            if (dt(a, { instancePath: t + "/default", parentData: e, parentDataProperty: "default", rootData: n, dynamicAnchors: o }))
                var m = dt.evaluated.props;
            else
                i = null === i ? dt.errors : i.concat(dt.errors), p = i.length;
            s = l = r === p, u = "then";
        }
        else {
            const r = p;
            Rt(a, { instancePath: t + "/default", parentData: e, parentDataProperty: "default", rootData: n, dynamicAnchors: o }) || (i = null === i ? Rt.errors : i.concat(Rt.errors), p = i.length), s = l = r === p, s && !0 !== m && (m = !0), u = "else";
        }
        if (!s) {
            const e = { instancePath: t + "/default", schemaPath: "#/properties/default/if", keyword: "if", params: { failingKeyword: u }, message: 'must match "' + u + '" schema' };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    for (const a in e)
        if (zt.test(a)) {
            let r = e[a];
            const s = p;
            let c = !0;
            const l = p;
            if (p === l)
                if (r && "object" == typeof r && !Array.isArray(r)) {
                    let e;
                    if (void 0 === r.$ref && (e = "$ref")) {
                        const e = {};
                        null === i ? i = [e] : i.push(e), p++;
                    }
                }
                else {
                    const e = {};
                    null === i ? i = [e] : i.push(e), p++;
                }
            var u = l === p;
            let m;
            if (p = s, null !== i && (s ? i.length = s : i = null), u) {
                const s = p;
                if (dt(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }))
                    var h = dt.evaluated.props;
                else
                    i = null === i ? dt.errors : i.concat(dt.errors), p = i.length;
                c = u = s === p, m = "then";
            }
            else {
                const s = p;
                Rt(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Rt.errors : i.concat(Rt.errors), p = i.length), c = u = s === p, c && !0 !== h && (h = !0), m = "else";
            }
            if (!c) {
                const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/patternProperties/%5E%5B1-5%5D(%3F%3A%5Cd%7B2%7D%7CXX)%24/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Ct.errors = i, 0 === p; }
Lt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Rt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ct.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Et = { validate: Ft };
function Vt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Vt.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e)
        r.test(a) || Et.validate(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Et.validate.errors : i.concat(Et.validate.errors), p = i.length);
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Vt.errors = i, 0 === p; }
function Kt(e, { instancePath: s = "", parentData: n, parentDataProperty: o, rootData: i = e, dynamicAnchors: p = {} } = {}) { let c = null, l = 0; const m = Kt.evaluated; if (m.dynamicProps && (m.props = void 0), m.dynamicItems && (m.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.responses) {
        const e = { instancePath: s, schemaPath: "#/required", keyword: "required", params: { missingProperty: "responses" }, message: "must have required property 'responses'" };
        null === c ? c = [e] : c.push(e), l++;
    }
    for (const a in e)
        if (!t.call(Mt.properties, a) && !r.test(a)) {
            const e = { instancePath: s, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === c ? c = [e] : c.push(e), l++;
        }
    if (void 0 !== e.tags) {
        let t = e.tags;
        if (Array.isArray(t)) {
            const e = t.length;
            for (let a = 0; a < e; a++)
                if ("string" != typeof t[a]) {
                    const e = { instancePath: s + "/tags/" + a, schemaPath: "#/properties/tags/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === c ? c = [e] : c.push(e), l++;
                }
        }
        else {
            const e = { instancePath: s + "/tags", schemaPath: "#/properties/tags/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: s + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: s + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.externalDocs && (it(e.externalDocs, { instancePath: s + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: i, dynamicAnchors: p }) || (c = null === c ? it.errors : c.concat(it.errors), l = c.length)), void 0 !== e.operationId && "string" != typeof e.operationId) {
        const e = { instancePath: s + "/operationId", schemaPath: "#/properties/operationId/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.parameters) {
        let t = e.parameters;
        if (Array.isArray(t)) {
            const e = t.length;
            for (let a = 0; a < e; a++) {
                let e = t[a];
                const r = l;
                let n = !0;
                const o = l;
                if (l === o)
                    if (e && "object" == typeof e && !Array.isArray(e)) {
                        let t;
                        if (void 0 === e.$ref && (t = "$ref")) {
                            const e = {};
                            null === c ? c = [e] : c.push(e), l++;
                        }
                    }
                    else {
                        const e = {};
                        null === c ? c = [e] : c.push(e), l++;
                    }
                var u = o === l;
                let m;
                if (l = r, null !== c && (r ? c.length = r : c = null), u) {
                    const r = l;
                    if (dt(e, { instancePath: s + "/parameters/" + a, parentData: t, parentDataProperty: a, rootData: i, dynamicAnchors: p }))
                        var h = dt.evaluated.props;
                    else
                        c = null === c ? dt.errors : c.concat(dt.errors), l = c.length;
                    n = u = r === l, m = "then";
                }
                else {
                    const r = l;
                    Tt(e, { instancePath: s + "/parameters/" + a, parentData: t, parentDataProperty: a, rootData: i, dynamicAnchors: p }) || (c = null === c ? Tt.errors : c.concat(Tt.errors), l = c.length), n = u = r === l, n && !0 !== h && (h = !0), m = "else";
                }
                if (!n) {
                    const e = { instancePath: s + "/parameters/" + a, schemaPath: "#/properties/parameters/items/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                    null === c ? c = [e] : c.push(e), l++;
                }
            }
            let r, n = t.length;
            if (n > 1)
                e: for (; n--;)
                    for (r = n; r--;)
                        if (a(t[n], t[r])) {
                            const e = { instancePath: s + "/parameters", schemaPath: "#/properties/parameters/uniqueItems", keyword: "uniqueItems", params: { i: n, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + n + " are identical)" };
                            null === c ? c = [e] : c.push(e), l++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: s + "/parameters", schemaPath: "#/properties/parameters/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.requestBody) {
        let t = e.requestBody;
        const a = l;
        let r = !0;
        const n = l;
        if (l === n)
            if (t && "object" == typeof t && !Array.isArray(t)) {
                let e;
                if (void 0 === t.$ref && (e = "$ref")) {
                    const e = {};
                    null === c ? c = [e] : c.push(e), l++;
                }
            }
            else {
                const e = {};
                null === c ? c = [e] : c.push(e), l++;
            }
        var d = n === l;
        let o;
        if (l = a, null !== c && (a ? c.length = a : c = null), d) {
            const a = l;
            if (dt(t, { instancePath: s + "/requestBody", parentData: e, parentDataProperty: "requestBody", rootData: i, dynamicAnchors: p }))
                var y = dt.evaluated.props;
            else
                c = null === c ? dt.errors : c.concat(dt.errors), l = c.length;
            r = d = a === l, o = "then";
        }
        else {
            const a = l;
            St(t, { instancePath: s + "/requestBody", parentData: e, parentDataProperty: "requestBody", rootData: i, dynamicAnchors: p }) || (c = null === c ? St.errors : c.concat(St.errors), l = c.length), r = d = a === l, r && !0 !== y && (y = !0), o = "else";
        }
        if (!r) {
            const e = { instancePath: s + "/requestBody", schemaPath: "#/properties/requestBody/if", keyword: "if", params: { failingKeyword: o }, message: 'must match "' + o + '" schema' };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.responses && (Ct(e.responses, { instancePath: s + "/responses", parentData: e, parentDataProperty: "responses", rootData: i, dynamicAnchors: p }) || (c = null === c ? Ct.errors : c.concat(Ct.errors), l = c.length)), void 0 !== e.callbacks) {
        let t = e.callbacks;
        if (t && "object" == typeof t && !Array.isArray(t))
            for (const e in t) {
                let a = t[e];
                const r = l;
                let n = !0;
                const o = l;
                if (l === o)
                    if (a && "object" == typeof a && !Array.isArray(a)) {
                        let e;
                        if (void 0 === a.$ref && (e = "$ref")) {
                            const e = {};
                            null === c ? c = [e] : c.push(e), l++;
                        }
                    }
                    else {
                        const e = {};
                        null === c ? c = [e] : c.push(e), l++;
                    }
                var f = o === l;
                let m;
                if (l = r, null !== c && (r ? c.length = r : c = null), f) {
                    const r = l;
                    if (dt(a, { instancePath: s + "/callbacks/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: i, dynamicAnchors: p }))
                        var P = dt.evaluated.props;
                    else
                        c = null === c ? dt.errors : c.concat(dt.errors), l = c.length;
                    n = f = r === l, m = "then";
                }
                else {
                    const r = l;
                    Vt(a, { instancePath: s + "/callbacks/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: i, dynamicAnchors: p }) || (c = null === c ? Vt.errors : c.concat(Vt.errors), l = c.length), n = f = r === l, n && !0 !== P && (P = !0), m = "else";
                }
                if (!n) {
                    const t = { instancePath: s + "/callbacks/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/callbacks/additionalProperties/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                    null === c ? c = [t] : c.push(t), l++;
                }
            }
        else {
            const e = { instancePath: s + "/callbacks", schemaPath: "#/properties/callbacks/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.deprecated && "boolean" != typeof e.deprecated) {
        const e = { instancePath: s + "/deprecated", schemaPath: "#/properties/deprecated/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === c ? c = [e] : c.push(e), l++;
    }
    if (void 0 !== e.security) {
        let t = e.security;
        if (Array.isArray(t)) {
            const e = t.length;
            for (let a = 0; a < e; a++)
                lt(t[a], { instancePath: s + "/security/" + a, parentData: t, parentDataProperty: a, rootData: i, dynamicAnchors: p }) || (c = null === c ? lt.errors : c.concat(lt.errors), l = c.length);
        }
        else {
            const e = { instancePath: s + "/security", schemaPath: "#/properties/security/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
    if (void 0 !== e.servers) {
        let t = e.servers;
        if (Array.isArray(t)) {
            const e = t.length;
            for (let a = 0; a < e; a++)
                ct(t[a], { instancePath: s + "/servers/" + a, parentData: t, parentDataProperty: a, rootData: i, dynamicAnchors: p }) || (c = null === c ? ct.errors : c.concat(ct.errors), l = c.length);
        }
        else {
            const e = { instancePath: s + "/servers", schemaPath: "#/properties/servers/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === c ? c = [e] : c.push(e), l++;
        }
    }
}
else {
    const e = { instancePath: s, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === c ? c = [e] : c.push(e), l++;
} return Kt.errors = c, 0 === l; }
function Ft(e, { instancePath: t = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let p = null, c = 0; const l = Ft.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("$ref" !== a && "summary" !== a && "description" !== a && "servers" !== a && "parameters" !== a && !ut.test(a) && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === p ? p = [e] : p.push(e), c++;
        }
    if (void 0 !== e.$ref && "string" != typeof e.$ref) {
        const e = { instancePath: t + "/$ref", schemaPath: "#/properties/%24ref/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: t + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.servers) {
        let a = e.servers;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                ct(a[r], { instancePath: t + "/servers/" + r, parentData: a, parentDataProperty: r, rootData: o, dynamicAnchors: i }) || (p = null === p ? ct.errors : p.concat(ct.errors), c = p.length);
        }
        else {
            const e = { instancePath: t + "/servers", schemaPath: "#/properties/servers/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.parameters) {
        let r = e.parameters;
        if (Array.isArray(r)) {
            const e = r.length;
            for (let a = 0; a < e; a++) {
                let e = r[a];
                const s = c;
                let n = !0;
                const l = c;
                if (c === l)
                    if (e && "object" == typeof e && !Array.isArray(e)) {
                        let t;
                        if (void 0 === e.$ref && (t = "$ref")) {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    }
                    else {
                        const e = {};
                        null === p ? p = [e] : p.push(e), c++;
                    }
                var m = l === c;
                let h;
                if (c = s, null !== p && (s ? p.length = s : p = null), m) {
                    const s = c;
                    if (dt(e, { instancePath: t + "/parameters/" + a, parentData: r, parentDataProperty: a, rootData: o, dynamicAnchors: i }))
                        var u = dt.evaluated.props;
                    else
                        p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                    n = m = s === c, h = "then";
                }
                else {
                    const s = c;
                    Tt(e, { instancePath: t + "/parameters/" + a, parentData: r, parentDataProperty: a, rootData: o, dynamicAnchors: i }) || (p = null === p ? Tt.errors : p.concat(Tt.errors), c = p.length), n = m = s === c, n && !0 !== u && (u = !0), h = "else";
                }
                if (!n) {
                    const e = { instancePath: t + "/parameters/" + a, schemaPath: "#/properties/parameters/items/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
                    null === p ? p = [e] : p.push(e), c++;
                }
            }
            let s, n = r.length;
            if (n > 1)
                e: for (; n--;)
                    for (s = n; s--;)
                        if (a(r[n], r[s])) {
                            const e = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/uniqueItems", keyword: "uniqueItems", params: { i: n, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + n + " are identical)" };
                            null === p ? p = [e] : p.push(e), c++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    for (const a in e)
        ut.test(a) && (Kt(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: o, dynamicAnchors: i }) || (p = null === p ? Kt.errors : p.concat(Kt.errors), c = p.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === p ? p = [e] : p.push(e), c++;
} return Ft.errors = p, 0 === c; }
function Bt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: o = e, dynamicAnchors: i = {} } = {}) { let p = null, c = 0; const l = Bt.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if (!n.test(a) && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === p ? p = [e] : p.push(e), c++;
        }
    for (const a in e)
        n.test(a) && (Ft(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: o, dynamicAnchors: i }) || (p = null === p ? Ft.errors : p.concat(Ft.errors), c = p.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === p ? p = [e] : p.push(e), c++;
} return Bt.errors = p, 0 === c; }
Vt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Kt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ft.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Bt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const _t = { type: "object", properties: { schemas: { type: "object", patternProperties: { "^[a-zA-Z0-9\\.\\-_]+$": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Schema" } } } }, responses: { type: "object", patternProperties: { "^[a-zA-Z0-9\\.\\-_]+$": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Response" } } } }, parameters: { type: "object", patternProperties: { "^[a-zA-Z0-9\\.\\-_]+$": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Parameter" } } } }, examples: { type: "object", patternProperties: { "^[a-zA-Z0-9\\.\\-_]+$": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Example" } } } }, requestBodies: { type: "object", patternProperties: { "^[a-zA-Z0-9\\.\\-_]+$": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/RequestBody" } } } }, headers: { type: "object", patternProperties: { "^[a-zA-Z0-9\\.\\-_]+$": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Header" } } } }, securitySchemes: { type: "object", patternProperties: { "^[a-zA-Z0-9\\.\\-_]+$": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/SecurityScheme" } } } }, links: { type: "object", patternProperties: { "^[a-zA-Z0-9\\.\\-_]+$": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Link" } } } }, callbacks: { type: "object", patternProperties: { "^[a-zA-Z0-9\\.\\-_]+$": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/definitions/Reference" }, else: { $ref: "#/definitions/Callback" } } } } }, patternProperties: { "^x-": {} }, additionalProperties: !1 }, Zt = new RegExp("^[a-zA-Z0-9\\.\\-_]+$", "u"), Ht = { if: { type: "object", properties: { type: { const: "apiKey" } }, required: ["type"] }, then: { $ref: "#/definitions/APIKeySecurityScheme" }, else: { if: { type: "object", properties: { type: { const: "apiKey" } }, required: ["type"] }, then: { $ref: "#/definitions/HTTPSecurityScheme" }, else: { if: { type: "object", properties: { type: { const: "oauth2" } }, required: ["type"] }, then: { $ref: "#/definitions/OAuth2SecurityScheme" }, else: { if: { type: "object", properties: { type: { const: "openIdConnect" } }, required: ["type"] }, then: { $ref: "#/definitions/OpenIdConnectSecurityScheme" }, else: { type: "object", properties: { type: { enum: ["apiKey", "http", "oauth2", "openIdConnect"] } }, required: ["type"], errorMessage: { required: "Security scheme must have a valid type", type: "Invalid security scheme" } } } } } }, Xt = { type: "object", required: ["type", "name", "in"], properties: { type: { const: "apiKey" }, name: { type: "string" }, in: { enum: ["header", "query", "cookie"] }, description: { type: "string" } }, patternProperties: { "^x-": {} }, additionalProperties: !1 };
function Gt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Gt.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.in) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "in" }, message: "must have required property 'in'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("type" !== a && "name" !== a && "in" !== a && "description" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.type && "apiKey" !== e.type) {
        const e = { instancePath: t + "/type", schemaPath: "#/properties/type/const", keyword: "const", params: { allowedValue: "apiKey" }, message: "must be equal to constant" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.in) {
        let a = e.in;
        if ("header" !== a && "query" !== a && "cookie" !== a) {
            const e = { instancePath: t + "/in", schemaPath: "#/properties/in/enum", keyword: "enum", params: { allowedValues: Xt.properties.in.enum }, message: "must be equal to one of the allowed values" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Gt.errors = i, 0 === p; }
function Jt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Jt.evaluated; c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0); const l = p; let m = !1, u = null; const h = p; if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.scheme && "bearer" !== e.scheme) {
    const e = { instancePath: t + "/scheme", schemaPath: "#/oneOf/0/properties/scheme/const", keyword: "const", params: { allowedValue: "bearer" }, message: "must be equal to constant" };
    null === i ? i = [e] : i.push(e), p++;
} if (h === p) {
    m = !0, u = 0;
    var d = { scheme: !0 };
} const y = p, f = p, P = p; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.bearerFormat && (t = "bearerFormat")) {
        const e = {};
        null === i ? i = [e] : i.push(e), p++;
    }
} var g; if (P === p) {
    const e = { instancePath: t, schemaPath: "#/oneOf/1/not", keyword: "not", params: {}, message: "must NOT be valid" };
    null === i ? i = [e] : i.push(e), p++;
}
else
    p = f, null !== i && (f ? i.length = f : i = null); if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.scheme) {
    const a = p, r = p;
    if ("bearer" !== e.scheme) {
        const e = {};
        null === i ? i = [e] : i.push(e), p++;
    }
    if (r === p) {
        const e = { instancePath: t + "/scheme", schemaPath: "#/oneOf/1/properties/scheme/not", keyword: "not", params: {}, message: "must NOT be valid" };
        null === i ? i = [e] : i.push(e), p++;
    }
    else
        p = a, null !== i && (a ? i.length = a : i = null);
} if ((g = y === p) && m ? (m = !1, u = [u, 1]) : g && (m = !0, u = 1, !0 !== d && ((d = d || {}).scheme = !0)), m)
    p = l, null !== i && (l ? i.length = l : i = null);
else {
    const e = { instancePath: t, schemaPath: "#/oneOf", keyword: "oneOf", params: { passingSchemas: u }, message: "must match exactly one schema in oneOf" };
    null === i ? i = [e] : i.push(e), p++;
} if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.scheme) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scheme" }, message: "must have required property 'scheme'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("scheme" !== a && "bearerFormat" !== a && "description" !== a && "type" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.scheme && "string" != typeof e.scheme) {
        const e = { instancePath: t + "/scheme", schemaPath: "#/properties/scheme/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.bearerFormat && "string" != typeof e.bearerFormat) {
        const e = { instancePath: t + "/bearerFormat", schemaPath: "#/properties/bearerFormat/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.type) {
        let a = e.type;
        if ("string" != typeof a) {
            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
        if ("http" !== a) {
            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/const", keyword: "const", params: { allowedValue: "http" }, message: "must be equal to constant" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Jt.errors = i, 0 === p; }
function Wt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Wt.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.authorizationUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "authorizationUrl" }, message: "must have required property 'authorizationUrl'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("authorizationUrl" !== a && "refreshUrl" !== a && "scopes" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.authorizationUrl) {
        let a = e.authorizationUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.refreshUrl) {
        let a = e.refreshUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.scopes) {
        let a = e.scopes;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            for (const e in a)
                if ("string" != typeof a[e]) {
                    const a = { instancePath: t + "/scopes/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/scopes/additionalProperties/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === i ? i = [a] : i.push(a), p++;
                }
        }
        else {
            const e = { instancePath: t + "/scopes", schemaPath: "#/properties/scopes/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Wt.errors = i, 0 === p; }
function Yt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Yt.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.tokenUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "tokenUrl" }, message: "must have required property 'tokenUrl'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("tokenUrl" !== a && "refreshUrl" !== a && "scopes" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.tokenUrl) {
        let a = e.tokenUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.refreshUrl) {
        let a = e.refreshUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.scopes) {
        let a = e.scopes;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            for (const e in a)
                if ("string" != typeof a[e]) {
                    const a = { instancePath: t + "/scopes/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/scopes/additionalProperties/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === i ? i = [a] : i.push(a), p++;
                }
        }
        else {
            const e = { instancePath: t + "/scopes", schemaPath: "#/properties/scopes/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Yt.errors = i, 0 === p; }
function Qt(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Qt.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.tokenUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "tokenUrl" }, message: "must have required property 'tokenUrl'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("tokenUrl" !== a && "refreshUrl" !== a && "scopes" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.tokenUrl) {
        let a = e.tokenUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.refreshUrl) {
        let a = e.refreshUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.scopes) {
        let a = e.scopes;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            for (const e in a)
                if ("string" != typeof a[e]) {
                    const a = { instancePath: t + "/scopes/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/scopes/additionalProperties/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === i ? i = [a] : i.push(a), p++;
                }
        }
        else {
            const e = { instancePath: t + "/scopes", schemaPath: "#/properties/scopes/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Qt.errors = i, 0 === p; }
function ea(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = ea.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.authorizationUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "authorizationUrl" }, message: "must have required property 'authorizationUrl'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.tokenUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "tokenUrl" }, message: "must have required property 'tokenUrl'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("authorizationUrl" !== a && "tokenUrl" !== a && "refreshUrl" !== a && "scopes" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.authorizationUrl) {
        let a = e.authorizationUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.tokenUrl) {
        let a = e.tokenUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.refreshUrl) {
        let a = e.refreshUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.scopes) {
        let a = e.scopes;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            for (const e in a)
                if ("string" != typeof a[e]) {
                    const a = { instancePath: t + "/scopes/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/scopes/additionalProperties/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === i ? i = [a] : i.push(a), p++;
                }
        }
        else {
            const e = { instancePath: t + "/scopes", schemaPath: "#/properties/scopes/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return ea.errors = i, 0 === p; }
function ta(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = ta.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("implicit" !== a && "password" !== a && "clientCredentials" !== a && "authorizationCode" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    void 0 !== e.implicit && (Wt(e.implicit, { instancePath: t + "/implicit", parentData: e, parentDataProperty: "implicit", rootData: n, dynamicAnchors: o }) || (i = null === i ? Wt.errors : i.concat(Wt.errors), p = i.length)), void 0 !== e.password && (Yt(e.password, { instancePath: t + "/password", parentData: e, parentDataProperty: "password", rootData: n, dynamicAnchors: o }) || (i = null === i ? Yt.errors : i.concat(Yt.errors), p = i.length)), void 0 !== e.clientCredentials && (Qt(e.clientCredentials, { instancePath: t + "/clientCredentials", parentData: e, parentDataProperty: "clientCredentials", rootData: n, dynamicAnchors: o }) || (i = null === i ? Qt.errors : i.concat(Qt.errors), p = i.length)), void 0 !== e.authorizationCode && (ea(e.authorizationCode, { instancePath: t + "/authorizationCode", parentData: e, parentDataProperty: "authorizationCode", rootData: n, dynamicAnchors: o }) || (i = null === i ? ea.errors : i.concat(ea.errors), p = i.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return ta.errors = i, 0 === p; }
function aa(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = aa.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.flows) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "flows" }, message: "must have required property 'flows'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("type" !== a && "flows" !== a && "description" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.type && "oauth2" !== e.type) {
        const e = { instancePath: t + "/type", schemaPath: "#/properties/type/const", keyword: "const", params: { allowedValue: "oauth2" }, message: "must be equal to constant" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.flows && (ta(e.flows, { instancePath: t + "/flows", parentData: e, parentDataProperty: "flows", rootData: n, dynamicAnchors: o }) || (i = null === i ? ta.errors : i.concat(ta.errors), p = i.length)), void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return aa.errors = i, 0 === p; }
function ra(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = ra.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.openIdConnectUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "openIdConnectUrl" }, message: "must have required property 'openIdConnectUrl'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    for (const a in e)
        if ("type" !== a && "openIdConnectUrl" !== a && "description" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === i ? i = [e] : i.push(e), p++;
        }
    if (void 0 !== e.type && "openIdConnect" !== e.type) {
        const e = { instancePath: t + "/type", schemaPath: "#/properties/type/const", keyword: "const", params: { allowedValue: "openIdConnect" }, message: "must be equal to constant" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.openIdConnectUrl) {
        let a = e.openIdConnectUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/openIdConnectUrl", schemaPath: "#/properties/openIdConnectUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/openIdConnectUrl", schemaPath: "#/properties/openIdConnectUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return ra.errors = i, 0 === p; }
function sa(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = sa.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.type && (t = "type")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
        else if (void 0 !== e.type && "apiKey" !== e.type) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (Gt(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Gt.errors : o.concat(Gt.errors), i = o.length), l = u = p === i, l)
        var d = !0;
    h = "then";
}
else {
    const p = i, c = i;
    let m = !0;
    const D = i;
    if (i === D)
        if (e && "object" == typeof e && !Array.isArray(e)) {
            let t;
            if (void 0 === e.type && (t = "type")) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
            else if (void 0 !== e.type && "apiKey" !== e.type) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    var y = D === i;
    let w;
    if (i = c, null !== o && (c ? o.length = c : o = null), y) {
        const p = i;
        if (Jt(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Jt.errors : o.concat(Jt.errors), i = o.length), m = y = p === i, m)
            var f = !0;
        w = "then";
    }
    else {
        const p = i, c = i;
        let l = !0;
        const u = i;
        if (i === u)
            if (e && "object" == typeof e && !Array.isArray(e)) {
                let t;
                if (void 0 === e.type && (t = "type")) {
                    const e = {};
                    null === o ? o = [e] : o.push(e), i++;
                }
                else if (void 0 !== e.type && "oauth2" !== e.type) {
                    const e = {};
                    null === o ? o = [e] : o.push(e), i++;
                }
            }
            else {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
        var P = u === i;
        let h;
        if (i = c, null !== o && (c ? o.length = c : o = null), P) {
            const p = i;
            if (aa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? aa.errors : o.concat(aa.errors), i = o.length), l = P = p === i, l)
                var g = !0;
            h = "then";
        }
        else {
            const p = i, c = i;
            let m = !0;
            const u = i;
            if (i === u)
                if (e && "object" == typeof e && !Array.isArray(e)) {
                    let t;
                    if (void 0 === e.type && (t = "type")) {
                        const e = {};
                        null === o ? o = [e] : o.push(e), i++;
                    }
                    else if (void 0 !== e.type && "openIdConnect" !== e.type) {
                        const e = {};
                        null === o ? o = [e] : o.push(e), i++;
                    }
                }
                else {
                    const e = {};
                    null === o ? o = [e] : o.push(e), i++;
                }
            var v = u === i;
            let d;
            if (i = c, null !== o && (c ? o.length = c : o = null), v) {
                const p = i;
                if (ra(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? ra.errors : o.concat(ra.errors), i = o.length), m = v = p === i, m)
                    var b = !0;
                d = "then";
            }
            else {
                const a = i;
                if (e && "object" == typeof e && !Array.isArray(e)) {
                    if (void 0 === e.type) {
                        const e = { instancePath: t, schemaPath: "#/else/else/else/else/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
                        null === o ? o = [e] : o.push(e), i++;
                    }
                    if (void 0 !== e.type) {
                        let a = e.type;
                        if ("apiKey" !== a && "http" !== a && "oauth2" !== a && "openIdConnect" !== a) {
                            const e = { instancePath: t + "/type", schemaPath: "#/else/else/else/else/properties/type/enum", keyword: "enum", params: { allowedValues: Ht.else.else.else.else.properties.type.enum }, message: "must be equal to one of the allowed values" };
                            null === o ? o = [e] : o.push(e), i++;
                        }
                    }
                }
                else {
                    const e = { instancePath: t, schemaPath: "#/else/else/else/else/type", keyword: "type", params: { type: "object" }, message: "must be object" };
                    null === o ? o = [e] : o.push(e), i++;
                }
                if (i > 0) {
                    const e = { required: [], type: [] }, a = {};
                    for (const a of o)
                        "errorMessage" !== a.keyword && !a.emUsed && a.instancePath === t && a.keyword in e && 0 === a.schemaPath.indexOf("#/else/else/else/else") && /^\/[^\/]*$/.test(a.schemaPath.slice(21)) && (e[a.keyword].push(a), a.emUsed = !0);
                    for (const r in e)
                        if (e[r].length) {
                            const s = { instancePath: t, schemaPath: "#/else/else/else/else/errorMessage", keyword: "errorMessage", params: { errors: e[r] }, message: r in a ? a[r]() : Ht.else.else.else.else.errorMessage[r] };
                            null === o ? o = [s] : o.push(s), i++;
                        }
                    const r = [];
                    for (const e of o)
                        e.emUsed || r.push(e);
                    o = r, i = r.length;
                }
                m = v = a === i, m && !0 !== b && ((b = b || {}).type = !0), d = "else";
            }
            if (!m) {
                const e = { instancePath: t, schemaPath: "#/else/else/else/if", keyword: "if", params: { failingKeyword: d }, message: 'must match "' + d + '" schema' };
                null === o ? o = [e] : o.push(e), i++;
            }
            l = P = p === i, l && !0 !== g && void 0 !== b && (!0 === b ? g = !0 : (g = g || {}, Object.assign(g, b))), h = "else";
        }
        if (!l) {
            const e = { instancePath: t, schemaPath: "#/else/else/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
            null === o ? o = [e] : o.push(e), i++;
        }
        m = y = p === i, m && !0 !== f && void 0 !== g && (!0 === g ? f = !0 : (f = f || {}, Object.assign(f, g))), w = "else";
    }
    if (!m) {
        const e = { instancePath: t, schemaPath: "#/else/if", keyword: "if", params: { failingKeyword: w }, message: 'must match "' + w + '" schema' };
        null === o ? o = [e] : o.push(e), i++;
    }
    l = u = p === i, l && !0 !== d && void 0 !== f && (!0 === f ? d = !0 : (d = d || {}, Object.assign(d, f))), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return sa.errors = o, p.props = d, 0 === i; }
function na(e, { instancePath: a = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let p = null, c = 0; const l = na.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const s in e)
        if (!t.call(_t.properties, s) && !r.test(s)) {
            const e = { instancePath: a, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: s }, message: "must NOT have additional properties" };
            null === p ? p = [e] : p.push(e), c++;
        }
    if (void 0 !== e.schemas) {
        let t = e.schemas;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            var m = {};
            for (const e in t)
                if (Zt.test(e)) {
                    let r = t[e];
                    const s = c;
                    let n = !0;
                    const l = c;
                    if (c === l)
                        if (r && "object" == typeof r && !Array.isArray(r)) {
                            let e;
                            if (void 0 === r.$ref && (e = "$ref")) {
                                const e = {};
                                null === p ? p = [e] : p.push(e), c++;
                            }
                        }
                        else {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    var u = l === c;
                    let d;
                    if (c = s, null !== p && (s ? p.length = s : p = null), u) {
                        const s = c;
                        if (dt(r, { instancePath: a + "/schemas/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                            var h = dt.evaluated.props;
                        else
                            p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                        n = u = s === c, d = "then";
                    }
                    else {
                        const s = c;
                        $t(r, { instancePath: a + "/schemas/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? $t.errors : p.concat($t.errors), c = p.length), n = u = s === c, n && !0 !== h && (h = !0), d = "else";
                    }
                    if (!n) {
                        const t = { instancePath: a + "/schemas/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/schemas/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/if", keyword: "if", params: { failingKeyword: d }, message: 'must match "' + d + '" schema' };
                        null === p ? p = [t] : p.push(t), c++;
                    }
                    m[e] = !0;
                }
        }
        else {
            const e = { instancePath: a + "/schemas", schemaPath: "#/properties/schemas/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.responses) {
        let t = e.responses;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            var d = {};
            for (const e in t)
                if (Zt.test(e)) {
                    let r = t[e];
                    const s = c;
                    let n = !0;
                    const l = c;
                    if (c === l)
                        if (r && "object" == typeof r && !Array.isArray(r)) {
                            let e;
                            if (void 0 === r.$ref && (e = "$ref")) {
                                const e = {};
                                null === p ? p = [e] : p.push(e), c++;
                            }
                        }
                        else {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    var y = l === c;
                    let m;
                    if (c = s, null !== p && (s ? p.length = s : p = null), y) {
                        const s = c;
                        if (dt(r, { instancePath: a + "/responses/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                            var f = dt.evaluated.props;
                        else
                            p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                        n = y = s === c, m = "then";
                    }
                    else {
                        const s = c;
                        Rt(r, { instancePath: a + "/responses/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? Rt.errors : p.concat(Rt.errors), c = p.length), n = y = s === c, n && !0 !== f && (f = !0), m = "else";
                    }
                    if (!n) {
                        const t = { instancePath: a + "/responses/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/responses/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                        null === p ? p = [t] : p.push(t), c++;
                    }
                    d[e] = !0;
                }
        }
        else {
            const e = { instancePath: a + "/responses", schemaPath: "#/properties/responses/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.parameters) {
        let t = e.parameters;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            var P = {};
            for (const e in t)
                if (Zt.test(e)) {
                    let r = t[e];
                    const s = c;
                    let n = !0;
                    const l = c;
                    if (c === l)
                        if (r && "object" == typeof r && !Array.isArray(r)) {
                            let e;
                            if (void 0 === r.$ref && (e = "$ref")) {
                                const e = {};
                                null === p ? p = [e] : p.push(e), c++;
                            }
                        }
                        else {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    var g = l === c;
                    let m;
                    if (c = s, null !== p && (s ? p.length = s : p = null), g) {
                        const s = c;
                        if (dt(r, { instancePath: a + "/parameters/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                            var v = dt.evaluated.props;
                        else
                            p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                        n = g = s === c, m = "then";
                    }
                    else {
                        const s = c;
                        Tt(r, { instancePath: a + "/parameters/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? Tt.errors : p.concat(Tt.errors), c = p.length), n = g = s === c, n && !0 !== v && (v = !0), m = "else";
                    }
                    if (!n) {
                        const t = { instancePath: a + "/parameters/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/parameters/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                        null === p ? p = [t] : p.push(t), c++;
                    }
                    P[e] = !0;
                }
        }
        else {
            const e = { instancePath: a + "/parameters", schemaPath: "#/properties/parameters/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.examples) {
        let t = e.examples;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            var b = {};
            for (const e in t)
                if (Zt.test(e)) {
                    let r = t[e];
                    const s = c;
                    let n = !0;
                    const l = c;
                    if (c === l)
                        if (r && "object" == typeof r && !Array.isArray(r)) {
                            let e;
                            if (void 0 === r.$ref && (e = "$ref")) {
                                const e = {};
                                null === p ? p = [e] : p.push(e), c++;
                            }
                        }
                        else {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    var D = l === c;
                    let m;
                    if (c = s, null !== p && (s ? p.length = s : p = null), D) {
                        const s = c;
                        if (dt(r, { instancePath: a + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                            var w = dt.evaluated.props;
                        else
                            p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                        n = D = s === c, m = "then";
                    }
                    else {
                        const s = c;
                        jt(r, { instancePath: a + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? jt.errors : p.concat(jt.errors), c = p.length), n = D = s === c, n && !0 !== w && (w = !0), m = "else";
                    }
                    if (!n) {
                        const t = { instancePath: a + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/examples/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                        null === p ? p = [t] : p.push(t), c++;
                    }
                    b[e] = !0;
                }
        }
        else {
            const e = { instancePath: a + "/examples", schemaPath: "#/properties/examples/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.requestBodies) {
        let t = e.requestBodies;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            var A = {};
            for (const e in t)
                if (Zt.test(e)) {
                    let r = t[e];
                    const s = c;
                    let n = !0;
                    const l = c;
                    if (c === l)
                        if (r && "object" == typeof r && !Array.isArray(r)) {
                            let e;
                            if (void 0 === r.$ref && (e = "$ref")) {
                                const e = {};
                                null === p ? p = [e] : p.push(e), c++;
                            }
                        }
                        else {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    var k = l === c;
                    let m;
                    if (c = s, null !== p && (s ? p.length = s : p = null), k) {
                        const s = c;
                        if (dt(r, { instancePath: a + "/requestBodies/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                            var $ = dt.evaluated.props;
                        else
                            p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                        n = k = s === c, m = "then";
                    }
                    else {
                        const s = c;
                        St(r, { instancePath: a + "/requestBodies/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? St.errors : p.concat(St.errors), c = p.length), n = k = s === c, n && !0 !== $ && ($ = !0), m = "else";
                    }
                    if (!n) {
                        const t = { instancePath: a + "/requestBodies/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/requestBodies/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                        null === p ? p = [t] : p.push(t), c++;
                    }
                    A[e] = !0;
                }
        }
        else {
            const e = { instancePath: a + "/requestBodies", schemaPath: "#/properties/requestBodies/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.headers) {
        let t = e.headers;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            var j = {};
            for (const e in t)
                if (Zt.test(e)) {
                    let r = t[e];
                    const s = c;
                    let n = !0;
                    const l = c;
                    if (c === l)
                        if (r && "object" == typeof r && !Array.isArray(r)) {
                            let e;
                            if (void 0 === r.$ref && (e = "$ref")) {
                                const e = {};
                                null === p ? p = [e] : p.push(e), c++;
                            }
                        }
                        else {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    var q = l === c;
                    let m;
                    if (c = s, null !== p && (s ? p.length = s : p = null), q) {
                        const s = c;
                        if (dt(r, { instancePath: a + "/headers/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                            var I = dt.evaluated.props;
                        else
                            p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                        n = q = s === c, m = "then";
                    }
                    else {
                        const s = c;
                        Ot(r, { instancePath: a + "/headers/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? Ot.errors : p.concat(Ot.errors), c = p.length), n = q = s === c, n && !0 !== I && (I = !0), m = "else";
                    }
                    if (!n) {
                        const t = { instancePath: a + "/headers/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/headers/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                        null === p ? p = [t] : p.push(t), c++;
                    }
                    j[e] = !0;
                }
        }
        else {
            const e = { instancePath: a + "/headers", schemaPath: "#/properties/headers/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.securitySchemes) {
        let t = e.securitySchemes;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            var x = {};
            for (const e in t)
                if (Zt.test(e)) {
                    let r = t[e];
                    const s = c;
                    let n = !0;
                    const l = c;
                    if (c === l)
                        if (r && "object" == typeof r && !Array.isArray(r)) {
                            let e;
                            if (void 0 === r.$ref && (e = "$ref")) {
                                const e = {};
                                null === p ? p = [e] : p.push(e), c++;
                            }
                        }
                        else {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    var O = l === c;
                    let m;
                    if (c = s, null !== p && (s ? p.length = s : p = null), O) {
                        const s = c;
                        if (dt(r, { instancePath: a + "/securitySchemes/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                            var N = dt.evaluated.props;
                        else
                            p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                        n = O = s === c, m = "then";
                    }
                    else {
                        const s = c;
                        if (sa(r, { instancePath: a + "/securitySchemes/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                            var U = sa.evaluated.props;
                        else
                            p = null === p ? sa.errors : p.concat(sa.errors), c = p.length;
                        n = O = s === c, n && !0 !== N && void 0 !== U && (!0 === U ? N = !0 : (N = N || {}, Object.assign(N, U))), m = "else";
                    }
                    if (!n) {
                        const t = { instancePath: a + "/securitySchemes/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/securitySchemes/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                        null === p ? p = [t] : p.push(t), c++;
                    }
                    x[e] = !0;
                }
        }
        else {
            const e = { instancePath: a + "/securitySchemes", schemaPath: "#/properties/securitySchemes/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.links) {
        let t = e.links;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            var T = {};
            for (const e in t)
                if (Zt.test(e)) {
                    let r = t[e];
                    const s = c;
                    let n = !0;
                    const l = c;
                    if (c === l)
                        if (r && "object" == typeof r && !Array.isArray(r)) {
                            let e;
                            if (void 0 === r.$ref && (e = "$ref")) {
                                const e = {};
                                null === p ? p = [e] : p.push(e), c++;
                            }
                        }
                        else {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    var M = l === c;
                    let m;
                    if (c = s, null !== p && (s ? p.length = s : p = null), M) {
                        const s = c;
                        if (dt(r, { instancePath: a + "/links/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                            var S = dt.evaluated.props;
                        else
                            p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                        n = M = s === c, m = "then";
                    }
                    else {
                        const s = c;
                        Lt(r, { instancePath: a + "/links/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? Lt.errors : p.concat(Lt.errors), c = p.length), n = M = s === c, n && !0 !== S && (S = !0), m = "else";
                    }
                    if (!n) {
                        const t = { instancePath: a + "/links/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/links/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                        null === p ? p = [t] : p.push(t), c++;
                    }
                    T[e] = !0;
                }
        }
        else {
            const e = { instancePath: a + "/links", schemaPath: "#/properties/links/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.callbacks) {
        let t = e.callbacks;
        if (t && "object" == typeof t && !Array.isArray(t)) {
            var z = {};
            for (const e in t)
                if (Zt.test(e)) {
                    let r = t[e];
                    const s = c;
                    let n = !0;
                    const l = c;
                    if (c === l)
                        if (r && "object" == typeof r && !Array.isArray(r)) {
                            let e;
                            if (void 0 === r.$ref && (e = "$ref")) {
                                const e = {};
                                null === p ? p = [e] : p.push(e), c++;
                            }
                        }
                        else {
                            const e = {};
                            null === p ? p = [e] : p.push(e), c++;
                        }
                    var L = l === c;
                    let m;
                    if (c = s, null !== p && (s ? p.length = s : p = null), L) {
                        const s = c;
                        if (dt(r, { instancePath: a + "/callbacks/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }))
                            var R = dt.evaluated.props;
                        else
                            p = null === p ? dt.errors : p.concat(dt.errors), c = p.length;
                        n = L = s === c, m = "then";
                    }
                    else {
                        const s = c;
                        Vt(r, { instancePath: a + "/callbacks/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: t, parentDataProperty: e, rootData: o, dynamicAnchors: i }) || (p = null === p ? Vt.errors : p.concat(Vt.errors), c = p.length), n = L = s === c, n && !0 !== R && (R = !0), m = "else";
                    }
                    if (!n) {
                        const t = { instancePath: a + "/callbacks/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/callbacks/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/if", keyword: "if", params: { failingKeyword: m }, message: 'must match "' + m + '" schema' };
                        null === p ? p = [t] : p.push(t), c++;
                    }
                    z[e] = !0;
                }
        }
        else {
            const e = { instancePath: a + "/callbacks", schemaPath: "#/properties/callbacks/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
}
else {
    const e = { instancePath: a, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === p ? p = [e] : p.push(e), c++;
} return na.errors = p, 0 === c; }
function oa(e, { instancePath: t = "", parentData: s, parentDataProperty: n, rootData: o = e, dynamicAnchors: i = {} } = {}) { let p = null, c = 0; const l = oa.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.openapi) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "openapi" }, message: "must have required property 'openapi'" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 === e.info) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "info" }, message: "must have required property 'info'" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 === e.paths) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "paths" }, message: "must have required property 'paths'" };
        null === p ? p = [e] : p.push(e), c++;
    }
    for (const a in e)
        if ("openapi" !== a && "info" !== a && "externalDocs" !== a && "servers" !== a && "security" !== a && "tags" !== a && "paths" !== a && "components" !== a && !r.test(a)) {
            const e = { instancePath: t, schemaPath: "#/additionalProperties", keyword: "additionalProperties", params: { additionalProperty: a }, message: "must NOT have additional properties" };
            null === p ? p = [e] : p.push(e), c++;
        }
    if (void 0 !== e.openapi) {
        let a = e.openapi;
        if ("string" == typeof a) {
            if (!at.test(a)) {
                const e = { instancePath: t + "/openapi", schemaPath: "#/properties/openapi/pattern", keyword: "pattern", params: { pattern: "^3\\.0\\.\\d(-.+)?$" }, message: 'must match pattern "^3\\.0\\.\\d(-.+)?$"' };
                null === p ? p = [e] : p.push(e), c++;
            }
        }
        else {
            const e = { instancePath: t + "/openapi", schemaPath: "#/properties/openapi/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.info && (ot(e.info, { instancePath: t + "/info", parentData: e, parentDataProperty: "info", rootData: o, dynamicAnchors: i }) || (p = null === p ? ot.errors : p.concat(ot.errors), c = p.length)), void 0 !== e.externalDocs && (it(e.externalDocs, { instancePath: t + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: o, dynamicAnchors: i }) || (p = null === p ? it.errors : p.concat(it.errors), c = p.length)), void 0 !== e.servers) {
        let a = e.servers;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                ct(a[r], { instancePath: t + "/servers/" + r, parentData: a, parentDataProperty: r, rootData: o, dynamicAnchors: i }) || (p = null === p ? ct.errors : p.concat(ct.errors), c = p.length);
        }
        else {
            const e = { instancePath: t + "/servers", schemaPath: "#/properties/servers/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.security) {
        let a = e.security;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                lt(a[r], { instancePath: t + "/security/" + r, parentData: a, parentDataProperty: r, rootData: o, dynamicAnchors: i }) || (p = null === p ? lt.errors : p.concat(lt.errors), c = p.length);
        }
        else {
            const e = { instancePath: t + "/security", schemaPath: "#/properties/security/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.tags) {
        let r = e.tags;
        if (Array.isArray(r)) {
            const e = r.length;
            for (let a = 0; a < e; a++)
                mt(r[a], { instancePath: t + "/tags/" + a, parentData: r, parentDataProperty: a, rootData: o, dynamicAnchors: i }) || (p = null === p ? mt.errors : p.concat(mt.errors), c = p.length);
            let s, n = r.length;
            if (n > 1)
                e: for (; n--;)
                    for (s = n; s--;)
                        if (a(r[n], r[s])) {
                            const e = { instancePath: t + "/tags", schemaPath: "#/properties/tags/uniqueItems", keyword: "uniqueItems", params: { i: n, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + n + " are identical)" };
                            null === p ? p = [e] : p.push(e), c++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/tags", schemaPath: "#/properties/tags/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    void 0 !== e.paths && (Bt(e.paths, { instancePath: t + "/paths", parentData: e, parentDataProperty: "paths", rootData: o, dynamicAnchors: i }) || (p = null === p ? Bt.errors : p.concat(Bt.errors), c = p.length)), void 0 !== e.components && (na(e.components, { instancePath: t + "/components", parentData: e, parentDataProperty: "components", rootData: o, dynamicAnchors: i }) || (p = null === p ? na.errors : p.concat(na.errors), c = p.length));
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === p ? p = [e] : p.push(e), c++;
} return oa.errors = p, 0 === c; }
Gt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Jt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Wt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Yt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Qt.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ea.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ta.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, aa.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ra.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, sa.evaluated = { dynamicProps: !0, dynamicItems: !1 }, na.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, oa.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
exports.oas3_1 = ss;
const ia = { $id: "https://spec.openapis.org/oas/3.1/schema/2021-09-28", $schema: "https://json-schema.org/draft/2020-12/schema", description: "The description of OpenAPI v3.1.x documents without schema validation, as defined by https://spec.openapis.org/oas/v3.1.0", type: "object", properties: { openapi: { type: "string", pattern: "^3\\.1\\.\\d+(-.+)?$" }, info: { $ref: "#/$defs/info" }, jsonSchemaDialect: { type: "string", format: "uri", default: "https://spec.openapis.org/oas/3.1/dialect/base" }, servers: { type: "array", items: { $ref: "#/$defs/server" }, default: [{ url: "/" }] }, paths: { $ref: "#/$defs/paths" }, webhooks: { type: "object", additionalProperties: { $ref: "#/$defs/path-item-or-reference" } }, components: { $ref: "#/$defs/components" }, security: { type: "array", items: { $ref: "#/$defs/security-requirement" } }, tags: { type: "array", items: { $ref: "#/$defs/tag" } }, externalDocs: { $ref: "#/$defs/external-documentation" } }, required: ["openapi", "info"], errorMessage: { anyOf: 'The document must have either "paths", "webhooks" or "components"' }, anyOf: [{ errorMessage: 'The document must have either "paths", "webhooks" or "components"', required: ["paths"] }, { errorMessage: 'The document must have either "paths", "webhooks" or "components"', required: ["components"] }, { errorMessage: 'The document must have either "paths", "webhooks" or "components"', required: ["webhooks"] }], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1, $defs: { info: { $comment: "https://spec.openapis.org/oas/v3.1.0#info-object", type: "object", properties: { title: { type: "string" }, summary: { type: "string" }, description: { type: "string" }, termsOfService: { type: "string", format: "uri" }, contact: { $ref: "#/$defs/contact" }, license: { $ref: "#/$defs/license" }, version: { type: "string" } }, required: ["title", "version"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, contact: { $comment: "https://spec.openapis.org/oas/v3.1.0#contact-object", type: "object", properties: { name: { type: "string" }, url: { type: "string", format: "uri" }, email: { type: "string", format: "email" } }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, license: { $comment: "https://spec.openapis.org/oas/v3.1.0#license-object", type: "object", properties: { name: { type: "string" }, identifier: { type: "string" }, url: { type: "string", format: "uri" } }, required: ["name"], dependentSchemas: { identifier: { not: { required: ["url"] } } }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, server: { $comment: "https://spec.openapis.org/oas/v3.1.0#server-object", type: "object", properties: { url: { type: "string" }, description: { type: "string" }, variables: { type: "object", additionalProperties: { $ref: "#/$defs/server-variable" } } }, required: ["url"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "server-variable": { $comment: "https://spec.openapis.org/oas/v3.1.0#server-variable-object", type: "object", properties: { enum: { type: "array", items: { type: "string" }, minItems: 1 }, default: { type: "string" }, description: { type: "string" } }, required: ["default"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, components: { $comment: "https://spec.openapis.org/oas/v3.1.0#components-object", type: "object", properties: { schemas: { type: "object", additionalProperties: { $ref: "https://spec.openapis.org/oas/3.1/dialect/base" } }, responses: { type: "object", additionalProperties: { $ref: "#/$defs/response-or-reference" } }, parameters: { type: "object", additionalProperties: { $ref: "#/$defs/parameter-or-reference" } }, examples: { type: "object", additionalProperties: { $ref: "#/$defs/example-or-reference" } }, requestBodies: { type: "object", additionalProperties: { $ref: "#/$defs/request-body-or-reference" } }, headers: { type: "object", additionalProperties: { $ref: "#/$defs/header-or-reference" } }, securitySchemes: { type: "object", additionalProperties: { $ref: "#/$defs/security-scheme-or-reference" } }, links: { type: "object", additionalProperties: { $ref: "#/$defs/link-or-reference" } }, callbacks: { type: "object", additionalProperties: { $ref: "#/$defs/callbacks-or-reference" } }, pathItems: { type: "object", additionalProperties: { $ref: "#/$defs/path-item-or-reference" } } }, patternProperties: { "^(schemas|responses|parameters|examples|requestBodies|headers|securitySchemes|links|callbacks|pathItems)$": { $comment: "Enumerating all of the property names in the regex above is necessary for unevaluatedProperties to work as expected", propertyNames: { pattern: "^[a-zA-Z0-9._-]+$" } } }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, paths: { $comment: "https://spec.openapis.org/oas/v3.1.0#paths-object", type: "object", patternProperties: { "^/": { $ref: "#/$defs/path-item" } }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "path-item": { $comment: "https://spec.openapis.org/oas/v3.1.0#path-item-object", type: "object", properties: { summary: { type: "string" }, description: { type: "string" }, servers: { type: "array", items: { $ref: "#/$defs/server" } }, parameters: { type: "array", items: { $ref: "#/$defs/parameter-or-reference" } }, get: { $ref: "#/$defs/operation" }, put: { $ref: "#/$defs/operation" }, post: { $ref: "#/$defs/operation" }, delete: { $ref: "#/$defs/operation" }, options: { $ref: "#/$defs/operation" }, head: { $ref: "#/$defs/operation" }, patch: { $ref: "#/$defs/operation" }, trace: { $ref: "#/$defs/operation" } }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "path-item-or-reference": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/$defs/reference" }, else: { $ref: "#/$defs/path-item" } }, operation: { $comment: "https://spec.openapis.org/oas/v3.1.0#operation-object", type: "object", properties: { tags: { type: "array", items: { type: "string" } }, summary: { type: "string" }, description: { type: "string" }, externalDocs: { $ref: "#/$defs/external-documentation" }, operationId: { type: "string" }, parameters: { type: "array", items: { $ref: "#/$defs/parameter-or-reference" } }, requestBody: { $ref: "#/$defs/request-body-or-reference" }, responses: { $ref: "#/$defs/responses" }, callbacks: { type: "object", additionalProperties: { $ref: "#/$defs/callbacks-or-reference" } }, deprecated: { default: !1, type: "boolean" }, security: { type: "array", items: { $ref: "#/$defs/security-requirement" } }, servers: { type: "array", items: { $ref: "#/$defs/server" } } }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "external-documentation": { $comment: "https://spec.openapis.org/oas/v3.1.0#external-documentation-object", type: "object", properties: { description: { type: "string" }, url: { type: "string", format: "uri" } }, required: ["url"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, parameter: { $comment: "https://spec.openapis.org/oas/v3.1.0#parameter-object", type: "object", properties: { name: { type: "string" }, in: { enum: ["query", "header", "path", "cookie"] }, description: { type: "string" }, required: { default: !1, type: "boolean" }, deprecated: { default: !1, type: "boolean" }, schema: { $ref: "https://spec.openapis.org/oas/3.1/dialect/base" }, content: { $ref: "#/$defs/content", minProperties: 1, maxProperties: 1 } }, required: ["name", "in"], oneOf: [{ required: ["schema"] }, { required: ["content"] }], if: { properties: { in: { const: "query" } }, required: ["in"] }, then: { properties: { allowEmptyValue: { default: !1, type: "boolean" } } }, dependentSchemas: { schema: { properties: { style: { type: "string" }, explode: { type: "boolean" } }, allOf: [{ $ref: "#/$defs/examples" }, { $ref: "#/$defs/parameter/dependentSchemas/schema/$defs/styles-for-path" }, { $ref: "#/$defs/parameter/dependentSchemas/schema/$defs/styles-for-header" }, { $ref: "#/$defs/parameter/dependentSchemas/schema/$defs/styles-for-query" }, { $ref: "#/$defs/parameter/dependentSchemas/schema/$defs/styles-for-cookie" }, { $ref: "#/$defs/styles-for-form" }], $defs: { "styles-for-path": { if: { properties: { in: { const: "path" } }, required: ["in"] }, then: { properties: { style: { default: "simple", enum: ["matrix", "label", "simple"] }, required: { const: !0 } }, required: ["required"] } }, "styles-for-header": { if: { properties: { in: { const: "header" } }, required: ["in"] }, then: { properties: { style: { default: "simple", const: "simple" } } } }, "styles-for-query": { if: { properties: { in: { const: "query" } }, required: ["in"] }, then: { properties: { style: { default: "form", enum: ["form", "spaceDelimited", "pipeDelimited", "deepObject"] }, allowReserved: { default: !1, type: "boolean" } } } }, "styles-for-cookie": { if: { properties: { in: { const: "cookie" } }, required: ["in"] }, then: { properties: { style: { default: "form", const: "form" } } } } } } }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "parameter-or-reference": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/$defs/reference" }, else: { $ref: "#/$defs/parameter" } }, "request-body": { $comment: "https://spec.openapis.org/oas/v3.1.0#request-body-object", type: "object", properties: { description: { type: "string" }, content: { $ref: "#/$defs/content" }, required: { default: !1, type: "boolean" } }, required: ["content"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "request-body-or-reference": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/$defs/reference" }, else: { $ref: "#/$defs/request-body" } }, content: { $comment: "https://spec.openapis.org/oas/v3.1.0#fixed-fields-10", type: "object", additionalProperties: { $ref: "#/$defs/media-type" }, propertyNames: { format: "media-range" } }, "media-type": { $comment: "https://spec.openapis.org/oas/v3.1.0#media-type-object", type: "object", properties: { schema: { $ref: "https://spec.openapis.org/oas/3.1/dialect/base" }, encoding: { type: "object", additionalProperties: { $ref: "#/$defs/encoding" } } }, allOf: [{ $ref: "#/$defs/specification-extensions" }, { $ref: "#/$defs/examples" }], unevaluatedProperties: !1 }, encoding: { $comment: "https://spec.openapis.org/oas/v3.1.0#encoding-object", type: "object", properties: { contentType: { type: "string", format: "media-range" }, headers: { type: "object", additionalProperties: { $ref: "#/$defs/header-or-reference" } }, style: { default: "form", enum: ["form", "spaceDelimited", "pipeDelimited", "deepObject"] }, explode: { type: "boolean" }, allowReserved: { default: !1, type: "boolean" } }, allOf: [{ $ref: "#/$defs/specification-extensions" }, { $ref: "#/$defs/styles-for-form" }], unevaluatedProperties: !1 }, responses: { $comment: "https://spec.openapis.org/oas/v3.1.0#responses-object", type: "object", properties: { default: { $ref: "#/$defs/response-or-reference" } }, patternProperties: { "^[1-5](?:[0-9]{2}|XX)$": { $ref: "#/$defs/response-or-reference" } }, minProperties: 1, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1, if: { $comment: "either default, or at least one response code property must exist", patternProperties: { "^[1-5](?:[0-9]{2}|XX)$": !1 } }, then: { required: ["default"] } }, response: { $comment: "https://spec.openapis.org/oas/v3.1.0#response-object", type: "object", properties: { description: { type: "string" }, headers: { type: "object", additionalProperties: { $ref: "#/$defs/header-or-reference" } }, content: { $ref: "#/$defs/content" }, links: { type: "object", additionalProperties: { $ref: "#/$defs/link-or-reference" } } }, required: ["description"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "response-or-reference": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/$defs/reference" }, else: { $ref: "#/$defs/response" } }, callbacks: { $comment: "https://spec.openapis.org/oas/v3.1.0#callback-object", type: "object", $ref: "#/$defs/specification-extensions", additionalProperties: { $ref: "#/$defs/path-item-or-reference" } }, "callbacks-or-reference": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/$defs/reference" }, else: { $ref: "#/$defs/callbacks" } }, example: { $comment: "https://spec.openapis.org/oas/v3.1.0#example-object", type: "object", properties: { summary: { type: "string" }, description: { type: "string" }, value: !0, externalValue: { type: "string", format: "uri" } }, not: { required: ["value", "externalValue"] }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "example-or-reference": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/$defs/reference" }, else: { $ref: "#/$defs/example" } }, link: { $comment: "https://spec.openapis.org/oas/v3.1.0#link-object", type: "object", properties: { operationRef: { type: "string", format: "uri-reference" }, operationId: { type: "string" }, parameters: { $ref: "#/$defs/map-of-strings" }, requestBody: !0, description: { type: "string" }, body: { $ref: "#/$defs/server" } }, oneOf: [{ required: ["operationRef"] }, { required: ["operationId"] }], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "link-or-reference": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/$defs/reference" }, else: { $ref: "#/$defs/link" } }, header: { $comment: "https://spec.openapis.org/oas/v3.1.0#header-object", type: "object", properties: { description: { type: "string" }, required: { default: !1, type: "boolean" }, deprecated: { default: !1, type: "boolean" }, schema: { $ref: "https://spec.openapis.org/oas/3.1/dialect/base" }, content: { $ref: "#/$defs/content", minProperties: 1, maxProperties: 1 } }, oneOf: [{ required: ["schema"] }, { required: ["content"] }], dependentSchemas: { schema: { properties: { style: { default: "simple", const: "simple" }, explode: { default: !1, type: "boolean" } }, $ref: "#/$defs/examples" } }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "header-or-reference": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/$defs/reference" }, else: { $ref: "#/$defs/header" } }, tag: { $comment: "https://spec.openapis.org/oas/v3.1.0#tag-object", type: "object", properties: { name: { type: "string" }, description: { type: "string" }, externalDocs: { $ref: "#/$defs/external-documentation" } }, required: ["name"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, reference: { $comment: "https://spec.openapis.org/oas/v3.1.0#reference-object", type: "object", properties: { $ref: { type: "string", format: "uri-reference" }, summary: { type: "string" }, description: { type: "string" } } }, schema: { $comment: "https://spec.openapis.org/oas/v3.1.0#schema-object", $ref: "https://spec.openapis.org/oas/3.1/dialect/base" }, "security-scheme": { $comment: "https://spec.openapis.org/oas/v3.1.0#security-scheme-object", type: "object", properties: { type: { enum: ["apiKey", "http", "mutualTLS", "oauth2", "openIdConnect"] }, description: { type: "string" } }, required: ["type"], allOf: [{ $ref: "#/$defs/specification-extensions" }, { $ref: "#/$defs/security-scheme/$defs/type-apikey" }, { $ref: "#/$defs/security-scheme/$defs/type-http" }, { $ref: "#/$defs/security-scheme/$defs/type-http-bearer" }, { $ref: "#/$defs/security-scheme/$defs/type-oauth2" }, { $ref: "#/$defs/security-scheme/$defs/type-oidc" }], unevaluatedProperties: !1, $defs: { "type-apikey": { if: { properties: { type: { const: "apiKey" } }, required: ["type"] }, then: { properties: { name: { type: "string" }, in: { enum: ["query", "header", "cookie"] } }, required: ["name", "in"] } }, "type-http": { if: { properties: { type: { const: "http" } }, required: ["type"] }, then: { properties: { scheme: { type: "string" } }, required: ["scheme"] } }, "type-http-bearer": { if: { properties: { type: { const: "http" }, scheme: { type: "string", pattern: "^[Bb][Ee][Aa][Rr][Ee][Rr]$" } }, required: ["type", "scheme"] }, then: { properties: { bearerFormat: { type: "string" } } } }, "type-oauth2": { if: { properties: { type: { const: "oauth2" } }, required: ["type"] }, then: { properties: { flows: { $ref: "#/$defs/oauth-flows" } }, required: ["flows"] } }, "type-oidc": { if: { properties: { type: { const: "openIdConnect" } }, required: ["type"] }, then: { properties: { openIdConnectUrl: { type: "string", format: "uri" } }, required: ["openIdConnectUrl"] } } } }, "security-scheme-or-reference": { if: { type: "object", required: ["$ref"] }, then: { $ref: "#/$defs/reference" }, else: { $ref: "#/$defs/security-scheme" } }, "oauth-flows": { type: "object", properties: { implicit: { $ref: "#/$defs/oauth-flows/$defs/implicit" }, password: { $ref: "#/$defs/oauth-flows/$defs/password" }, clientCredentials: { $ref: "#/$defs/oauth-flows/$defs/client-credentials" }, authorizationCode: { $ref: "#/$defs/oauth-flows/$defs/authorization-code" } }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1, $defs: { implicit: { type: "object", properties: { authorizationUrl: { type: "string", format: "uri-reference" }, refreshUrl: { type: "string", format: "uri-reference" }, scopes: { $ref: "#/$defs/map-of-strings" } }, required: ["authorizationUrl", "scopes"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, password: { type: "object", properties: { tokenUrl: { type: "string", format: "uri-reference" }, refreshUrl: { type: "string", format: "uri-reference" }, scopes: { $ref: "#/$defs/map-of-strings" } }, required: ["tokenUrl", "scopes"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "client-credentials": { type: "object", properties: { tokenUrl: { type: "string", format: "uri-reference" }, refreshUrl: { type: "string", format: "uri-reference" }, scopes: { $ref: "#/$defs/map-of-strings" } }, required: ["tokenUrl", "scopes"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, "authorization-code": { type: "object", properties: { authorizationUrl: { type: "string", format: "uri-reference" }, tokenUrl: { type: "string", format: "uri-reference" }, refreshUrl: { type: "string", format: "uri-reference" }, scopes: { $ref: "#/$defs/map-of-strings" } }, required: ["authorizationUrl", "tokenUrl", "scopes"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 } } }, "security-requirement": { $comment: "https://spec.openapis.org/oas/v3.1.0#security-requirement-object", type: "object", additionalProperties: { type: "array", items: { type: "string" } } }, "specification-extensions": { $comment: "https://spec.openapis.org/oas/v3.1.0#specification-extensions", patternProperties: { "^x-": !0 } }, examples: { properties: { example: !0, examples: { type: "object", additionalProperties: { $ref: "#/$defs/example-or-reference" } } } }, "map-of-strings": { type: "object", additionalProperties: { type: "string" } }, "styles-for-form": { if: { properties: { style: { const: "form" } }, required: ["style"] }, then: { properties: { explode: { default: !0 } } }, else: { properties: { explode: { default: !1 } } } } } };
function pa(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { const i = pa.evaluated; if (i.dynamicProps && (i.props = void 0), i.dynamicItems && (i.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    var p = {};
    for (const t in e)
        r.test(t) && (p[t] = !0);
} return pa.errors = null, i.props = p, !0; }
function ca(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let p = null, c = 0; const l = ca.evaluated; if (l.dynamicProps && (l.props = void 0), l.dynamicItems && (l.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var m = pa.evaluated.props;
else
    p = null === p ? pa.errors : p.concat(pa.errors), c = p.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== m && ((m = m || {}).name = !0, m.url = !0, m.email = !0), void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === p ? p = [e] : p.push(e), c++;
    }
    if (void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === p ? p = [e] : p.push(e), c++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (void 0 !== e.email) {
        let a = e.email;
        if ("string" == typeof a) {
            if (!i.test(a)) {
                const e = { instancePath: t + "/email", schemaPath: "#/properties/email/format", keyword: "format", params: { format: "email" }, message: 'must match format "email"' };
                null === p ? p = [e] : p.push(e), c++;
            }
        }
        else {
            const e = { instancePath: t + "/email", schemaPath: "#/properties/email/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === p ? p = [e] : p.push(e), c++;
        }
    }
    if (!0 !== m)
        for (const a in e)
            if (!m || !m[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === p ? p = [e] : p.push(e), c++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === p ? p = [e] : p.push(e), c++;
} return ca.errors = p, 0 === c; }
function la(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let i = null, p = 0; const c = la.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var l = pa.evaluated.props;
else
    i = null === i ? pa.errors : i.concat(pa.errors), p = i.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l && ((l = l || {}).name = !0, l.identifier = !0, l.url = !0), void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.identifier && "string" != typeof e.identifier) {
        const e = { instancePath: t + "/identifier", schemaPath: "#/properties/identifier/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.identifier) {
        const a = p, r = p;
        if (e && "object" == typeof e && !Array.isArray(e)) {
            let t;
            if (void 0 === e.url && (t = "url")) {
                const e = {};
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        if (r === p) {
            const e = { instancePath: t, schemaPath: "#/dependentSchemas/identifier/not", keyword: "not", params: {}, message: "must NOT be valid" };
            null === i ? i = [e] : i.push(e), p++;
        }
        else
            p = a, null !== i && (a ? i.length = a : i = null);
    }
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return la.errors = i, 0 === p; }
function ma(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let i = null, p = 0; const c = ma.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var l = pa.evaluated.props;
else
    i = null === i ? pa.errors : i.concat(pa.errors), p = i.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.title) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "title" }, message: "must have required property 'title'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.version) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "version" }, message: "must have required property 'version'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l && ((l = l || {}).title = !0, l.summary = !0, l.description = !0, l.termsOfService = !0, l.contact = !0, l.license = !0, l.version = !0), void 0 !== e.title && "string" != typeof e.title) {
        const e = { instancePath: t + "/title", schemaPath: "#/properties/title/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: t + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.termsOfService) {
        let a = e.termsOfService;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/termsOfService", schemaPath: "#/properties/termsOfService/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/termsOfService", schemaPath: "#/properties/termsOfService/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.contact && (ca(e.contact, { instancePath: t + "/contact", parentData: e, parentDataProperty: "contact", rootData: s, dynamicAnchors: n }) || (i = null === i ? ca.errors : i.concat(ca.errors), p = i.length)), void 0 !== e.license && (la(e.license, { instancePath: t + "/license", parentData: e, parentDataProperty: "license", rootData: s, dynamicAnchors: n }) || (i = null === i ? la.errors : i.concat(la.errors), p = i.length)), void 0 !== e.version && "string" != typeof e.version) {
        const e = { instancePath: t + "/version", schemaPath: "#/properties/version/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return ma.errors = i, 0 === p; }
function ua(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ua.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.default) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "default" }, message: "must have required property 'default'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).enum = !0, c.default = !0, c.description = !0), void 0 !== e.enum) {
        let a = e.enum;
        if (Array.isArray(a)) {
            if (a.length < 1) {
                const e = { instancePath: t + "/enum", schemaPath: "#/properties/enum/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === o ? o = [e] : o.push(e), i++;
            }
            const e = a.length;
            for (let r = 0; r < e; r++)
                if ("string" != typeof a[r]) {
                    const e = { instancePath: t + "/enum/" + r, schemaPath: "#/properties/enum/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === o ? o = [e] : o.push(e), i++;
                }
        }
        else {
            const e = { instancePath: t + "/enum", schemaPath: "#/properties/enum/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.default && "string" != typeof e.default) {
        const e = { instancePath: t + "/default", schemaPath: "#/properties/default/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return ua.errors = o, 0 === i; }
function ha(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ha.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.url) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "url" }, message: "must have required property 'url'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).url = !0, c.description = !0, c.variables = !0), void 0 !== e.url && "string" != typeof e.url) {
        const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.variables) {
        let a = e.variables;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                ua(a[e], { instancePath: t + "/variables/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? ua.errors : o.concat(ua.errors), i = o.length);
        else {
            const e = { instancePath: t + "/variables", schemaPath: "#/properties/variables/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return ha.errors = o, 0 === i; }
function da(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = da.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 !== e.$ref) {
        let a = e.$ref;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/$ref", schemaPath: "#/properties/%24ref/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/$ref", schemaPath: "#/properties/%24ref/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: t + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return da.errors = o, 0 === i; }
pa.evaluated = { dynamicProps: !0, dynamicItems: !1 }, ca.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, la.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ma.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ua.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ha.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, da.evaluated = { props: { $ref: !0, summary: !0, description: !0 }, dynamicProps: !1, dynamicItems: !1 };
const ya = { $comment: "https://spec.openapis.org/oas/v3.1.0#parameter-object", type: "object", properties: { name: { type: "string" }, in: { enum: ["query", "header", "path", "cookie"] }, description: { type: "string" }, required: { default: !1, type: "boolean" }, deprecated: { default: !1, type: "boolean" }, schema: { $ref: "https://spec.openapis.org/oas/3.1/dialect/base" }, content: { $ref: "#/$defs/content", minProperties: 1, maxProperties: 1 } }, required: ["name", "in"], oneOf: [{ required: ["schema"] }, { required: ["content"] }], if: { properties: { in: { const: "query" } }, required: ["in"] }, then: { properties: { allowEmptyValue: { default: !1, type: "boolean" } } }, dependentSchemas: { schema: { properties: { style: { type: "string" }, explode: { type: "boolean" } }, allOf: [{ $ref: "#/$defs/examples" }, { $ref: "#/$defs/parameter/dependentSchemas/schema/$defs/styles-for-path" }, { $ref: "#/$defs/parameter/dependentSchemas/schema/$defs/styles-for-header" }, { $ref: "#/$defs/parameter/dependentSchemas/schema/$defs/styles-for-query" }, { $ref: "#/$defs/parameter/dependentSchemas/schema/$defs/styles-for-cookie" }, { $ref: "#/$defs/styles-for-form" }], $defs: { "styles-for-path": { if: { properties: { in: { const: "path" } }, required: ["in"] }, then: { properties: { style: { default: "simple", enum: ["matrix", "label", "simple"] }, required: { const: !0 } }, required: ["required"] } }, "styles-for-header": { if: { properties: { in: { const: "header" } }, required: ["in"] }, then: { properties: { style: { default: "simple", const: "simple" } } } }, "styles-for-query": { if: { properties: { in: { const: "query" } }, required: ["in"] }, then: { properties: { style: { default: "form", enum: ["form", "spaceDelimited", "pipeDelimited", "deepObject"] }, allowReserved: { default: !1, type: "boolean" } } } }, "styles-for-cookie": { if: { properties: { in: { const: "cookie" } }, required: ["in"] }, then: { properties: { style: { default: "form", const: "form" } } } } } } }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, fa = { $schema: "https://json-schema.org/draft/2020-12/schema", $id: "https://json-schema.org/draft/2020-12/meta/core", $vocabulary: { "https://json-schema.org/draft/2020-12/vocab/core": !0 }, $dynamicAnchor: "meta", title: "Core vocabulary meta-schema", type: ["object", "boolean"], properties: { $id: { $ref: "#/$defs/uriReferenceString", $comment: "Non-empty fragments not allowed.", pattern: "^[^#]*#?$" }, $schema: { $ref: "#/$defs/uriString" }, $ref: { $ref: "#/$defs/uriReferenceString" }, $anchor: { $ref: "#/$defs/anchorString" }, $dynamicRef: { $ref: "#/$defs/uriReferenceString" }, $dynamicAnchor: { $ref: "#/$defs/anchorString" }, $vocabulary: { type: "object", propertyNames: { $ref: "#/$defs/uriString" }, additionalProperties: { type: "boolean" } }, $comment: { type: "string" }, $defs: { type: "object", additionalProperties: { $dynamicRef: "#meta" } } }, $defs: { anchorString: { type: "string", pattern: "^[A-Za-z_][-A-Za-z0-9._]*$" }, uriString: { type: "string", format: "uri" }, uriReferenceString: { type: "string", format: "uri-reference" } } };
function Pa(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Pa.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return Pa.errors = o, 0 === i; }
function ga(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ga.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return ga.errors = o, 0 === i; }
Pa.evaluated = { dynamicProps: !1, dynamicItems: !1 }, ga.evaluated = { dynamicProps: !1, dynamicItems: !1 };
const va = new RegExp("^[A-Za-z_][-A-Za-z0-9._]*$", "u");
function ba(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ba.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" == typeof e) {
    if (!va.test(e)) {
        const e = { instancePath: t, schemaPath: "#/pattern", keyword: "pattern", params: { pattern: "^[A-Za-z_][-A-Za-z0-9._]*$" }, message: 'must match pattern "^[A-Za-z_][-A-Za-z0-9._]*$"' };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return ba.errors = o, 0 === i; }
ba.evaluated = { dynamicProps: !1, dynamicItems: !1 };
const Da = new RegExp("^[^#]*#?$", "u");
function wa(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = wa.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), (!e || "object" != typeof e || Array.isArray(e)) && "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: fa.type }, message: "must be object,boolean" };
    null === o ? o = [e] : o.push(e), i++;
} if (n.meta || (n.meta = wa), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 !== e.$id) {
        let a = e.$id;
        if (Pa(a, { instancePath: t + "/$id", parentData: e, parentDataProperty: "$id", rootData: s, dynamicAnchors: n }) || (o = null === o ? Pa.errors : o.concat(Pa.errors), i = o.length), "string" == typeof a && !Da.test(a)) {
            const e = { instancePath: t + "/$id", schemaPath: "#/properties/%24id/pattern", keyword: "pattern", params: { pattern: "^[^#]*#?$" }, message: 'must match pattern "^[^#]*#?$"' };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.$schema && (ga(e.$schema, { instancePath: t + "/$schema", parentData: e, parentDataProperty: "$schema", rootData: s, dynamicAnchors: n }) || (o = null === o ? ga.errors : o.concat(ga.errors), i = o.length)), void 0 !== e.$ref && (Pa(e.$ref, { instancePath: t + "/$ref", parentData: e, parentDataProperty: "$ref", rootData: s, dynamicAnchors: n }) || (o = null === o ? Pa.errors : o.concat(Pa.errors), i = o.length)), void 0 !== e.$anchor && (ba(e.$anchor, { instancePath: t + "/$anchor", parentData: e, parentDataProperty: "$anchor", rootData: s, dynamicAnchors: n }) || (o = null === o ? ba.errors : o.concat(ba.errors), i = o.length)), void 0 !== e.$dynamicRef && (Pa(e.$dynamicRef, { instancePath: t + "/$dynamicRef", parentData: e, parentDataProperty: "$dynamicRef", rootData: s, dynamicAnchors: n }) || (o = null === o ? Pa.errors : o.concat(Pa.errors), i = o.length)), void 0 !== e.$dynamicAnchor && (ba(e.$dynamicAnchor, { instancePath: t + "/$dynamicAnchor", parentData: e, parentDataProperty: "$dynamicAnchor", rootData: s, dynamicAnchors: n }) || (o = null === o ? ba.errors : o.concat(ba.errors), i = o.length)), void 0 !== e.$vocabulary) {
        let a = e.$vocabulary;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            for (const e in a) {
                const r = i;
                if (ga(e, { instancePath: t + "/$vocabulary", parentData: a, parentDataProperty: "$vocabulary", rootData: s, dynamicAnchors: n }) || (o = null === o ? ga.errors : o.concat(ga.errors), i = o.length), r !== i) {
                    const a = { instancePath: t + "/$vocabulary", schemaPath: "#/properties/%24vocabulary/propertyNames", keyword: "propertyNames", params: { propertyName: e }, message: "property name must be valid" };
                    null === o ? o = [a] : o.push(a), i++;
                }
            }
            for (const e in a)
                if ("boolean" != typeof a[e]) {
                    const a = { instancePath: t + "/$vocabulary/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/%24vocabulary/additionalProperties/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
                    null === o ? o = [a] : o.push(a), i++;
                }
        }
        else {
            const e = { instancePath: t + "/$vocabulary", schemaPath: "#/properties/%24vocabulary/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.$comment && "string" != typeof e.$comment) {
        const e = { instancePath: t + "/$comment", schemaPath: "#/properties/%24comment/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.$defs) {
        let a = e.$defs;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a) {
                let r = a[e], p = n.meta;
                if (p)
                    if (p(r, { instancePath: t + "/$defs/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }))
                        var c = p.evaluated.props, l = p.evaluated.items;
                    else
                        o = null === o ? p.errors : o.concat(p.errors), i = o.length;
                else if (wa(r, { instancePath: t + "/$defs/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n })) {
                    var m = wa.evaluated.props;
                    !0 !== c && void 0 !== m && (!0 === m ? c = !0 : (c = c || {}, Object.assign(c, m)));
                    var u = wa.evaluated.items;
                    !0 !== l && void 0 !== u && (l = !0 === u || (l > u ? l : u));
                }
                else
                    o = null === o ? wa.errors : o.concat(wa.errors), i = o.length;
            }
        else {
            const e = { instancePath: t + "/$defs", schemaPath: "#/properties/%24defs/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
} return wa.errors = o, 0 === i; }
wa.evaluated = { props: { $id: !0, $schema: !0, $ref: !0, $anchor: !0, $dynamicRef: !0, $dynamicAnchor: !0, $vocabulary: !0, $comment: !0, $defs: !0 }, dynamicProps: !1, dynamicItems: !1 };
const Aa = { $schema: "https://json-schema.org/draft/2020-12/schema", $id: "https://json-schema.org/draft/2020-12/meta/applicator", $vocabulary: { "https://json-schema.org/draft/2020-12/vocab/applicator": !0 }, $dynamicAnchor: "meta", title: "Applicator vocabulary meta-schema", type: ["object", "boolean"], properties: { prefixItems: { $ref: "#/$defs/schemaArray" }, items: { $dynamicRef: "#meta" }, contains: { $dynamicRef: "#meta" }, additionalProperties: { $dynamicRef: "#meta" }, properties: { type: "object", additionalProperties: { $dynamicRef: "#meta" }, default: {} }, patternProperties: { type: "object", additionalProperties: { $dynamicRef: "#meta" }, propertyNames: { format: "regex" }, default: {} }, dependentSchemas: { type: "object", additionalProperties: { $dynamicRef: "#meta" }, default: {} }, propertyNames: { $dynamicRef: "#meta" }, if: { $dynamicRef: "#meta" }, then: { $dynamicRef: "#meta" }, else: { $dynamicRef: "#meta" }, allOf: { $ref: "#/$defs/schemaArray" }, anyOf: { $ref: "#/$defs/schemaArray" }, oneOf: { $ref: "#/$defs/schemaArray" }, not: { $dynamicRef: "#meta" } }, $defs: { schemaArray: { type: "array", minItems: 1, items: { $dynamicRef: "#meta" } } } };
function ka(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ka.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), Array.isArray(e)) {
    if (e.length < 1) {
        const e = { instancePath: t, schemaPath: "#/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
        null === o ? o = [e] : o.push(e), i++;
    }
    const a = e.length;
    for (let r = 0; r < a; r++) {
        let a = e[r], p = n.meta;
        if (p)
            if (p(a, { instancePath: t + "/" + r, parentData: e, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
                var c = p.evaluated.props, l = p.evaluated.items;
            else
                o = null === o ? p.errors : o.concat(p.errors), i = o.length;
        else if (ka(a, { instancePath: t + "/" + r, parentData: e, parentDataProperty: r, rootData: s, dynamicAnchors: n })) {
            var m = ka.evaluated.props;
            !0 !== c && void 0 !== m && (!0 === m ? c = !0 : (c = c || {}, Object.assign(c, m)));
            var u = ka.evaluated.items;
            !0 !== l && void 0 !== u && (l = !0 === u || (l > u ? l : u));
        }
        else
            o = null === o ? ka.errors : o.concat(ka.errors), i = o.length;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === o ? o = [e] : o.push(e), i++;
} return ka.errors = o, 0 === i; }
function $a(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = $a.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), (!e || "object" != typeof e || Array.isArray(e)) && "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: Aa.type }, message: "must be object,boolean" };
    null === o ? o = [e] : o.push(e), i++;
} if (n.meta || (n.meta = $a), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 !== e.prefixItems && (ka(e.prefixItems, { instancePath: t + "/prefixItems", parentData: e, parentDataProperty: "prefixItems", rootData: s, dynamicAnchors: n }) || (o = null === o ? ka.errors : o.concat(ka.errors), i = o.length)), void 0 !== e.items) {
        let a = e.items, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/items", parentData: e, parentDataProperty: "items", rootData: s, dynamicAnchors: n }))
                var c = r.evaluated.props, l = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if ($a(a, { instancePath: t + "/items", parentData: e, parentDataProperty: "items", rootData: s, dynamicAnchors: n })) {
            var m = $a.evaluated.props;
            !0 !== c && void 0 !== m && (!0 === m ? c = !0 : (c = c || {}, Object.assign(c, m)));
            var u = $a.evaluated.items;
            !0 !== l && void 0 !== u && (l = !0 === u || (l > u ? l : u));
        }
        else
            o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
    }
    if (void 0 !== e.contains) {
        let a = e.contains, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/contains", parentData: e, parentDataProperty: "contains", rootData: s, dynamicAnchors: n }))
                var h = r.evaluated.props, d = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if ($a(a, { instancePath: t + "/contains", parentData: e, parentDataProperty: "contains", rootData: s, dynamicAnchors: n })) {
            var y = $a.evaluated.props;
            !0 !== h && void 0 !== y && (!0 === y ? h = !0 : (h = h || {}, Object.assign(h, y)));
            var f = $a.evaluated.items;
            !0 !== d && void 0 !== f && (d = !0 === f || (d > f ? d : f));
        }
        else
            o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
    }
    if (void 0 !== e.additionalProperties) {
        let a = e.additionalProperties, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/additionalProperties", parentData: e, parentDataProperty: "additionalProperties", rootData: s, dynamicAnchors: n }))
                var P = r.evaluated.props, g = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if ($a(a, { instancePath: t + "/additionalProperties", parentData: e, parentDataProperty: "additionalProperties", rootData: s, dynamicAnchors: n })) {
            var v = $a.evaluated.props;
            !0 !== P && void 0 !== v && (!0 === v ? P = !0 : (P = P || {}, Object.assign(P, v)));
            var b = $a.evaluated.items;
            !0 !== g && void 0 !== b && (g = !0 === b || (g > b ? g : b));
        }
        else
            o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
    }
    if (void 0 !== e.properties) {
        let a = e.properties;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a) {
                let r = a[e], p = n.meta;
                if (p)
                    if (p(r, { instancePath: t + "/properties/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }))
                        var D = p.evaluated.props, w = p.evaluated.items;
                    else
                        o = null === o ? p.errors : o.concat(p.errors), i = o.length;
                else if ($a(r, { instancePath: t + "/properties/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n })) {
                    var A = $a.evaluated.props;
                    !0 !== D && void 0 !== A && (!0 === A ? D = !0 : (D = D || {}, Object.assign(D, A)));
                    var k = $a.evaluated.items;
                    !0 !== w && void 0 !== k && (w = !0 === k || (w > k ? w : k));
                }
                else
                    o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
            }
        else {
            const e = { instancePath: t + "/properties", schemaPath: "#/properties/properties/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.patternProperties) {
        let a = e.patternProperties;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            for (const e in a)
                if (i != i) {
                    const a = { instancePath: t + "/patternProperties", schemaPath: "#/properties/patternProperties/propertyNames", keyword: "propertyNames", params: { propertyName: e }, message: "property name must be valid" };
                    null === o ? o = [a] : o.push(a), i++;
                }
            for (const e in a) {
                let r = a[e], p = n.meta;
                if (p)
                    if (p(r, { instancePath: t + "/patternProperties/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }))
                        var $ = p.evaluated.props, j = p.evaluated.items;
                    else
                        o = null === o ? p.errors : o.concat(p.errors), i = o.length;
                else if ($a(r, { instancePath: t + "/patternProperties/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n })) {
                    var q = $a.evaluated.props;
                    !0 !== $ && void 0 !== q && (!0 === q ? $ = !0 : ($ = $ || {}, Object.assign($, q)));
                    var I = $a.evaluated.items;
                    !0 !== j && void 0 !== I && (j = !0 === I || (j > I ? j : I));
                }
                else
                    o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
            }
        }
        else {
            const e = { instancePath: t + "/patternProperties", schemaPath: "#/properties/patternProperties/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.dependentSchemas) {
        let a = e.dependentSchemas;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a) {
                let r = a[e], p = n.meta;
                if (p)
                    if (p(r, { instancePath: t + "/dependentSchemas/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }))
                        var x = p.evaluated.props, O = p.evaluated.items;
                    else
                        o = null === o ? p.errors : o.concat(p.errors), i = o.length;
                else if ($a(r, { instancePath: t + "/dependentSchemas/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n })) {
                    var N = $a.evaluated.props;
                    !0 !== x && void 0 !== N && (!0 === N ? x = !0 : (x = x || {}, Object.assign(x, N)));
                    var U = $a.evaluated.items;
                    !0 !== O && void 0 !== U && (O = !0 === U || (O > U ? O : U));
                }
                else
                    o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
            }
        else {
            const e = { instancePath: t + "/dependentSchemas", schemaPath: "#/properties/dependentSchemas/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.propertyNames) {
        let a = e.propertyNames, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/propertyNames", parentData: e, parentDataProperty: "propertyNames", rootData: s, dynamicAnchors: n }))
                var T = r.evaluated.props, M = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if ($a(a, { instancePath: t + "/propertyNames", parentData: e, parentDataProperty: "propertyNames", rootData: s, dynamicAnchors: n })) {
            var S = $a.evaluated.props;
            !0 !== T && void 0 !== S && (!0 === S ? T = !0 : (T = T || {}, Object.assign(T, S)));
            var z = $a.evaluated.items;
            !0 !== M && void 0 !== z && (M = !0 === z || (M > z ? M : z));
        }
        else
            o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
    }
    if (void 0 !== e.if) {
        let a = e.if, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/if", parentData: e, parentDataProperty: "if", rootData: s, dynamicAnchors: n }))
                var L = r.evaluated.props, R = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if ($a(a, { instancePath: t + "/if", parentData: e, parentDataProperty: "if", rootData: s, dynamicAnchors: n })) {
            var C = $a.evaluated.props;
            !0 !== L && void 0 !== C && (!0 === C ? L = !0 : (L = L || {}, Object.assign(L, C)));
            var E = $a.evaluated.items;
            !0 !== R && void 0 !== E && (R = !0 === E || (R > E ? R : E));
        }
        else
            o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
    }
    if (void 0 !== e.then) {
        let a = e.then, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/then", parentData: e, parentDataProperty: "then", rootData: s, dynamicAnchors: n }))
                var V = r.evaluated.props, K = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if ($a(a, { instancePath: t + "/then", parentData: e, parentDataProperty: "then", rootData: s, dynamicAnchors: n })) {
            var F = $a.evaluated.props;
            !0 !== V && void 0 !== F && (!0 === F ? V = !0 : (V = V || {}, Object.assign(V, F)));
            var B = $a.evaluated.items;
            !0 !== K && void 0 !== B && (K = !0 === B || (K > B ? K : B));
        }
        else
            o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
    }
    if (void 0 !== e.else) {
        let a = e.else, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/else", parentData: e, parentDataProperty: "else", rootData: s, dynamicAnchors: n }))
                var _ = r.evaluated.props, Z = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if ($a(a, { instancePath: t + "/else", parentData: e, parentDataProperty: "else", rootData: s, dynamicAnchors: n })) {
            var H = $a.evaluated.props;
            !0 !== _ && void 0 !== H && (!0 === H ? _ = !0 : (_ = _ || {}, Object.assign(_, H)));
            var X = $a.evaluated.items;
            !0 !== Z && void 0 !== X && (Z = !0 === X || (Z > X ? Z : X));
        }
        else
            o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
    }
    if (void 0 !== e.allOf && (ka(e.allOf, { instancePath: t + "/allOf", parentData: e, parentDataProperty: "allOf", rootData: s, dynamicAnchors: n }) || (o = null === o ? ka.errors : o.concat(ka.errors), i = o.length)), void 0 !== e.anyOf && (ka(e.anyOf, { instancePath: t + "/anyOf", parentData: e, parentDataProperty: "anyOf", rootData: s, dynamicAnchors: n }) || (o = null === o ? ka.errors : o.concat(ka.errors), i = o.length)), void 0 !== e.oneOf && (ka(e.oneOf, { instancePath: t + "/oneOf", parentData: e, parentDataProperty: "oneOf", rootData: s, dynamicAnchors: n }) || (o = null === o ? ka.errors : o.concat(ka.errors), i = o.length)), void 0 !== e.not) {
        let a = e.not, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/not", parentData: e, parentDataProperty: "not", rootData: s, dynamicAnchors: n }))
                var G = r.evaluated.props, J = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if ($a(a, { instancePath: t + "/not", parentData: e, parentDataProperty: "not", rootData: s, dynamicAnchors: n })) {
            var W = $a.evaluated.props;
            !0 !== G && void 0 !== W && (!0 === W ? G = !0 : (G = G || {}, Object.assign(G, W)));
            var Y = $a.evaluated.items;
            !0 !== J && void 0 !== Y && (J = !0 === Y || (J > Y ? J : Y));
        }
        else
            o = null === o ? $a.errors : o.concat($a.errors), i = o.length;
    }
} return $a.errors = o, 0 === i; }
ka.evaluated = { items: !0, dynamicProps: !1, dynamicItems: !1 }, $a.evaluated = { props: { prefixItems: !0, items: !0, contains: !0, additionalProperties: !0, properties: !0, patternProperties: !0, dependentSchemas: !0, propertyNames: !0, if: !0, then: !0, else: !0, allOf: !0, anyOf: !0, oneOf: !0, not: !0 }, dynamicProps: !1, dynamicItems: !1 };
const ja = { $schema: "https://json-schema.org/draft/2020-12/schema", $id: "https://json-schema.org/draft/2020-12/meta/unevaluated", $vocabulary: { "https://json-schema.org/draft/2020-12/vocab/unevaluated": !0 }, $dynamicAnchor: "meta", title: "Unevaluated applicator vocabulary meta-schema", type: ["object", "boolean"], properties: { unevaluatedItems: { $dynamicRef: "#meta" }, unevaluatedProperties: { $dynamicRef: "#meta" } } };
function qa(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = qa.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), (!e || "object" != typeof e || Array.isArray(e)) && "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: ja.type }, message: "must be object,boolean" };
    null === o ? o = [e] : o.push(e), i++;
} if (n.meta || (n.meta = qa), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 !== e.unevaluatedItems) {
        let a = e.unevaluatedItems, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/unevaluatedItems", parentData: e, parentDataProperty: "unevaluatedItems", rootData: s, dynamicAnchors: n }))
                var c = r.evaluated.props, l = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if (qa(a, { instancePath: t + "/unevaluatedItems", parentData: e, parentDataProperty: "unevaluatedItems", rootData: s, dynamicAnchors: n })) {
            var m = qa.evaluated.props;
            !0 !== c && void 0 !== m && (!0 === m ? c = !0 : (c = c || {}, Object.assign(c, m)));
            var u = qa.evaluated.items;
            !0 !== l && void 0 !== u && (l = !0 === u || (l > u ? l : u));
        }
        else
            o = null === o ? qa.errors : o.concat(qa.errors), i = o.length;
    }
    if (void 0 !== e.unevaluatedProperties) {
        let a = e.unevaluatedProperties, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/unevaluatedProperties", parentData: e, parentDataProperty: "unevaluatedProperties", rootData: s, dynamicAnchors: n }))
                var h = r.evaluated.props, d = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if (qa(a, { instancePath: t + "/unevaluatedProperties", parentData: e, parentDataProperty: "unevaluatedProperties", rootData: s, dynamicAnchors: n })) {
            var y = qa.evaluated.props;
            !0 !== h && void 0 !== y && (!0 === y ? h = !0 : (h = h || {}, Object.assign(h, y)));
            var f = qa.evaluated.items;
            !0 !== d && void 0 !== f && (d = !0 === f || (d > f ? d : f));
        }
        else
            o = null === o ? qa.errors : o.concat(qa.errors), i = o.length;
    }
} return qa.errors = o, 0 === i; }
qa.evaluated = { props: { unevaluatedItems: !0, unevaluatedProperties: !0 }, dynamicProps: !1, dynamicItems: !1 };
const Ia = { $schema: "https://json-schema.org/draft/2020-12/schema", $id: "https://stoplight.io/json-schema/draft/2020-12/meta/validation", $vocabulary: { "https://json-schema.org/draft/2020-12/vocab/validation": !0 }, $dynamicAnchor: "meta", title: "Validation vocabulary meta-schema", type: ["object", "boolean"], properties: { type: { if: { type: "string" }, then: { $ref: "#/$defs/simpleTypes" }, else: { if: { type: "array" }, then: { type: "array", items: { $ref: "#/$defs/simpleTypes" }, minItems: 1, uniqueItems: !0 }, else: { not: !0, errorMessage: '"type" property must be either a string or an array of strings' } } }, const: !0, enum: { type: "array", items: !0 }, multipleOf: { type: "number", exclusiveMinimum: 0 }, maximum: { type: "number" }, exclusiveMaximum: { type: "number" }, minimum: { type: "number" }, exclusiveMinimum: { type: "number" }, maxLength: { $ref: "#/$defs/nonNegativeInteger" }, minLength: { $ref: "#/$defs/nonNegativeIntegerDefault0" }, pattern: { type: "string", format: "regex" }, maxItems: { $ref: "#/$defs/nonNegativeInteger" }, minItems: { $ref: "#/$defs/nonNegativeIntegerDefault0" }, uniqueItems: { type: "boolean", default: !1 }, maxContains: { $ref: "#/$defs/nonNegativeInteger" }, minContains: { $ref: "#/$defs/nonNegativeInteger", default: 1 }, maxProperties: { $ref: "#/$defs/nonNegativeInteger" }, minProperties: { $ref: "#/$defs/nonNegativeIntegerDefault0" }, required: { $ref: "#/$defs/stringArray" }, dependentRequired: { type: "object", additionalProperties: { $ref: "#/$defs/stringArray" } } }, $defs: { nonNegativeInteger: { type: "integer", minimum: 0 }, nonNegativeIntegerDefault0: { $ref: "#/$defs/nonNegativeInteger", default: 0 }, simpleTypes: { enum: ["array", "boolean", "integer", "null", "number", "object", "string"] }, stringArray: { type: "array", items: { type: "string" }, uniqueItems: !0, default: [] } } }, xa = { enum: ["array", "boolean", "integer", "null", "number", "object", "string"] };
function Oa(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Oa.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "array" !== e && "boolean" !== e && "integer" !== e && "null" !== e && "number" !== e && "object" !== e && "string" !== e) {
    const e = { instancePath: t, schemaPath: "#/enum", keyword: "enum", params: { allowedValues: xa.enum }, message: "must be equal to one of the allowed values" };
    null === o ? o = [e] : o.push(e), i++;
} return Oa.errors = o, 0 === i; }
function Na(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Na.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e || e % 1 || isNaN(e)) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
    null === o ? o = [e] : o.push(e), i++;
} if ("number" == typeof e && (e < 0 || isNaN(e))) {
    const e = { instancePath: t, schemaPath: "#/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
    null === o ? o = [e] : o.push(e), i++;
} return Na.errors = o, 0 === i; }
function Ua(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ua.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e || e % 1 || isNaN(e)) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
    null === o ? o = [e] : o.push(e), i++;
} if ("number" == typeof e && (e < 0 || isNaN(e))) {
    const e = { instancePath: t, schemaPath: "#/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
    null === o ? o = [e] : o.push(e), i++;
} return Ua.errors = o, 0 === i; }
function Ta(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ta.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), Array.isArray(e)) {
    const a = e.length;
    for (let r = 0; r < a; r++)
        if ("string" != typeof e[r]) {
            const e = { instancePath: t + "/" + r, schemaPath: "#/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    let r, s = e.length;
    if (s > 1) {
        const a = {};
        for (; s--;) {
            let n = e[s];
            if ("string" == typeof n) {
                if ("number" == typeof a[n]) {
                    r = a[n];
                    const e = { instancePath: t, schemaPath: "#/uniqueItems", keyword: "uniqueItems", params: { i: s, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + s + " are identical)" };
                    null === o ? o = [e] : o.push(e), i++;
                    break;
                }
                a[n] = s;
            }
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === o ? o = [e] : o.push(e), i++;
} return Ta.errors = o, 0 === i; }
function Ma(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Ma.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), (!e || "object" != typeof e || Array.isArray(e)) && "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: Ia.type }, message: "must be object,boolean" };
    null === i ? i = [e] : i.push(e), p++;
} if (o.meta || (o.meta = Ma), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 !== e.type) {
        let r = e.type;
        const s = p;
        let c = !0;
        const u = p;
        if ("string" != typeof r) {
            const e = {};
            null === i ? i = [e] : i.push(e), p++;
        }
        var l = u === p;
        let h;
        if (p = s, null !== i && (s ? i.length = s : i = null), l) {
            const a = p;
            Oa(r, { instancePath: t + "/type", parentData: e, parentDataProperty: "type", rootData: n, dynamicAnchors: o }) || (i = null === i ? Oa.errors : i.concat(Oa.errors), p = i.length), c = l = a === p, h = "then";
        }
        else {
            const e = p, s = p;
            let u = !0;
            const d = p;
            if (!Array.isArray(r)) {
                const e = {};
                null === i ? i = [e] : i.push(e), p++;
            }
            var m = d === p;
            let y;
            if (p = s, null !== i && (s ? i.length = s : i = null), m) {
                const e = p;
                if (Array.isArray(r)) {
                    if (r.length < 1) {
                        const e = { instancePath: t + "/type", schemaPath: "#/properties/type/else/then/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    const e = r.length;
                    for (let a = 0; a < e; a++)
                        Oa(r[a], { instancePath: t + "/type/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Oa.errors : i.concat(Oa.errors), p = i.length);
                    let s, c = r.length;
                    if (c > 1)
                        e: for (; c--;)
                            for (s = c; s--;)
                                if (a(r[c], r[s])) {
                                    const e = { instancePath: t + "/type", schemaPath: "#/properties/type/else/then/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                                    null === i ? i = [e] : i.push(e), p++;
                                    break e;
                                }
                }
                else {
                    const e = { instancePath: t + "/type", schemaPath: "#/properties/type/else/then/type", keyword: "type", params: { type: "array" }, message: "must be array" };
                    null === i ? i = [e] : i.push(e), p++;
                }
                u = m = e === p, y = "then";
            }
            else {
                const e = p, a = { instancePath: t + "/type", schemaPath: "#/properties/type/else/else/not", keyword: "not", params: {}, message: "must NOT be valid" };
                if (null === i ? i = [a] : i.push(a), p++, p > 0) {
                    const e = [];
                    for (const a of i)
                        "errorMessage" === a.keyword || a.emUsed || a.instancePath !== t + "/type" && (0 !== a.instancePath.indexOf(t + "/type") || "/" !== a.instancePath[t + 5]) || 0 !== a.schemaPath.indexOf("#/properties/type/else/else") || "/" !== a.schemaPath[27] || (e.push(a), a.emUsed = !0);
                    if (e.length) {
                        const a = { instancePath: t + "/type", schemaPath: "#/properties/type/else/else/errorMessage", keyword: "errorMessage", params: { errors: e }, message: '"type" property must be either a string or an array of strings' };
                        null === i ? i = [a] : i.push(a), p++;
                    }
                    const a = [];
                    for (const e of i)
                        e.emUsed || a.push(e);
                    i = a, p = a.length;
                }
                u = m = e === p, y = "else";
            }
            if (!u) {
                const e = { instancePath: t + "/type", schemaPath: "#/properties/type/else/if", keyword: "if", params: { failingKeyword: y }, message: 'must match "' + y + '" schema' };
                null === i ? i = [e] : i.push(e), p++;
            }
            c = l = e === p, h = "else";
        }
        if (!c) {
            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.enum && !Array.isArray(e.enum)) {
        const e = { instancePath: t + "/enum", schemaPath: "#/properties/enum/type", keyword: "type", params: { type: "array" }, message: "must be array" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.multipleOf) {
        let a = e.multipleOf;
        if ("number" == typeof a) {
            if (a <= 0 || isNaN(a)) {
                const e = { instancePath: t + "/multipleOf", schemaPath: "#/properties/multipleOf/exclusiveMinimum", keyword: "exclusiveMinimum", params: { comparison: ">", limit: 0 }, message: "must be > 0" };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/multipleOf", schemaPath: "#/properties/multipleOf/type", keyword: "type", params: { type: "number" }, message: "must be number" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.maximum && "number" != typeof e.maximum) {
        const e = { instancePath: t + "/maximum", schemaPath: "#/properties/maximum/type", keyword: "type", params: { type: "number" }, message: "must be number" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.exclusiveMaximum && "number" != typeof e.exclusiveMaximum) {
        const e = { instancePath: t + "/exclusiveMaximum", schemaPath: "#/properties/exclusiveMaximum/type", keyword: "type", params: { type: "number" }, message: "must be number" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.minimum && "number" != typeof e.minimum) {
        const e = { instancePath: t + "/minimum", schemaPath: "#/properties/minimum/type", keyword: "type", params: { type: "number" }, message: "must be number" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.exclusiveMinimum && "number" != typeof e.exclusiveMinimum) {
        const e = { instancePath: t + "/exclusiveMinimum", schemaPath: "#/properties/exclusiveMinimum/type", keyword: "type", params: { type: "number" }, message: "must be number" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.maxLength && (Na(e.maxLength, { instancePath: t + "/maxLength", parentData: e, parentDataProperty: "maxLength", rootData: n, dynamicAnchors: o }) || (i = null === i ? Na.errors : i.concat(Na.errors), p = i.length)), void 0 !== e.minLength && (Ua(e.minLength, { instancePath: t + "/minLength", parentData: e, parentDataProperty: "minLength", rootData: n, dynamicAnchors: o }) || (i = null === i ? Ua.errors : i.concat(Ua.errors), p = i.length)), void 0 !== e.pattern) {
        let a = e.pattern;
        if ("string" == typeof a) {
            if (!T(a)) {
                const e = { instancePath: t + "/pattern", schemaPath: "#/properties/pattern/format", keyword: "format", params: { format: "regex" }, message: 'must match format "regex"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/pattern", schemaPath: "#/properties/pattern/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.maxItems && (Na(e.maxItems, { instancePath: t + "/maxItems", parentData: e, parentDataProperty: "maxItems", rootData: n, dynamicAnchors: o }) || (i = null === i ? Na.errors : i.concat(Na.errors), p = i.length)), void 0 !== e.minItems && (Ua(e.minItems, { instancePath: t + "/minItems", parentData: e, parentDataProperty: "minItems", rootData: n, dynamicAnchors: o }) || (i = null === i ? Ua.errors : i.concat(Ua.errors), p = i.length)), void 0 !== e.uniqueItems && "boolean" != typeof e.uniqueItems) {
        const e = { instancePath: t + "/uniqueItems", schemaPath: "#/properties/uniqueItems/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.maxContains && (Na(e.maxContains, { instancePath: t + "/maxContains", parentData: e, parentDataProperty: "maxContains", rootData: n, dynamicAnchors: o }) || (i = null === i ? Na.errors : i.concat(Na.errors), p = i.length)), void 0 !== e.minContains && (Na(e.minContains, { instancePath: t + "/minContains", parentData: e, parentDataProperty: "minContains", rootData: n, dynamicAnchors: o }) || (i = null === i ? Na.errors : i.concat(Na.errors), p = i.length)), void 0 !== e.maxProperties && (Na(e.maxProperties, { instancePath: t + "/maxProperties", parentData: e, parentDataProperty: "maxProperties", rootData: n, dynamicAnchors: o }) || (i = null === i ? Na.errors : i.concat(Na.errors), p = i.length)), void 0 !== e.minProperties && (Ua(e.minProperties, { instancePath: t + "/minProperties", parentData: e, parentDataProperty: "minProperties", rootData: n, dynamicAnchors: o }) || (i = null === i ? Ua.errors : i.concat(Ua.errors), p = i.length)), void 0 !== e.required && (Ta(e.required, { instancePath: t + "/required", parentData: e, parentDataProperty: "required", rootData: n, dynamicAnchors: o }) || (i = null === i ? Ta.errors : i.concat(Ta.errors), p = i.length)), void 0 !== e.dependentRequired) {
        let a = e.dependentRequired;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Ta(a[e], { instancePath: t + "/dependentRequired/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ta.errors : i.concat(Ta.errors), p = i.length);
        else {
            const e = { instancePath: t + "/dependentRequired", schemaPath: "#/properties/dependentRequired/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
} return Ma.errors = i, 0 === p; }
Oa.evaluated = { dynamicProps: !1, dynamicItems: !1 }, Na.evaluated = { dynamicProps: !1, dynamicItems: !1 }, Ua.evaluated = { dynamicProps: !1, dynamicItems: !1 }, Ta.evaluated = { items: !0, dynamicProps: !1, dynamicItems: !1 }, Ma.evaluated = { props: { type: !0, const: !0, enum: !0, multipleOf: !0, maximum: !0, exclusiveMaximum: !0, minimum: !0, exclusiveMinimum: !0, maxLength: !0, minLength: !0, pattern: !0, maxItems: !0, minItems: !0, uniqueItems: !0, maxContains: !0, minContains: !0, maxProperties: !0, minProperties: !0, required: !0, dependentRequired: !0 }, dynamicProps: !1, dynamicItems: !1 };
const Sa = { $schema: "https://json-schema.org/draft/2020-12/schema", $id: "https://json-schema.org/draft/2020-12/meta/meta-data", $vocabulary: { "https://json-schema.org/draft/2020-12/vocab/meta-data": !0 }, $dynamicAnchor: "meta", title: "Meta-data vocabulary meta-schema", type: ["object", "boolean"], properties: { title: { type: "string" }, description: { type: "string" }, default: !0, deprecated: { type: "boolean", default: !1 }, readOnly: { type: "boolean", default: !1 }, writeOnly: { type: "boolean", default: !1 }, examples: { type: "array", items: !0 } } };
function za(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = za.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), (!e || "object" != typeof e || Array.isArray(e)) && "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: Sa.type }, message: "must be object,boolean" };
    null === o ? o = [e] : o.push(e), i++;
} if (n.meta || (n.meta = za), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 !== e.title && "string" != typeof e.title) {
        const e = { instancePath: t + "/title", schemaPath: "#/properties/title/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.deprecated && "boolean" != typeof e.deprecated) {
        const e = { instancePath: t + "/deprecated", schemaPath: "#/properties/deprecated/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.readOnly && "boolean" != typeof e.readOnly) {
        const e = { instancePath: t + "/readOnly", schemaPath: "#/properties/readOnly/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.writeOnly && "boolean" != typeof e.writeOnly) {
        const e = { instancePath: t + "/writeOnly", schemaPath: "#/properties/writeOnly/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.examples && !Array.isArray(e.examples)) {
        const e = { instancePath: t + "/examples", schemaPath: "#/properties/examples/type", keyword: "type", params: { type: "array" }, message: "must be array" };
        null === o ? o = [e] : o.push(e), i++;
    }
} return za.errors = o, 0 === i; }
za.evaluated = { props: { title: !0, description: !0, default: !0, deprecated: !0, readOnly: !0, writeOnly: !0, examples: !0 }, dynamicProps: !1, dynamicItems: !1 };
const La = { $schema: "https://json-schema.org/draft/2020-12/schema", $id: "https://json-schema.org/draft/2020-12/meta/format-annotation", $vocabulary: { "https://json-schema.org/draft/2020-12/vocab/format-annotation": !0 }, $dynamicAnchor: "meta", title: "Format vocabulary meta-schema for annotation results", type: ["object", "boolean"], properties: { format: { type: "string" } } };
function Ra(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ra.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), (!e || "object" != typeof e || Array.isArray(e)) && "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: La.type }, message: "must be object,boolean" };
    null === o ? o = [e] : o.push(e), i++;
} if (n.meta || (n.meta = Ra), e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.format && "string" != typeof e.format) {
    const e = { instancePath: t + "/format", schemaPath: "#/properties/format/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return Ra.errors = o, 0 === i; }
Ra.evaluated = { props: { format: !0 }, dynamicProps: !1, dynamicItems: !1 };
const Ca = { $schema: "https://json-schema.org/draft/2020-12/schema", $id: "https://json-schema.org/draft/2020-12/meta/content", $vocabulary: { "https://json-schema.org/draft/2020-12/vocab/content": !0 }, $dynamicAnchor: "meta", title: "Content vocabulary meta-schema", type: ["object", "boolean"], properties: { contentEncoding: { type: "string" }, contentMediaType: { type: "string" }, contentSchema: { $dynamicRef: "#meta" } } };
function Ea(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ea.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), (!e || "object" != typeof e || Array.isArray(e)) && "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: Ca.type }, message: "must be object,boolean" };
    null === o ? o = [e] : o.push(e), i++;
} if (n.meta || (n.meta = Ea), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 !== e.contentEncoding && "string" != typeof e.contentEncoding) {
        const e = { instancePath: t + "/contentEncoding", schemaPath: "#/properties/contentEncoding/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.contentMediaType && "string" != typeof e.contentMediaType) {
        const e = { instancePath: t + "/contentMediaType", schemaPath: "#/properties/contentMediaType/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.contentSchema) {
        let a = e.contentSchema, r = n.meta;
        if (r)
            if (r(a, { instancePath: t + "/contentSchema", parentData: e, parentDataProperty: "contentSchema", rootData: s, dynamicAnchors: n }))
                var c = r.evaluated.props, l = r.evaluated.items;
            else
                o = null === o ? r.errors : o.concat(r.errors), i = o.length;
        else if (Ea(a, { instancePath: t + "/contentSchema", parentData: e, parentDataProperty: "contentSchema", rootData: s, dynamicAnchors: n })) {
            var m = Ea.evaluated.props;
            !0 !== c && void 0 !== m && (!0 === m ? c = !0 : (c = c || {}, Object.assign(c, m)));
            var u = Ea.evaluated.items;
            !0 !== l && void 0 !== u && (l = !0 === u || (l > u ? l : u));
        }
        else
            o = null === o ? Ea.errors : o.concat(Ea.errors), i = o.length;
    }
} return Ea.errors = o, 0 === i; }
function Va(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Va.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e) {
        let r = e[a], p = n.meta;
        if (p)
            if (p(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }))
                var c = p.evaluated.props, l = p.evaluated.items;
            else
                o = null === o ? p.errors : o.concat(p.errors), i = o.length;
        else if (Va(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n })) {
            var m = Va.evaluated.props;
            !0 !== c && void 0 !== m && (!0 === m ? c = !0 : (c = c || {}, Object.assign(c, m)));
            var u = Va.evaluated.items;
            !0 !== l && void 0 !== u && (l = !0 === u || (l > u ? l : u));
        }
        else
            o = null === o ? Va.errors : o.concat(Va.errors), i = o.length;
    }
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Va.errors = o, 0 === i; }
function Ka(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ka.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), Array.isArray(e)) {
    const a = e.length;
    for (let r = 0; r < a; r++)
        if ("string" != typeof e[r]) {
            const e = { instancePath: t + "/" + r, schemaPath: "#/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    let r, s = e.length;
    if (s > 1) {
        const a = {};
        for (; s--;) {
            let n = e[s];
            if ("string" == typeof n) {
                if ("number" == typeof a[n]) {
                    r = a[n];
                    const e = { instancePath: t, schemaPath: "#/uniqueItems", keyword: "uniqueItems", params: { i: s, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + s + " are identical)" };
                    null === o ? o = [e] : o.push(e), i++;
                    break;
                }
                a[n] = s;
            }
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === o ? o = [e] : o.push(e), i++;
} return Ka.errors = o, 0 === i; }
function Fa(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Fa.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e) {
        let r = e[a];
        const p = i;
        let d = !1;
        const y = i;
        let f = n.meta;
        if (f)
            if (f(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }))
                var c = f.evaluated.props, l = f.evaluated.items;
            else
                o = null === o ? f.errors : o.concat(f.errors), i = o.length;
        else if (Fa(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n })) {
            var m = Fa.evaluated.props;
            !0 !== c && void 0 !== m && (!0 === m ? c = !0 : (c = c || {}, Object.assign(c, m)));
            var u = Fa.evaluated.items;
            !0 !== l && void 0 !== u && (l = !0 === u || (l > u ? l : u));
        }
        else
            o = null === o ? Fa.errors : o.concat(Fa.errors), i = o.length;
        var h = y === i;
        d = d || h;
        const P = i;
        if (Ka(r, { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ka.errors : o.concat(Ka.errors), i = o.length), h = P === i, d = d || h, h && !0 !== l && (l = !0), d)
            i = p, null !== o && (p ? o.length = p : o = null);
        else {
            const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/additionalProperties/anyOf", keyword: "anyOf", params: {}, message: "must match a schema in anyOf" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Fa.errors = o, 0 === i; }
function Ba(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ba.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" == typeof e) {
    if (!va.test(e)) {
        const e = { instancePath: t, schemaPath: "#/pattern", keyword: "pattern", params: { pattern: "^[A-Za-z_][-A-Za-z0-9._]*$" }, message: 'must match pattern "^[A-Za-z_][-A-Za-z0-9._]*$"' };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return Ba.errors = o, 0 === i; }
function _a(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = _a.evaluated; return p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), Ba(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ba.errors : o.concat(Ba.errors), i = o.length), _a.errors = o, 0 === i; }
function Za(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Za.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return Za.errors = o, 0 === i; }
function Ha(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ha.evaluated; return p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), Za(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Za.errors : o.concat(Za.errors), i = o.length), Ha.errors = o, 0 === i; }
function Xa(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Xa.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), n.meta || (n.meta = Xa); const c = i; let l = !0; const m = i; if (!e || "object" != typeof e || Array.isArray(e)) {
    const e = {};
    null === o ? o = [e] : o.push(e), i++;
} var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (wa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? wa.errors : o.concat(wa.errors), i = o.length), $a(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? $a.errors : o.concat($a.errors), i = o.length), qa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? qa.errors : o.concat(qa.errors), i = o.length), Ma(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ma.errors : o.concat(Ma.errors), i = o.length), za(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? za.errors : o.concat(za.errors), i = o.length), Ra(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ra.errors : o.concat(Ra.errors), i = o.length), Ea(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ea.errors : o.concat(Ea.errors), i = o.length), e && "object" == typeof e && !Array.isArray(e) && (void 0 !== e.definitions && (Va(e.definitions, { instancePath: t + "/definitions", parentData: e, parentDataProperty: "definitions", rootData: s, dynamicAnchors: n }) || (o = null === o ? Va.errors : o.concat(Va.errors), i = o.length)), void 0 !== e.dependencies && (Fa(e.dependencies, { instancePath: t + "/dependencies", parentData: e, parentDataProperty: "dependencies", rootData: s, dynamicAnchors: n }) || (o = null === o ? Fa.errors : o.concat(Fa.errors), i = o.length)), void 0 !== e.$recursiveAnchor && (_a(e.$recursiveAnchor, { instancePath: t + "/$recursiveAnchor", parentData: e, parentDataProperty: "$recursiveAnchor", rootData: s, dynamicAnchors: n }) || (o = null === o ? _a.errors : o.concat(_a.errors), i = o.length)), void 0 !== e.$recursiveRef && (Ha(e.$recursiveRef, { instancePath: t + "/$recursiveRef", parentData: e, parentDataProperty: "$recursiveRef", rootData: s, dynamicAnchors: n }) || (o = null === o ? Ha.errors : o.concat(Ha.errors), i = o.length))), l = u = p === i, l)
        var d = { definitions: !0, dependencies: !0, $recursiveAnchor: !0, $recursiveRef: !0, contentEncoding: !0, contentMediaType: !0, contentSchema: !0, format: !0, title: !0, description: !0, default: !0, deprecated: !0, readOnly: !0, writeOnly: !0, examples: !0, type: !0, const: !0, enum: !0, multipleOf: !0, maximum: !0, exclusiveMaximum: !0, minimum: !0, exclusiveMinimum: !0, maxLength: !0, minLength: !0, pattern: !0, maxItems: !0, minItems: !0, uniqueItems: !0, maxContains: !0, minContains: !0, maxProperties: !0, minProperties: !0, required: !0, dependentRequired: !0, unevaluatedItems: !0, unevaluatedProperties: !0, prefixItems: !0, items: !0, contains: !0, additionalProperties: !0, properties: !0, patternProperties: !0, dependentSchemas: !0, propertyNames: !0, if: !0, then: !0, else: !0, allOf: !0, anyOf: !0, oneOf: !0, not: !0, $id: !0, $schema: !0, $ref: !0, $anchor: !0, $dynamicRef: !0, $dynamicAnchor: !0, $vocabulary: !0, $comment: !0, $defs: !0 };
    h = "then";
}
else {
    const a = i, r = i;
    let s = !0;
    const n = i;
    if ("boolean" != typeof e) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    var y = n === i;
    if (i = r, null !== o && (r ? o.length = r : o = null), !y) {
        const e = i, a = { instancePath: t, schemaPath: "#/else/else/not", keyword: "not", params: {}, message: "must NOT be valid" };
        if (null === o ? o = [a] : o.push(a), i++, i > 0) {
            const e = [];
            for (const a of o)
                "errorMessage" === a.keyword || a.emUsed || a.instancePath !== t && (0 !== a.instancePath.indexOf(t) || "/" !== a.instancePath[t.length]) || 0 !== a.schemaPath.indexOf("#/else/else") || "/" !== a.schemaPath[11] || (e.push(a), a.emUsed = !0);
            if (e.length) {
                const a = { instancePath: t, schemaPath: "#/else/else/errorMessage", keyword: "errorMessage", params: { errors: e }, message: '"{{property}}" property must be a valid Schema Object' };
                null === o ? o = [a] : o.push(a), i++;
            }
            const a = [];
            for (const e of o)
                e.emUsed || a.push(e);
            o = a, i = a.length;
        }
        s = y = e === i;
    }
    if (!s) {
        const e = { instancePath: t, schemaPath: "#/else/if", keyword: "if", params: { failingKeyword: "else" }, message: 'must match "else" schema' };
        null === o ? o = [e] : o.push(e), i++;
    }
    l = u = a === i, h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Xa.errors = o, p.props = d, 0 === i; }
function Ga(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { const i = Ga.evaluated; if (i.dynamicProps && (i.props = void 0), i.dynamicItems && (i.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    var p = {};
    for (const t in e)
        r.test(t) && (p[t] = !0);
} return Ga.errors = null, i.props = p, !0; }
function Ja(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ja.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), Ga(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = Ga.evaluated.props;
else
    o = null === o ? Ga.errors : o.concat(Ga.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.propertyName) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "propertyName" }, message: "must have required property 'propertyName'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).propertyName = !0, c.mapping = !0), void 0 !== e.propertyName && "string" != typeof e.propertyName) {
        const e = { instancePath: t + "/propertyName", schemaPath: "#/properties/propertyName/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.mapping) {
        let a = e.mapping;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            for (const e in a)
                if ("string" != typeof a[e]) {
                    const a = { instancePath: t + "/mapping/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/mapping/additionalProperties/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === o ? o = [a] : o.push(a), i++;
                }
        }
        else {
            const e = { instancePath: t + "/mapping", schemaPath: "#/properties/mapping/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Ja.errors = o, 0 === i; }
function Wa(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Wa.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), Ga(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = Ga.evaluated.props;
else
    o = null === o ? Ga.errors : o.concat(Ga.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.url) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "url" }, message: "must have required property 'url'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).url = !0, c.description = !0), void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Wa.errors = o, 0 === i; }
function Ya(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let i = null, p = 0; const c = Ya.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), Ga(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var l = Ga.evaluated.props;
else
    i = null === i ? Ga.errors : i.concat(Ga.errors), p = i.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== l && ((l = l || {}).name = !0, l.namespace = !0, l.prefix = !0, l.attribute = !0, l.wrapped = !0), void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.namespace) {
        let a = e.namespace;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/namespace", schemaPath: "#/properties/namespace/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/namespace", schemaPath: "#/properties/namespace/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.prefix && "string" != typeof e.prefix) {
        const e = { instancePath: t + "/prefix", schemaPath: "#/properties/prefix/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.attribute && "boolean" != typeof e.attribute) {
        const e = { instancePath: t + "/attribute", schemaPath: "#/properties/attribute/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.wrapped && "boolean" != typeof e.wrapped) {
        const e = { instancePath: t + "/wrapped", schemaPath: "#/properties/wrapped/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Ya.errors = i, 0 === p; }
function Qa(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Qa.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (!e || "object" != typeof e || Array.isArray(e)) {
    const e = {};
    null === o ? o = [e] : o.push(e), i++;
} var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e))
        void 0 !== e.discriminator && (Ja(e.discriminator, { instancePath: t + "/discriminator", parentData: e, parentDataProperty: "discriminator", rootData: s, dynamicAnchors: n }) || (o = null === o ? Ja.errors : o.concat(Ja.errors), i = o.length)), void 0 !== e.externalDocs && (Wa(e.externalDocs, { instancePath: t + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: s, dynamicAnchors: n }) || (o = null === o ? Wa.errors : o.concat(Wa.errors), i = o.length)), void 0 !== e.xml && (Ya(e.xml, { instancePath: t + "/xml", parentData: e, parentDataProperty: "xml", rootData: s, dynamicAnchors: n }) || (o = null === o ? Ya.errors : o.concat(Ya.errors), i = o.length));
    else {
        const e = { instancePath: t, schemaPath: "#/then/type", keyword: "type", params: { type: "object" }, message: "must be object" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (l = u = a === i, l)
        var d = { example: !0, discriminator: !0, externalDocs: !0, xml: !0 };
    h = "then";
}
else {
    const a = i, r = i;
    let s = !0;
    const n = i;
    if ("boolean" != typeof e) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    var y = n === i;
    if (i = r, null !== o && (r ? o.length = r : o = null), !y) {
        const e = i, a = { instancePath: t, schemaPath: "#/else/else/not", keyword: "not", params: {}, message: "must NOT be valid" };
        if (null === o ? o = [a] : o.push(a), i++, i > 0) {
            const e = [];
            for (const a of o)
                "errorMessage" === a.keyword || a.emUsed || a.instancePath !== t && (0 !== a.instancePath.indexOf(t) || "/" !== a.instancePath[t.length]) || 0 !== a.schemaPath.indexOf("#/else/else") || "/" !== a.schemaPath[11] || (e.push(a), a.emUsed = !0);
            if (e.length) {
                const a = { instancePath: t, schemaPath: "#/else/else/errorMessage", keyword: "errorMessage", params: { errors: e }, message: '"{{property}}" property must be a valid Schema Object' };
                null === o ? o = [a] : o.push(a), i++;
            }
            const a = [];
            for (const e of o)
                e.emUsed || a.push(e);
            o = a, i = a.length;
        }
        s = y = e === i;
    }
    if (!s) {
        const e = { instancePath: t, schemaPath: "#/else/if", keyword: "if", params: { failingKeyword: "else" }, message: 'must match "else" schema' };
        null === o ? o = [e] : o.push(e), i++;
    }
    l = u = a === i, h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Qa.errors = o, p.props = d, 0 === i; }
function er(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = er.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (!e || "object" != typeof e || Array.isArray(e)) {
    const e = {};
    null === o ? o = [e] : o.push(e), i++;
} var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (Xa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
        var d = Xa.evaluated.props;
    else
        o = null === o ? Xa.errors : o.concat(Xa.errors), i = o.length;
    if (Qa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
        var y = Qa.evaluated.props;
    else
        o = null === o ? Qa.errors : o.concat(Qa.errors), i = o.length;
    !0 !== d && void 0 !== y && (!0 === y ? d = !0 : (d = d || {}, Object.assign(d, y))), l = u = p === i, h = "then";
}
else {
    const a = i, r = i;
    let s = !0;
    const n = i;
    if ("boolean" != typeof e) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    var f = n === i;
    if (i = r, null !== o && (r ? o.length = r : o = null), !f) {
        const e = i, a = { instancePath: t, schemaPath: "#/else/else/not", keyword: "not", params: {}, message: "must NOT be valid" };
        if (null === o ? o = [a] : o.push(a), i++, i > 0) {
            const e = [];
            for (const a of o)
                "errorMessage" === a.keyword || a.emUsed || a.instancePath !== t && (0 !== a.instancePath.indexOf(t) || "/" !== a.instancePath[t.length]) || 0 !== a.schemaPath.indexOf("#/else/else") || "/" !== a.schemaPath[11] || (e.push(a), a.emUsed = !0);
            if (e.length) {
                const a = { instancePath: t, schemaPath: "#/else/else/errorMessage", keyword: "errorMessage", params: { errors: e }, message: '"{{property}}" property must be a valid Schema Object' };
                null === o ? o = [a] : o.push(a), i++;
            }
            const a = [];
            for (const e of o)
                e.emUsed || a.push(e);
            o = a, i = a.length;
        }
        s = f = e === i;
    }
    if (!s) {
        const e = { instancePath: t, schemaPath: "#/else/if", keyword: "if", params: { failingKeyword: "else" }, message: 'must match "else" schema' };
        null === o ? o = [e] : o.push(e), i++;
    }
    l = u = a === i, h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return er.errors = o, p.props = d, 0 === i; }
function tr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let i = null, p = 0; const c = tr.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var l = pa.evaluated.props;
else
    i = null === i ? pa.errors : i.concat(pa.errors), p = i.length; const m = p, u = p; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.value && (t = "value") || void 0 === e.externalValue && (t = "externalValue")) {
        const e = {};
        null === i ? i = [e] : i.push(e), p++;
    }
} if (u === p) {
    const e = { instancePath: t, schemaPath: "#/not", keyword: "not", params: {}, message: "must NOT be valid" };
    null === i ? i = [e] : i.push(e), p++;
}
else
    p = m, null !== i && (m ? i.length = m : i = null); if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== l && ((l = l || {}).summary = !0, l.description = !0, l.value = !0, l.externalValue = !0), void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: t + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.externalValue) {
        let a = e.externalValue;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/externalValue", schemaPath: "#/properties/externalValue/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/externalValue", schemaPath: "#/properties/externalValue/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return tr.errors = i, 0 === p; }
function ar(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ar.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.$ref && (t = "$ref")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (da(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? da.errors : o.concat(da.errors), i = o.length), l = u = p === i, l)
        var d = { $ref: !0, summary: !0, description: !0 };
    h = "then";
}
else {
    const p = i;
    tr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? tr.errors : o.concat(tr.errors), i = o.length), l = u = p === i, l && !0 !== d && (d = !0), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return ar.errors = o, p.props = d, 0 === i; }
function rr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = rr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.examples) {
    let a = e.examples;
    if (a && "object" == typeof a && !Array.isArray(a))
        for (const e in a)
            ar(a[e], { instancePath: t + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? ar.errors : o.concat(ar.errors), i = o.length);
    else {
        const e = { instancePath: t + "/examples", schemaPath: "#/properties/examples/type", keyword: "type", params: { type: "object" }, message: "must be object" };
        null === o ? o = [e] : o.push(e), i++;
    }
} return rr.errors = o, 0 === i; }
Ea.evaluated = { props: { contentEncoding: !0, contentMediaType: !0, contentSchema: !0 }, dynamicProps: !1, dynamicItems: !1 }, Va.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ka.evaluated = { items: !0, dynamicProps: !1, dynamicItems: !1 }, Fa.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ba.evaluated = { dynamicProps: !1, dynamicItems: !1 }, _a.evaluated = { dynamicProps: !1, dynamicItems: !1 }, Za.evaluated = { dynamicProps: !1, dynamicItems: !1 }, Ha.evaluated = { dynamicProps: !1, dynamicItems: !1 }, Xa.evaluated = { dynamicProps: !0, dynamicItems: !1 }, Ga.evaluated = { dynamicProps: !0, dynamicItems: !1 }, Ja.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Wa.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ya.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Qa.evaluated = { dynamicProps: !0, dynamicItems: !1 }, er.evaluated = { dynamicProps: !0, dynamicItems: !1 }, tr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ar.evaluated = { dynamicProps: !0, dynamicItems: !1 }, rr.evaluated = { props: { example: !0, examples: !0 }, dynamicProps: !1, dynamicItems: !1 };
const sr = { $comment: "https://spec.openapis.org/oas/v3.1.0#encoding-object", type: "object", properties: { contentType: { type: "string", format: "media-range" }, headers: { type: "object", additionalProperties: { $ref: "#/$defs/header-or-reference" } }, style: { default: "form", enum: ["form", "spaceDelimited", "pipeDelimited", "deepObject"] }, explode: { type: "boolean" }, allowReserved: { default: !1, type: "boolean" } }, allOf: [{ $ref: "#/$defs/specification-extensions" }, { $ref: "#/$defs/styles-for-form" }], unevaluatedProperties: !1 };
function nr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = nr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.style && (t = "style")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.style && "form" !== e.style) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    if (l = u = i == i, l)
        var d = { explode: !0, style: !0 };
    h = "then";
}
else
    l = u = i == i, l && !0 !== d && ((d = d || {}).explode = !0), h = "else"; if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return nr.errors = o, p.props = d, 0 === i; }
nr.evaluated = { dynamicProps: !0, dynamicItems: !1 };
const or = { validate: mr };
function ir(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ir.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; const l = i; let m = !1, u = null; const h = i; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.schema) {
    const e = { instancePath: t, schemaPath: "#/oneOf/0/required", keyword: "required", params: { missingProperty: "schema" }, message: "must have required property 'schema'" };
    null === o ? o = [e] : o.push(e), i++;
} h === i && (m = !0, u = 0); const d = i; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.content) {
    const e = { instancePath: t, schemaPath: "#/oneOf/1/required", keyword: "required", params: { missingProperty: "content" }, message: "must have required property 'content'" };
    null === o ? o = [e] : o.push(e), i++;
} var y; if ((y = d === i) && m ? (m = !1, u = [u, 1]) : y && (m = !0, u = 1), m)
    i = l, null !== o && (l ? o.length = l : o = null);
else {
    const e = { instancePath: t, schemaPath: "#/oneOf", keyword: "oneOf", params: { passingSchemas: u }, message: "must match exactly one schema in oneOf" };
    null === o ? o = [e] : o.push(e), i++;
} if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== c && ((c = c || {}).description = !0, c.required = !0, c.deprecated = !0, c.schema = !0, c.content = !0), void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.required && "boolean" != typeof e.required) {
        const e = { instancePath: t + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.deprecated && "boolean" != typeof e.deprecated) {
        const e = { instancePath: t + "/deprecated", schemaPath: "#/properties/deprecated/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.schema && (er(e.schema, { instancePath: t + "/schema", parentData: e, parentDataProperty: "schema", rootData: s, dynamicAnchors: n }) || (o = null === o ? er.errors : o.concat(er.errors), i = o.length)), void 0 !== e.content) {
        let a = e.content;
        if (or.validate(a, { instancePath: t + "/content", parentData: e, parentDataProperty: "content", rootData: s, dynamicAnchors: n }) || (o = null === o ? or.validate.errors : o.concat(or.validate.errors), i = o.length), a && "object" == typeof a && !Array.isArray(a)) {
            if (Object.keys(a).length > 1) {
                const e = { instancePath: t + "/content", schemaPath: "#/properties/content/maxProperties", keyword: "maxProperties", params: { limit: 1 }, message: "must NOT have more than 1 properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
            if (Object.keys(a).length < 1) {
                const e = { instancePath: t + "/content", schemaPath: "#/properties/content/minProperties", keyword: "minProperties", params: { limit: 1 }, message: "must NOT have fewer than 1 properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
    }
    if (void 0 !== e.schema) {
        const p = i;
        if (rr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? rr.errors : o.concat(rr.errors), i = o.length), e && "object" == typeof e && !Array.isArray(e)) {
            if (void 0 !== e.style && "simple" !== e.style) {
                const e = { instancePath: t + "/style", schemaPath: "#/dependentSchemas/schema/properties/style/const", keyword: "const", params: { allowedValue: "simple" }, message: "must be equal to constant" };
                null === o ? o = [e] : o.push(e), i++;
            }
            if (void 0 !== e.explode && "boolean" != typeof e.explode) {
                const e = { instancePath: t + "/explode", schemaPath: "#/dependentSchemas/schema/properties/explode/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        p === i && !0 !== c && ((c = c || {}).style = !0, c.explode = !0, c.example = !0, c.examples = !0);
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return ir.errors = o, 0 === i; }
function pr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = pr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.$ref && (t = "$ref")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (da(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? da.errors : o.concat(da.errors), i = o.length), l = u = p === i, l)
        var d = { $ref: !0, summary: !0, description: !0 };
    h = "then";
}
else {
    const p = i;
    ir(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? ir.errors : o.concat(ir.errors), i = o.length), l = u = p === i, l && !0 !== d && (d = !0), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return pr.errors = o, p.props = d, 0 === i; }
function cr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = cr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (nr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var l = nr.evaluated.props;
else
    o = null === o ? nr.errors : o.concat(nr.errors), i = o.length; if (!0 !== c && void 0 !== l && (!0 === l ? c = !0 : (c = c || {}, Object.assign(c, l))), e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== c && ((c = c || {}).contentType = !0, c.headers = !0, c.style = !0, c.explode = !0, c.allowReserved = !0), void 0 !== e.contentType && "string" != typeof e.contentType) {
        const e = { instancePath: t + "/contentType", schemaPath: "#/properties/contentType/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.headers) {
        let a = e.headers;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                pr(a[e], { instancePath: t + "/headers/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? pr.errors : o.concat(pr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/headers", schemaPath: "#/properties/headers/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.style) {
        let a = e.style;
        if ("form" !== a && "spaceDelimited" !== a && "pipeDelimited" !== a && "deepObject" !== a) {
            const e = { instancePath: t + "/style", schemaPath: "#/properties/style/enum", keyword: "enum", params: { allowedValues: sr.properties.style.enum }, message: "must be equal to one of the allowed values" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.explode && "boolean" != typeof e.explode) {
        const e = { instancePath: t + "/explode", schemaPath: "#/properties/explode/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.allowReserved && "boolean" != typeof e.allowReserved) {
        const e = { instancePath: t + "/allowReserved", schemaPath: "#/properties/allowReserved/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return cr.errors = o, 0 === i; }
function lr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = lr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (rr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? rr.errors : o.concat(rr.errors), i = o.length), !0 !== c && ((c = c || {}).example = !0, c.examples = !0), e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== c && ((c = c || {}).schema = !0, c.encoding = !0), void 0 !== e.schema && (er(e.schema, { instancePath: t + "/schema", parentData: e, parentDataProperty: "schema", rootData: s, dynamicAnchors: n }) || (o = null === o ? er.errors : o.concat(er.errors), i = o.length)), void 0 !== e.encoding) {
        let a = e.encoding;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                cr(a[e], { instancePath: t + "/encoding/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? cr.errors : o.concat(cr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/encoding", schemaPath: "#/properties/encoding/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return lr.errors = o, 0 === i; }
function mr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = mr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if (i != i) {
            const e = { instancePath: t, schemaPath: "#/propertyNames", keyword: "propertyNames", params: { propertyName: a }, message: "property name must be valid" };
            null === o ? o = [e] : o.push(e), i++;
        }
    for (const a in e)
        lr(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? lr.errors : o.concat(lr.errors), i = o.length);
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return mr.errors = o, 0 === i; }
ir.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, pr.evaluated = { dynamicProps: !0, dynamicItems: !1 }, cr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, lr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, mr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const ur = { if: { properties: { in: { const: "path" } }, required: ["in"] }, then: { properties: { style: { default: "simple", enum: ["matrix", "label", "simple"] }, required: { const: !0 } }, required: ["required"] } };
function hr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = hr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.in && (t = "in")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.in && "path" !== e.in) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var u = m === i; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e)) {
        if (void 0 === e.required) {
            const e = { instancePath: t, schemaPath: "#/then/required", keyword: "required", params: { missingProperty: "required" }, message: "must have required property 'required'" };
            null === o ? o = [e] : o.push(e), i++;
        }
        if (void 0 !== e.style) {
            let a = e.style;
            if ("matrix" !== a && "label" !== a && "simple" !== a) {
                const e = { instancePath: t + "/style", schemaPath: "#/then/properties/style/enum", keyword: "enum", params: { allowedValues: ur.then.properties.style.enum }, message: "must be equal to one of the allowed values" };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        if (void 0 !== e.required && !0 !== e.required) {
            const e = { instancePath: t + "/required", schemaPath: "#/then/properties/required/const", keyword: "const", params: { allowedValue: !0 }, message: "must be equal to constant" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (l = u = a === i, l)
        var h = { style: !0, required: !0, in: !0 };
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return hr.errors = o, p.props = h, 0 === i; }
function dr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = dr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.in && (t = "in")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.in && "header" !== e.in) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var u = m === i; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.style && "simple" !== e.style) {
        const e = { instancePath: t + "/style", schemaPath: "#/then/properties/style/const", keyword: "const", params: { allowedValue: "simple" }, message: "must be equal to constant" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (l = u = a === i, l)
        var h = { style: !0, in: !0 };
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return dr.errors = o, p.props = h, 0 === i; }
hr.evaluated = { dynamicProps: !0, dynamicItems: !1 }, dr.evaluated = { dynamicProps: !0, dynamicItems: !1 };
const yr = { if: { properties: { in: { const: "query" } }, required: ["in"] }, then: { properties: { style: { default: "form", enum: ["form", "spaceDelimited", "pipeDelimited", "deepObject"] }, allowReserved: { default: !1, type: "boolean" } } } };
function fr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = fr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.in && (t = "in")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.in && "query" !== e.in) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var u = m === i; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e)) {
        if (void 0 !== e.style) {
            let a = e.style;
            if ("form" !== a && "spaceDelimited" !== a && "pipeDelimited" !== a && "deepObject" !== a) {
                const e = { instancePath: t + "/style", schemaPath: "#/then/properties/style/enum", keyword: "enum", params: { allowedValues: yr.then.properties.style.enum }, message: "must be equal to one of the allowed values" };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        if (void 0 !== e.allowReserved && "boolean" != typeof e.allowReserved) {
            const e = { instancePath: t + "/allowReserved", schemaPath: "#/then/properties/allowReserved/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (l = u = a === i, l)
        var h = { style: !0, allowReserved: !0, in: !0 };
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return fr.errors = o, p.props = h, 0 === i; }
function Pr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Pr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.in && (t = "in")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.in && "cookie" !== e.in) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var u = m === i; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.style && "form" !== e.style) {
        const e = { instancePath: t + "/style", schemaPath: "#/then/properties/style/const", keyword: "const", params: { allowedValue: "form" }, message: "must be equal to constant" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (l = u = a === i, l)
        var h = { style: !0, in: !0 };
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Pr.errors = o, p.props = h, 0 === i; }
function gr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = gr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; const l = i; let m = !1, u = null; const h = i; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.schema) {
    const e = { instancePath: t, schemaPath: "#/oneOf/0/required", keyword: "required", params: { missingProperty: "schema" }, message: "must have required property 'schema'" };
    null === o ? o = [e] : o.push(e), i++;
} h === i && (m = !0, u = 0); const d = i; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.content) {
    const e = { instancePath: t, schemaPath: "#/oneOf/1/required", keyword: "required", params: { missingProperty: "content" }, message: "must have required property 'content'" };
    null === o ? o = [e] : o.push(e), i++;
} var y; if ((y = d === i) && m ? (m = !1, u = [u, 1]) : y && (m = !0, u = 1), m)
    i = l, null !== o && (l ? o.length = l : o = null);
else {
    const e = { instancePath: t, schemaPath: "#/oneOf", keyword: "oneOf", params: { passingSchemas: u }, message: "must match exactly one schema in oneOf" };
    null === o ? o = [e] : o.push(e), i++;
} const f = i; let P = !0; const g = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.in && (t = "in")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.in && "query" !== e.in) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var v = g === i; if (!0 !== c && ((c = c || {}).in = !0), i = f, null !== o && (f ? o.length = f : o = null), v) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.allowEmptyValue && "boolean" != typeof e.allowEmptyValue) {
        const e = { instancePath: t + "/allowEmptyValue", schemaPath: "#/then/properties/allowEmptyValue/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    P = v = a === i, P && !0 !== c && ((c = c || {}).allowEmptyValue = !0);
} if (!P) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.in) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "in" }, message: "must have required property 'in'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).name = !0, c.in = !0, c.description = !0, c.required = !0, c.deprecated = !0, c.schema = !0, c.content = !0), void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.in) {
        let a = e.in;
        if ("query" !== a && "header" !== a && "path" !== a && "cookie" !== a) {
            const e = { instancePath: t + "/in", schemaPath: "#/properties/in/enum", keyword: "enum", params: { allowedValues: ya.properties.in.enum }, message: "must be equal to one of the allowed values" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.required && "boolean" != typeof e.required) {
        const e = { instancePath: t + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.deprecated && "boolean" != typeof e.deprecated) {
        const e = { instancePath: t + "/deprecated", schemaPath: "#/properties/deprecated/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.schema && (er(e.schema, { instancePath: t + "/schema", parentData: e, parentDataProperty: "schema", rootData: s, dynamicAnchors: n }) || (o = null === o ? er.errors : o.concat(er.errors), i = o.length)), void 0 !== e.content) {
        let a = e.content;
        if (mr(a, { instancePath: t + "/content", parentData: e, parentDataProperty: "content", rootData: s, dynamicAnchors: n }) || (o = null === o ? mr.errors : o.concat(mr.errors), i = o.length), a && "object" == typeof a && !Array.isArray(a)) {
            if (Object.keys(a).length > 1) {
                const e = { instancePath: t + "/content", schemaPath: "#/properties/content/maxProperties", keyword: "maxProperties", params: { limit: 1 }, message: "must NOT have more than 1 properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
            if (Object.keys(a).length < 1) {
                const e = { instancePath: t + "/content", schemaPath: "#/properties/content/minProperties", keyword: "minProperties", params: { limit: 1 }, message: "must NOT have fewer than 1 properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
    }
    if (void 0 !== e.schema) {
        const p = i;
        if (rr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? rr.errors : o.concat(rr.errors), i = o.length), hr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
            var b = hr.evaluated.props;
        else
            o = null === o ? hr.errors : o.concat(hr.errors), i = o.length;
        if (!0 !== b && ((b = b || {}).example = !0, b.examples = !0), dr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
            var D = dr.evaluated.props;
        else
            o = null === o ? dr.errors : o.concat(dr.errors), i = o.length;
        if (!0 !== b && void 0 !== D && (!0 === D ? b = !0 : (b = b || {}, Object.assign(b, D))), fr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
            var w = fr.evaluated.props;
        else
            o = null === o ? fr.errors : o.concat(fr.errors), i = o.length;
        if (!0 !== b && void 0 !== w && (!0 === w ? b = !0 : (b = b || {}, Object.assign(b, w))), Pr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
            var A = Pr.evaluated.props;
        else
            o = null === o ? Pr.errors : o.concat(Pr.errors), i = o.length;
        if (!0 !== b && void 0 !== A && (!0 === A ? b = !0 : (b = b || {}, Object.assign(b, A))), nr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
            var k = nr.evaluated.props;
        else
            o = null === o ? nr.errors : o.concat(nr.errors), i = o.length;
        if (!0 !== b && void 0 !== k && (!0 === k ? b = !0 : (b = b || {}, Object.assign(b, k))), e && "object" == typeof e && !Array.isArray(e)) {
            if (!0 !== b && ((b = b || {}).style = !0, b.explode = !0), void 0 !== e.style && "string" != typeof e.style) {
                const e = { instancePath: t + "/style", schemaPath: "#/dependentSchemas/schema/properties/style/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                null === o ? o = [e] : o.push(e), i++;
            }
            if (void 0 !== e.explode && "boolean" != typeof e.explode) {
                const e = { instancePath: t + "/explode", schemaPath: "#/dependentSchemas/schema/properties/explode/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        p === i && !0 !== c && void 0 !== b && (!0 === b ? c = !0 : (c = c || {}, Object.assign(c, b)));
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return gr.errors = o, 0 === i; }
function vr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = vr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.$ref && (t = "$ref")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (da(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? da.errors : o.concat(da.errors), i = o.length), l = u = p === i, l)
        var d = { $ref: !0, summary: !0, description: !0 };
    h = "then";
}
else {
    const p = i;
    gr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? gr.errors : o.concat(gr.errors), i = o.length), l = u = p === i, l && !0 !== d && (d = !0), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return vr.errors = o, p.props = d, 0 === i; }
function br(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let i = null, p = 0; const c = br.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var l = pa.evaluated.props;
else
    i = null === i ? pa.errors : i.concat(pa.errors), p = i.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.url) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "url" }, message: "must have required property 'url'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l && ((l = l || {}).description = !0, l.url = !0), void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return br.errors = i, 0 === p; }
function Dr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Dr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.content) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "content" }, message: "must have required property 'content'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).description = !0, c.content = !0, c.required = !0), void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.content && (mr(e.content, { instancePath: t + "/content", parentData: e, parentDataProperty: "content", rootData: s, dynamicAnchors: n }) || (o = null === o ? mr.errors : o.concat(mr.errors), i = o.length)), void 0 !== e.required && "boolean" != typeof e.required) {
        const e = { instancePath: t + "/required", schemaPath: "#/properties/required/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Dr.errors = o, 0 === i; }
function wr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = wr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.$ref && (t = "$ref")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (da(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? da.errors : o.concat(da.errors), i = o.length), l = u = p === i, l)
        var d = { $ref: !0, summary: !0, description: !0 };
    h = "then";
}
else {
    const p = i;
    Dr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Dr.errors : o.concat(Dr.errors), i = o.length), l = u = p === i, l && !0 !== d && (d = !0), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return wr.errors = o, p.props = d, 0 === i; }
function Ar(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ar.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        if ("string" != typeof e[a]) {
            const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/additionalProperties/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Ar.errors = o, 0 === i; }
function kr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = kr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; const l = i; let m = !1, u = null; const h = i; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.operationRef) {
    const e = { instancePath: t, schemaPath: "#/oneOf/0/required", keyword: "required", params: { missingProperty: "operationRef" }, message: "must have required property 'operationRef'" };
    null === o ? o = [e] : o.push(e), i++;
} h === i && (m = !0, u = 0); const d = i; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.operationId) {
    const e = { instancePath: t, schemaPath: "#/oneOf/1/required", keyword: "required", params: { missingProperty: "operationId" }, message: "must have required property 'operationId'" };
    null === o ? o = [e] : o.push(e), i++;
} var y; if ((y = d === i) && m ? (m = !1, u = [u, 1]) : y && (m = !0, u = 1), m)
    i = l, null !== o && (l ? o.length = l : o = null);
else {
    const e = { instancePath: t, schemaPath: "#/oneOf", keyword: "oneOf", params: { passingSchemas: u }, message: "must match exactly one schema in oneOf" };
    null === o ? o = [e] : o.push(e), i++;
} if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== c && ((c = c || {}).operationRef = !0, c.operationId = !0, c.parameters = !0, c.requestBody = !0, c.description = !0, c.body = !0), void 0 !== e.operationRef) {
        let a = e.operationRef;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/operationRef", schemaPath: "#/properties/operationRef/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/operationRef", schemaPath: "#/properties/operationRef/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.operationId && "string" != typeof e.operationId) {
        const e = { instancePath: t + "/operationId", schemaPath: "#/properties/operationId/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.parameters && (Ar(e.parameters, { instancePath: t + "/parameters", parentData: e, parentDataProperty: "parameters", rootData: s, dynamicAnchors: n }) || (o = null === o ? Ar.errors : o.concat(Ar.errors), i = o.length)), void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.body && (ha(e.body, { instancePath: t + "/body", parentData: e, parentDataProperty: "body", rootData: s, dynamicAnchors: n }) || (o = null === o ? ha.errors : o.concat(ha.errors), i = o.length)), !0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return kr.errors = o, 0 === i; }
function $r(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = $r.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.$ref && (t = "$ref")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (da(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? da.errors : o.concat(da.errors), i = o.length), l = u = p === i, l)
        var d = { $ref: !0, summary: !0, description: !0 };
    h = "then";
}
else {
    const p = i;
    kr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? kr.errors : o.concat(kr.errors), i = o.length), l = u = p === i, l && !0 !== d && (d = !0), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return $r.errors = o, p.props = d, 0 === i; }
function jr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = jr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.description) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "description" }, message: "must have required property 'description'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).description = !0, c.headers = !0, c.content = !0, c.links = !0), void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.headers) {
        let a = e.headers;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                pr(a[e], { instancePath: t + "/headers/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? pr.errors : o.concat(pr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/headers", schemaPath: "#/properties/headers/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.content && (mr(e.content, { instancePath: t + "/content", parentData: e, parentDataProperty: "content", rootData: s, dynamicAnchors: n }) || (o = null === o ? mr.errors : o.concat(mr.errors), i = o.length)), void 0 !== e.links) {
        let a = e.links;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                $r(a[e], { instancePath: t + "/links/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? $r.errors : o.concat($r.errors), i = o.length);
        else {
            const e = { instancePath: t + "/links", schemaPath: "#/properties/links/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return jr.errors = o, 0 === i; }
function qr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = qr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.$ref && (t = "$ref")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (da(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? da.errors : o.concat(da.errors), i = o.length), l = u = p === i, l)
        var d = { $ref: !0, summary: !0, description: !0 };
    h = "then";
}
else {
    const p = i;
    jr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? jr.errors : o.concat(jr.errors), i = o.length), l = u = p === i, l && !0 !== d && (d = !0), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return qr.errors = o, p.props = d, 0 === i; }
fr.evaluated = { dynamicProps: !0, dynamicItems: !1 }, Pr.evaluated = { dynamicProps: !0, dynamicItems: !1 }, gr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, vr.evaluated = { dynamicProps: !0, dynamicItems: !1 }, br.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Dr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, wr.evaluated = { dynamicProps: !0, dynamicItems: !1 }, Ar.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, kr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, $r.evaluated = { dynamicProps: !0, dynamicItems: !1 }, jr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, qr.evaluated = { dynamicProps: !0, dynamicItems: !1 };
const Ir = new RegExp("^[1-5](?:[0-9]{2}|XX)$", "u");
function xr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = xr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; const l = i; let m = !0; const u = i; if (i === u && e && "object" == typeof e && !Array.isArray(e)) {
    var h = {};
    for (const t in e)
        if (Ir.test(t)) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++, h[t] = !0;
        }
} var d = u === i; if (!0 !== c && void 0 !== h && (!0 === h ? c = !0 : (c = c || {}, Object.assign(c, h))), i = l, null !== o && (l ? o.length = l : o = null), d) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.default) {
        const e = { instancePath: t, schemaPath: "#/then/required", keyword: "required", params: { missingProperty: "default" }, message: "must have required property 'default'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    m = d = a === i;
} if (!m) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} if (e && "object" == typeof e && !Array.isArray(e)) {
    if (Object.keys(e).length < 1) {
        const e = { instancePath: t, schemaPath: "#/minProperties", keyword: "minProperties", params: { limit: 1 }, message: "must NOT have fewer than 1 properties" };
        null === o ? o = [e] : o.push(e), i++;
    }
    !0 !== c && ((c = c || {}).default = !0), void 0 !== e.default && (qr(e.default, { instancePath: t + "/default", parentData: e, parentDataProperty: "default", rootData: s, dynamicAnchors: n }) || (o = null === o ? qr.errors : o.concat(qr.errors), i = o.length));
    for (const a in e)
        Ir.test(a) && (qr(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? qr.errors : o.concat(qr.errors), i = o.length), c[a] = !0);
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return xr.errors = o, 0 === i; }
xr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Or = { validate: zr };
function Nr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Nr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.$ref && (t = "$ref")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (da(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? da.errors : o.concat(da.errors), i = o.length), l = u = p === i, l)
        var d = { $ref: !0, summary: !0, description: !0 };
    h = "then";
}
else {
    const p = i;
    if (Or.validate(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
        var y = Or.validate.evaluated.props, f = Or.validate.evaluated.items;
    else
        o = null === o ? Or.validate.errors : o.concat(Or.validate.errors), i = o.length;
    l = u = p === i, l && !0 !== d && void 0 !== y && (!0 === y ? d = !0 : (d = d || {}, Object.assign(d, y))), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Nr.errors = o, p.props = d, p.items = f, 0 === i; }
function Ur(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ur.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? pa.errors : o.concat(pa.errors), i = o.length), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e)
        Nr(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: n }) || (o = null === o ? Nr.errors : o.concat(Nr.errors), i = o.length);
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Ur.errors = o, 0 === i; }
function Tr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Tr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.$ref && (t = "$ref")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (da(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? da.errors : o.concat(da.errors), i = o.length), l = u = p === i, l)
        var d = { $ref: !0, summary: !0, description: !0 };
    h = "then";
}
else {
    const p = i;
    Ur(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ur.errors : o.concat(Ur.errors), i = o.length), l = u = p === i, l && !0 !== d && (d = !0), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Tr.errors = o, p.props = d, 0 === i; }
function Mr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Mr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e))
    for (const a in e) {
        let r = e[a];
        if (Array.isArray(r)) {
            const e = r.length;
            for (let s = 0; s < e; s++)
                if ("string" != typeof r[s]) {
                    const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1") + "/" + s, schemaPath: "#/additionalProperties/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === o ? o = [e] : o.push(e), i++;
                }
        }
        else {
            const e = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/additionalProperties/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Mr.errors = o, 0 === i; }
function Sr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Sr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== c && ((c = c || {}).tags = !0, c.summary = !0, c.description = !0, c.externalDocs = !0, c.operationId = !0, c.parameters = !0, c.requestBody = !0, c.responses = !0, c.callbacks = !0, c.deprecated = !0, c.security = !0, c.servers = !0), void 0 !== e.tags) {
        let a = e.tags;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                if ("string" != typeof a[r]) {
                    const e = { instancePath: t + "/tags/" + r, schemaPath: "#/properties/tags/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === o ? o = [e] : o.push(e), i++;
                }
        }
        else {
            const e = { instancePath: t + "/tags", schemaPath: "#/properties/tags/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: t + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.externalDocs && (br(e.externalDocs, { instancePath: t + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: s, dynamicAnchors: n }) || (o = null === o ? br.errors : o.concat(br.errors), i = o.length)), void 0 !== e.operationId && "string" != typeof e.operationId) {
        const e = { instancePath: t + "/operationId", schemaPath: "#/properties/operationId/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.parameters) {
        let a = e.parameters;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                vr(a[r], { instancePath: t + "/parameters/" + r, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? vr.errors : o.concat(vr.errors), i = o.length);
        }
        else {
            const e = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.requestBody && (wr(e.requestBody, { instancePath: t + "/requestBody", parentData: e, parentDataProperty: "requestBody", rootData: s, dynamicAnchors: n }) || (o = null === o ? wr.errors : o.concat(wr.errors), i = o.length)), void 0 !== e.responses && (xr(e.responses, { instancePath: t + "/responses", parentData: e, parentDataProperty: "responses", rootData: s, dynamicAnchors: n }) || (o = null === o ? xr.errors : o.concat(xr.errors), i = o.length)), void 0 !== e.callbacks) {
        let a = e.callbacks;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Tr(a[e], { instancePath: t + "/callbacks/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? Tr.errors : o.concat(Tr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/callbacks", schemaPath: "#/properties/callbacks/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.deprecated && "boolean" != typeof e.deprecated) {
        const e = { instancePath: t + "/deprecated", schemaPath: "#/properties/deprecated/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.security) {
        let a = e.security;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                Mr(a[r], { instancePath: t + "/security/" + r, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Mr.errors : o.concat(Mr.errors), i = o.length);
        }
        else {
            const e = { instancePath: t + "/security", schemaPath: "#/properties/security/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.servers) {
        let a = e.servers;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                ha(a[r], { instancePath: t + "/servers/" + r, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? ha.errors : o.concat(ha.errors), i = o.length);
        }
        else {
            const e = { instancePath: t + "/servers", schemaPath: "#/properties/servers/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Sr.errors = o, 0 === i; }
function zr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = zr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== c && ((c = c || {}).summary = !0, c.description = !0, c.servers = !0, c.parameters = !0, c.get = !0, c.put = !0, c.post = !0, c.delete = !0, c.options = !0, c.head = !0, c.patch = !0, c.trace = !0), void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: t + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.servers) {
        let a = e.servers;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                ha(a[r], { instancePath: t + "/servers/" + r, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? ha.errors : o.concat(ha.errors), i = o.length);
        }
        else {
            const e = { instancePath: t + "/servers", schemaPath: "#/properties/servers/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.parameters) {
        let a = e.parameters;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                vr(a[r], { instancePath: t + "/parameters/" + r, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? vr.errors : o.concat(vr.errors), i = o.length);
        }
        else {
            const e = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.get && (Sr(e.get, { instancePath: t + "/get", parentData: e, parentDataProperty: "get", rootData: s, dynamicAnchors: n }) || (o = null === o ? Sr.errors : o.concat(Sr.errors), i = o.length)), void 0 !== e.put && (Sr(e.put, { instancePath: t + "/put", parentData: e, parentDataProperty: "put", rootData: s, dynamicAnchors: n }) || (o = null === o ? Sr.errors : o.concat(Sr.errors), i = o.length)), void 0 !== e.post && (Sr(e.post, { instancePath: t + "/post", parentData: e, parentDataProperty: "post", rootData: s, dynamicAnchors: n }) || (o = null === o ? Sr.errors : o.concat(Sr.errors), i = o.length)), void 0 !== e.delete && (Sr(e.delete, { instancePath: t + "/delete", parentData: e, parentDataProperty: "delete", rootData: s, dynamicAnchors: n }) || (o = null === o ? Sr.errors : o.concat(Sr.errors), i = o.length)), void 0 !== e.options && (Sr(e.options, { instancePath: t + "/options", parentData: e, parentDataProperty: "options", rootData: s, dynamicAnchors: n }) || (o = null === o ? Sr.errors : o.concat(Sr.errors), i = o.length)), void 0 !== e.head && (Sr(e.head, { instancePath: t + "/head", parentData: e, parentDataProperty: "head", rootData: s, dynamicAnchors: n }) || (o = null === o ? Sr.errors : o.concat(Sr.errors), i = o.length)), void 0 !== e.patch && (Sr(e.patch, { instancePath: t + "/patch", parentData: e, parentDataProperty: "patch", rootData: s, dynamicAnchors: n }) || (o = null === o ? Sr.errors : o.concat(Sr.errors), i = o.length)), void 0 !== e.trace && (Sr(e.trace, { instancePath: t + "/trace", parentData: e, parentDataProperty: "trace", rootData: s, dynamicAnchors: n }) || (o = null === o ? Sr.errors : o.concat(Sr.errors), i = o.length)), !0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return zr.errors = o, 0 === i; }
function Lr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Lr.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: o }))
    var l = pa.evaluated.props;
else
    i = null === i ? pa.errors : i.concat(pa.errors), p = i.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    for (const a in e)
        n.test(a) && (zr(e[a], { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: e, parentDataProperty: a, rootData: s, dynamicAnchors: o }) || (i = null === i ? zr.errors : i.concat(zr.errors), p = i.length), l[a] = !0);
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Lr.errors = i, 0 === p; }
Nr.evaluated = { dynamicProps: !0, dynamicItems: !0 }, Ur.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Tr.evaluated = { dynamicProps: !0, dynamicItems: !1 }, Mr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Sr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, zr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Lr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Rr = { $comment: "https://spec.openapis.org/oas/v3.1.0#security-scheme-object", type: "object", properties: { type: { enum: ["apiKey", "http", "mutualTLS", "oauth2", "openIdConnect"] }, description: { type: "string" } }, required: ["type"], allOf: [{ $ref: "#/$defs/specification-extensions" }, { $ref: "#/$defs/security-scheme/$defs/type-apikey" }, { $ref: "#/$defs/security-scheme/$defs/type-http" }, { $ref: "#/$defs/security-scheme/$defs/type-http-bearer" }, { $ref: "#/$defs/security-scheme/$defs/type-oauth2" }, { $ref: "#/$defs/security-scheme/$defs/type-oidc" }], unevaluatedProperties: !1, $defs: { "type-apikey": { if: { properties: { type: { const: "apiKey" } }, required: ["type"] }, then: { properties: { name: { type: "string" }, in: { enum: ["query", "header", "cookie"] } }, required: ["name", "in"] } }, "type-http": { if: { properties: { type: { const: "http" } }, required: ["type"] }, then: { properties: { scheme: { type: "string" } }, required: ["scheme"] } }, "type-http-bearer": { if: { properties: { type: { const: "http" }, scheme: { type: "string", pattern: "^[Bb][Ee][Aa][Rr][Ee][Rr]$" } }, required: ["type", "scheme"] }, then: { properties: { bearerFormat: { type: "string" } } } }, "type-oauth2": { if: { properties: { type: { const: "oauth2" } }, required: ["type"] }, then: { properties: { flows: { $ref: "#/$defs/oauth-flows" } }, required: ["flows"] } }, "type-oidc": { if: { properties: { type: { const: "openIdConnect" } }, required: ["type"] }, then: { properties: { openIdConnectUrl: { type: "string", format: "uri" } }, required: ["openIdConnectUrl"] } } } }, Cr = { if: { properties: { type: { const: "apiKey" } }, required: ["type"] }, then: { properties: { name: { type: "string" }, in: { enum: ["query", "header", "cookie"] } }, required: ["name", "in"] } };
function Er(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Er.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.type && (t = "type")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.type && "apiKey" !== e.type) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var u = m === i; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e)) {
        if (void 0 === e.name) {
            const e = { instancePath: t, schemaPath: "#/then/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
            null === o ? o = [e] : o.push(e), i++;
        }
        if (void 0 === e.in) {
            const e = { instancePath: t, schemaPath: "#/then/required", keyword: "required", params: { missingProperty: "in" }, message: "must have required property 'in'" };
            null === o ? o = [e] : o.push(e), i++;
        }
        if (void 0 !== e.name && "string" != typeof e.name) {
            const e = { instancePath: t + "/name", schemaPath: "#/then/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
        if (void 0 !== e.in) {
            let a = e.in;
            if ("query" !== a && "header" !== a && "cookie" !== a) {
                const e = { instancePath: t + "/in", schemaPath: "#/then/properties/in/enum", keyword: "enum", params: { allowedValues: Cr.then.properties.in.enum }, message: "must be equal to one of the allowed values" };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
    }
    if (l = u = a === i, l)
        var h = { name: !0, in: !0, type: !0 };
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Er.errors = o, p.props = h, 0 === i; }
function Vr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Vr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.type && (t = "type")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.type && "http" !== e.type) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var u = m === i; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e)) {
        if (void 0 === e.scheme) {
            const e = { instancePath: t, schemaPath: "#/then/required", keyword: "required", params: { missingProperty: "scheme" }, message: "must have required property 'scheme'" };
            null === o ? o = [e] : o.push(e), i++;
        }
        if (void 0 !== e.scheme && "string" != typeof e.scheme) {
            const e = { instancePath: t + "/scheme", schemaPath: "#/then/properties/scheme/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (l = u = a === i, l)
        var h = { scheme: !0, type: !0 };
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Vr.errors = o, p.props = h, 0 === i; }
Er.evaluated = { dynamicProps: !0, dynamicItems: !1 }, Vr.evaluated = { dynamicProps: !0, dynamicItems: !1 };
const Kr = new RegExp("^[Bb][Ee][Aa][Rr][Ee][Rr]$", "u");
function Fr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Fr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.type && (t = "type") || void 0 === e.scheme && (t = "scheme")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else {
        if (void 0 !== e.type) {
            const t = i;
            if ("http" !== e.type) {
                const e = {};
                null === o ? o = [e] : o.push(e), i++;
            }
            var u = t === i;
        }
        else
            u = !0;
        if (u)
            if (void 0 !== e.scheme) {
                let t = e.scheme;
                const a = i;
                if (i === a)
                    if ("string" == typeof t) {
                        if (!Kr.test(t)) {
                            const e = {};
                            null === o ? o = [e] : o.push(e), i++;
                        }
                    }
                    else {
                        const e = {};
                        null === o ? o = [e] : o.push(e), i++;
                    }
                u = a === i;
            }
            else
                u = !0;
    }
} var h = m === i; if (i = c, null !== o && (c ? o.length = c : o = null), h) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.bearerFormat && "string" != typeof e.bearerFormat) {
        const e = { instancePath: t + "/bearerFormat", schemaPath: "#/then/properties/bearerFormat/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (l = h = a === i, l)
        var d = { bearerFormat: !0, type: !0, scheme: !0 };
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Fr.errors = o, p.props = d, 0 === i; }
function Br(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Br.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.authorizationUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "authorizationUrl" }, message: "must have required property 'authorizationUrl'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).authorizationUrl = !0, c.refreshUrl = !0, c.scopes = !0), void 0 !== e.authorizationUrl) {
        let a = e.authorizationUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.refreshUrl) {
        let a = e.refreshUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.scopes && (Ar(e.scopes, { instancePath: t + "/scopes", parentData: e, parentDataProperty: "scopes", rootData: s, dynamicAnchors: n }) || (o = null === o ? Ar.errors : o.concat(Ar.errors), i = o.length)), !0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Br.errors = o, 0 === i; }
function _r(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = _r.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.tokenUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "tokenUrl" }, message: "must have required property 'tokenUrl'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).tokenUrl = !0, c.refreshUrl = !0, c.scopes = !0), void 0 !== e.tokenUrl) {
        let a = e.tokenUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.refreshUrl) {
        let a = e.refreshUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.scopes && (Ar(e.scopes, { instancePath: t + "/scopes", parentData: e, parentDataProperty: "scopes", rootData: s, dynamicAnchors: n }) || (o = null === o ? Ar.errors : o.concat(Ar.errors), i = o.length)), !0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return _r.errors = o, 0 === i; }
function Zr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Zr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.tokenUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "tokenUrl" }, message: "must have required property 'tokenUrl'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).tokenUrl = !0, c.refreshUrl = !0, c.scopes = !0), void 0 !== e.tokenUrl) {
        let a = e.tokenUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.refreshUrl) {
        let a = e.refreshUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.scopes && (Ar(e.scopes, { instancePath: t + "/scopes", parentData: e, parentDataProperty: "scopes", rootData: s, dynamicAnchors: n }) || (o = null === o ? Ar.errors : o.concat(Ar.errors), i = o.length)), !0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Zr.errors = o, 0 === i; }
function Hr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Hr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.authorizationUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "authorizationUrl" }, message: "must have required property 'authorizationUrl'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.tokenUrl) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "tokenUrl" }, message: "must have required property 'tokenUrl'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.scopes) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "scopes" }, message: "must have required property 'scopes'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).authorizationUrl = !0, c.tokenUrl = !0, c.refreshUrl = !0, c.scopes = !0), void 0 !== e.authorizationUrl) {
        let a = e.authorizationUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/authorizationUrl", schemaPath: "#/properties/authorizationUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.tokenUrl) {
        let a = e.tokenUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/tokenUrl", schemaPath: "#/properties/tokenUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.refreshUrl) {
        let a = e.refreshUrl;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/refreshUrl", schemaPath: "#/properties/refreshUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.scopes && (Ar(e.scopes, { instancePath: t + "/scopes", parentData: e, parentDataProperty: "scopes", rootData: s, dynamicAnchors: n }) || (o = null === o ? Ar.errors : o.concat(Ar.errors), i = o.length)), !0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Hr.errors = o, 0 === i; }
function Xr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Xr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== c && ((c = c || {}).implicit = !0, c.password = !0, c.clientCredentials = !0, c.authorizationCode = !0), void 0 !== e.implicit && (Br(e.implicit, { instancePath: t + "/implicit", parentData: e, parentDataProperty: "implicit", rootData: s, dynamicAnchors: n }) || (o = null === o ? Br.errors : o.concat(Br.errors), i = o.length)), void 0 !== e.password && (_r(e.password, { instancePath: t + "/password", parentData: e, parentDataProperty: "password", rootData: s, dynamicAnchors: n }) || (o = null === o ? _r.errors : o.concat(_r.errors), i = o.length)), void 0 !== e.clientCredentials && (Zr(e.clientCredentials, { instancePath: t + "/clientCredentials", parentData: e, parentDataProperty: "clientCredentials", rootData: s, dynamicAnchors: n }) || (o = null === o ? Zr.errors : o.concat(Zr.errors), i = o.length)), void 0 !== e.authorizationCode && (Hr(e.authorizationCode, { instancePath: t + "/authorizationCode", parentData: e, parentDataProperty: "authorizationCode", rootData: s, dynamicAnchors: n }) || (o = null === o ? Hr.errors : o.concat(Hr.errors), i = o.length)), !0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Xr.errors = o, 0 === i; }
function Gr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Gr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.type && (t = "type")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.type && "oauth2" !== e.type) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var u = m === i; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e)) {
        if (void 0 === e.flows) {
            const e = { instancePath: t, schemaPath: "#/then/required", keyword: "required", params: { missingProperty: "flows" }, message: "must have required property 'flows'" };
            null === o ? o = [e] : o.push(e), i++;
        }
        void 0 !== e.flows && (Xr(e.flows, { instancePath: t + "/flows", parentData: e, parentDataProperty: "flows", rootData: s, dynamicAnchors: n }) || (o = null === o ? Xr.errors : o.concat(Xr.errors), i = o.length));
    }
    if (l = u = a === i, l)
        var h = { flows: !0, type: !0 };
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Gr.errors = o, p.props = h, 0 === i; }
function Jr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let i = null, p = 0; const c = Jr.evaluated; c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0); const l = p; let m = !0; const u = p; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.type && (t = "type")) {
        const e = {};
        null === i ? i = [e] : i.push(e), p++;
    }
    else if (void 0 !== e.type && "openIdConnect" !== e.type) {
        const e = {};
        null === i ? i = [e] : i.push(e), p++;
    }
} var h = u === p; if (p = l, null !== i && (l ? i.length = l : i = null), h) {
    const a = p;
    if (e && "object" == typeof e && !Array.isArray(e)) {
        if (void 0 === e.openIdConnectUrl) {
            const e = { instancePath: t, schemaPath: "#/then/required", keyword: "required", params: { missingProperty: "openIdConnectUrl" }, message: "must have required property 'openIdConnectUrl'" };
            null === i ? i = [e] : i.push(e), p++;
        }
        if (void 0 !== e.openIdConnectUrl) {
            let a = e.openIdConnectUrl;
            if ("string" == typeof a) {
                if (!o(a)) {
                    const e = { instancePath: t + "/openIdConnectUrl", schemaPath: "#/then/properties/openIdConnectUrl/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
            else {
                const e = { instancePath: t + "/openIdConnectUrl", schemaPath: "#/then/properties/openIdConnectUrl/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
    }
    if (m = h = a === p, m)
        var d = { openIdConnectUrl: !0, type: !0 };
} if (!m) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === i ? i = [e] : i.push(e), p++;
} return Jr.errors = i, c.props = d, 0 === p; }
function Wr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Wr.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (Er(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var l = Er.evaluated.props;
else
    o = null === o ? Er.errors : o.concat(Er.errors), i = o.length; if (!0 !== c && void 0 !== l && (!0 === l ? c = !0 : (c = c || {}, Object.assign(c, l))), Vr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var m = Vr.evaluated.props;
else
    o = null === o ? Vr.errors : o.concat(Vr.errors), i = o.length; if (!0 !== c && void 0 !== m && (!0 === m ? c = !0 : (c = c || {}, Object.assign(c, m))), Fr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var u = Fr.evaluated.props;
else
    o = null === o ? Fr.errors : o.concat(Fr.errors), i = o.length; if (!0 !== c && void 0 !== u && (!0 === u ? c = !0 : (c = c || {}, Object.assign(c, u))), Gr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var h = Gr.evaluated.props;
else
    o = null === o ? Gr.errors : o.concat(Gr.errors), i = o.length; if (!0 !== c && void 0 !== h && (!0 === h ? c = !0 : (c = c || {}, Object.assign(c, h))), Jr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var d = Jr.evaluated.props;
else
    o = null === o ? Jr.errors : o.concat(Jr.errors), i = o.length; if (!0 !== c && void 0 !== d && (!0 === d ? c = !0 : (c = c || {}, Object.assign(c, d))), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).type = !0, c.description = !0), void 0 !== e.type) {
        let a = e.type;
        if ("apiKey" !== a && "http" !== a && "mutualTLS" !== a && "oauth2" !== a && "openIdConnect" !== a) {
            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: Rr.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Wr.errors = o, 0 === i; }
function Yr(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Yr.evaluated; p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0); const c = i; let l = !0; const m = i; if (i === m)
    if (e && "object" == typeof e && !Array.isArray(e)) {
        let t;
        if (void 0 === e.$ref && (t = "$ref")) {
            const e = {};
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    else {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    } var u = m === i; let h; if (i = c, null !== o && (c ? o.length = c : o = null), u) {
    const p = i;
    if (da(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? da.errors : o.concat(da.errors), i = o.length), l = u = p === i, l)
        var d = { $ref: !0, summary: !0, description: !0 };
    h = "then";
}
else {
    const p = i;
    Wr(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Wr.errors : o.concat(Wr.errors), i = o.length), l = u = p === i, l && !0 !== d && (d = !0), h = "else";
} if (!l) {
    const e = { instancePath: t, schemaPath: "#/if", keyword: "if", params: { failingKeyword: h }, message: 'must match "' + h + '" schema' };
    null === o ? o = [e] : o.push(e), i++;
} return Yr.errors = o, p.props = d, 0 === i; }
Fr.evaluated = { dynamicProps: !0, dynamicItems: !1 }, Br.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, _r.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Zr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Hr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Xr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Gr.evaluated = { dynamicProps: !0, dynamicItems: !1 }, Jr.evaluated = { dynamicProps: !0, dynamicItems: !1 }, Wr.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Yr.evaluated = { dynamicProps: !0, dynamicItems: !1 };
const Qr = new RegExp("^(schemas|responses|parameters|examples|requestBodies|headers|securitySchemes|links|callbacks|pathItems)$", "u"), es = new RegExp("^[a-zA-Z0-9._-]+$", "u");
function ts(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ts.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== c && ((c = c || {}).schemas = !0, c.responses = !0, c.parameters = !0, c.examples = !0, c.requestBodies = !0, c.headers = !0, c.securitySchemes = !0, c.links = !0, c.callbacks = !0, c.pathItems = !0), void 0 !== e.schemas) {
        let a = e.schemas;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                er(a[e], { instancePath: t + "/schemas/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? er.errors : o.concat(er.errors), i = o.length);
        else {
            const e = { instancePath: t + "/schemas", schemaPath: "#/properties/schemas/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.responses) {
        let a = e.responses;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                qr(a[e], { instancePath: t + "/responses/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? qr.errors : o.concat(qr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/responses", schemaPath: "#/properties/responses/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.parameters) {
        let a = e.parameters;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                vr(a[e], { instancePath: t + "/parameters/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? vr.errors : o.concat(vr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.examples) {
        let a = e.examples;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                ar(a[e], { instancePath: t + "/examples/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? ar.errors : o.concat(ar.errors), i = o.length);
        else {
            const e = { instancePath: t + "/examples", schemaPath: "#/properties/examples/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.requestBodies) {
        let a = e.requestBodies;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                wr(a[e], { instancePath: t + "/requestBodies/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? wr.errors : o.concat(wr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/requestBodies", schemaPath: "#/properties/requestBodies/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.headers) {
        let a = e.headers;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                pr(a[e], { instancePath: t + "/headers/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? pr.errors : o.concat(pr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/headers", schemaPath: "#/properties/headers/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.securitySchemes) {
        let a = e.securitySchemes;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Yr(a[e], { instancePath: t + "/securitySchemes/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? Yr.errors : o.concat(Yr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/securitySchemes", schemaPath: "#/properties/securitySchemes/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.links) {
        let a = e.links;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                $r(a[e], { instancePath: t + "/links/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? $r.errors : o.concat($r.errors), i = o.length);
        else {
            const e = { instancePath: t + "/links", schemaPath: "#/properties/links/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.callbacks) {
        let a = e.callbacks;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Tr(a[e], { instancePath: t + "/callbacks/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? Tr.errors : o.concat(Tr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/callbacks", schemaPath: "#/properties/callbacks/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.pathItems) {
        let a = e.pathItems;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Nr(a[e], { instancePath: t + "/pathItems/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? Nr.errors : o.concat(Nr.errors), i = o.length);
        else {
            const e = { instancePath: t + "/pathItems", schemaPath: "#/properties/pathItems/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    for (const a in e)
        if (Qr.test(a)) {
            let r = e[a];
            if (r && "object" == typeof r && !Array.isArray(r))
                for (const e in r) {
                    const r = i;
                    if ("string" == typeof e && !es.test(e)) {
                        const r = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/patternProperties/%5E(schemas%7Cresponses%7Cparameters%7Cexamples%7CrequestBodies%7Cheaders%7CsecuritySchemes%7Clinks%7Ccallbacks%7CpathItems)%24/propertyNames/pattern", keyword: "pattern", params: { pattern: "^[a-zA-Z0-9._-]+$" }, message: 'must match pattern "^[a-zA-Z0-9._-]+$"', propertyName: e };
                        null === o ? o = [r] : o.push(r), i++;
                    }
                    if (r !== i) {
                        const r = { instancePath: t + "/" + a.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/patternProperties/%5E(schemas%7Cresponses%7Cparameters%7Cexamples%7CrequestBodies%7Cheaders%7CsecuritySchemes%7Clinks%7Ccallbacks%7CpathItems)%24/propertyNames", keyword: "propertyNames", params: { propertyName: e }, message: "property name must be valid" };
                        null === o ? o = [r] : o.push(r), i++;
                    }
                }
            c[a] = !0;
        }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return ts.errors = o, 0 === i; }
function as(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = as.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = pa.evaluated.props;
else
    o = null === o ? pa.errors : o.concat(pa.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).name = !0, c.description = !0, c.externalDocs = !0), void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.externalDocs && (br(e.externalDocs, { instancePath: t + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: s, dynamicAnchors: n }) || (o = null === o ? br.errors : o.concat(br.errors), i = o.length)), !0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return as.errors = o, 0 === i; }
ts.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, as.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const rs = new RegExp("^3\\.1\\.\\d+(-.+)?$", "u");
function ss(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let i = null, p = 0; const c = ss.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), pa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var l = pa.evaluated.props;
else
    i = null === i ? pa.errors : i.concat(pa.errors), p = i.length; const m = p; let u = !1; const h = p; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.paths) {
    const e = { instancePath: t, schemaPath: "#/anyOf/0/required", keyword: "required", params: { missingProperty: "paths" }, message: "must have required property 'paths'" };
    null === i ? i = [e] : i.push(e), p++;
} if (p > 0) {
    const e = [];
    for (const a of i)
        "errorMessage" === a.keyword || a.emUsed || a.instancePath !== t && (0 !== a.instancePath.indexOf(t) || "/" !== a.instancePath[t.length]) || 0 !== a.schemaPath.indexOf("#/anyOf/0") || "/" !== a.schemaPath[9] || (e.push(a), a.emUsed = !0);
    if (e.length) {
        const a = { instancePath: t, schemaPath: "#/anyOf/0/errorMessage", keyword: "errorMessage", params: { errors: e }, message: 'The document must have either "paths", "webhooks" or "components"' };
        null === i ? i = [a] : i.push(a), p++;
    }
    const a = [];
    for (const e of i)
        e.emUsed || a.push(e);
    i = a, p = a.length;
} var d = h === p; u = u || d; const y = p; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.components) {
    const e = { instancePath: t, schemaPath: "#/anyOf/1/required", keyword: "required", params: { missingProperty: "components" }, message: "must have required property 'components'" };
    null === i ? i = [e] : i.push(e), p++;
} if (p > 0) {
    const e = [];
    for (const a of i)
        "errorMessage" === a.keyword || a.emUsed || a.instancePath !== t && (0 !== a.instancePath.indexOf(t) || "/" !== a.instancePath[t.length]) || 0 !== a.schemaPath.indexOf("#/anyOf/1") || "/" !== a.schemaPath[9] || (e.push(a), a.emUsed = !0);
    if (e.length) {
        const a = { instancePath: t, schemaPath: "#/anyOf/1/errorMessage", keyword: "errorMessage", params: { errors: e }, message: 'The document must have either "paths", "webhooks" or "components"' };
        null === i ? i = [a] : i.push(a), p++;
    }
    const a = [];
    for (const e of i)
        e.emUsed || a.push(e);
    i = a, p = a.length;
} d = y === p, u = u || d; const f = p; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.webhooks) {
    const e = { instancePath: t, schemaPath: "#/anyOf/2/required", keyword: "required", params: { missingProperty: "webhooks" }, message: "must have required property 'webhooks'" };
    null === i ? i = [e] : i.push(e), p++;
} if (p > 0) {
    const e = [];
    for (const a of i)
        "errorMessage" === a.keyword || a.emUsed || a.instancePath !== t && (0 !== a.instancePath.indexOf(t) || "/" !== a.instancePath[t.length]) || 0 !== a.schemaPath.indexOf("#/anyOf/2") || "/" !== a.schemaPath[9] || (e.push(a), a.emUsed = !0);
    if (e.length) {
        const a = { instancePath: t, schemaPath: "#/anyOf/2/errorMessage", keyword: "errorMessage", params: { errors: e }, message: 'The document must have either "paths", "webhooks" or "components"' };
        null === i ? i = [a] : i.push(a), p++;
    }
    const a = [];
    for (const e of i)
        e.emUsed || a.push(e);
    i = a, p = a.length;
} if (d = f === p, u = u || d, u)
    p = m, null !== i && (m ? i.length = m : i = null);
else {
    const e = { instancePath: t, schemaPath: "#/anyOf", keyword: "anyOf", params: {}, message: "must match a schema in anyOf" };
    null === i ? i = [e] : i.push(e), p++;
} if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.openapi) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "openapi" }, message: "must have required property 'openapi'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.info) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "info" }, message: "must have required property 'info'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l && ((l = l || {}).openapi = !0, l.info = !0, l.jsonSchemaDialect = !0, l.servers = !0, l.paths = !0, l.webhooks = !0, l.components = !0, l.security = !0, l.tags = !0, l.externalDocs = !0), void 0 !== e.openapi) {
        let a = e.openapi;
        if ("string" == typeof a) {
            if (!rs.test(a)) {
                const e = { instancePath: t + "/openapi", schemaPath: "#/properties/openapi/pattern", keyword: "pattern", params: { pattern: "^3\\.1\\.\\d+(-.+)?$" }, message: 'must match pattern "^3\\.1\\.\\d+(-.+)?$"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/openapi", schemaPath: "#/properties/openapi/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.info && (ma(e.info, { instancePath: t + "/info", parentData: e, parentDataProperty: "info", rootData: s, dynamicAnchors: n }) || (i = null === i ? ma.errors : i.concat(ma.errors), p = i.length)), void 0 !== e.jsonSchemaDialect) {
        let a = e.jsonSchemaDialect;
        if ("string" == typeof a) {
            if (!o(a)) {
                const e = { instancePath: t + "/jsonSchemaDialect", schemaPath: "#/properties/jsonSchemaDialect/format", keyword: "format", params: { format: "uri" }, message: 'must match format "uri"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/jsonSchemaDialect", schemaPath: "#/properties/jsonSchemaDialect/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.servers) {
        let a = e.servers;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                ha(a[r], { instancePath: t + "/servers/" + r, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (i = null === i ? ha.errors : i.concat(ha.errors), p = i.length);
        }
        else {
            const e = { instancePath: t + "/servers", schemaPath: "#/properties/servers/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.paths && (Lr(e.paths, { instancePath: t + "/paths", parentData: e, parentDataProperty: "paths", rootData: s, dynamicAnchors: n }) || (i = null === i ? Lr.errors : i.concat(Lr.errors), p = i.length)), void 0 !== e.webhooks) {
        let a = e.webhooks;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Nr(a[e], { instancePath: t + "/webhooks/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (i = null === i ? Nr.errors : i.concat(Nr.errors), p = i.length);
        else {
            const e = { instancePath: t + "/webhooks", schemaPath: "#/properties/webhooks/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.components && (ts(e.components, { instancePath: t + "/components", parentData: e, parentDataProperty: "components", rootData: s, dynamicAnchors: n }) || (i = null === i ? ts.errors : i.concat(ts.errors), p = i.length)), void 0 !== e.security) {
        let a = e.security;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                Mr(a[r], { instancePath: t + "/security/" + r, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (i = null === i ? Mr.errors : i.concat(Mr.errors), p = i.length);
        }
        else {
            const e = { instancePath: t + "/security", schemaPath: "#/properties/security/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.tags) {
        let a = e.tags;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                as(a[r], { instancePath: t + "/tags/" + r, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (i = null === i ? as.errors : i.concat(as.errors), p = i.length);
        }
        else {
            const e = { instancePath: t + "/tags", schemaPath: "#/properties/tags/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.externalDocs && (br(e.externalDocs, { instancePath: t + "/externalDocs", parentData: e, parentDataProperty: "externalDocs", rootData: s, dynamicAnchors: n }) || (i = null === i ? br.errors : i.concat(br.errors), p = i.length)), !0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} if (p > 0) {
    const e = { anyOf: [] }, a = {};
    for (const a of i)
        "errorMessage" !== a.keyword && !a.emUsed && a.instancePath === t && a.keyword in e && 0 === a.schemaPath.indexOf("#") && /^\/[^\/]*$/.test(a.schemaPath.slice(1)) && (e[a.keyword].push(a), a.emUsed = !0);
    for (const r in e)
        if (e[r].length) {
            const s = { instancePath: t, schemaPath: "#/errorMessage", keyword: "errorMessage", params: { errors: e[r] }, message: r in a ? a[r]() : ia.errorMessage[r] };
            null === i ? i = [s] : i.push(s), p++;
        }
    const r = [];
    for (const e of i)
        e.emUsed || r.push(e);
    i = r, p = r.length;
} return ss.errors = i, 0 === p; }
ss.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
exports.arazzo1_0 = Es;
function ns(e, { instancePath: t = "", parentData: a, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { const i = ns.evaluated; if (i.dynamicProps && (i.props = void 0), i.dynamicItems && (i.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    var p = {};
    for (const t in e)
        r.test(t) && (p[t] = !0);
} return ns.errors = null, i.props = p, !0; }
function os(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = os.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), ns(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = ns.evaluated.props;
else
    o = null === o ? ns.errors : o.concat(ns.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.title) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "title" }, message: "must have required property 'title'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.version) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "version" }, message: "must have required property 'version'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).title = !0, c.summary = !0, c.description = !0, c.version = !0), void 0 !== e.title && "string" != typeof e.title) {
        const e = { instancePath: t + "/title", schemaPath: "#/properties/title/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: t + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.version && "string" != typeof e.version) {
        const e = { instancePath: t + "/version", schemaPath: "#/properties/version/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return os.errors = o, 0 === i; }
ns.evaluated = { dynamicProps: !0, dynamicItems: !1 }, os.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const is = { $comment: "https://spec.openapis.org/arazzo/v1.0.0#source-description-object", description: "Describes a source description (such as an OpenAPI description)\nthat will be referenced by one or more workflows described within\nan Arazzo description", type: "object", properties: { name: { description: "A unique name for the source description", type: "string", pattern: "^[A-Za-z0-9_\\-]+$" }, url: { description: "A URL to a source description to be used by a workflow", type: "string", format: "uri-reference" }, type: { description: "The type of source description", enum: ["arazzo", "openapi"] } }, required: ["name", "url"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, ps = new RegExp("^[A-Za-z0-9_\\-]+$", "u");
function cs(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = cs.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), ns(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = ns.evaluated.props;
else
    o = null === o ? ns.errors : o.concat(ns.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.url) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "url" }, message: "must have required property 'url'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).name = !0, c.url = !0, c.type = !0), void 0 !== e.name) {
        let a = e.name;
        if ("string" == typeof a) {
            if (!ps.test(a)) {
                const e = { instancePath: t + "/name", schemaPath: "#/properties/name/pattern", keyword: "pattern", params: { pattern: "^[A-Za-z0-9_\\-]+$" }, message: 'must match pattern "^[A-Za-z0-9_\\-]+$"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.url) {
        let a = e.url;
        if ("string" == typeof a) {
            if (!rt.test(a)) {
                const e = { instancePath: t + "/url", schemaPath: "#/properties/url/format", keyword: "format", params: { format: "uri-reference" }, message: 'must match format "uri-reference"' };
                null === o ? o = [e] : o.push(e), i++;
            }
        }
        else {
            const e = { instancePath: t + "/url", schemaPath: "#/properties/url/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.type) {
        let a = e.type;
        if ("arazzo" !== a && "openapi" !== a) {
            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: is.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return cs.errors = o, 0 === i; }
function ls(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ls.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return n.workflowId || (n.workflowId = ls), ls.errors = o, 0 === i; }
cs.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, ls.evaluated = { dynamicProps: !1, dynamicItems: !1 };
const ms = { $schema: "https://json-schema.org/draft/2020-12/schema", $id: "https://json-schema.org/draft/2020-12/schema", $vocabulary: { "https://json-schema.org/draft/2020-12/vocab/core": !0, "https://json-schema.org/draft/2020-12/vocab/applicator": !0, "https://json-schema.org/draft/2020-12/vocab/unevaluated": !0, "https://json-schema.org/draft/2020-12/vocab/validation": !0, "https://json-schema.org/draft/2020-12/vocab/meta-data": !0, "https://json-schema.org/draft/2020-12/vocab/format-annotation": !0, "https://json-schema.org/draft/2020-12/vocab/content": !0 }, $dynamicAnchor: "meta", title: "Core and Validation specifications meta-schema", allOf: [{ $ref: "meta/core" }, { $ref: "meta/applicator" }, { $ref: "meta/unevaluated" }, { $ref: "meta/validation" }, { $ref: "meta/meta-data" }, { $ref: "meta/format-annotation" }, { $ref: "meta/content" }], type: ["object", "boolean"], $comment: "This meta-schema also defines keywords that have appeared in previous drafts in order to prevent incompatible extensions as they remain in common use.", properties: { definitions: { $comment: '"definitions" has been replaced by "$defs".', type: "object", additionalProperties: { $dynamicRef: "#meta" }, deprecated: !0, default: {} }, dependencies: { $comment: '"dependencies" has been split and replaced by "dependentSchemas" and "dependentRequired" in order to serve their differing semantics.', type: "object", additionalProperties: { anyOf: [{ $dynamicRef: "#meta" }, { $ref: "meta/validation#/$defs/stringArray" }] }, deprecated: !0, default: {} }, $recursiveAnchor: { $comment: '"$recursiveAnchor" has been replaced by "$dynamicAnchor".', $ref: "meta/core#/$defs/anchorString", deprecated: !0 }, $recursiveRef: { $comment: '"$recursiveRef" has been replaced by "$dynamicRef".', $ref: "meta/core#/$defs/uriReferenceString", deprecated: !0 } } }, us = { $schema: "https://json-schema.org/draft/2020-12/schema", $id: "https://json-schema.org/draft/2020-12/meta/validation", $vocabulary: { "https://json-schema.org/draft/2020-12/vocab/validation": !0 }, $dynamicAnchor: "meta", title: "Validation vocabulary meta-schema", type: ["object", "boolean"], properties: { type: { anyOf: [{ $ref: "#/$defs/simpleTypes" }, { type: "array", items: { $ref: "#/$defs/simpleTypes" }, minItems: 1, uniqueItems: !0 }] }, const: !0, enum: { type: "array", items: !0 }, multipleOf: { type: "number", exclusiveMinimum: 0 }, maximum: { type: "number" }, exclusiveMaximum: { type: "number" }, minimum: { type: "number" }, exclusiveMinimum: { type: "number" }, maxLength: { $ref: "#/$defs/nonNegativeInteger" }, minLength: { $ref: "#/$defs/nonNegativeIntegerDefault0" }, pattern: { type: "string", format: "regex" }, maxItems: { $ref: "#/$defs/nonNegativeInteger" }, minItems: { $ref: "#/$defs/nonNegativeIntegerDefault0" }, uniqueItems: { type: "boolean", default: !1 }, maxContains: { $ref: "#/$defs/nonNegativeInteger" }, minContains: { $ref: "#/$defs/nonNegativeInteger", default: 1 }, maxProperties: { $ref: "#/$defs/nonNegativeInteger" }, minProperties: { $ref: "#/$defs/nonNegativeIntegerDefault0" }, required: { $ref: "#/$defs/stringArray" }, dependentRequired: { type: "object", additionalProperties: { $ref: "#/$defs/stringArray" } } }, $defs: { nonNegativeInteger: { type: "integer", minimum: 0 }, nonNegativeIntegerDefault0: { $ref: "#/$defs/nonNegativeInteger", default: 0 }, simpleTypes: { enum: ["array", "boolean", "integer", "null", "number", "object", "string"] }, stringArray: { type: "array", items: { type: "string" }, uniqueItems: !0, default: [] } } }, hs = { enum: ["array", "boolean", "integer", "null", "number", "object", "string"] };
function ds(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ds.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "array" !== e && "boolean" !== e && "integer" !== e && "null" !== e && "number" !== e && "object" !== e && "string" !== e) {
    const e = { instancePath: t, schemaPath: "#/enum", keyword: "enum", params: { allowedValues: hs.enum }, message: "must be equal to one of the allowed values" };
    null === o ? o = [e] : o.push(e), i++;
} return ds.errors = o, 0 === i; }
function ys(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ys.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e || e % 1 || isNaN(e)) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
    null === o ? o = [e] : o.push(e), i++;
} if ("number" == typeof e && (e < 0 || isNaN(e))) {
    const e = { instancePath: t, schemaPath: "#/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
    null === o ? o = [e] : o.push(e), i++;
} return ys.errors = o, 0 === i; }
function fs(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = fs.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "number" != typeof e || e % 1 || isNaN(e)) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
    null === o ? o = [e] : o.push(e), i++;
} if ("number" == typeof e && (e < 0 || isNaN(e))) {
    const e = { instancePath: t, schemaPath: "#/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
    null === o ? o = [e] : o.push(e), i++;
} return fs.errors = o, 0 === i; }
function Ps(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ps.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), Array.isArray(e)) {
    const a = e.length;
    for (let r = 0; r < a; r++)
        if ("string" != typeof e[r]) {
            const e = { instancePath: t + "/" + r, schemaPath: "#/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === o ? o = [e] : o.push(e), i++;
        }
    let r, s = e.length;
    if (s > 1) {
        const a = {};
        for (; s--;) {
            let n = e[s];
            if ("string" == typeof n) {
                if ("number" == typeof a[n]) {
                    r = a[n];
                    const e = { instancePath: t, schemaPath: "#/uniqueItems", keyword: "uniqueItems", params: { i: s, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + s + " are identical)" };
                    null === o ? o = [e] : o.push(e), i++;
                    break;
                }
                a[n] = s;
            }
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "array" }, message: "must be array" };
    null === o ? o = [e] : o.push(e), i++;
} return Ps.errors = o, 0 === i; }
function gs(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = gs.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), (!e || "object" != typeof e || Array.isArray(e)) && "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: us.type }, message: "must be object,boolean" };
    null === i ? i = [e] : i.push(e), p++;
} if (o.meta || (o.meta = gs), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 !== e.type) {
        let r = e.type;
        const s = p;
        let c = !1;
        const m = p;
        ds(r, { instancePath: t + "/type", parentData: e, parentDataProperty: "type", rootData: n, dynamicAnchors: o }) || (i = null === i ? ds.errors : i.concat(ds.errors), p = i.length);
        var l = m === p;
        c = c || l;
        const u = p;
        if (Array.isArray(r)) {
            if (r.length < 1) {
                const e = { instancePath: t + "/type", schemaPath: "#/properties/type/anyOf/1/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === i ? i = [e] : i.push(e), p++;
            }
            const e = r.length;
            for (let a = 0; a < e; a++)
                ds(r[a], { instancePath: t + "/type/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? ds.errors : i.concat(ds.errors), p = i.length);
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/anyOf/1/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/anyOf/1/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
        if (l = u === p, c = c || l, c)
            p = s, null !== i && (s ? i.length = s : i = null);
        else {
            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/anyOf", keyword: "anyOf", params: {}, message: "must match a schema in anyOf" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.enum && !Array.isArray(e.enum)) {
        const e = { instancePath: t + "/enum", schemaPath: "#/properties/enum/type", keyword: "type", params: { type: "array" }, message: "must be array" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.multipleOf) {
        let a = e.multipleOf;
        if ("number" == typeof a) {
            if (a <= 0 || isNaN(a)) {
                const e = { instancePath: t + "/multipleOf", schemaPath: "#/properties/multipleOf/exclusiveMinimum", keyword: "exclusiveMinimum", params: { comparison: ">", limit: 0 }, message: "must be > 0" };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/multipleOf", schemaPath: "#/properties/multipleOf/type", keyword: "type", params: { type: "number" }, message: "must be number" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.maximum && "number" != typeof e.maximum) {
        const e = { instancePath: t + "/maximum", schemaPath: "#/properties/maximum/type", keyword: "type", params: { type: "number" }, message: "must be number" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.exclusiveMaximum && "number" != typeof e.exclusiveMaximum) {
        const e = { instancePath: t + "/exclusiveMaximum", schemaPath: "#/properties/exclusiveMaximum/type", keyword: "type", params: { type: "number" }, message: "must be number" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.minimum && "number" != typeof e.minimum) {
        const e = { instancePath: t + "/minimum", schemaPath: "#/properties/minimum/type", keyword: "type", params: { type: "number" }, message: "must be number" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.exclusiveMinimum && "number" != typeof e.exclusiveMinimum) {
        const e = { instancePath: t + "/exclusiveMinimum", schemaPath: "#/properties/exclusiveMinimum/type", keyword: "type", params: { type: "number" }, message: "must be number" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.maxLength && (ys(e.maxLength, { instancePath: t + "/maxLength", parentData: e, parentDataProperty: "maxLength", rootData: n, dynamicAnchors: o }) || (i = null === i ? ys.errors : i.concat(ys.errors), p = i.length)), void 0 !== e.minLength && (fs(e.minLength, { instancePath: t + "/minLength", parentData: e, parentDataProperty: "minLength", rootData: n, dynamicAnchors: o }) || (i = null === i ? fs.errors : i.concat(fs.errors), p = i.length)), void 0 !== e.pattern && "string" != typeof e.pattern) {
        const e = { instancePath: t + "/pattern", schemaPath: "#/properties/pattern/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.maxItems && (ys(e.maxItems, { instancePath: t + "/maxItems", parentData: e, parentDataProperty: "maxItems", rootData: n, dynamicAnchors: o }) || (i = null === i ? ys.errors : i.concat(ys.errors), p = i.length)), void 0 !== e.minItems && (fs(e.minItems, { instancePath: t + "/minItems", parentData: e, parentDataProperty: "minItems", rootData: n, dynamicAnchors: o }) || (i = null === i ? fs.errors : i.concat(fs.errors), p = i.length)), void 0 !== e.uniqueItems && "boolean" != typeof e.uniqueItems) {
        const e = { instancePath: t + "/uniqueItems", schemaPath: "#/properties/uniqueItems/type", keyword: "type", params: { type: "boolean" }, message: "must be boolean" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.maxContains && (ys(e.maxContains, { instancePath: t + "/maxContains", parentData: e, parentDataProperty: "maxContains", rootData: n, dynamicAnchors: o }) || (i = null === i ? ys.errors : i.concat(ys.errors), p = i.length)), void 0 !== e.minContains && (ys(e.minContains, { instancePath: t + "/minContains", parentData: e, parentDataProperty: "minContains", rootData: n, dynamicAnchors: o }) || (i = null === i ? ys.errors : i.concat(ys.errors), p = i.length)), void 0 !== e.maxProperties && (ys(e.maxProperties, { instancePath: t + "/maxProperties", parentData: e, parentDataProperty: "maxProperties", rootData: n, dynamicAnchors: o }) || (i = null === i ? ys.errors : i.concat(ys.errors), p = i.length)), void 0 !== e.minProperties && (fs(e.minProperties, { instancePath: t + "/minProperties", parentData: e, parentDataProperty: "minProperties", rootData: n, dynamicAnchors: o }) || (i = null === i ? fs.errors : i.concat(fs.errors), p = i.length)), void 0 !== e.required && (Ps(e.required, { instancePath: t + "/required", parentData: e, parentDataProperty: "required", rootData: n, dynamicAnchors: o }) || (i = null === i ? Ps.errors : i.concat(Ps.errors), p = i.length)), void 0 !== e.dependentRequired) {
        let a = e.dependentRequired;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a)
                Ps(a[e], { instancePath: t + "/dependentRequired/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ps.errors : i.concat(Ps.errors), p = i.length);
        else {
            const e = { instancePath: t + "/dependentRequired", schemaPath: "#/properties/dependentRequired/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
} return gs.errors = i, 0 === p; }
function vs(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = vs.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), (!e || "object" != typeof e || Array.isArray(e)) && "boolean" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: ms.type }, message: "must be object,boolean" };
    null === o ? o = [e] : o.push(e), i++;
} if (n.meta || (n.meta = vs), wa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? wa.errors : o.concat(wa.errors), i = o.length), $a(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? $a.errors : o.concat($a.errors), i = o.length), qa(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? qa.errors : o.concat(qa.errors), i = o.length), gs(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? gs.errors : o.concat(gs.errors), i = o.length), za(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? za.errors : o.concat(za.errors), i = o.length), Ra(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ra.errors : o.concat(Ra.errors), i = o.length), Ea(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ea.errors : o.concat(Ea.errors), i = o.length), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 !== e.definitions) {
        let a = e.definitions;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a) {
                let r = a[e], p = n.meta;
                if (p)
                    if (p(r, { instancePath: t + "/definitions/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }))
                        var c = p.evaluated.props, l = p.evaluated.items;
                    else
                        o = null === o ? p.errors : o.concat(p.errors), i = o.length;
                else if (vs(r, { instancePath: t + "/definitions/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n })) {
                    var m = vs.evaluated.props;
                    !0 !== c && void 0 !== m && (!0 === m ? c = !0 : (c = c || {}, Object.assign(c, m)));
                    var u = vs.evaluated.items;
                    !0 !== l && void 0 !== u && (l = !0 === u || (l > u ? l : u));
                }
                else
                    o = null === o ? vs.errors : o.concat(vs.errors), i = o.length;
            }
        else {
            const e = { instancePath: t + "/definitions", schemaPath: "#/properties/definitions/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.dependencies) {
        let a = e.dependencies;
        if (a && "object" == typeof a && !Array.isArray(a))
            for (const e in a) {
                let r = a[e];
                const p = i;
                let c = !1;
                const l = i;
                let m = n.meta;
                if (m)
                    if (m(r, { instancePath: t + "/dependencies/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }))
                        var h = m.evaluated.props, d = m.evaluated.items;
                    else
                        o = null === o ? m.errors : o.concat(m.errors), i = o.length;
                else if (vs(r, { instancePath: t + "/dependencies/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n })) {
                    var y = vs.evaluated.props;
                    !0 !== h && void 0 !== y && (!0 === y ? h = !0 : (h = h || {}, Object.assign(h, y)));
                    var f = vs.evaluated.items;
                    !0 !== d && void 0 !== f && (d = !0 === f || (d > f ? d : f));
                }
                else
                    o = null === o ? vs.errors : o.concat(vs.errors), i = o.length;
                var P = l === i;
                c = c || P;
                const u = i;
                if (Ka(r, { instancePath: t + "/dependencies/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ka.errors : o.concat(Ka.errors), i = o.length), P = u === i, c = c || P, P && !0 !== d && (d = !0), c)
                    i = p, null !== o && (p ? o.length = p : o = null);
                else {
                    const a = { instancePath: t + "/dependencies/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/dependencies/additionalProperties/anyOf", keyword: "anyOf", params: {}, message: "must match a schema in anyOf" };
                    null === o ? o = [a] : o.push(a), i++;
                }
            }
        else {
            const e = { instancePath: t + "/dependencies", schemaPath: "#/properties/dependencies/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    void 0 !== e.$recursiveAnchor && (Ba(e.$recursiveAnchor, { instancePath: t + "/$recursiveAnchor", parentData: e, parentDataProperty: "$recursiveAnchor", rootData: s, dynamicAnchors: n }) || (o = null === o ? Ba.errors : o.concat(Ba.errors), i = o.length)), void 0 !== e.$recursiveRef && (Za(e.$recursiveRef, { instancePath: t + "/$recursiveRef", parentData: e, parentDataProperty: "$recursiveRef", rootData: s, dynamicAnchors: n }) || (o = null === o ? Za.errors : o.concat(Za.errors), i = o.length));
} return vs.errors = o, 0 === i; }
ds.evaluated = { dynamicProps: !1, dynamicItems: !1 }, ys.evaluated = { dynamicProps: !1, dynamicItems: !1 }, fs.evaluated = { dynamicProps: !1, dynamicItems: !1 }, Ps.evaluated = { items: !0, dynamicProps: !1, dynamicItems: !1 }, gs.evaluated = { props: { type: !0, const: !0, enum: !0, multipleOf: !0, maximum: !0, exclusiveMaximum: !0, minimum: !0, exclusiveMinimum: !0, maxLength: !0, minLength: !0, pattern: !0, maxItems: !0, minItems: !0, uniqueItems: !0, maxContains: !0, minContains: !0, maxProperties: !0, minProperties: !0, required: !0, dependentRequired: !0 }, dynamicProps: !1, dynamicItems: !1 }, vs.evaluated = { props: { definitions: !0, dependencies: !0, $recursiveAnchor: !0, $recursiveRef: !0, contentEncoding: !0, contentMediaType: !0, contentSchema: !0, format: !0, title: !0, description: !0, default: !0, deprecated: !0, readOnly: !0, writeOnly: !0, examples: !0, type: !0, const: !0, enum: !0, multipleOf: !0, maximum: !0, exclusiveMaximum: !0, minimum: !0, exclusiveMinimum: !0, maxLength: !0, minLength: !0, pattern: !0, maxItems: !0, minItems: !0, uniqueItems: !0, maxContains: !0, minContains: !0, maxProperties: !0, minProperties: !0, required: !0, dependentRequired: !0, unevaluatedItems: !0, unevaluatedProperties: !0, prefixItems: !0, items: !0, contains: !0, additionalProperties: !0, properties: !0, patternProperties: !0, dependentSchemas: !0, propertyNames: !0, if: !0, then: !0, else: !0, allOf: !0, anyOf: !0, oneOf: !0, not: !0, $id: !0, $schema: !0, $ref: !0, $anchor: !0, $dynamicRef: !0, $dynamicAnchor: !0, $vocabulary: !0, $comment: !0, $defs: !0 }, dynamicProps: !1, dynamicItems: !1 };
const bs = { $comment: "https://spec.openapis.org/arazzo/v1.0.0#step-object'", description: "Describes a single workflow step which MAY be a call to an\nAPI operation (OpenAPI Operation Object or another Workflow Object)", type: "object", properties: { stepId: { description: "Unique string to represent the step", $dynamicAnchor: "stepId", type: "string" }, description: { description: "A description of the step. CommonMark syntax MAY be used for rich text representation", type: "string" }, operationId: { description: "The name of an existing, resolvable operation, as defined with a unique operationId and existing within one of the sourceDescriptions", type: "string" }, operationPath: { description: "A reference to a Source combined with a JSON Pointer to reference an operation", type: "string" }, workflowId: { description: "The workflowId referencing an existing workflow within the Arazzo description", $dynamicRef: "#workflowId" }, parameters: { description: "A list of parameters that MUST be passed to an operation or workflow as referenced by operationId, operationPath, or workflowId", type: "array", uniqueItems: !0, items: !0 }, requestBody: { $ref: "#/$defs/request-body-object" }, successCriteria: { description: "A list of assertions to determine the success of the step", type: "array", uniqueItems: !0, minItems: 1, items: { $ref: "#/$defs/criterion-object" } }, onSuccess: { description: "An array of success action objects that specify what to do upon step success", type: "array", uniqueItems: !0, items: { oneOf: [{ $ref: "#/$defs/success-action-object" }, { $ref: "#/$defs/reusable-object" }] } }, onFailure: { description: "An array of failure action objects that specify what to do upon step failure", type: "array", uniqueItems: !0, items: { oneOf: [{ $ref: "#/$defs/failure-action-object" }, { $ref: "#/$defs/reusable-object" }] } }, outputs: { description: "A map between a friendly name and a dynamic output value defined using a runtime expression", type: "object", patternProperties: { "^[a-zA-Z0-9\\.\\-_]+$": { type: "string" } } } }, required: ["stepId"], oneOf: [{ required: ["operationId"] }, { required: ["operationPath"] }, { required: ["workflowId"] }], allOf: [{ if: { required: ["operationId"] }, then: { properties: { parameters: { items: { oneOf: [{ type: "object", properties: { name: { type: "string" }, in: { description: "The named location of the parameter", enum: ["path", "query", "header", "cookie", "body"] }, value: { description: "The value to pass in the parameter", type: ["string", "boolean", "object", "array", "number", "null"] } }, required: ["name", "value", "in"] }, { type: "object", properties: { reference: { type: "string" }, value: { description: "The value to pass in the parameter", type: ["string", "boolean", "object", "array", "number", "null"] } }, required: ["reference"] }] } } } } }, { if: { required: ["operationPath"] }, then: { properties: { parameters: { items: { oneOf: [{ type: "object", properties: { name: { type: "string" }, in: { description: "The named location of the parameter", enum: ["path", "query", "header", "cookie", "body"] }, value: { description: "The value to pass in the parameter", type: ["string", "boolean", "object", "array", "number", "null"] } }, required: ["name", "value", "in"] }, { type: "object", properties: { reference: { type: "string" }, value: { description: "The value to pass in the parameter", type: ["string", "boolean", "object", "array", "number", "null"] } }, required: ["reference"] }] } } } } }, { if: { required: ["workflowId"] }, then: { properties: { parameters: { items: { oneOf: [{ type: "object", properties: { name: { type: "string" }, value: { description: "The value to pass in the parameter", type: ["string", "boolean", "object", "array", "number", "null"] } }, required: ["name", "value"] }, { type: "object", properties: { reference: { type: "string" }, value: { description: "The value to pass in the parameter", type: ["string", "boolean", "object", "array", "number", "null"] } }, required: ["reference"] }] } } } } }], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 };
function Ds(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ds.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), "string" != typeof e) {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "string" }, message: "must be string" };
    null === o ? o = [e] : o.push(e), i++;
} return n.stepId || (n.stepId = Ds), Ds.errors = o, 0 === i; }
function ws(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = ws.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), ns(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = ns.evaluated.props;
else
    o = null === o ? ns.errors : o.concat(ns.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.target) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "target" }, message: "must have required property 'target'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.value) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "value" }, message: "must have required property 'value'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).target = !0, c.value = !0), void 0 !== e.target && "string" != typeof e.target) {
        const e = { instancePath: t + "/target", schemaPath: "#/properties/target/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.value && "string" != typeof e.value) {
        const e = { instancePath: t + "/value", schemaPath: "#/properties/value/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return ws.errors = o, 0 === i; }
function As(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = As.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), ns(e, { instancePath: t, parentData: r, parentDataProperty: s, rootData: n, dynamicAnchors: o }))
    var l = ns.evaluated.props;
else
    i = null === i ? ns.errors : i.concat(ns.errors), p = i.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== l && ((l = l || {}).contentType = !0, l.payload = !0, l.replacements = !0), void 0 !== e.contentType && "string" != typeof e.contentType) {
        const e = { instancePath: t + "/contentType", schemaPath: "#/properties/contentType/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.replacements) {
        let r = e.replacements;
        if (Array.isArray(r)) {
            const e = r.length;
            for (let a = 0; a < e; a++)
                ws(r[a], { instancePath: t + "/replacements/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? ws.errors : i.concat(ws.errors), p = i.length);
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/replacements", schemaPath: "#/properties/replacements/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/replacements", schemaPath: "#/properties/replacements/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return As.errors = i, 0 === p; }
Ds.evaluated = { dynamicProps: !1, dynamicItems: !1 }, ws.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, As.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const ks = { $comment: "https://spec.openapis.org/arazzo/v1.0.0#criterion-object", description: "An object used to specify the context, conditions, and condition types\nthat can be used to prove or satisfy assertions specified in Step Object successCriteria,\nSuccess Action Object criteria, and Failure Action Object criteria", type: "object", properties: { context: { description: "A runtime expression used to set the context for the condition to be applied on", type: "string" }, condition: { description: "The condition to apply", type: "string" } }, anyOf: [{ type: "object", properties: { type: { description: "The type of condition to be applied", enum: ["simple", "regex", "jsonpath", "xpath"], default: "simple" } } }, { $ref: "#/$defs/criterion-expression-type-object" }], required: ["condition"], dependentRequired: { type: ["context"] }, $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 }, $s = { $comment: "https://spec.openapis.org/arazzo/v1.0.0#criterion-expression-type-object", description: "An object used to describe the type and version of an expression used within a Criterion Object", type: "object", properties: { type: { description: "The type of condition to be applied", enum: ["jsonpath", "xpath"] }, version: { description: "A short hand string representing the version of the expression type", type: "string" } }, required: ["type", "version"], allOf: [{ if: { required: ["type"], properties: { type: { const: "jsonpath" } } }, then: { properties: { version: { const: "draft-goessner-dispatch-jsonpath-00" } } } }, { if: { required: ["type"], properties: { type: { const: "xpath" } } }, then: { properties: { version: { enum: ["xpath-10", "xpath-20", "xpath-30"] } } } }], $ref: "#/$defs/specification-extensions" };
function js(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = js.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), ns(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = ns.evaluated.props;
else
    o = null === o ? ns.errors : o.concat(ns.errors), i = o.length; const l = i; let m = !0; const u = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.type && (t = "type")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.type && "jsonpath" !== e.type) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var h = u === i; if (i = l, null !== o && (l ? o.length = l : o = null), h) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.version && "draft-goessner-dispatch-jsonpath-00" !== e.version) {
        const e = { instancePath: t + "/version", schemaPath: "#/allOf/0/then/properties/version/const", keyword: "const", params: { allowedValue: "draft-goessner-dispatch-jsonpath-00" }, message: "must be equal to constant" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (m = h = a === i, m)
        var d = { version: !0, type: !0 };
} if (!m) {
    const e = { instancePath: t, schemaPath: "#/allOf/0/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} !0 !== c && void 0 !== d && (!0 === d ? c = !0 : (c = c || {}, Object.assign(c, d))); const y = i; let f = !0; const P = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.type && (t = "type")) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
    else if (void 0 !== e.type && "xpath" !== e.type) {
        const e = {};
        null === o ? o = [e] : o.push(e), i++;
    }
} var g = P === i; if (i = y, null !== o && (y ? o.length = y : o = null), g) {
    const a = i;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.version) {
        let a = e.version;
        if ("xpath-10" !== a && "xpath-20" !== a && "xpath-30" !== a) {
            const e = { instancePath: t + "/version", schemaPath: "#/allOf/1/then/properties/version/enum", keyword: "enum", params: { allowedValues: $s.allOf[1].then.properties.version.enum }, message: "must be equal to one of the allowed values" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (f = g = a === i, f)
        var v = { version: !0, type: !0 };
} if (!f) {
    const e = { instancePath: t, schemaPath: "#/allOf/1/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === o ? o = [e] : o.push(e), i++;
} if (!0 !== c && void 0 !== v && (!0 === v ? c = !0 : (c = c || {}, Object.assign(c, v))), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.version) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "version" }, message: "must have required property 'version'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).type = !0, c.version = !0), void 0 !== e.type) {
        let a = e.type;
        if ("jsonpath" !== a && "xpath" !== a) {
            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: $s.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.version && "string" != typeof e.version) {
        const e = { instancePath: t + "/version", schemaPath: "#/properties/version/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return js.errors = o, p.props = c, 0 === i; }
function qs(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = qs.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), ns(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = ns.evaluated.props;
else
    o = null === o ? ns.errors : o.concat(ns.errors), i = o.length; const l = i; let m = !1; const u = i; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 !== e.type) {
        let a = e.type;
        if ("simple" !== a && "regex" !== a && "jsonpath" !== a && "xpath" !== a) {
            const e = { instancePath: t + "/type", schemaPath: "#/anyOf/0/properties/type/enum", keyword: "enum", params: { allowedValues: ks.anyOf[0].properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
}
else {
    const e = { instancePath: t, schemaPath: "#/anyOf/0/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} var h = u === i; m = m || h, h && !0 !== c && ((c = c || {}).type = !0); const d = i; if (js(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var y = js.evaluated.props;
else
    o = null === o ? js.errors : o.concat(js.errors), i = o.length; if (h = d === i, m = m || h, h && !0 !== c && void 0 !== y && (!0 === y ? c = !0 : (c = c || {}, Object.assign(c, y))), m)
    i = l, null !== o && (l ? o.length = l : o = null);
else {
    const e = { instancePath: t, schemaPath: "#/anyOf", keyword: "anyOf", params: {}, message: "must match a schema in anyOf" };
    null === o ? o = [e] : o.push(e), i++;
} if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.condition) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "condition" }, message: "must have required property 'condition'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).context = !0, c.condition = !0), void 0 !== e.context && "string" != typeof e.context) {
        const e = { instancePath: t + "/context", schemaPath: "#/properties/context/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.condition && "string" != typeof e.condition) {
        const e = { instancePath: t + "/condition", schemaPath: "#/properties/condition/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.type && void 0 === e.context) {
        const e = { instancePath: t, schemaPath: "#/dependentRequired", keyword: "dependentRequired", params: { property: "type", missingProperty: "context", depsCount: 1, deps: "context" }, message: "must have property context when property type is present" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return qs.errors = o, 0 === i; }
js.evaluated = { dynamicProps: !0, dynamicItems: !1 }, qs.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Is = { $comment: "https://spec.openapis.org/arazzo/v1.0.0#success-action-object", description: "A single success action which describes an action to take upon success of a workflow step", type: "object", properties: { name: { description: "The name of the success action", type: "string" }, type: { description: "The type of action to take", enum: ["end", "goto"] }, workflowId: { description: "The workflowId referencing an existing workflow within the Arazzo description to transfer to upon success of the step", $dynamicRef: "#workflowId" }, stepId: { description: "The stepId to transfer to upon success of the step", $dynamicRef: "#stepId" }, criteria: { description: "A list of assertions to determine if this action SHALL be executed", type: "array", uniqueItems: !0, minItems: 1, items: { $ref: "#/$defs/criterion-object" } } }, allOf: [{ if: { properties: { type: { const: "goto" } } }, then: { oneOf: [{ required: ["workflowId"] }, { required: ["stepId"] }] } }], dependentSchemas: { workflowId: { properties: { type: { enum: ["goto"] } } }, stepId: { properties: { type: { enum: ["goto"] } } } }, required: ["name", "type"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 };
function xs(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = xs.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), ns(e, { instancePath: t, parentData: r, parentDataProperty: s, rootData: n, dynamicAnchors: o }))
    var l = ns.evaluated.props;
else
    i = null === i ? ns.errors : i.concat(ns.errors), p = i.length; const m = p; let u = !0; const h = p; if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.type && "goto" !== e.type) {
    const e = {};
    null === i ? i = [e] : i.push(e), p++;
} var d = h === p; if (p = m, null !== i && (m ? i.length = m : i = null), d) {
    const a = p, r = p;
    let s = !1, n = null;
    const o = p;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.workflowId) {
        const e = { instancePath: t, schemaPath: "#/allOf/0/then/oneOf/0/required", keyword: "required", params: { missingProperty: "workflowId" }, message: "must have required property 'workflowId'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    o === p && (s = !0, n = 0);
    const c = p;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.stepId) {
        const e = { instancePath: t, schemaPath: "#/allOf/0/then/oneOf/1/required", keyword: "required", params: { missingProperty: "stepId" }, message: "must have required property 'stepId'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    var y;
    if ((y = c === p) && s ? (s = !1, n = [n, 1]) : y && (s = !0, n = 1), s)
        p = r, null !== i && (r ? i.length = r : i = null);
    else {
        const e = { instancePath: t, schemaPath: "#/allOf/0/then/oneOf", keyword: "oneOf", params: { passingSchemas: n }, message: "must match exactly one schema in oneOf" };
        null === i ? i = [e] : i.push(e), p++;
    }
    u = d = a === p;
} if (!u) {
    const e = { instancePath: t, schemaPath: "#/allOf/0/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === i ? i = [e] : i.push(e), p++;
} if (!0 !== l && ((l = l || {}).type = !0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l && ((l = l || {}).name = !0, l.type = !0, l.workflowId = !0, l.stepId = !0, l.criteria = !0), void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.type) {
        let a = e.type;
        if ("end" !== a && "goto" !== a) {
            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: Is.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.workflowId) {
        let a = e.workflowId, r = o.workflowId;
        if (r)
            if (r(a, { instancePath: t + "/workflowId", parentData: e, parentDataProperty: "workflowId", rootData: n, dynamicAnchors: o }))
                var f = r.evaluated.props, P = r.evaluated.items;
            else
                i = null === i ? r.errors : i.concat(r.errors), p = i.length;
        else if (xs(a, { instancePath: t + "/workflowId", parentData: e, parentDataProperty: "workflowId", rootData: n, dynamicAnchors: o })) {
            var g = xs.evaluated.props;
            !0 !== f && void 0 !== g && (!0 === g ? f = !0 : (f = f || {}, Object.assign(f, g)));
            var v = xs.evaluated.items;
            !0 !== P && void 0 !== v && (P = !0 === v || (P > v ? P : v));
        }
        else
            i = null === i ? xs.errors : i.concat(xs.errors), p = i.length;
    }
    if (void 0 !== e.stepId) {
        let a = e.stepId, r = o.stepId;
        if (r)
            if (r(a, { instancePath: t + "/stepId", parentData: e, parentDataProperty: "stepId", rootData: n, dynamicAnchors: o }))
                var b = r.evaluated.props, D = r.evaluated.items;
            else
                i = null === i ? r.errors : i.concat(r.errors), p = i.length;
        else if (xs(a, { instancePath: t + "/stepId", parentData: e, parentDataProperty: "stepId", rootData: n, dynamicAnchors: o })) {
            var w = xs.evaluated.props;
            !0 !== b && void 0 !== w && (!0 === w ? b = !0 : (b = b || {}, Object.assign(b, w)));
            var A = xs.evaluated.items;
            !0 !== D && void 0 !== A && (D = !0 === A || (D > A ? D : A));
        }
        else
            i = null === i ? xs.errors : i.concat(xs.errors), p = i.length;
    }
    if (void 0 !== e.criteria) {
        let r = e.criteria;
        if (Array.isArray(r)) {
            if (r.length < 1) {
                const e = { instancePath: t + "/criteria", schemaPath: "#/properties/criteria/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === i ? i = [e] : i.push(e), p++;
            }
            const e = r.length;
            for (let a = 0; a < e; a++)
                qs(r[a], { instancePath: t + "/criteria/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? qs.errors : i.concat(qs.errors), p = i.length);
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/criteria", schemaPath: "#/properties/criteria/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/criteria", schemaPath: "#/properties/criteria/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.workflowId) {
        const a = p;
        if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.type && "goto" !== e.type) {
            const e = { instancePath: t + "/type", schemaPath: "#/dependentSchemas/workflowId/properties/type/enum", keyword: "enum", params: { allowedValues: Is.dependentSchemas.workflowId.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === i ? i = [e] : i.push(e), p++;
        }
        a === p && !0 !== l && ((l = l || {}).type = !0);
    }
    if (void 0 !== e.stepId) {
        const a = p;
        if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.type && "goto" !== e.type) {
            const e = { instancePath: t + "/type", schemaPath: "#/dependentSchemas/stepId/properties/type/enum", keyword: "enum", params: { allowedValues: Is.dependentSchemas.stepId.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === i ? i = [e] : i.push(e), p++;
        }
        a === p && !0 !== l && ((l = l || {}).type = !0);
    }
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return xs.errors = i, 0 === p; }
xs.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Os = { $comment: "https://spec.openapis.org/arazzo/v1.0.0#reusable-object", description: "A simple object to allow referencing of objects contained within the Components Object", type: "object", properties: { reference: { description: "A runtime expression used to reference the desired object", type: "string" }, value: { description: "Sets a value of the referenced parameter", type: ["string", "boolean", "object", "array", "number", "null"] } }, required: ["reference"], unevaluatedProperties: !1 };
function Ns(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Ns.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.reference) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "reference" }, message: "must have required property 'reference'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.reference && "string" != typeof e.reference) {
        const e = { instancePath: t + "/reference", schemaPath: "#/properties/reference/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.value) {
        let a = e.value;
        if ("object" != typeof a && "string" != typeof a && "boolean" != typeof a && "number" != typeof a) {
            const e = { instancePath: t + "/value", schemaPath: "#/properties/value/type", keyword: "type", params: { type: Os.properties.value.type }, message: "must be string,boolean,object,array,number,null" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    for (const a in e)
        if ("reference" !== a && "value" !== a) {
            const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
            null === o ? o = [e] : o.push(e), i++;
        }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Ns.errors = o, 0 === i; }
Ns.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Us = { $comment: "https://spec.openapis.org/arazzo/v1.0.0#failure-action-object", description: "A single failure action which describes an action to take upon failure of a workflow step", type: "object", properties: { name: { description: "The name of the failure action", type: "string" }, type: { description: "The type of action to take", enum: ["end", "goto", "retry"] }, workflowId: { description: "The workflowId referencing an existing workflow within the Arazzo description to transfer to upon failure of the step", $dynamicRef: "#workflowId" }, stepId: { description: "The stepId to transfer to upon failure of the step", $dynamicRef: "#stepId" }, retryAfter: { description: "A non-negative decimal indicating the seconds to delay after the step failure before another attempt SHALL be made", type: "number", minimum: 0 }, retryLimit: { description: "A non-negative integer indicating how many attempts to retry the step MAY be attempted before failing the overall step", type: "integer", minimum: 0 }, criteria: { description: "A list of assertions to determine if this action SHALL be executed", type: "array", uniqueItems: !0, items: { $ref: "#/$defs/criterion-object" } } }, allOf: [{ if: { properties: { type: { enum: ["goto"] } } }, then: { oneOf: [{ required: ["workflowId"] }, { required: ["stepId"] }] } }, { if: { properties: { type: { const: "retry" } } }, then: { required: ["retryAfter"] } }], dependentSchemas: { workflowId: { properties: { type: { enum: ["goto", "retry"] } } }, stepId: { properties: { type: { enum: ["goto", "retry"] } } } }, required: ["name", "type"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 };
function Ts(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Ts.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), ns(e, { instancePath: t, parentData: r, parentDataProperty: s, rootData: n, dynamicAnchors: o }))
    var l = ns.evaluated.props;
else
    i = null === i ? ns.errors : i.concat(ns.errors), p = i.length; const m = p; let u = !0; const h = p; if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.type && "goto" !== e.type) {
    const e = {};
    null === i ? i = [e] : i.push(e), p++;
} var d = h === p; if (p = m, null !== i && (m ? i.length = m : i = null), d) {
    const a = p, r = p;
    let s = !1, n = null;
    const o = p;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.workflowId) {
        const e = { instancePath: t, schemaPath: "#/allOf/0/then/oneOf/0/required", keyword: "required", params: { missingProperty: "workflowId" }, message: "must have required property 'workflowId'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    o === p && (s = !0, n = 0);
    const c = p;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.stepId) {
        const e = { instancePath: t, schemaPath: "#/allOf/0/then/oneOf/1/required", keyword: "required", params: { missingProperty: "stepId" }, message: "must have required property 'stepId'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    var y;
    if ((y = c === p) && s ? (s = !1, n = [n, 1]) : y && (s = !0, n = 1), s)
        p = r, null !== i && (r ? i.length = r : i = null);
    else {
        const e = { instancePath: t, schemaPath: "#/allOf/0/then/oneOf", keyword: "oneOf", params: { passingSchemas: n }, message: "must match exactly one schema in oneOf" };
        null === i ? i = [e] : i.push(e), p++;
    }
    u = d = a === p;
} if (!u) {
    const e = { instancePath: t, schemaPath: "#/allOf/0/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === i ? i = [e] : i.push(e), p++;
} !0 !== l && ((l = l || {}).type = !0); const f = p; let P = !0; const g = p; if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.type && "retry" !== e.type) {
    const e = {};
    null === i ? i = [e] : i.push(e), p++;
} var v = g === p; if (p = f, null !== i && (f ? i.length = f : i = null), v) {
    const a = p;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.retryAfter) {
        const e = { instancePath: t, schemaPath: "#/allOf/1/then/required", keyword: "required", params: { missingProperty: "retryAfter" }, message: "must have required property 'retryAfter'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    P = v = a === p;
} if (!P) {
    const e = { instancePath: t, schemaPath: "#/allOf/1/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === i ? i = [e] : i.push(e), p++;
} if (!0 !== l && ((l = l || {}).type = !0), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.type) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "type" }, message: "must have required property 'type'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l && ((l = l || {}).name = !0, l.type = !0, l.workflowId = !0, l.stepId = !0, l.retryAfter = !0, l.retryLimit = !0, l.criteria = !0), void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.type) {
        let a = e.type;
        if ("end" !== a && "goto" !== a && "retry" !== a) {
            const e = { instancePath: t + "/type", schemaPath: "#/properties/type/enum", keyword: "enum", params: { allowedValues: Us.properties.type.enum }, message: "must be equal to one of the allowed values" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.workflowId) {
        let a = e.workflowId, r = o.workflowId;
        if (r)
            if (r(a, { instancePath: t + "/workflowId", parentData: e, parentDataProperty: "workflowId", rootData: n, dynamicAnchors: o }))
                var b = r.evaluated.props, D = r.evaluated.items;
            else
                i = null === i ? r.errors : i.concat(r.errors), p = i.length;
        else if (Ts(a, { instancePath: t + "/workflowId", parentData: e, parentDataProperty: "workflowId", rootData: n, dynamicAnchors: o })) {
            var w = Ts.evaluated.props;
            !0 !== b && void 0 !== w && (!0 === w ? b = !0 : (b = b || {}, Object.assign(b, w)));
            var A = Ts.evaluated.items;
            !0 !== D && void 0 !== A && (D = !0 === A || (D > A ? D : A));
        }
        else
            i = null === i ? Ts.errors : i.concat(Ts.errors), p = i.length;
    }
    if (void 0 !== e.stepId) {
        let a = e.stepId, r = o.stepId;
        if (r)
            if (r(a, { instancePath: t + "/stepId", parentData: e, parentDataProperty: "stepId", rootData: n, dynamicAnchors: o }))
                var k = r.evaluated.props, $ = r.evaluated.items;
            else
                i = null === i ? r.errors : i.concat(r.errors), p = i.length;
        else if (Ts(a, { instancePath: t + "/stepId", parentData: e, parentDataProperty: "stepId", rootData: n, dynamicAnchors: o })) {
            var j = Ts.evaluated.props;
            !0 !== k && void 0 !== j && (!0 === j ? k = !0 : (k = k || {}, Object.assign(k, j)));
            var q = Ts.evaluated.items;
            !0 !== $ && void 0 !== q && ($ = !0 === q || ($ > q ? $ : q));
        }
        else
            i = null === i ? Ts.errors : i.concat(Ts.errors), p = i.length;
    }
    if (void 0 !== e.retryAfter) {
        let a = e.retryAfter;
        if ("number" == typeof a) {
            if (a < 0 || isNaN(a)) {
                const e = { instancePath: t + "/retryAfter", schemaPath: "#/properties/retryAfter/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/retryAfter", schemaPath: "#/properties/retryAfter/type", keyword: "type", params: { type: "number" }, message: "must be number" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.retryLimit) {
        let a = e.retryLimit;
        if ("number" != typeof a || a % 1 || isNaN(a)) {
            const e = { instancePath: t + "/retryLimit", schemaPath: "#/properties/retryLimit/type", keyword: "type", params: { type: "integer" }, message: "must be integer" };
            null === i ? i = [e] : i.push(e), p++;
        }
        if ("number" == typeof a && (a < 0 || isNaN(a))) {
            const e = { instancePath: t + "/retryLimit", schemaPath: "#/properties/retryLimit/minimum", keyword: "minimum", params: { comparison: ">=", limit: 0 }, message: "must be >= 0" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.criteria) {
        let r = e.criteria;
        if (Array.isArray(r)) {
            const e = r.length;
            for (let a = 0; a < e; a++)
                qs(r[a], { instancePath: t + "/criteria/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? qs.errors : i.concat(qs.errors), p = i.length);
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/criteria", schemaPath: "#/properties/criteria/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/criteria", schemaPath: "#/properties/criteria/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.workflowId) {
        const a = p;
        if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.type) {
            let a = e.type;
            if ("goto" !== a && "retry" !== a) {
                const e = { instancePath: t + "/type", schemaPath: "#/dependentSchemas/workflowId/properties/type/enum", keyword: "enum", params: { allowedValues: Us.dependentSchemas.workflowId.properties.type.enum }, message: "must be equal to one of the allowed values" };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        a === p && !0 !== l && ((l = l || {}).type = !0);
    }
    if (void 0 !== e.stepId) {
        const a = p;
        if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.type) {
            let a = e.type;
            if ("goto" !== a && "retry" !== a) {
                const e = { instancePath: t + "/type", schemaPath: "#/dependentSchemas/stepId/properties/type/enum", keyword: "enum", params: { allowedValues: Us.dependentSchemas.stepId.properties.type.enum }, message: "must be equal to one of the allowed values" };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        a === p && !0 !== l && ((l = l || {}).type = !0);
    }
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Ts.errors = i, 0 === p; }
function Ms(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Ms.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), ns(e, { instancePath: t, parentData: r, parentDataProperty: s, rootData: n, dynamicAnchors: o }))
    var l = ns.evaluated.props;
else
    i = null === i ? ns.errors : i.concat(ns.errors), p = i.length; const m = p; let u = !1, h = null; const d = p; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.operationId) {
    const e = { instancePath: t, schemaPath: "#/oneOf/0/required", keyword: "required", params: { missingProperty: "operationId" }, message: "must have required property 'operationId'" };
    null === i ? i = [e] : i.push(e), p++;
} (f = d === p) && (u = !0, h = 0); const y = p; if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.operationPath) {
    const e = { instancePath: t, schemaPath: "#/oneOf/1/required", keyword: "required", params: { missingProperty: "operationPath" }, message: "must have required property 'operationPath'" };
    null === i ? i = [e] : i.push(e), p++;
} if ((f = y === p) && u)
    u = !1, h = [h, 1];
else {
    f && (u = !0, h = 1);
    const a = p;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 === e.workflowId) {
        const e = { instancePath: t, schemaPath: "#/oneOf/2/required", keyword: "required", params: { missingProperty: "workflowId" }, message: "must have required property 'workflowId'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    var f;
    (f = a === p) && u ? (u = !1, h = [h, 2]) : f && (u = !0, h = 2);
} if (u)
    p = m, null !== i && (m ? i.length = m : i = null);
else {
    const e = { instancePath: t, schemaPath: "#/oneOf", keyword: "oneOf", params: { passingSchemas: h }, message: "must match exactly one schema in oneOf" };
    null === i ? i = [e] : i.push(e), p++;
} const P = p; let g = !0; const v = p; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.operationId && (t = "operationId")) {
        const e = {};
        null === i ? i = [e] : i.push(e), p++;
    }
} var b = v === p; if (p = P, null !== i && (P ? i.length = P : i = null), b) {
    const a = p;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.parameters) {
        let a = e.parameters;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++) {
                let e = a[r];
                const s = p;
                let n = !1, o = null;
                const c = p;
                if (e && "object" == typeof e && !Array.isArray(e)) {
                    if (void 0 === e.name) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/0/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 === e.value) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/0/required", keyword: "required", params: { missingProperty: "value" }, message: "must have required property 'value'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 === e.in) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/0/required", keyword: "required", params: { missingProperty: "in" }, message: "must have required property 'in'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.name && "string" != typeof e.name) {
                        const e = { instancePath: t + "/parameters/" + r + "/name", schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/0/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.in) {
                        let a = e.in;
                        if ("path" !== a && "query" !== a && "header" !== a && "cookie" !== a && "body" !== a) {
                            const e = { instancePath: t + "/parameters/" + r + "/in", schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/0/properties/in/enum", keyword: "enum", params: { allowedValues: bs.allOf[0].then.properties.parameters.items.oneOf[0].properties.in.enum }, message: "must be equal to one of the allowed values" };
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                    if (void 0 !== e.value) {
                        let a = e.value;
                        if ("object" != typeof a && "string" != typeof a && "boolean" != typeof a && "number" != typeof a) {
                            const e = { instancePath: t + "/parameters/" + r + "/value", schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/0/properties/value/type", keyword: "type", params: { type: bs.allOf[0].then.properties.parameters.items.oneOf[0].properties.value.type }, message: "must be string,boolean,object,array,number,null" };
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                }
                else {
                    const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/0/type", keyword: "type", params: { type: "object" }, message: "must be object" };
                    null === i ? i = [e] : i.push(e), p++;
                }
                if (c === p) {
                    n = !0, o = 0;
                    var D = { name: !0, in: !0, value: !0 };
                }
                const l = p;
                if (e && "object" == typeof e && !Array.isArray(e)) {
                    if (void 0 === e.reference) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/1/required", keyword: "required", params: { missingProperty: "reference" }, message: "must have required property 'reference'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.reference && "string" != typeof e.reference) {
                        const e = { instancePath: t + "/parameters/" + r + "/reference", schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/1/properties/reference/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.value) {
                        let a = e.value;
                        if ("object" != typeof a && "string" != typeof a && "boolean" != typeof a && "number" != typeof a) {
                            const e = { instancePath: t + "/parameters/" + r + "/value", schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/1/properties/value/type", keyword: "type", params: { type: bs.allOf[0].then.properties.parameters.items.oneOf[1].properties.value.type }, message: "must be string,boolean,object,array,number,null" };
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                }
                else {
                    const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf/1/type", keyword: "type", params: { type: "object" }, message: "must be object" };
                    null === i ? i = [e] : i.push(e), p++;
                }
                var w;
                if ((w = l === p) && n ? (n = !1, o = [o, 1]) : w && (n = !0, o = 1, !0 !== D && ((D = D || {}).reference = !0, D.value = !0)), n)
                    p = s, null !== i && (s ? i.length = s : i = null);
                else {
                    const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/0/then/properties/parameters/items/oneOf", keyword: "oneOf", params: { passingSchemas: o }, message: "must match exactly one schema in oneOf" };
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
        }
    }
    if (g = b = a === p, g)
        var A = { parameters: !0 };
} if (!g) {
    const e = { instancePath: t, schemaPath: "#/allOf/0/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === i ? i = [e] : i.push(e), p++;
} !0 !== l && void 0 !== A && (!0 === A ? l = !0 : (l = l || {}, Object.assign(l, A))); const k = p; let $ = !0; const j = p; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.operationPath && (t = "operationPath")) {
        const e = {};
        null === i ? i = [e] : i.push(e), p++;
    }
} var q = j === p; if (p = k, null !== i && (k ? i.length = k : i = null), q) {
    const a = p;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.parameters) {
        let a = e.parameters;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++) {
                let e = a[r];
                const s = p;
                let n = !1, o = null;
                const c = p;
                if (e && "object" == typeof e && !Array.isArray(e)) {
                    if (void 0 === e.name) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/0/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 === e.value) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/0/required", keyword: "required", params: { missingProperty: "value" }, message: "must have required property 'value'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 === e.in) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/0/required", keyword: "required", params: { missingProperty: "in" }, message: "must have required property 'in'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.name && "string" != typeof e.name) {
                        const e = { instancePath: t + "/parameters/" + r + "/name", schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/0/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.in) {
                        let a = e.in;
                        if ("path" !== a && "query" !== a && "header" !== a && "cookie" !== a && "body" !== a) {
                            const e = { instancePath: t + "/parameters/" + r + "/in", schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/0/properties/in/enum", keyword: "enum", params: { allowedValues: bs.allOf[1].then.properties.parameters.items.oneOf[0].properties.in.enum }, message: "must be equal to one of the allowed values" };
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                    if (void 0 !== e.value) {
                        let a = e.value;
                        if ("object" != typeof a && "string" != typeof a && "boolean" != typeof a && "number" != typeof a) {
                            const e = { instancePath: t + "/parameters/" + r + "/value", schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/0/properties/value/type", keyword: "type", params: { type: bs.allOf[1].then.properties.parameters.items.oneOf[0].properties.value.type }, message: "must be string,boolean,object,array,number,null" };
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                }
                else {
                    const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/0/type", keyword: "type", params: { type: "object" }, message: "must be object" };
                    null === i ? i = [e] : i.push(e), p++;
                }
                if (c === p) {
                    n = !0, o = 0;
                    var I = { name: !0, in: !0, value: !0 };
                }
                const l = p;
                if (e && "object" == typeof e && !Array.isArray(e)) {
                    if (void 0 === e.reference) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/1/required", keyword: "required", params: { missingProperty: "reference" }, message: "must have required property 'reference'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.reference && "string" != typeof e.reference) {
                        const e = { instancePath: t + "/parameters/" + r + "/reference", schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/1/properties/reference/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.value) {
                        let a = e.value;
                        if ("object" != typeof a && "string" != typeof a && "boolean" != typeof a && "number" != typeof a) {
                            const e = { instancePath: t + "/parameters/" + r + "/value", schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/1/properties/value/type", keyword: "type", params: { type: bs.allOf[1].then.properties.parameters.items.oneOf[1].properties.value.type }, message: "must be string,boolean,object,array,number,null" };
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                }
                else {
                    const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf/1/type", keyword: "type", params: { type: "object" }, message: "must be object" };
                    null === i ? i = [e] : i.push(e), p++;
                }
                var x;
                if ((x = l === p) && n ? (n = !1, o = [o, 1]) : x && (n = !0, o = 1, !0 !== I && ((I = I || {}).reference = !0, I.value = !0)), n)
                    p = s, null !== i && (s ? i.length = s : i = null);
                else {
                    const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/1/then/properties/parameters/items/oneOf", keyword: "oneOf", params: { passingSchemas: o }, message: "must match exactly one schema in oneOf" };
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
        }
    }
    if ($ = q = a === p, $)
        var O = { parameters: !0 };
} if (!$) {
    const e = { instancePath: t, schemaPath: "#/allOf/1/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === i ? i = [e] : i.push(e), p++;
} !0 !== l && void 0 !== O && (!0 === O ? l = !0 : (l = l || {}, Object.assign(l, O))); const N = p; let U = !0; const T = p; if (e && "object" == typeof e && !Array.isArray(e)) {
    let t;
    if (void 0 === e.workflowId && (t = "workflowId")) {
        const e = {};
        null === i ? i = [e] : i.push(e), p++;
    }
} var M = T === p; if (p = N, null !== i && (N ? i.length = N : i = null), M) {
    const a = p;
    if (e && "object" == typeof e && !Array.isArray(e) && void 0 !== e.parameters) {
        let a = e.parameters;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++) {
                let e = a[r];
                const s = p;
                let n = !1, o = null;
                const c = p;
                if (e && "object" == typeof e && !Array.isArray(e)) {
                    if (void 0 === e.name) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/2/then/properties/parameters/items/oneOf/0/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 === e.value) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/2/then/properties/parameters/items/oneOf/0/required", keyword: "required", params: { missingProperty: "value" }, message: "must have required property 'value'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.name && "string" != typeof e.name) {
                        const e = { instancePath: t + "/parameters/" + r + "/name", schemaPath: "#/allOf/2/then/properties/parameters/items/oneOf/0/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.value) {
                        let a = e.value;
                        if ("object" != typeof a && "string" != typeof a && "boolean" != typeof a && "number" != typeof a) {
                            const e = { instancePath: t + "/parameters/" + r + "/value", schemaPath: "#/allOf/2/then/properties/parameters/items/oneOf/0/properties/value/type", keyword: "type", params: { type: bs.allOf[2].then.properties.parameters.items.oneOf[0].properties.value.type }, message: "must be string,boolean,object,array,number,null" };
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                }
                else {
                    const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/2/then/properties/parameters/items/oneOf/0/type", keyword: "type", params: { type: "object" }, message: "must be object" };
                    null === i ? i = [e] : i.push(e), p++;
                }
                if (c === p) {
                    n = !0, o = 0;
                    var S = { name: !0, value: !0 };
                }
                const l = p;
                if (e && "object" == typeof e && !Array.isArray(e)) {
                    if (void 0 === e.reference) {
                        const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/2/then/properties/parameters/items/oneOf/1/required", keyword: "required", params: { missingProperty: "reference" }, message: "must have required property 'reference'" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.reference && "string" != typeof e.reference) {
                        const e = { instancePath: t + "/parameters/" + r + "/reference", schemaPath: "#/allOf/2/then/properties/parameters/items/oneOf/1/properties/reference/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                        null === i ? i = [e] : i.push(e), p++;
                    }
                    if (void 0 !== e.value) {
                        let a = e.value;
                        if ("object" != typeof a && "string" != typeof a && "boolean" != typeof a && "number" != typeof a) {
                            const e = { instancePath: t + "/parameters/" + r + "/value", schemaPath: "#/allOf/2/then/properties/parameters/items/oneOf/1/properties/value/type", keyword: "type", params: { type: bs.allOf[2].then.properties.parameters.items.oneOf[1].properties.value.type }, message: "must be string,boolean,object,array,number,null" };
                            null === i ? i = [e] : i.push(e), p++;
                        }
                    }
                }
                else {
                    const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/2/then/properties/parameters/items/oneOf/1/type", keyword: "type", params: { type: "object" }, message: "must be object" };
                    null === i ? i = [e] : i.push(e), p++;
                }
                var z;
                if ((z = l === p) && n ? (n = !1, o = [o, 1]) : z && (n = !0, o = 1, !0 !== S && ((S = S || {}).reference = !0, S.value = !0)), n)
                    p = s, null !== i && (s ? i.length = s : i = null);
                else {
                    const e = { instancePath: t + "/parameters/" + r, schemaPath: "#/allOf/2/then/properties/parameters/items/oneOf", keyword: "oneOf", params: { passingSchemas: o }, message: "must match exactly one schema in oneOf" };
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
        }
    }
    if (U = M = a === p, U)
        var L = { parameters: !0 };
} if (!U) {
    const e = { instancePath: t, schemaPath: "#/allOf/2/if", keyword: "if", params: { failingKeyword: "then" }, message: 'must match "then" schema' };
    null === i ? i = [e] : i.push(e), p++;
} if (!0 !== l && void 0 !== L && (!0 === L ? l = !0 : (l = l || {}, Object.assign(l, L))), e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.stepId) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "stepId" }, message: "must have required property 'stepId'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l && ((l = l || {}).stepId = !0, l.description = !0, l.operationId = !0, l.operationPath = !0, l.workflowId = !0, l.parameters = !0, l.requestBody = !0, l.successCriteria = !0, l.onSuccess = !0, l.onFailure = !0, l.outputs = !0), void 0 !== e.stepId) {
        if ("string" != typeof e.stepId) {
            const e = { instancePath: t + "/stepId", schemaPath: "#/properties/stepId/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
        o.stepId || (o.stepId = Ds);
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.operationId && "string" != typeof e.operationId) {
        const e = { instancePath: t + "/operationId", schemaPath: "#/properties/operationId/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.operationPath && "string" != typeof e.operationPath) {
        const e = { instancePath: t + "/operationPath", schemaPath: "#/properties/operationPath/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.workflowId) {
        let a = e.workflowId, r = o.workflowId;
        if (r)
            if (r(a, { instancePath: t + "/workflowId", parentData: e, parentDataProperty: "workflowId", rootData: n, dynamicAnchors: o }))
                var R = r.evaluated.props, C = r.evaluated.items;
            else
                i = null === i ? r.errors : i.concat(r.errors), p = i.length;
        else if (Ms(a, { instancePath: t + "/workflowId", parentData: e, parentDataProperty: "workflowId", rootData: n, dynamicAnchors: o })) {
            var E = Ms.evaluated.props;
            !0 !== R && void 0 !== E && (!0 === E ? R = !0 : (R = R || {}, Object.assign(R, E)));
            var V = Ms.evaluated.items;
            !0 !== C && void 0 !== V && (C = !0 === V || (C > V ? C : V));
        }
        else
            i = null === i ? Ms.errors : i.concat(Ms.errors), p = i.length;
    }
    if (void 0 !== e.parameters) {
        let r = e.parameters;
        if (Array.isArray(r)) {
            let e, s = r.length;
            if (s > 1)
                e: for (; s--;)
                    for (e = s; e--;)
                        if (a(r[s], r[e])) {
                            const a = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/uniqueItems", keyword: "uniqueItems", params: { i: s, j: e }, message: "must NOT have duplicate items (items ## " + e + " and " + s + " are identical)" };
                            null === i ? i = [a] : i.push(a), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.requestBody && (As(e.requestBody, { instancePath: t + "/requestBody", parentData: e, parentDataProperty: "requestBody", rootData: n, dynamicAnchors: o }) || (i = null === i ? As.errors : i.concat(As.errors), p = i.length)), void 0 !== e.successCriteria) {
        let r = e.successCriteria;
        if (Array.isArray(r)) {
            if (r.length < 1) {
                const e = { instancePath: t + "/successCriteria", schemaPath: "#/properties/successCriteria/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === i ? i = [e] : i.push(e), p++;
            }
            const e = r.length;
            for (let a = 0; a < e; a++)
                qs(r[a], { instancePath: t + "/successCriteria/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? qs.errors : i.concat(qs.errors), p = i.length);
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/successCriteria", schemaPath: "#/properties/successCriteria/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/successCriteria", schemaPath: "#/properties/successCriteria/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.onSuccess) {
        let r = e.onSuccess;
        if (Array.isArray(r)) {
            const e = r.length;
            for (let a = 0; a < e; a++) {
                let e = r[a];
                const s = p;
                let c = !1, l = null;
                const m = p;
                if (xs(e, { instancePath: t + "/onSuccess/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? xs.errors : i.concat(xs.errors), p = i.length), m === p) {
                    c = !0, l = 0;
                    var K = !0;
                }
                const u = p;
                var F;
                if (Ns(e, { instancePath: t + "/onSuccess/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ns.errors : i.concat(Ns.errors), p = i.length), (F = u === p) && c ? (c = !1, l = [l, 1]) : F && (c = !0, l = 1, !0 !== K && (K = !0)), c)
                    p = s, null !== i && (s ? i.length = s : i = null);
                else {
                    const e = { instancePath: t + "/onSuccess/" + a, schemaPath: "#/properties/onSuccess/items/oneOf", keyword: "oneOf", params: { passingSchemas: l }, message: "must match exactly one schema in oneOf" };
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/onSuccess", schemaPath: "#/properties/onSuccess/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/onSuccess", schemaPath: "#/properties/onSuccess/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.onFailure) {
        let r = e.onFailure;
        if (Array.isArray(r)) {
            const e = r.length;
            for (let a = 0; a < e; a++) {
                let e = r[a];
                const s = p;
                let c = !1, l = null;
                const m = p;
                if (Ts(e, { instancePath: t + "/onFailure/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ts.errors : i.concat(Ts.errors), p = i.length), m === p) {
                    c = !0, l = 0;
                    var B = !0;
                }
                const u = p;
                var _;
                if (Ns(e, { instancePath: t + "/onFailure/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ns.errors : i.concat(Ns.errors), p = i.length), (_ = u === p) && c ? (c = !1, l = [l, 1]) : _ && (c = !0, l = 1, !0 !== B && (B = !0)), c)
                    p = s, null !== i && (s ? i.length = s : i = null);
                else {
                    const e = { instancePath: t + "/onFailure/" + a, schemaPath: "#/properties/onFailure/items/oneOf", keyword: "oneOf", params: { passingSchemas: l }, message: "must match exactly one schema in oneOf" };
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/onFailure", schemaPath: "#/properties/onFailure/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/onFailure", schemaPath: "#/properties/onFailure/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.outputs) {
        let a = e.outputs;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            var Z = {};
            for (const e in a)
                if (Zt.test(e)) {
                    if ("string" != typeof a[e]) {
                        const a = { instancePath: t + "/outputs/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/outputs/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                        null === i ? i = [a] : i.push(a), p++;
                    }
                    Z[e] = !0;
                }
        }
        else {
            const e = { instancePath: t + "/outputs", schemaPath: "#/properties/outputs/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Ms.errors = i, 0 === p; }
Ts.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ms.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Ss = { $comment: "https://spec.openapis.org/arazzo/v1.0.0#parameter-object", description: "Describes a single step parameter", type: "object", properties: { name: { description: "The name of the parameter", type: "string" }, in: { description: "The named location of the parameter", enum: ["path", "query", "header", "cookie", "body"] }, value: { description: "The value to pass in the parameter", type: ["string", "boolean", "object", "array", "number", "null"] } }, required: ["name", "value"], $ref: "#/$defs/specification-extensions", unevaluatedProperties: !1 };
function zs(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = zs.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), ns(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = ns.evaluated.props;
else
    o = null === o ? ns.errors : o.concat(ns.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.name) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "name" }, message: "must have required property 'name'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 === e.value) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "value" }, message: "must have required property 'value'" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (!0 !== c && ((c = c || {}).name = !0, c.in = !0, c.value = !0), void 0 !== e.name && "string" != typeof e.name) {
        const e = { instancePath: t + "/name", schemaPath: "#/properties/name/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === o ? o = [e] : o.push(e), i++;
    }
    if (void 0 !== e.in) {
        let a = e.in;
        if ("path" !== a && "query" !== a && "header" !== a && "cookie" !== a && "body" !== a) {
            const e = { instancePath: t + "/in", schemaPath: "#/properties/in/enum", keyword: "enum", params: { allowedValues: Ss.properties.in.enum }, message: "must be equal to one of the allowed values" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.value) {
        let a = e.value;
        if ("object" != typeof a && "string" != typeof a && "boolean" != typeof a && "number" != typeof a) {
            const e = { instancePath: t + "/value", schemaPath: "#/properties/value/type", keyword: "type", params: { type: Ss.properties.value.type }, message: "must be string,boolean,object,array,number,null" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return zs.errors = o, 0 === i; }
function Ls(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Ls.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), ns(e, { instancePath: t, parentData: r, parentDataProperty: s, rootData: n, dynamicAnchors: o }))
    var l = ns.evaluated.props;
else
    i = null === i ? ns.errors : i.concat(ns.errors), p = i.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.workflowId) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "workflowId" }, message: "must have required property 'workflowId'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.steps) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "steps" }, message: "must have required property 'steps'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l && ((l = l || {}).workflowId = !0, l.summary = !0, l.description = !0, l.inputs = !0, l.dependsOn = !0, l.steps = !0, l.successActions = !0, l.failureActions = !0, l.outputs = !0, l.parameters = !0), void 0 !== e.workflowId) {
        if ("string" != typeof e.workflowId) {
            const e = { instancePath: t + "/workflowId", schemaPath: "#/properties/workflowId/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
        o.workflowId || (o.workflowId = ls);
    }
    if (void 0 !== e.summary && "string" != typeof e.summary) {
        const e = { instancePath: t + "/summary", schemaPath: "#/properties/summary/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.description && "string" != typeof e.description) {
        const e = { instancePath: t + "/description", schemaPath: "#/properties/description/type", keyword: "type", params: { type: "string" }, message: "must be string" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 !== e.inputs && (vs(e.inputs, { instancePath: t + "/inputs", parentData: e, parentDataProperty: "inputs", rootData: n, dynamicAnchors: o }) || (i = null === i ? vs.errors : i.concat(vs.errors), p = i.length)), void 0 !== e.dependsOn) {
        let a = e.dependsOn;
        if (Array.isArray(a)) {
            const e = a.length;
            for (let r = 0; r < e; r++)
                if ("string" != typeof a[r]) {
                    const e = { instancePath: t + "/dependsOn/" + r, schemaPath: "#/properties/dependsOn/items/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                    null === i ? i = [e] : i.push(e), p++;
                }
            let r, s = a.length;
            if (s > 1) {
                const e = {};
                for (; s--;) {
                    let n = a[s];
                    if ("string" == typeof n) {
                        if ("number" == typeof e[n]) {
                            r = e[n];
                            const a = { instancePath: t + "/dependsOn", schemaPath: "#/properties/dependsOn/uniqueItems", keyword: "uniqueItems", params: { i: s, j: r }, message: "must NOT have duplicate items (items ## " + r + " and " + s + " are identical)" };
                            null === i ? i = [a] : i.push(a), p++;
                            break;
                        }
                        e[n] = s;
                    }
                }
            }
        }
        else {
            const e = { instancePath: t + "/dependsOn", schemaPath: "#/properties/dependsOn/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.steps) {
        let r = e.steps;
        if (Array.isArray(r)) {
            if (r.length < 1) {
                const e = { instancePath: t + "/steps", schemaPath: "#/properties/steps/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === i ? i = [e] : i.push(e), p++;
            }
            const e = r.length;
            for (let a = 0; a < e; a++)
                Ms(r[a], { instancePath: t + "/steps/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ms.errors : i.concat(Ms.errors), p = i.length);
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/steps", schemaPath: "#/properties/steps/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/steps", schemaPath: "#/properties/steps/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.successActions) {
        let r = e.successActions;
        if (Array.isArray(r)) {
            const e = r.length;
            for (let a = 0; a < e; a++) {
                let e = r[a];
                const s = p;
                let c = !1, l = null;
                const h = p;
                if (xs(e, { instancePath: t + "/successActions/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? xs.errors : i.concat(xs.errors), p = i.length), h === p) {
                    c = !0, l = 0;
                    var m = !0;
                }
                const d = p;
                var u;
                if (Ns(e, { instancePath: t + "/successActions/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ns.errors : i.concat(Ns.errors), p = i.length), (u = d === p) && c ? (c = !1, l = [l, 1]) : u && (c = !0, l = 1, !0 !== m && (m = !0)), c)
                    p = s, null !== i && (s ? i.length = s : i = null);
                else {
                    const e = { instancePath: t + "/successActions/" + a, schemaPath: "#/properties/successActions/items/oneOf", keyword: "oneOf", params: { passingSchemas: l }, message: "must match exactly one schema in oneOf" };
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/successActions", schemaPath: "#/properties/successActions/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/successActions", schemaPath: "#/properties/successActions/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.failureActions) {
        let r = e.failureActions;
        if (Array.isArray(r)) {
            const e = r.length;
            for (let a = 0; a < e; a++) {
                let e = r[a];
                const s = p;
                let c = !1, l = null;
                const m = p;
                if (Ts(e, { instancePath: t + "/failureActions/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ts.errors : i.concat(Ts.errors), p = i.length), m === p) {
                    c = !0, l = 0;
                    var h = !0;
                }
                const u = p;
                var d;
                if (Ns(e, { instancePath: t + "/failureActions/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ns.errors : i.concat(Ns.errors), p = i.length), (d = u === p) && c ? (c = !1, l = [l, 1]) : d && (c = !0, l = 1, !0 !== h && (h = !0)), c)
                    p = s, null !== i && (s ? i.length = s : i = null);
                else {
                    const e = { instancePath: t + "/failureActions/" + a, schemaPath: "#/properties/failureActions/items/oneOf", keyword: "oneOf", params: { passingSchemas: l }, message: "must match exactly one schema in oneOf" };
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/failureActions", schemaPath: "#/properties/failureActions/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/failureActions", schemaPath: "#/properties/failureActions/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.outputs) {
        let a = e.outputs;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            var y = {};
            for (const e in a)
                if (Zt.test(e)) {
                    if ("string" != typeof a[e]) {
                        const a = { instancePath: t + "/outputs/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), schemaPath: "#/properties/outputs/patternProperties/%5E%5Ba-zA-Z0-9%5C.%5C-_%5D%2B%24/type", keyword: "type", params: { type: "string" }, message: "must be string" };
                        null === i ? i = [a] : i.push(a), p++;
                    }
                    y[e] = !0;
                }
        }
        else {
            const e = { instancePath: t + "/outputs", schemaPath: "#/properties/outputs/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.parameters) {
        let r = e.parameters;
        if (Array.isArray(r)) {
            const e = r.length;
            for (let a = 0; a < e; a++) {
                let e = r[a];
                const s = p;
                let c = !1, l = null;
                const m = p;
                if (zs(e, { instancePath: t + "/parameters/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? zs.errors : i.concat(zs.errors), p = i.length), m === p) {
                    c = !0, l = 0;
                    var f = !0;
                }
                const u = p;
                var P;
                if (Ns(e, { instancePath: t + "/parameters/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ns.errors : i.concat(Ns.errors), p = i.length), (P = u === p) && c ? (c = !1, l = [l, 1]) : P && (c = !0, l = 1, !0 !== f && (f = !0)), c)
                    p = s, null !== i && (s ? i.length = s : i = null);
                else {
                    const e = { instancePath: t + "/parameters/" + a, schemaPath: "#/properties/parameters/items/oneOf", keyword: "oneOf", params: { passingSchemas: l }, message: "must match exactly one schema in oneOf" };
                    null === i ? i = [e] : i.push(e), p++;
                }
            }
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (!0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Ls.errors = i, 0 === p; }
function Rs(e, { instancePath: t = "", parentData: a, parentDataProperty: r, rootData: s = e, dynamicAnchors: n = {} } = {}) { let o = null, i = 0; const p = Rs.evaluated; if (p.dynamicProps && (p.props = void 0), p.dynamicItems && (p.items = void 0), ns(e, { instancePath: t, parentData: a, parentDataProperty: r, rootData: s, dynamicAnchors: n }))
    var c = ns.evaluated.props;
else
    o = null === o ? ns.errors : o.concat(ns.errors), i = o.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (!0 !== c && ((c = c || {}).inputs = !0, c.parameters = !0, c.successActions = !0, c.failureActions = !0), void 0 !== e.inputs) {
        let a = e.inputs;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            var l = {};
            for (const e in a)
                Zt.test(e) && (vs(a[e], { instancePath: t + "/inputs/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? vs.errors : o.concat(vs.errors), i = o.length), l[e] = !0);
        }
        else {
            const e = { instancePath: t + "/inputs", schemaPath: "#/properties/inputs/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.parameters) {
        let a = e.parameters;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            var m = {};
            for (const e in a)
                Zt.test(e) && (zs(a[e], { instancePath: t + "/parameters/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? zs.errors : o.concat(zs.errors), i = o.length), m[e] = !0);
        }
        else {
            const e = { instancePath: t + "/parameters", schemaPath: "#/properties/parameters/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.successActions) {
        let a = e.successActions;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            var u = {};
            for (const e in a)
                Zt.test(e) && (xs(a[e], { instancePath: t + "/successActions/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? xs.errors : o.concat(xs.errors), i = o.length), u[e] = !0);
        }
        else {
            const e = { instancePath: t + "/successActions", schemaPath: "#/properties/successActions/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (void 0 !== e.failureActions) {
        let a = e.failureActions;
        if (a && "object" == typeof a && !Array.isArray(a)) {
            var h = {};
            for (const e in a)
                Zt.test(e) && (Ts(a[e], { instancePath: t + "/failureActions/" + e.replace(/~/g, "~0").replace(/\//g, "~1"), parentData: a, parentDataProperty: e, rootData: s, dynamicAnchors: n }) || (o = null === o ? Ts.errors : o.concat(Ts.errors), i = o.length), h[e] = !0);
        }
        else {
            const e = { instancePath: t + "/failureActions", schemaPath: "#/properties/failureActions/type", keyword: "type", params: { type: "object" }, message: "must be object" };
            null === o ? o = [e] : o.push(e), i++;
        }
    }
    if (!0 !== c)
        for (const a in e)
            if (!c || !c[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === o ? o = [e] : o.push(e), i++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === o ? o = [e] : o.push(e), i++;
} return Rs.errors = o, 0 === i; }
zs.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Ls.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 }, Rs.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
const Cs = new RegExp("^1\\.0\\.\\d+(-.+)?$", "u");
function Es(e, { instancePath: t = "", parentData: r, parentDataProperty: s, rootData: n = e, dynamicAnchors: o = {} } = {}) { let i = null, p = 0; const c = Es.evaluated; if (c.dynamicProps && (c.props = void 0), c.dynamicItems && (c.items = void 0), ns(e, { instancePath: t, parentData: r, parentDataProperty: s, rootData: n, dynamicAnchors: o }))
    var l = ns.evaluated.props;
else
    i = null === i ? ns.errors : i.concat(ns.errors), p = i.length; if (e && "object" == typeof e && !Array.isArray(e)) {
    if (void 0 === e.arazzo) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "arazzo" }, message: "must have required property 'arazzo'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.info) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "info" }, message: "must have required property 'info'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.sourceDescriptions) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "sourceDescriptions" }, message: "must have required property 'sourceDescriptions'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (void 0 === e.workflows) {
        const e = { instancePath: t, schemaPath: "#/required", keyword: "required", params: { missingProperty: "workflows" }, message: "must have required property 'workflows'" };
        null === i ? i = [e] : i.push(e), p++;
    }
    if (!0 !== l && ((l = l || {}).arazzo = !0, l.info = !0, l.sourceDescriptions = !0, l.workflows = !0, l.components = !0), void 0 !== e.arazzo) {
        let a = e.arazzo;
        if ("string" == typeof a) {
            if (!Cs.test(a)) {
                const e = { instancePath: t + "/arazzo", schemaPath: "#/properties/arazzo/pattern", keyword: "pattern", params: { pattern: "^1\\.0\\.\\d+(-.+)?$" }, message: 'must match pattern "^1\\.0\\.\\d+(-.+)?$"' };
                null === i ? i = [e] : i.push(e), p++;
            }
        }
        else {
            const e = { instancePath: t + "/arazzo", schemaPath: "#/properties/arazzo/type", keyword: "type", params: { type: "string" }, message: "must be string" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.info && (os(e.info, { instancePath: t + "/info", parentData: e, parentDataProperty: "info", rootData: n, dynamicAnchors: o }) || (i = null === i ? os.errors : i.concat(os.errors), p = i.length)), void 0 !== e.sourceDescriptions) {
        let r = e.sourceDescriptions;
        if (Array.isArray(r)) {
            if (r.length < 1) {
                const e = { instancePath: t + "/sourceDescriptions", schemaPath: "#/properties/sourceDescriptions/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === i ? i = [e] : i.push(e), p++;
            }
            const e = r.length;
            for (let a = 0; a < e; a++)
                cs(r[a], { instancePath: t + "/sourceDescriptions/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? cs.errors : i.concat(cs.errors), p = i.length);
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/sourceDescriptions", schemaPath: "#/properties/sourceDescriptions/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/sourceDescriptions", schemaPath: "#/properties/sourceDescriptions/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.workflows) {
        let r = e.workflows;
        if (Array.isArray(r)) {
            if (r.length < 1) {
                const e = { instancePath: t + "/workflows", schemaPath: "#/properties/workflows/minItems", keyword: "minItems", params: { limit: 1 }, message: "must NOT have fewer than 1 items" };
                null === i ? i = [e] : i.push(e), p++;
            }
            const e = r.length;
            for (let a = 0; a < e; a++)
                Ls(r[a], { instancePath: t + "/workflows/" + a, parentData: r, parentDataProperty: a, rootData: n, dynamicAnchors: o }) || (i = null === i ? Ls.errors : i.concat(Ls.errors), p = i.length);
            let s, c = r.length;
            if (c > 1)
                e: for (; c--;)
                    for (s = c; s--;)
                        if (a(r[c], r[s])) {
                            const e = { instancePath: t + "/workflows", schemaPath: "#/properties/workflows/uniqueItems", keyword: "uniqueItems", params: { i: c, j: s }, message: "must NOT have duplicate items (items ## " + s + " and " + c + " are identical)" };
                            null === i ? i = [e] : i.push(e), p++;
                            break e;
                        }
        }
        else {
            const e = { instancePath: t + "/workflows", schemaPath: "#/properties/workflows/type", keyword: "type", params: { type: "array" }, message: "must be array" };
            null === i ? i = [e] : i.push(e), p++;
        }
    }
    if (void 0 !== e.components && (Rs(e.components, { instancePath: t + "/components", parentData: e, parentDataProperty: "components", rootData: n, dynamicAnchors: o }) || (i = null === i ? Rs.errors : i.concat(Rs.errors), p = i.length)), !0 !== l)
        for (const a in e)
            if (!l || !l[a]) {
                const e = { instancePath: t, schemaPath: "#/unevaluatedProperties", keyword: "unevaluatedProperties", params: { unevaluatedProperty: a }, message: "must NOT have unevaluated properties" };
                null === i ? i = [e] : i.push(e), p++;
            }
}
else {
    const e = { instancePath: t, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" };
    null === i ? i = [e] : i.push(e), p++;
} return Es.errors = i, 0 === p; }
Es.evaluated = { props: !0, dynamicProps: !1, dynamicItems: !1 };
//# sourceMappingURL=validators.js.map