/// <reference types="react" />
import * as React from "react";
import { LinkModel, PointModel } from "../Common";
import { DiagramEngine } from "../DiagramEngine";
export interface DefaultLinkProps {
    color?: string;
    width?: number;
    link: LinkModel;
    smooth?: boolean;
    diagramEngine: DiagramEngine;
    pointAdded?: (point: PointModel, event) => any;
}
export interface DefaultLinkState {
    selected: boolean;
}
/**
 * @author Dylan Vorster
 */
export declare class DefaultLinkWidget extends React.Component<DefaultLinkProps, DefaultLinkState> {
    static defaultProps: DefaultLinkProps;
    constructor(props: DefaultLinkProps);
    addPointToLink: (event: any, index: number) => void;
    generatePoint(pointIndex: number): JSX.Element;
    generateLink(extraProps: any, id: string | number): JSX.Element;
    generateLinePath(firstPoint: PointModel, lastPoint: PointModel): string;
    generateCurvePath(firstPoint: PointModel, lastPoint: PointModel, firstPointDelta?: number, lastPointDelta?: number): string;
    render(): JSX.Element;
}
