"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

// Generated by CoffeeScript 2.4.1
// # Stream Transformer Sync
// Provides a synchronous alternative to the CSV transformer.
// ## Usage  
// `const records = transform(records, [options], handler)`  
// ## Source Code
var clone, transform;
transform = require('.');

var _require = require('mixme');

clone = _require.clone;

module.exports = function () {
  var argument, callback, chunks, expected_handler_length, handler, i, j, k, len, len1, options, record, records, transformer, type; // Import arguments normalization

  options = {};

  for (i = j = 0, len = arguments.length; j < len; i = ++j) {
    argument = arguments[i];
    type = _typeof(argument);

    if (argument === null) {
      type = 'null';
    } else if (type === 'object' && Array.isArray(argument)) {
      type = 'array';
    }

    if (type === 'array') {
      records = argument;
    } else if (type === 'object') {
      options = clone(argument);
    } else if (type === 'function') {
      if (handler && i === arguments.length - 1) {
        callback = argument;
      } else {
        handler = argument;
      }
    } else if (type !== 'null') {
      throw new Error("Invalid Arguments: got ".concat(JSON.stringify(argument), " at position ").concat(i));
    }
  } // Validate arguments


  expected_handler_length = 1;

  if (options.params) {
    expected_handler_length++;
  }

  if (handler.length > expected_handler_length) {
    throw Error('Invalid Handler: only synchonous handlers are supported');
  } // Start transformation


  chunks = [];
  transformer = new transform.Transformer(options, handler);

  transformer.push = function (chunk) {
    return chunks.push(chunk);
  };

  for (k = 0, len1 = records.length; k < len1; k++) {
    record = records[k];

    transformer._transform(record, null, function () {});
  }

  return chunks;
};