// File generated from our OpenAPI spec

'use strict';

const resourceNamespace = require('./ResourceNamespace');

module.exports = {
  Accounts: require('./resources/Accounts'),
  // Support Accounts for consistency, Account for backwards compatibility
  Account: require('./resources/Accounts'),
  AccountLinks: require('./resources/AccountLinks'),
  ApplePayDomains: require('./resources/ApplePayDomains'),
  ApplicationFees: require('./resources/ApplicationFees'),
  Balance: require('./resources/Balance'),
  BalanceTransactions: require('./resources/BalanceTransactions'),
  Charges: require('./resources/Charges'),
  CountrySpecs: require('./resources/CountrySpecs'),
  Coupons: require('./resources/Coupons'),
  CreditNotes: require('./resources/CreditNotes'),
  Customers: require('./resources/Customers'),
  Disputes: require('./resources/Disputes'),
  EphemeralKeys: require('./resources/EphemeralKeys'),
  Events: require('./resources/Events'),
  ExchangeRates: require('./resources/ExchangeRates'),
  Files: require('./resources/Files'),
  FileLinks: require('./resources/FileLinks'),
  Invoices: require('./resources/Invoices'),
  InvoiceItems: require('./resources/InvoiceItems'),
  IssuerFraudRecords: require('./resources/IssuerFraudRecords'),
  Mandates: require('./resources/Mandates'),
  OAuth: require('./resources/OAuth'),
  Orders: require('./resources/Orders'),
  OrderReturns: require('./resources/OrderReturns'),
  PaymentIntents: require('./resources/PaymentIntents'),
  PaymentMethods: require('./resources/PaymentMethods'),
  Payouts: require('./resources/Payouts'),
  Plans: require('./resources/Plans'),
  Prices: require('./resources/Prices'),
  Products: require('./resources/Products'),
  PromotionCodes: require('./resources/PromotionCodes'),
  Refunds: require('./resources/Refunds'),
  Reviews: require('./resources/Reviews'),
  SetupAttempts: require('./resources/SetupAttempts'),
  SetupIntents: require('./resources/SetupIntents'),
  Skus: require('./resources/SKUs'),
  Sources: require('./resources/Sources'),
  Subscriptions: require('./resources/Subscriptions'),
  SubscriptionItems: require('./resources/SubscriptionItems'),
  SubscriptionSchedules: require('./resources/SubscriptionSchedules'),
  TaxCodes: require('./resources/TaxCodes'),
  TaxRates: require('./resources/TaxRates'),
  Tokens: require('./resources/Tokens'),
  Topups: require('./resources/Topups'),
  Transfers: require('./resources/Transfers'),
  WebhookEndpoints: require('./resources/WebhookEndpoints'),
  BillingPortal: resourceNamespace('billingPortal', {
    Configurations: require('./resources/BillingPortal/Configurations'),
    Sessions: require('./resources/BillingPortal/Sessions'),
  }),
  Checkout: resourceNamespace('checkout', {
    Sessions: require('./resources/Checkout/Sessions'),
  }),
  Identity: resourceNamespace('identity', {
    VerificationReports: require('./resources/Identity/VerificationReports'),
    VerificationSessions: require('./resources/Identity/VerificationSessions'),
  }),
  Issuing: resourceNamespace('issuing', {
    Authorizations: require('./resources/Issuing/Authorizations'),
    Cards: require('./resources/Issuing/Cards'),
    Cardholders: require('./resources/Issuing/Cardholders'),
    Disputes: require('./resources/Issuing/Disputes'),
    Transactions: require('./resources/Issuing/Transactions'),
  }),
  Radar: resourceNamespace('radar', {
    EarlyFraudWarnings: require('./resources/Radar/EarlyFraudWarnings'),
    ValueLists: require('./resources/Radar/ValueLists'),
    ValueListItems: require('./resources/Radar/ValueListItems'),
  }),
  Reporting: resourceNamespace('reporting', {
    ReportRuns: require('./resources/Reporting/ReportRuns'),
    ReportTypes: require('./resources/Reporting/ReportTypes'),
  }),
  Sigma: resourceNamespace('sigma', {
    ScheduledQueryRuns: require('./resources/Sigma/ScheduledQueryRuns'),
  }),
  Terminal: resourceNamespace('terminal', {
    ConnectionTokens: require('./resources/Terminal/ConnectionTokens'),
    Locations: require('./resources/Terminal/Locations'),
    Readers: require('./resources/Terminal/Readers'),
  }),
};
