import React from 'react';
import { Styled } from '../constructors/constructWithOptions';
import css from '../constructors/css';
import withTheme from '../hoc/withTheme';
import useTheme from '../hooks/useTheme';
import ThemeProvider, { ThemeConsumer, ThemeContext } from '../models/ThemeProvider';
import { NativeTarget } from '../types';
import isStyledComponent from '../utils/isStyledComponent';
declare const styled: (<Target extends NativeTarget>(tag: Target) => Styled<"native", Target, Target extends import("../types").KnownTarget ? React.ComponentPropsWithRef<Target> : object, object, object>) & {
    ActivityIndicator: Styled<"native", typeof import("react-native").ActivityIndicator, object, object, object>;
    Button: Styled<"native", typeof import("react-native").Button, object, object, object>;
    DatePickerIOS: Styled<"native", typeof import("react-native").DatePickerIOS, object, object, object>;
    DrawerLayoutAndroid: Styled<"native", typeof import("react-native").DrawerLayoutAndroid, object, object, object>;
    FlatList: Styled<"native", typeof import("react-native").FlatList, object, object, object>;
    Image: Styled<"native", typeof import("react-native").Image, object, object, object>;
    ImageBackground: Styled<"native", typeof import("react-native").ImageBackground, object, object, object>;
    KeyboardAvoidingView: Styled<"native", typeof import("react-native").KeyboardAvoidingView, object, object, object>;
    Modal: Styled<"native", typeof import("react-native").Modal, object, object, object>;
    Pressable: Styled<"native", import("react").ForwardRefExoticComponent<import("react-native").PressableProps & import("react").RefAttributes<import("react-native").View>>, object, object, object>;
    ProgressBarAndroid: Styled<"native", typeof import("react-native").ProgressBarAndroid, object, object, object>;
    ProgressViewIOS: Styled<"native", typeof import("react-native").ProgressViewIOS, object, object, object>;
    RefreshControl: Styled<"native", typeof import("react-native").RefreshControl, object, object, object>;
    SafeAreaView: Styled<"native", typeof import("react-native").SafeAreaView, object, object, object>;
    ScrollView: Styled<"native", typeof import("react-native").ScrollView, object, object, object>;
    SectionList: Styled<"native", typeof import("react-native").SectionList, object, object, object>;
    Slider: Styled<"native", typeof import("react-native").Slider, object, object, object>;
    Switch: Styled<"native", typeof import("react-native").Switch, object, object, object>;
    Text: Styled<"native", typeof import("react-native").Text, object, object, object>;
    TextInput: Styled<"native", typeof import("react-native").TextInput, object, object, object>;
    TouchableHighlight: Styled<"native", typeof import("react-native").TouchableHighlight, object, object, object>;
    TouchableOpacity: Styled<"native", typeof import("react-native").TouchableOpacity, object, object, object>;
    View: Styled<"native", typeof import("react-native").View, object, object, object>;
    VirtualizedList: Styled<"native", typeof import("react-native").VirtualizedList, object, object, object>;
};
export { DefaultTheme, ExecutionContext, ExecutionProps, IStyledComponent, IStyledComponentFactory, IStyledStatics, NativeTarget, PolymorphicComponent, PolymorphicComponentProps, Runtime, StyledObject, StyledOptions, } from '../types';
export { css, isStyledComponent, ThemeProvider, ThemeConsumer, ThemeContext, withTheme, useTheme };
export { styled, styled as default };
