export declare type State = {
    [key: string]: string | number | CustomTemplate;
};
export declare type ResolvedState = {
    [key: string]: string | number;
};
export declare type Props = {
    [key: string]: any;
};
export declare type ChangedValues = string[];
export declare type CustomTemplate = (state: State) => string;
export declare type Config = {
    onRead: (key: string, props: Props) => any;
    onRender: (state: State, props: Props, changedValues: ChangedValues) => void;
    aliasMap?: {
        [key: string]: string;
    };
    useCache?: boolean;
    uncachedValues?: Set<string>;
};
export declare type Setter = (value: any) => any;
export interface Styler {
    get: (key: string) => any;
    set: (key: string | State, value?: any) => Styler | Setter;
    render: (forceRender?: boolean) => Styler;
}
