'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _browserslist = require('browserslist');

var _browserslist2 = _interopRequireDefault(_browserslist);

var _plugins = require('./plugins');

var _plugins2 = _interopRequireDefault(_plugins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var stylehacks = _postcss2.default.plugin('stylehacks', function () {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    return function (css, result) {
        var resultOpts = result.opts || {};
        var browsers = (0, _browserslist2.default)(null, {
            stats: resultOpts.stats,
            path: __dirname,
            env: resultOpts.env
        });
        var processors = _plugins2.default.reduce(function (list, Plugin) {
            var hack = new Plugin(result);
            var applied = browsers.some(function (browser) {
                return hack.targets.some(function (target) {
                    return browser === target;
                });
            });
            if (applied) {
                return list;
            }
            return [].concat(_toConsumableArray(list), [hack]);
        }, []);
        css.walk(function (node) {
            processors.forEach(function (proc) {
                if (!~proc.nodeTypes.indexOf(node.type)) {
                    return;
                }
                if (opts.lint) {
                    return proc.detectAndWarn(node);
                }
                return proc.detectAndResolve(node);
            });
        });
    };
});

stylehacks.detect = function (node) {
    return _plugins2.default.some(function (Plugin) {
        var hack = new Plugin();
        return hack.any(node);
    });
};

exports.default = stylehacks;
module.exports = exports['default'];