"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.default = plugin;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function plugin(targets, nodeTypes, detect) {
    var Plugin = function () {
        function Plugin(result) {
            _classCallCheck(this, Plugin);

            this.nodes = [];
            this.result = result;
            this.targets = targets;
            this.nodeTypes = nodeTypes;
        }

        _createClass(Plugin, [{
            key: "push",
            value: function push(node, metadata) {
                node._stylehacks = Object.assign({}, metadata, {
                    message: `Bad ${metadata.identifier}: ${metadata.hack}`,
                    browsers: this.targets
                });
                this.nodes.push(node);
            }
        }, {
            key: "any",
            value: function any(node) {
                if (~this.nodeTypes.indexOf(node.type)) {
                    detect.apply(this, arguments);
                    return !!node._stylehacks;
                }
                return false;
            }
        }, {
            key: "detectAndResolve",
            value: function detectAndResolve() {
                this.nodes = [];

                for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key];
                }

                detect.apply(this, args);
                return this.resolve();
            }
        }, {
            key: "detectAndWarn",
            value: function detectAndWarn() {
                this.nodes = [];

                for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                    args[_key2] = arguments[_key2];
                }

                detect.apply(this, args);
                return this.warn();
            }
        }, {
            key: "resolve",
            value: function resolve() {
                return this.nodes.forEach(function (node) {
                    return node.remove();
                });
            }
        }, {
            key: "warn",
            value: function warn() {
                var _this = this;

                return this.nodes.forEach(function (node) {
                    var _node$_stylehacks = node._stylehacks,
                        message = _node$_stylehacks.message,
                        browsers = _node$_stylehacks.browsers,
                        identifier = _node$_stylehacks.identifier,
                        hack = _node$_stylehacks.hack;

                    return node.warn(_this.result, message, { browsers, identifier, hack });
                });
            }
        }]);

        return Plugin;
    }();

    return Plugin;
}
module.exports = exports["default"];