'use strict';

const cssTree = require('css-tree');

const LEFTCURLYBRACKET = cssTree.tokenTypes.LeftCurlyBracket;
const RIGHTCURLYBRACKET = cssTree.tokenTypes.RightCurlyBracket;
const NUMBERSIGN = 0x0023; // U+0023 NUMBER SIGN (#)

const name = 'SassInterpolation';
const structure = {
    children: [[]]
};
function parse(recognizer, readSequence) {
    const start = this.tokenStart;
    let children = new cssTree.List();

    this.eatDelim(NUMBERSIGN);
    this.eat(LEFTCURLYBRACKET);
    children = readSequence.call(this, recognizer);
    this.eat(RIGHTCURLYBRACKET);

    return {
        type: 'SassInterpolation',
        loc: this.getLocation(start, this.tokenStart),
        children
    };
}

exports.name = name;
exports.parse = parse;
exports.structure = structure;
