"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listStyleTypeKeywords = exports.gridAreaKeywords = exports.gridColumnKeywords = exports.gridRowKeywords = exports.counterIncrementKeywords = exports.camelCaseKeywords = exports.timeProperties = exports.longhandTimeProperties = exports.shorthandTimeProperties = exports.pseudoClasses = exports.otherPseudoClasses = exports.linguisticPseudoClasses = exports.aNPlusBNotationPseudoClasses = exports.pseudoElements = exports.levelThreePseudoElements = exports.levelOneAndTwoPseudoElements = exports.animationNameKeywords = exports.animationShorthandKeywords = exports.camelCaseFunctionNames = exports.fontWeightKeywords = exports.fontWeightAbsoluteKeywords = exports.fontWeightRelativeKeywords = exports.fontFamilyKeywords = exports.colorFunctionNames = exports.units = exports.lengthUnits = exports.nonLengthUnits = undefined;

var _lodash = require("lodash");

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var nonLengthUnits = exports.nonLengthUnits = new Set([
// Relative length units
"%",
// Time length units
"s", "ms",
// Angle
"deg", "grad", "turn", "rad",
// Frequency
"Hz", "kHz",
// Resolution
"dpi", "dpcm", "dppx"]);

var lengthUnits = exports.lengthUnits = new Set([
// Relative length units
"em", "ex", "ch", "rem",
// Viewport-percentage lengths
"vh", "vw", "vmin", "vmax", "vm",
// Absolute length units
"px", "mm", "cm", "in", "pt", "pc", "q"]);

var units = exports.units = uniteSets(nonLengthUnits, lengthUnits);

var colorFunctionNames = exports.colorFunctionNames = new Set(["rgb", "rgba", "hsl", "hsla", "hwb", "gray"]);

var fontFamilyKeywords = exports.fontFamilyKeywords = new Set(["inherit", "unset", "serif", "sans-serif", "cursive", "fantasy", "monospace"]);

var fontWeightRelativeKeywords = exports.fontWeightRelativeKeywords = new Set(["bolder", "lighter"]);

var fontWeightAbsoluteKeywords = exports.fontWeightAbsoluteKeywords = new Set(["bold"]);

var fontWeightKeywords = exports.fontWeightKeywords = uniteSets(fontWeightRelativeKeywords, fontWeightAbsoluteKeywords);

var camelCaseFunctionNames = exports.camelCaseFunctionNames = new Set(["translateX", "translateY", "translateZ", "scaleX", "scaleY", "scaleZ", "rotateX", "rotateY", "rotateZ", "skewX", "skewY"]);

// cf. https://developer.mozilla.org/en-US/docs/Web/CSS/animation
var animationShorthandKeywords = exports.animationShorthandKeywords = new Set(["infinite", "normal", "reverse", "alternate", "alternate-reverse", "none", "initial", "inherit", "unset", "forwards", "backwards", "both", "running", "paused", "linear", "ease", "ease-in", "ease-out", "ease-in-out", "step-start", "step-end"]);

var animationNameKeywords = exports.animationNameKeywords = new Set(["none", "initial", "inherit", "unset"]);

// These are the ones that can have single-colon notation
var levelOneAndTwoPseudoElements = exports.levelOneAndTwoPseudoElements = new Set(["before", "after", "first-line", "first-letter"]);

// These are the ones that require double-colon notation
var levelThreePseudoElements = exports.levelThreePseudoElements = new Set(["before", "after", "first-line", "first-letter", "selection", "spelling-error", "grammar-error", "backdrop", "marker", "placeholder", "shadow", "content"]);

var pseudoElements = exports.pseudoElements = uniteSets(levelOneAndTwoPseudoElements, levelThreePseudoElements);

var aNPlusBNotationPseudoClasses = exports.aNPlusBNotationPseudoClasses = new Set(["nth-child", "nth-column", "nth-last-child", "nth-last-column", "nth-last-of-type", "nth-of-type"]);

var linguisticPseudoClasses = exports.linguisticPseudoClasses = new Set(["dir", "lang"]);

var otherPseudoClasses = exports.otherPseudoClasses = new Set(["active", "any-link", "blank", "checked", "contains", "current", "default", "disabled", "drop", "empty", "enabled", "first-child", "first-of-type", "focus", "focus-within", "fullscreen", "future", "has", "hover", "indeterminate", "in-range", "invalid", "last-child", "last-of-type", "link", "matches", "not", "only-child", "only-of-type", "optional", "out-of-range", "past", "placeholder-shown", "read-only", "read-write", "required", "root", "scope", "target", "user-error", "user-invalid", "val", "valid", "visited"]);

var pseudoClasses = exports.pseudoClasses = uniteSets(aNPlusBNotationPseudoClasses, linguisticPseudoClasses, otherPseudoClasses);

var shorthandTimeProperties = exports.shorthandTimeProperties = new Set(["transition", "animation"]);

var longhandTimeProperties = exports.longhandTimeProperties = new Set(["transition-duration", "transition-delay", "animation-duration", "animation-delay"]);

var timeProperties = exports.timeProperties = uniteSets(shorthandTimeProperties, longhandTimeProperties);

var camelCaseKeywords = exports.camelCaseKeywords = new Set(["optimizeSpeed", "optimizeLegibility", "geometricPrecision", "currentColor"]);

// https://developer.mozilla.org/docs/Web/CSS/counter-increment
var counterIncrementKeywords = exports.counterIncrementKeywords = new Set(["none", "inherit", "initial", "unset"]);

var gridRowKeywords = exports.gridRowKeywords = new Set(["auto", "span"]);

var gridColumnKeywords = exports.gridColumnKeywords = new Set(["auto", "span"]);

var gridAreaKeywords = exports.gridAreaKeywords = new Set(["unset", "initial", "inherit", "auto", "span"]);

// https://developer.mozilla.org/ru/docs/Web/CSS/list-style-type
var listStyleTypeKeywords = exports.listStyleTypeKeywords = new Set(["none", "unset", "initial", "inherit", "disc", "circle", "square", "decimal", "cjk-decimal", "decimal-leading-zero", "lower-roman", "upper-roman", "lower-greek", "lower-alpha", "lower-latin", "upper-alpha", "upper-latin", "arabic-indic", "armenian", "bengali", "cambodian", "cjk-earthly-branch", "cjk-ideographic", "devanagari", "ethiopic-numeric", "georgian", "gujarati", "gurmukhi", "hebrew", "hiragana", "hiragana-iroha", "japanese-formal", "japanese-informal", "kannada", "katakana", "katakana-iroha", "khmer", "korean-hangul-formal", "korean-hanja-formal", "korean-hanja-informal", "lao", "lower-armenian", "malayalam", "mongolian", "myanmar", "oriya", "persian", "simp-chinese-formal", "simp-chinese-informal", "tamil", "telugu", "thai", "tibetan", "trad-chinese-formal", "trad-chinese-informal", "upper-armenian", "disclosure-open", "disclosure-closed",
// Non-standard extensions (without prefixe)
"ethiopic-halehame", "ethiopic-halehame-am", "ethiopic-halehame-ti-er", "ethiopic-halehame-ti-et", "hangul", "hangul-consonant", "urdu"]);

function uniteSets() {
  for (var _len = arguments.length, sets = Array(_len), _key = 0; _key < _len; _key++) {
    sets[_key] = arguments[_key];
  }

  return new Set(sets.reduce(function (result, set) {
    return result.concat(_lodash2.default.toArray(set));
  }, []));
}