"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }

    root.walkAtRules(function (atRule) {
      var name = atRule.name;

      var expectedName = expectation === "lower" ? name.toLowerCase() : name.toUpperCase();

      if (name === expectedName) {
        return;
      }

      (0, _utils.report)({
        message: messages.expected(name, expectedName),
        node: atRule,
        ruleName: ruleName,
        result: result
      });
    });
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "at-rule-name-case";

var messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"" + actual + "\" to be \"" + _expected + "\"";
  }
});

exports.messages = messages;