"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  var checker = (0, _utils.whitespaceChecker)("space", expectation, messages);
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["always", "always-single-line"]
    });
    if (!validOptions) {
      return;
    }

    atRuleNameSpaceChecker({
      root: root,
      result: result,
      locationChecker: checker.after,
      checkedRuleName: ruleName
    });
  };
};

exports.atRuleNameSpaceChecker = atRuleNameSpaceChecker;

var _utils = require("../../utils");

var ruleName = exports.ruleName = "at-rule-name-space-after";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expectedAfter: function expectedAfter(name) {
    return "Expected single space after at-rule name \"" + name + "\"";
  }
});

function atRuleNameSpaceChecker(_ref) {
  var locationChecker = _ref.locationChecker;
  var root = _ref.root;
  var result = _ref.result;
  var checkedRuleName = _ref.checkedRuleName;

  root.walkAtRules(function (atRule) {
    if (!(0, _utils.isStandardAtRule)(atRule)) {
      return;
    }

    checkColon("@" + atRule.name + atRule.raws.afterName + atRule.params, atRule.name.length, atRule);
  });

  function checkColon(source, index, node) {
    locationChecker({
      source: source,
      index: index,
      err: function err(m) {
        return (0, _utils.report)({
          message: m,
          node: node,
          index: index,
          result: result,
          ruleName: checkedRuleName
        });
      },
      errTarget: "@" + node.name
    });
  }
}