"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });
    if (!validOptions) {
      return;
    }

    // Check both kinds of statements: rules and at-rules
    root.walkRules(check);
    root.walkAtRules(check);

    function check(statement) {
      if (!(0, _utils.hasEmptyBlock)(statement)) {
        return;
      }

      (0, _utils.report)({
        message: messages.rejected,
        node: statement,
        index: (0, _utils.beforeBlockString)(statement, { noRawBefore: true }).length,
        result: result,
        ruleName: ruleName
      });
    }
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "block-no-empty";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: "Unexpected empty block"
});