"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["never", "always-where-possible"]
    });
    if (!validOptions) {
      return;
    }

    var namedColors = Object.keys(_namedColorData2.default);

    root.walkDecls(function (decl) {
      (0, _postcssValueParser2.default)(decl.value).walk(function (node) {
        var value = node.value;
        var type = node.type;
        var sourceIndex = node.sourceIndex;


        if (!(0, _utils.isStandardValue)(value)) {
          return;
        }
        // Return early if neither a word nor a function
        if (NODE_TYPES.indexOf(type) === -1) {
          return;
        }

        // Check for named colors for "never" option
        if (expectation === "never" && type === "word" && namedColors.indexOf(value.toLowerCase()) !== -1) {
          complain(messages.rejected(value), decl, (0, _utils.declarationValueIndex)(decl) + sourceIndex);
          return;
        }

        // Check "always-where-possible" option ...
        if (expectation !== "always-where-possible") {
          return;
        }

        // First by checking for alternative color function representations ...
        if (type === "function" && _keywordSets.colorFunctionNames.has(value.toLowerCase())) {
          // Remove all spaces to match what's in `representations`
          var normalizedFunctionString = _postcssValueParser2.default.stringify(node).replace(/\s+/g, "");
          var _namedColor = void 0;
          for (var i = 0, l = namedColors.length; i < l; i++) {
            _namedColor = namedColors[i];
            if (_namedColorData2.default[_namedColor].func.indexOf(normalizedFunctionString.toLowerCase()) !== -1) {
              complain(messages.expected(_namedColor, normalizedFunctionString), decl, (0, _utils.declarationValueIndex)(decl) + sourceIndex);
              return; // Exit as soon as a problem is found
            }
          }
          return;
        }

        // Then by checking for alternative hex representations
        var namedColor = void 0;
        for (var _i = 0, _l = namedColors.length; _i < _l; _i++) {
          namedColor = namedColors[_i];
          if (_namedColorData2.default[namedColor].hex.indexOf(value.toLowerCase()) !== -1) {
            complain(messages.expected(namedColor, value), decl, (0, _utils.declarationValueIndex)(decl) + sourceIndex);
            return; // Exit as soon as a problem is found
          }
        }
      });
    });

    function complain(message, node, index) {
      (0, _utils.report)({
        result: result,
        ruleName: ruleName,
        message: message,
        node: node,
        index: index
      });
    }
  };
};

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

var _namedColorData = require("../../reference/namedColorData");

var _namedColorData2 = _interopRequireDefault(_namedColorData);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "color-named";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(named, original) {
    return "Expected \"" + original + "\" to be \"" + named + "\"";
  },
  rejected: function rejected(named) {
    return "Unexpected named color \"" + named + "\"";
  }
});

// Todo tested on case insensivity
var NODE_TYPES = ["word", "function"];