"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (blacklist) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: blacklist,
      possible: [_lodash.isString]
    });
    if (!validOptions) {
      return;
    }

    root.walkComments(function (comment) {
      var text = comment.text;
      var rawComment = comment.toString();
      var firstFourChars = rawComment.substr(0, 4);

      // Return early if sourcemap or copyright comment
      if (firstFourChars === "/*# " || firstFourChars === "/*! ") {
        return;
      }

      var matchesWord = (0, _utils.matchesStringOrRegExp)(text, blacklist);

      if (!matchesWord) {
        return;
      }

      (0, _utils.report)({
        message: messages.rejected(matchesWord.pattern),
        node: comment,
        result: result,
        ruleName: ruleName
      });
    });
  };
};

var _lodash = require("lodash");

var _utils = require("../../utils");

var ruleName = exports.ruleName = "comment-word-blacklist";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(pattern) {
    return "Unexpected word matching pattern \"" + pattern + "\"";
  }
});