"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });

    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl, index) {
      var prop = decl.prop;
      var value = decl.value;

      var unprefixedProp = _postcss.vendor.unprefixed(prop);
      var unprefixedValue = _postcss.vendor.unprefixed(value);

      ignored.forEach(function (ignore) {
        var matchProperty = (0, _utils.matchesStringOrRegExp)(unprefixedProp.toLowerCase(), ignore.property);
        var matchValue = (0, _utils.matchesStringOrRegExp)(unprefixedValue.toLowerCase(), ignore.value);

        if (!matchProperty || !matchValue) {
          return;
        }

        var ignoredProperties = ignore.ignoredProperties;

        decl.parent.nodes.forEach(function (node, nodeIndex) {
          if (!node.prop || ignoredProperties.indexOf(node.prop.toLowerCase()) === -1 || index === nodeIndex) {
            return;
          }

          (0, _utils.report)({
            message: messages.rejected(node.prop, decl.toString()),
            node: node,
            result: result,
            ruleName: ruleName
          });
        });
      });
    });
  };
};

var _postcss = require("postcss");

var _utils = require("../../utils");

var ruleName = exports.ruleName = "declaration-block-no-ignored-properties";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(ignored, cause) {
    return "Unexpected property \"" + ignored + "\" that is ignored because of \"" + cause + "\"";
  }
});

var ignored = [{
  property: "display",
  value: "inline",
  ignoredProperties: ["width", "height", "margin", "margin-top", "margin-bottom", "float"]
}, {
  property: "display",
  value: "inline-block",
  ignoredProperties: ["float"]
}, {
  property: "display",
  value: "list-item",
  ignoredProperties: ["vertical-align"]
}, {
  property: "display",
  value: "block",
  ignoredProperties: ["vertical-align"]
}, {
  property: "display",
  value: "flex",
  ignoredProperties: ["vertical-align"]
}, {
  property: "display",
  value: "table",
  ignoredProperties: ["vertical-align"]
}, {
  property: "display",
  value: "/^table-.*$/",
  ignoredProperties: ["margin", "margin-top", "margin-right", "margin-bottom", "margin-left"]
}, {
  property: "display",
  value: "/^table-(row|row-group|column|column-group|header-group|footer-group|caption).*$/",
  ignoredProperties: ["vertical-align"]
}, {
  property: "float",
  value: "left",
  ignoredProperties: ["vertical-align"]
}, {
  property: "float",
  value: "right",
  ignoredProperties: ["vertical-align"]
}, {
  property: "position",
  value: "static",
  ignoredProperties: ["top", "right", "bottom", "left"]
}, {
  property: "position",
  value: "absolute",
  ignoredProperties: ["float", "clear", "vertical-align"]
}, {
  property: "position",
  value: "fixed",
  ignoredProperties: ["float", "clear", "vertical-align"]
}];