"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });
    if (!validOptions) {
      return;
    }

    root.walkRules(check);
    root.walkAtRules(check);

    function check(statement) {
      var declarations = {};
      // Shallow iteration so nesting doesn't produce
      // false positives
      statement.each(function (node) {
        if (node.type !== "decl") {
          return;
        }
        var prop = node.prop;

        var overrideables = _shorthandData2.default[prop.toLowerCase()];
        if (!overrideables) {
          declarations[prop.toLowerCase()] = prop;
          return;
        }
        overrideables.forEach(function (longhandProp) {
          if (!declarations.hasOwnProperty(longhandProp)) {
            return;
          }
          (0, _utils.report)({
            ruleName: ruleName,
            result: result,
            node: node,
            message: messages.rejected(prop, declarations[longhandProp])
          });
        });
      });
    }
  };
};

var _utils = require("../../utils");

var _shorthandData = require("../../reference/shorthandData");

var _shorthandData2 = _interopRequireDefault(_shorthandData);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "declaration-block-no-shorthand-property-overrides";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(shorthand, original) {
    return "Unexpected shorthand \"" + shorthand + "\" after \"" + original + "\"";
  }
});