"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }

    root.walkAtRules(function (atRule) {
      if (atRule.parent === root) {
        return;
      }
      if (atRule !== atRule.parent.last) {
        return;
      }
      if ((0, _utils.hasBlock)(atRule)) {
        return;
      }
      checkLastNode(atRule);
    });

    root.walkDecls(function (decl) {
      if (decl !== decl.parent.last) {
        return;
      }
      checkLastNode(decl);
    });

    function checkLastNode(node) {
      var message = void 0;

      if (expectation === "always") {
        if (node.parent.raws.semicolon) {
          return;
        }
        message = messages.expected;
      }
      if (expectation === "never") {
        if (!node.parent.raws.semicolon) {
          return;
        }
        message = messages.rejected;
      }

      (0, _utils.report)({
        message: message,
        node: node,
        index: node.toString().trim().length - 1,
        result: result,
        ruleName: ruleName
      });
    }
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "declaration-block-trailing-semicolon";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expected: "Expected a trailing semicolon",
  rejected: "Unexpected trailing semicolon"
});