"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      var value = decl.value;


      (0, _postcssValueParser2.default)(value).walk(function (node) {
        if (node.type !== "function" || !(0, _utils.isStandardFunction)(node)) {
          return;
        }

        var functionName = node.value;
        var functionNameLowerCase = functionName.toLowerCase();

        var expectedFunctionName = null;

        if (expectation === "lower" && mapLowercaseFunctionNamesToCamelCase.has(functionNameLowerCase)) {
          expectedFunctionName = mapLowercaseFunctionNamesToCamelCase.get(functionNameLowerCase);
        } else if (expectation === "lower") {
          expectedFunctionName = functionNameLowerCase;
        } else {
          expectedFunctionName = functionName.toUpperCase();
        }

        if (functionName === expectedFunctionName) {
          return;
        }

        (0, _utils.report)({
          message: messages.expected(functionName, expectedFunctionName),
          node: decl,
          index: (0, _utils.declarationValueIndex)(decl) + node.sourceIndex,
          result: result,
          ruleName: ruleName
        });
      });
    });
  };
};

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "function-name-case";

var messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"" + actual + "\" to be \"" + _expected + "\"";
  }
});

exports.messages = messages;
var mapLowercaseFunctionNamesToCamelCase = new Map();
_keywordSets.camelCaseFunctionNames.forEach(function (func) {
  mapLowercaseFunctionNamesToCamelCase.set(func.toLowerCase(), func);
});