"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      (0, _postcssValueParser2.default)(decl.value).walk(function (valueNode) {
        if (valueNode.type !== "function" || valueNode.value.toLowerCase() !== "url" || !valueNode.nodes.length > 0) {
          return;
        }

        var urlValueNode = valueNode.nodes[0];

        if (!urlValueNode.value || !(0, _utils.isStandardValue)(urlValueNode.value) || (0, _utils.isVariable)(urlValueNode.value)) {
          return;
        }

        var valueContainDataUris = urlValueNode.value.toLowerCase().indexOf("data:") === 0;
        var needUrlDataUris = expectation === "always";

        if (valueContainDataUris && needUrlDataUris || !valueContainDataUris && !needUrlDataUris) {
          return;
        }

        var message = needUrlDataUris ? messages.expected : messages.rejected;

        (0, _utils.report)({
          message: message,
          node: decl,
          result: result,
          ruleName: ruleName
        });
      });
    });
  };
};

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "function-url-data-uris";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expected: "Expected a data URI",
  rejected: "Unexpected data URI"
});