"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (max) {
  var maxAdjacentNewlines = max + 1;

  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: max,
      possible: _lodash.isNumber
    });
    if (!validOptions) {
      return;
    }

    var rootString = root.toString();
    var repeatLFNewLines = (0, _lodash.repeat)("\n", maxAdjacentNewlines);
    var repeatCRLFNewLines = (0, _lodash.repeat)("\r\n", maxAdjacentNewlines);

    (0, _utils.styleSearch)({ source: rootString, target: "\n" }, function (match) {
      checkMatch(rootString, match.endIndex, root);
    });

    // We must check comments separately in order to accommodate stupid
    // `//`-comments from SCSS, which postcss-scss converts to `/* ... */`,
    // which adds to extra characters at the end, which messes up our
    // warning position
    root.walkComments(function (comment) {
      var source = comment.raw("left") + comment.text + comment.raw("right");
      (0, _utils.styleSearch)({ source: source, target: "\n" }, function (match) {
        checkMatch(source, match.endIndex, comment, 2);
      });
    });

    function checkMatch(source, matchEndIndex, node) {
      var offset = arguments.length <= 3 || arguments[3] === undefined ? 0 : arguments[3];

      var violationIndex = false;
      if (source.substr(matchEndIndex, maxAdjacentNewlines) === repeatLFNewLines) {
        violationIndex = matchEndIndex + maxAdjacentNewlines;
      } else if (source.substr(matchEndIndex, maxAdjacentNewlines * 2) === repeatCRLFNewLines) {
        violationIndex = matchEndIndex + maxAdjacentNewlines * 2;
      }

      if (!violationIndex) {
        return;
      }

      (0, _utils.report)({
        message: messages.rejected,
        node: node,
        index: violationIndex + offset,
        result: result,
        ruleName: ruleName
      });
    }
  };
};

var _lodash = require("lodash");

var _utils = require("../../utils");

var ruleName = exports.ruleName = "max-empty-lines";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: "Unexpected empty line"
});