"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (on, options) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: on }, {
      optional: true,
      actual: options,
      possible: {
        browsers: [_lodash.isString]
      }
    });
    if (!validOptions) {
      return;
    }

    var stylehacksOptions = { lint: true };
    if (options && options.browsers) {
      stylehacksOptions.browsers = options.browsers;
    }

    var stylehacksResult = new _result2.default();
    (0, _stylehacks2.default)(stylehacksOptions)(root, stylehacksResult);
    stylehacksResult.warnings().forEach(function (stylehacksWarning) {
      var message = messages.rejected(stylehacksWarning.identifier, stylehacksWarning.hack);
      (0, _utils.report)({
        ruleName: ruleName,
        result: result,
        message: message,
        node: stylehacksWarning.node,
        line: stylehacksWarning.line,
        column: stylehacksWarning.column
      });
    });
  };
};

var _stylehacks = require("stylehacks");

var _stylehacks2 = _interopRequireDefault(_stylehacks);

var _result = require("postcss/lib/result");

var _result2 = _interopRequireDefault(_result);

var _lodash = require("lodash");

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "no-browser-hacks";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(type, hack) {
    return "Unexpected " + type + " hack \"" + hack + "\"";
  }
});