"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });
    if (!validOptions) {
      return;
    }

    if (root.raws.after) {
      (function () {
        var rawAfterRoot = root.raws.after;
        (0, _utils.styleSearch)({ source: rawAfterRoot, target: ";" }, function (match) {
          complain(root.toString().length - rawAfterRoot.length + match.startIndex);
        });
      })();
    }

    root.walk(function (node) {
      if (node.raws.before) {
        (function () {
          var rawBeforeNode = node.raws.before;
          (0, _utils.styleSearch)({ source: rawBeforeNode, target: ";" }, function (match) {
            complain(getOffsetByNode(node) - rawBeforeNode.length + match.startIndex);
          });
        })();
      }

      if (node.raws.after) {
        (function () {
          var rawAfterNode = node.raws.after;
          (0, _utils.styleSearch)({ source: rawAfterNode, target: ";" }, function (match) {
            var index = node.source.start.column + node.toString().length - 1 - rawAfterNode.length - 1 + match.startIndex;
            complain(index);
          });
        })();
      }
    });

    function complain(index) {
      (0, _utils.report)({
        message: messages.rejected,
        node: root,
        index: index,
        result: result,
        ruleName: ruleName
      });
    }
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "no-extra-semicolons";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: "Unexpected extra semicolon"
});

function getOffsetByNode(node) {
  var string = node.root().toString();
  var nodeColumn = node.source.start.column;
  var nodeLine = node.source.start.line;
  var line = 1;
  var column = 1;
  var index = 0;

  for (var i = 0; i < string.length; i++) {
    if (column === nodeColumn && nodeLine === line) {
      index = i;
      break;
    }

    if (string[i] === "\n") {
      column = 1;
      line += 1;
    } else {
      column += 1;
    }
  }

  return index;
}