"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });
    if (!validOptions) {
      return;
    }

    var declaredAnimations = new Set();
    root.walkAtRules(/keyframes/i, function (atRule) {
      declaredAnimations.add(atRule.params);
    });

    root.walkDecls(function (decl) {
      if (decl.prop.toLowerCase() === "animation-name" && !_keywordSets.animationNameKeywords.has(decl.value.toLowerCase())) {
        checkAnimationName(decl.value, decl);
      }

      if (decl.prop.toLowerCase() === "animation") {
        var valueList = _postcss2.default.list.space(decl.value);
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = valueList[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var value = _step.value;

            // Ignore non standard syntax
            if (!(0, _utils.isStandardValue)(value)) {
              continue;
            }
            // Ignore variables
            if ((0, _utils.isVariable)(value)) {
              continue;
            }
            // Ignore numbers with units
            if (_postcssValueParser2.default.unit(value)) {
              continue;
            }
            // Ignore keywords for other animation parts
            if (_keywordSets.animationShorthandKeywords.has(value.toLowerCase())) {
              continue;
            }
            // Ignore functions
            if (value.indexOf("(") !== -1) {
              continue;
            }
            checkAnimationName(value, decl, decl.value.indexOf(value));
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      }
    });

    function checkAnimationName(animationName, decl) {
      var offset = arguments.length <= 2 || arguments[2] === undefined ? 0 : arguments[2];

      if (declaredAnimations.has(animationName)) {
        return;
      }
      (0, _utils.report)({
        result: result,
        ruleName: ruleName,
        message: messages.rejected(animationName),
        node: decl,
        index: (0, _utils.declarationValueIndex)(decl) + offset
      });
    }
  };
};

var _postcss = require("postcss");

var _postcss2 = _interopRequireDefault(_postcss);

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "no-unknown-animations";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(animationName) {
    return "Unknown animation name \"" + animationName + "\"";
  }
});