"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (precision) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: precision,
      possible: [_lodash.isNumber]
    });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      // Don't bother with strings
      if (decl.prop.toLowerCase() === "content") {
        return;
      }
      check(decl.toString(), decl);
    });

    root.walkAtRules(function (atRule) {
      // Ignore @imports
      if (atRule.name === "import") {
        return;
      }

      var source = (0, _utils.hasBlock)(atRule) ? (0, _utils.beforeBlockString)(atRule, { noRawBefore: true }) : atRule.toString();
      check(source, atRule);
    });

    function check(source, node) {

      var sanitizedSource = (0, _utils.blurComments)((0, _utils.blurFunctionArguments)(source, "url"));
      var decimalNumberMatches = (0, _execall2.default)(/(\d*\.(\d+))/g, sanitizedSource);
      if (!decimalNumberMatches.length) {
        return;
      }

      decimalNumberMatches.forEach(function (match) {
        if (match.sub[1].length <= precision) {
          return;
        }
        (0, _utils.report)({
          result: result,
          ruleName: ruleName,
          node: node,
          index: match.index,
          message: messages.expected(parseFloat(match.sub[0]), precision)
        });
      });
    }
  };
};

var _lodash = require("lodash");

var _execall = require("execall");

var _execall2 = _interopRequireDefault(_execall);

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "number-max-precision";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(number, precision) {
    return "Expected \"" + number + "\" to be \"" + number.toFixed(precision) + "\"";
  }
});