"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      var prop = decl.prop;

      if (!(0, _utils.isStandardProperty)(prop)) {
        return;
      }
      if ((0, _utils.isCustomProperty)(prop)) {
        return;
      }

      var expectedProp = expectation === "lower" ? prop.toLowerCase() : prop.toUpperCase();
      if (prop === expectedProp) {
        return;
      }

      (0, _utils.report)({
        message: messages.expected(prop, expectedProp),
        node: decl,
        ruleName: ruleName,
        result: result
      });
    });
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "property-case";

var messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"" + actual + "\" to be \"" + _expected + "\"";
  }
});

exports.messages = messages;