"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (blacklist) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: blacklist,
      possible: [_lodash.isObject]
    });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      var prop = decl.prop;
      var value = decl.value;

      var unprefixedProp = _postcss.vendor.unprefixed(prop);

      var propBlacklist = (0, _lodash.find)(blacklist, function (list, propIdentifier) {
        return (0, _utils.matchesStringOrRegExp)(unprefixedProp, propIdentifier);
      });

      if (!propBlacklist) {
        return;
      }

      (0, _postcssValueParser2.default)(value).walk(function (node) {
        // Ignore wrong units within `url` function
        if (node.type === "function" && node.value.toLowerCase() === "url") {
          return false;
        }
        if (node.type === "string") {
          return;
        }

        var unit = (0, _utils.getUnitFromValueNode)(node);

        if (!unit || unit && propBlacklist.indexOf(unit.toLowerCase()) === -1) {
          return;
        }

        (0, _utils.report)({
          message: messages.rejected(prop, unit),
          node: decl,
          index: (0, _utils.declarationValueIndex)(decl) + node.sourceIndex,
          result: result,
          ruleName: ruleName
        });
      });
    });
  };
};

var _postcss = require("postcss");

var _lodash = require("lodash");

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "property-unit-blacklist";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(property, unit) {
    return "Unexpected unit \"" + unit + "\" for property \"" + property + "\"";
  }
});