"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (rule.selector.toLowerCase().indexOf(":root") === -1) {
        return;
      }
      (0, _utils.parseSelector)(rule.selector, result, rule, checkSelector);

      function checkSelector(selectorAST) {
        if (ignoreRule(selectorAST)) {
          return;
        }

        rule.walkDecls(function (decl) {
          var prop = decl.prop;

          if (!(0, _utils.isStandardProperty)(prop)) {
            return;
          }
          if ((0, _utils.isCustomProperty)(prop)) {
            return;
          }

          (0, _utils.report)({
            message: messages.rejected(prop),
            node: decl,
            result: result,
            ruleName: ruleName
          });
        });
      }
    });
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "root-no-standard-properties";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(property) {
    return "Unexpected standard property \"" + property + "\" applied to \":root\"";
  }
});

function ignoreRule(selectorAST) {
  var ignore = false;
  selectorAST.walk(function (selectorNode) {
    // ignore `:root` selector inside a `:not()` selector
    if (selectorNode.value && selectorNode.value.toLowerCase() === ":root" && selectorNode.parent.parent.value && selectorNode.parent.parent.value.toLowerCase() === ":not") {
      ignore = true;
    }
  });
  return ignore;
}