"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      if (rule.selector.indexOf("[") === -1) {
        return;
      }

      (0, _utils.parseSelector)(rule.selector, result, rule, function (selectorTree) {
        selectorTree.walkAttributes(function (attributeNode) {
          var attributeSelectorString = attributeNode.toString();

          (0, _utils.styleSearch)({ source: attributeSelectorString, target: "[" }, function (match) {
            var nextCharIsSpace = attributeSelectorString[match.startIndex + 1] === " ";
            var index = attributeNode.sourceIndex + match.startIndex + 1;
            if (nextCharIsSpace && expectation === "never") {
              complain(messages.rejectedOpening, index);
            }
            if (!nextCharIsSpace && expectation === "always") {
              complain(messages.expectedOpening, index);
            }
          });

          (0, _utils.styleSearch)({ source: attributeSelectorString, target: "]" }, function (match) {
            var prevCharIsSpace = attributeSelectorString[match.startIndex - 1] === " ";
            var index = attributeNode.sourceIndex + match.startIndex - 1;
            if (prevCharIsSpace && expectation === "never") {
              complain(messages.rejectedClosing, index);
            }
            if (!prevCharIsSpace && expectation === "always") {
              complain(messages.expectedClosing, index);
            }
          });
        });
      });

      function complain(message, index) {
        (0, _utils.report)({
          message: message,
          index: index,
          result: result,
          ruleName: ruleName,
          node: rule
        });
      }
    });
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "selector-attribute-brackets-space-inside";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expectedOpening: "Expected single space after \"[\"",
  rejectedOpening: "Unexpected whitespace after \"[\"",
  expectedClosing: "Expected single space before \"]\"",
  rejectedClosing: "Unexpected whitespace before \"]\""
});